/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import java.util.Collections;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class PrepareQuerySetRequestAdapter
extends RequestAdapter {
    @Override
    public ResponseAdapter executeRequest(RequestEnvironment environment) {
        boolean collectMetrics = MetricsService.isEnabled();
        long startTime = 0L;
        if (collectMetrics) {
            startTime = System.currentTimeMillis();
            MetricsService.collectMetricInfo(environment, "requestType", "releaseQuerySet");
        }
        BIBusEnvelope requestEnvelope = environment.getRequestEnvelope();
        Element v5RootElement = requestEnvelope.getBody().element("prepareQuerySet");
        v5RootElement.detach();
        Document requestDocument = DocumentHelper.createDocument((Element)v5RootElement);
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)environment.getExecutionEnvironment();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(executionEnvironment);
        MultiRequestContext multiRequestContext = QueryEngine.getInstance().configureMultiRequestContext(environment, requestDocument);
        multiRequestContext.incrementRefCount();
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        try {
            Element element = v5RootElement.element("querySet");
        }
        catch (XQERuntimeException e) {
            throw e;
        }
        finally {
            multiRequestContext.decrementRefCount();
            executionEnvironmentContext.exit();
            if (collectMetrics) {
                long time = System.currentTimeMillis() - startTime;
                MetricsService.collectMetricInfo(environment, "isQuerySetPrepared", "true", time);
            }
        }
        List attachmentList = Collections.emptyList();
        return new SimpleResponseAdapter(responseEnvelope, attachmentList);
    }

    @Override
    public String getOperationName() {
        return "prepareQuerySet";
    }
}

