/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorState;
import com.cognos.xqe.bibushandler.ROLAPAdvisorCommandResponseUtility;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Advisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorCommandResult;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import org.dom4j.Element;

public class ROLAPAdvisorCommandRequestAdapter
extends RequestAdapter {
    public static final String ROLAPADVISORCOMMAND_OP_NAME = "ROLAPAdvisorCommands";
    public static final String USERSESSIONID_ELEMENT_NAME = "userSessionID";
    private static final XQELogger INFO_LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor");
    private ReentrantLock executionLock = new ReentrantLock();

    private static Element getCommandElement(BIBusEnvelope requestEnvelope) {
        Element commandElement = (Element)requestEnvelope.getBody().elementIterator().next();
        return commandElement;
    }

    private static String getUserSessionID(BIBusEnvelope requestEnvelope) {
        Element commandElement = requestEnvelope.getCAM().element(USERSESSIONID_ELEMENT_NAME);
        return commandElement.getText();
    }

    private static String getLogMessagePrefix(String commandName, String sessionID) {
        return "[" + commandName + "(" + sessionID + ")] ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseAdapter executeRequest(RequestEnvironment environment) throws XQEException, IOException {
        BIBusEnvelope requestEnvelope = environment.getRequestEnvelope();
        Element commandElement = ROLAPAdvisorCommandRequestAdapter.getCommandElement(requestEnvelope);
        String commandName = commandElement.getName();
        String userSessionID = ROLAPAdvisorCommandRequestAdapter.getUserSessionID(requestEnvelope);
        if (this.requiresExecutionLock(commandName)) {
            this.acquireExecutionLock(commandName, userSessionID);
        }
        try {
            Object recommendationIDs;
            AdvisorCommandResult result = null;
            if (commandName.equals("startAggregateAdvisor")) {
                String cubeName = ROLAPAdvisorCommandRequestAdapter.getChildValue(commandElement, "cubeName");
                Properties properties = ROLAPAdvisorCommandRequestAdapter.getProperties(commandElement);
                Map<String, String> options = ROLAPAdvisorCommandRequestAdapter.getOptions(commandElement);
                result = AdvisorManager.getInstance().startAdvisor(userSessionID, cubeName, properties, options);
            } else if (commandName.equals("stopAggregateAdvisor")) {
                boolean getRecommendations = ROLAPAdvisorCommandRequestAdapter.getGetRecommendations(commandElement);
                result = AdvisorManager.getInstance().stopAdvisor(userSessionID, getRecommendations);
            } else if (commandName.equals("getAggregateAdvisorRecommendations")) {
                result = AdvisorManager.getInstance().getAggregateRecommendations(userSessionID);
            } else if (commandName.equals("getCurrentWorkloadForAggregateAdvisor")) {
                String cubeName = ROLAPAdvisorCommandRequestAdapter.getChildValue(commandElement, "cubeName");
                result = AdvisorManager.getInstance().getCurrentWorkloadForAggregateAdvisor(cubeName);
            } else if (commandName.equals("retrieveInitialAggregateAdvisorRecommendations")) {
                Map<String, String> options = ROLAPAdvisorCommandRequestAdapter.getOptions(commandElement);
                result = AdvisorManager.getInstance().retrieveInitialAggregateAdvisorRecommendations(userSessionID, options);
            } else if (commandName.equals("retrieveSubsequentAggregateAdvisorRecommendations")) {
                result = AdvisorManager.getInstance().retrieveSubsequentAggregateAdvisorRecommendations(userSessionID);
            } else if (commandName.equals("storeAggregateAdvisorRecommendation")) {
                Properties properties = ROLAPAdvisorCommandRequestAdapter.getProperties(commandElement);
                Element recommendationsElement = ROLAPAdvisorCommandRequestAdapter.getRecommendationsElement(commandElement);
                result = AdvisorManager.getInstance().storeAggregateAdvisorRecommendation(userSessionID, properties, recommendationsElement);
            } else if (commandName.equals("migrateAggregateAdvisorRecommendation")) {
                String state = ROLAPAdvisorCommandRequestAdapter.getChildValue(commandElement, "state");
                List<String> messages = ROLAPAdvisorCommandRequestAdapter.getMessages(commandElement);
                Map<String, String> options = ROLAPAdvisorCommandRequestAdapter.getOptions(commandElement);
                Properties properties = ROLAPAdvisorCommandRequestAdapter.getProperties(commandElement);
                Element recommendationsElement = ROLAPAdvisorCommandRequestAdapter.getRecommendationsElement(commandElement);
                result = AdvisorManager.getInstance().migrateAggregateAdvisorRecommendation(userSessionID, state, messages, options, properties, recommendationsElement);
            } else if (commandName.equals("updateAggregateAdvisorRecommendationName")) {
                String cubeName = ROLAPAdvisorCommandRequestAdapter.getChildValue(commandElement, "cubeName");
                String recommendationID = ROLAPAdvisorCommandRequestAdapter.getChildValue(commandElement, "recommendationID");
                String recommendationName = ROLAPAdvisorCommandRequestAdapter.getChildValue(commandElement, "recommendationName");
                result = AdvisorManager.getInstance().updateAggregateAdvisorRecommendationName(userSessionID, cubeName, recommendationID, recommendationName);
            } else if (commandName.equals("deleteAggregateAdvisorRecommendations")) {
                String cubeName = ROLAPAdvisorCommandRequestAdapter.getChildValue(commandElement, "cubeName");
                recommendationIDs = ROLAPAdvisorCommandRequestAdapter.getRecommendationIDs(commandElement);
                result = AdvisorManager.getInstance().deleteAggregateAdvisorRecommendations(cubeName, (List<String>)recommendationIDs);
            } else if (commandName.equals("replaceAggregateAdvisorSession")) {
                String sessionIDToReplace = ROLAPAdvisorCommandRequestAdapter.getChildValue(commandElement, "sessionID");
                result = AdvisorManager.getInstance().replaceAggregateAdvisorSession(sessionIDToReplace, userSessionID);
            }
            if (result == null) {
                result = new AdvisorCommandResult(AggregateAdvisorState.COMPLETED, Advisor.buildError(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommandYieldNoResult, commandName)));
            }
            BIBusEnvelope responseEnvelope = ROLAPAdvisorCommandResponseUtility.createResponseEnvelope(requestEnvelope, commandName, result);
            result.tearDown();
            recommendationIDs = new SimpleResponseAdapter(responseEnvelope, Collections.emptyList());
            return recommendationIDs;
        }
        catch (Exception e) {
            INFO_LOGGER.log(LogLevel.ERROR, ROLAPAdvisorCommandRequestAdapter.getLogMessagePrefix(commandName, userSessionID) + " - Advisor encountered unexpected error when processing the command.", (Throwable)e);
            AdvisorCommandResult result = new AdvisorCommandResult(AggregateAdvisorState.COMPLETED, Advisor.buildError(e));
            BIBusEnvelope responseEnvelope = ROLAPAdvisorCommandResponseUtility.createResponseEnvelope(requestEnvelope, commandName, result);
            SimpleResponseAdapter simpleResponseAdapter = new SimpleResponseAdapter(responseEnvelope, Collections.emptyList());
            return simpleResponseAdapter;
        }
        finally {
            if (this.requiresExecutionLock(commandName)) {
                this.releaseExecutionLock(commandName, userSessionID);
            }
        }
    }

    private static String getChildValue(Element parentElement, String childElementName) {
        String childValue = null;
        Element childElement = parentElement.element(childElementName);
        if (childElement != null) {
            childValue = childElement.getText();
        }
        return childValue;
    }

    private static List<String> getMessages(Element commandElement) {
        ArrayList<String> messages = new ArrayList<String>();
        Element messagesElement = commandElement.element("messages");
        if (messagesElement != null) {
            List messageElements = messagesElement.elements("message");
            for (Element messageElement : messageElements) {
                String message = messageElement.getText();
                messages.add(message);
            }
        }
        return messages;
    }

    private static Properties getProperties(Element commandElement) {
        Properties properties = new Properties();
        Element propertiesElement = commandElement.element("properties");
        if (propertiesElement != null) {
            List propertyElements = propertiesElement.elements("property");
            for (Element propertyElement : propertyElements) {
                String name = null;
                Element nameElement = propertyElement.element("name");
                if (nameElement != null) {
                    name = nameElement.getText();
                }
                String value = null;
                Element valueElement = propertyElement.element("value");
                if (valueElement != null) {
                    value = valueElement.getText();
                }
                if (name == null || value == null) continue;
                properties.setProperty(name, value);
            }
        }
        return properties;
    }

    private static Map<String, String> getOptions(Element commandElement) {
        HashMap<String, String> options = new HashMap<String, String>();
        Element optionsElement = commandElement.element("options");
        if (optionsElement != null) {
            List childElements = optionsElement.elements("option");
            for (Element childElement : childElements) {
                String name = childElement.element("name").getText();
                String value = childElement.element("value").getText();
                options.put(name, value);
            }
        }
        return options;
    }

    private static boolean getGetRecommendations(Element commandElement) {
        String elementText = null;
        boolean bGetRecommendations = true;
        Element getRecommendationsElement = commandElement.element("getRecommendations");
        if (getRecommendationsElement != null && (elementText = getRecommendationsElement.getText()) != null) {
            bGetRecommendations = Boolean.parseBoolean(elementText);
        }
        return bGetRecommendations;
    }

    private static Element getRecommendationsElement(Element commandElement) {
        Element recommendationsElement = commandElement.element("recommendations");
        if (recommendationsElement != null) {
            recommendationsElement.detach();
        }
        return recommendationsElement;
    }

    private static List<String> getRecommendationIDs(Element commandElement) {
        ArrayList<String> recommendationIDs = new ArrayList<String>();
        Element recommendationIDsElement = commandElement.element("recommendationIDs");
        if (recommendationIDsElement != null) {
            List recommendationIDElements = recommendationIDsElement.elements("recommendationID");
            for (Element recommendationIDElement : recommendationIDElements) {
                String recommendationID = recommendationIDElement.getText();
                recommendationIDs.add(recommendationID);
            }
        }
        return recommendationIDs;
    }

    @Override
    public String getOperationName() {
        return ROLAPADVISORCOMMAND_OP_NAME;
    }

    @Override
    protected boolean requiresCancelableRegistration() {
        return false;
    }

    @Override
    public boolean requiresMultiRequestContext() {
        return false;
    }

    private boolean requiresExecutionLock(String commandName) {
        return !"getCurrentWorkloadForAggregateAdvisor".equals(commandName);
    }

    private void acquireExecutionLock(String commandName, String sessionID) {
        ROLAPLog.logTrace("ROLAPAggregateAdvisor.Management", String.format("The execution lock was requested for the command %s by session %s.", commandName, sessionID));
        this.executionLock.lock();
        ROLAPLog.logTrace("ROLAPAggregateAdvisor.Management", String.format("The execution lock was acquired for the command %s by session %s.", commandName, sessionID));
    }

    private void releaseExecutionLock(String commandName, String sessionID) {
        this.executionLock.unlock();
        ROLAPLog.logTrace("ROLAPAggregateAdvisor.Management", String.format("The execution lock was released for the command %s by session %s.", commandName, sessionID));
    }
}

