/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.xqe.bibushandler.ROLAPBIBusXMLHelper;
import com.cognos.xqe.bibushandler.ROLAPCommandResponseUtility;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCommandResult;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ROLAPAsyncBIBusXMLHelper
extends ROLAPBIBusXMLHelper {
    private static final XQELogger LOGGER = ROLAPLog.getLogger("ROLAPCubes.Management");
    private static final QName QN_BUS_STATUS = DocumentHelper.createQName((String)"status", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName QN_BUS_ASYNCH_REPLY_STATUS_ENUM = DocumentHelper.createQName((String)"asynchReplyStatusEnum", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName QN_WAIT_RESPONSE = DocumentHelper.createQName((String)"waitResponse");
    private static final QName QN_BUS_SECONDARY_REQUESTS = DocumentHelper.createQName((String)"secondaryRequests", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName QN_BUS_ASYNCH_SECONDARY_REQUEST = DocumentHelper.createQName((String)"asynchSecondaryRequest", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName QN_NAME = DocumentHelper.createQName((String)"name");
    private static final String MESSAGE_CONTEXT_PROPERTY_RESPONSE_ENVELOPE = "response.envelope";
    private static final String[] SECONDARY_REQUEST_NAMES = new String[]{"wait"};
    private String primaryRequestElementName;

    public void cachePrimaryRequestInfo(BIBusEnvelope requestEnvelope, boolean alwaysIncludePrimaryRequest) {
        if (this.primaryRequestElementName == null) {
            ROLAPAsyncBIBusXMLHelper.logRequest(requestEnvelope, this.getLogMessagePrefix("cachePrimaryRequestInfo"));
            Element requestElement = (Element)requestEnvelope.getBody().elementIterator().next();
            this.primaryRequestElementName = requestElement.getName();
        }
    }

    public void changeCompletedPrimaryToWaitResponse(MessageContext messageContext) {
        ROLAPAsyncBIBusXMLHelper.logResponse(messageContext, this.getLogMessagePrefix("changeCompletedPrimaryToWaitResponse entry"));
        BIBusEnvelope responseEnvelope = (BIBusEnvelope)messageContext.getProperty(MESSAGE_CONTEXT_PROPERTY_RESPONSE_ENVELOPE);
        Element responseBodyElement = responseEnvelope.getBody();
        Element primaryResponseElement = responseBodyElement.element(ROLAPCommandResponseUtility.getResponseElementName(this.primaryRequestElementName));
        Element resultElement = primaryResponseElement.element(QN_RESULT.getName());
        resultElement.detach();
        primaryResponseElement.detach();
        Element waitResponse = responseBodyElement.addElement(QN_WAIT_RESPONSE);
        waitResponse.add(resultElement);
        ROLAPAsyncBIBusXMLHelper.logResponse(messageContext, this.getLogMessagePrefix("changeCompletedPrimaryToWaitResponse exit"));
    }

    public void prepareCompletedPrimaryResponse(MessageContext messageContext) {
    }

    public void prepareStillWorkingResponse(MessageContext messageContext) {
        ROLAPAsyncBIBusXMLHelper.prepareWaitResponse(messageContext, QN_WAIT_RESPONSE.getQualifiedName(), AsynchReplyStatusEnum.stillWorking);
        ROLAPAsyncBIBusXMLHelper.logResponse(messageContext, this.getLogMessagePrefix("prepareStillWorkingResponse"));
    }

    public void prepareWorkingResponse(MessageContext messageContext) {
        ROLAPAsyncBIBusXMLHelper.prepareWaitResponse(messageContext, ROLAPCommandResponseUtility.getResponseElementName(this.primaryRequestElementName), AsynchReplyStatusEnum.working);
        ROLAPAsyncBIBusXMLHelper.logResponse(messageContext, this.getLogMessagePrefix("prepareWorkingResponse"));
    }

    private static void prepareWaitResponse(MessageContext messageContext, String responseElementName, AsynchReplyStatusEnum status) {
        BIBusEnvelope responseEnvelope = (BIBusEnvelope)messageContext.getProperty(MESSAGE_CONTEXT_PROPERTY_RESPONSE_ENVELOPE);
        Element responseElement = responseEnvelope.getBody().addElement(responseElementName);
        responseEnvelope.addRequiredEnvNamespaces(responseElement);
        Element resultElement = ROLAPAsyncBIBusXMLHelper.addResultElement(responseElement);
        ROLAPAsyncBIBusXMLHelper.addSecondaryRequests(resultElement);
        ROLAPAsyncBIBusXMLHelper.addStatusElement(responseEnvelope, resultElement, status);
    }

    private static Element addSecondaryRequests(Element resultElement) {
        Element secondaryRequests = resultElement.addElement(QN_BUS_SECONDARY_REQUESTS);
        secondaryRequests.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        secondaryRequests.addAttribute(BIBusEnvelope.SOAP_ENC_ARRAYTYPE, QN_BUS_ASYNCH_SECONDARY_REQUEST.getQualifiedName() + "[" + SECONDARY_REQUEST_NAMES.length + "]");
        for (String secondaryRequestName : SECONDARY_REQUEST_NAMES) {
            ROLAPAsyncBIBusXMLHelper.addItemSecondaryRequest(secondaryRequests, secondaryRequestName);
        }
        return secondaryRequests;
    }

    private static Element addItemSecondaryRequest(Element secondaryRequests, String secondaryRequestName) {
        Element itemElement = secondaryRequests.addElement(BIBusEnvelope.ITEM);
        itemElement.addAttribute(BIBusEnvelope.XSI_TYPE, QN_BUS_ASYNCH_SECONDARY_REQUEST.getQualifiedName());
        Element nameElement = itemElement.addElement(QN_NAME);
        nameElement.addAttribute(BIBusEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        nameElement.setText(secondaryRequestName);
        return itemElement;
    }

    public BIBusEnvelope createResponseEnvelope(BIBusEnvelope requestEnvelope, String commandName, List<String> cubeNames, IROLAPCommandResult cubeResult) {
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        ROLAPAsyncBIBusXMLHelper.addCommandResponseElement(requestEnvelope, responseEnvelope, commandName, cubeNames, cubeResult);
        return responseEnvelope;
    }

    private static void addCommandResponseElement(BIBusEnvelope requestEnvelope, BIBusEnvelope responseEnvelope, String commandName, List<String> cubeNames, IROLAPCommandResult cubeResult) {
        Element commandResponseElement = ROLAPCommandResponseUtility.createCommandResponseElement(commandName);
        Element resultElement = ROLAPAsyncBIBusXMLHelper.addResultElement(commandResponseElement);
        if (cubeResult != null) {
            cubeResult.render(resultElement, commandName);
        }
        ROLAPAsyncBIBusXMLHelper.addStatusElement(responseEnvelope, resultElement, AsynchReplyStatusEnum.conversationComplete);
        responseEnvelope.getBody().add(commandResponseElement);
    }

    private static Element addResultElement(Element commandResponseElement) {
        Element resultElement = commandResponseElement.addElement(QN_RESULT);
        resultElement.addAttribute(SOAPEnvelope.XSI_TYPE, QN_BUS_ASYNCH_REPLY.getQualifiedName());
        return resultElement;
    }

    public static void addStatusElement(BIBusEnvelope envelope, Element resultElement, AsynchReplyStatusEnum status) {
        Element statusElement = resultElement.addElement(QN_BUS_STATUS);
        statusElement.addAttribute(SOAPEnvelope.XSI_TYPE, QN_BUS_ASYNCH_REPLY_STATUS_ENUM.getQualifiedName());
        statusElement.addText(status.getValue());
        envelope.setConversationContextStatus(status.getValue());
    }

    public static boolean isAsynchRequest(BIBusEnvelope requestEnvelope) {
        Element element;
        String elementName;
        boolean isAsynchRequest = false;
        Iterator elementIterator = requestEnvelope.getBody().elementIterator();
        if (elementIterator.hasNext() && ("getCubeState".equals(elementName = (element = (Element)elementIterator.next()).getName()) || "refreshCubeDataCache".equals(elementName) || "refreshCubeMemberCache".equals(elementName) || "refreshCubeSecurity".equals(elementName) || "restartCubes".equals(elementName) || "startCubes".equals(elementName) || "stopCubes".equals(elementName) || "pauseCubes".equals(elementName) || "incrementallyLoadCubes".equals(elementName) || "getCubeMetrics".equals(elementName) || "clearCubeWorkloadLog".equals(elementName))) {
            isAsynchRequest = true;
        }
        return isAsynchRequest;
    }

    private String getLogMessagePrefix(String methodDescription) {
        return "[" + ((Object)((Object)this)).getClass().getSimpleName() + "." + methodDescription + "]" + " ";
    }

    private static void logRequest(BIBusEnvelope requestEnvelope, String logMessagePrefix) {
        if (LOGGER.isOn(LogLevel.TRACE)) {
            try {
                String requestEnvelopeString = requestEnvelope.getAsString();
                LOGGER.log(LogLevel.TRACE, logMessagePrefix + "Request envelope: " + requestEnvelopeString);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void logResponse(MessageContext messageContext, String logMessagePrefix) {
        if (LOGGER.isOn(LogLevel.TRACE)) {
            BIBusEnvelope responseEnvelope = (BIBusEnvelope)messageContext.getProperty(MESSAGE_CONTEXT_PROPERTY_RESPONSE_ENVELOPE);
            try {
                String responseEnvelopeString = responseEnvelope.getAsString();
                LOGGER.log(LogLevel.TRACE, logMessagePrefix + "Response envelope: " + responseEnvelopeString);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

