/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqebifw.bibushandler.ROLAPCubeAdminCommandRequestUtility;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class ROLAPCubeAdminCommandRequestAdapter
extends RequestAdapter {
    public static final String ROLAPADMINCOMMAND_OP_NAME = "ROLAPAdminCommands";
    public static final String CUBENAMES_ELEMENT_NAME = "cubeNames";
    private static final String TRUE = "true";

    private static List<String> getCubeNames(Element commandElement) {
        ArrayList<String> cubeNames = new ArrayList<String>();
        Element cubeNamesElement = commandElement.element(CUBENAMES_ELEMENT_NAME);
        List childElements = cubeNamesElement.elements();
        for (Element childElement : childElements) {
            cubeNames.add(childElement.getText());
        }
        return cubeNames;
    }

    private static Element getCommandElement(BIBusEnvelope requestEnvelope) {
        Element commandElement = (Element)requestEnvelope.getBody().elementIterator().next();
        return commandElement;
    }

    @Override
    public ResponseAdapter executeRequest(RequestEnvironment environment) throws XQEException, IOException {
        BIBusEnvelope requestEnvelope = environment.getRequestEnvelope();
        ROLAPCubeAdminCommandRequestUtility.logRequestBody(requestEnvelope);
        Element commandElement = ROLAPCubeAdminCommandRequestAdapter.getCommandElement(requestEnvelope);
        String commandName = commandElement.getName();
        Object[] params = null;
        Element options = commandElement.element("options");
        List childElements = options.elements();
        for (Element childElement : childElements) {
            String name = childElement.elementText("name");
            String value = childElement.elementText("value");
            if (name.indexOf("startROLAPCubesAndSourceCubes") != -1) {
                params = new Object[]{Boolean.valueOf(value)};
                break;
            }
            if (name.indexOf("stopROLAPCubesImmediately") != -1) {
                params = new Object[]{Boolean.valueOf(value)};
                break;
            }
            if (name.indexOf("transactionID") == -1) continue;
            params = new Object[]{value};
            break;
        }
        List<String> cubeNames = ROLAPCubeAdminCommandRequestAdapter.getCubeNames(commandElement);
        ResponseAdapter responseAdapter = ROLAPCubeAdminCommandRequestUtility.executeRequest(requestEnvelope, commandName, cubeNames, params);
        return responseAdapter;
    }

    @Override
    public String getOperationName() {
        return ROLAPADMINCOMMAND_OP_NAME;
    }

    @Override
    protected boolean requiresCancelableRegistration() {
        return false;
    }

    @Override
    public boolean requiresMultiRequestContext() {
        return false;
    }
}

