/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.ContentManagerServiceStub;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.DateTimeProp;
import com.cognos.developer.schemas.bibus._3.HistoryDetail;
import com.cognos.developer.schemas.bibus._3.MonitorService_PortType;
import com.cognos.developer.schemas.bibus._3.MonitorService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Session;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.SeverityEnumProp;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnumArrayProp;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.common.UserCapabilityCache;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCommandResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeCommandResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.xml.XMLUtils;
import com.cognos.xqebifw.bibushandler.ROLAPAsyncBIBusXMLHelper;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import com.cognos.xqebifw.bibushandler.WaitRequestAdapter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.dom4j.Element;
import org.dom4j.Node;

public class ROLAPCubeAdminCommandRequestUtility {
    public static final String GET_CUBE_STATE = "getCubeState";
    public static final String GET_CUBE_METRICS = "getCubeMetrics";
    public static final String REFRESH_CUBE_DATA_CACHE = "refreshCubeDataCache";
    public static final String REFRESH_CUBE_MEMBER_CACHE = "refreshCubeMemberCache";
    public static final String REFRESH_CUBE_SECURITY = "refreshCubeSecurity";
    public static final String RESTART_CUBES = "restartCubes";
    public static final String START_CUBES = "startCubes";
    public static final String FORCE_START_CUBES = "forceStartCubes";
    public static final String STOP_CUBES = "stopCubes";
    public static final String FORCE_STOP_CUBES = "forceStopCubes";
    public static final String CLEAR_CUBE_WORKLOAD_LOG = "clearCubeWorkloadLog";
    public static final String PAUSE_CUBES = "pauseCubes";
    public static final String INCREMENTALLY_LOAD_CUBES = "incrementallyLoadCubes";
    private static final String DELIMITER = ", ";
    private static final int CM_STUB_TIMEOUT = 600000;
    private static final XQELogger INFO_LOGGER = ROLAPLog.getLogger("ROLAPCubes.Management");
    private static ROLAPCubeAdminCommandRequestUtlityAdaptor adaptorInst = new ROLAPCubeAdminCommandRequestUtlityAdaptor();

    public static ResponseAdapter executeRequest(BIBusEnvelope requestEnvelope, String commandName, List<String> cubeNames, Object[] params) throws XQEException {
        return adaptorInst.executeRequest(commandName, cubeNames, params, requestEnvelope);
    }

    private static IROLAPCommandResult executeCommand(String commandName, List<String> cubeNames, Object[] params) {
        IROLAPCommandResult result = null;
        INFO_LOGGER.log(LogLevel.INFO, ROLAPCubeAdminCommandRequestUtility.getLogMessagePrefix(commandName, cubeNames) + "Command execution is starting.");
        try {
            if (commandName.equals(GET_CUBE_STATE)) {
                result = ROLAPCubeManager.getInstance().getCubeState(cubeNames);
            } else if (commandName.equals(GET_CUBE_METRICS)) {
                result = ROLAPCubeManager.getInstance().getCubeMetrics(cubeNames);
            } else {
                ROLAPCubeManager.AdminCommandManagerTask adminCommandManagerTask = null;
                if (commandName.equals(REFRESH_CUBE_DATA_CACHE)) {
                    adminCommandManagerTask = ROLAPCubeManager.getInstance().refreshCubeDataCache(cubeNames);
                } else if (commandName.equals(REFRESH_CUBE_MEMBER_CACHE)) {
                    adminCommandManagerTask = ROLAPCubeManager.getInstance().refreshCubeMemberCache(cubeNames);
                } else if (commandName.equals(REFRESH_CUBE_SECURITY)) {
                    adminCommandManagerTask = ROLAPCubeManager.getInstance().refreshCubeSecurity(cubeNames);
                } else if (commandName.equals(RESTART_CUBES)) {
                    adminCommandManagerTask = ROLAPCubeManager.getInstance().restartCubes(cubeNames);
                } else if (commandName.equals(START_CUBES)) {
                    boolean force = false;
                    if (params != null && params.length == 1 && params[0] != null && params[0].getClass() == Boolean.class) {
                        force = (Boolean)params[0];
                    }
                    adminCommandManagerTask = force ? ROLAPCubeManager.getInstance().forceStartCubes(cubeNames, false) : ROLAPCubeManager.getInstance().startCubes(cubeNames);
                } else if (commandName.equals(STOP_CUBES)) {
                    boolean force = false;
                    if (params != null && params.length == 1 && params[0] != null && params[0].getClass() == Boolean.class) {
                        force = (Boolean)params[0];
                    }
                    adminCommandManagerTask = force ? ROLAPCubeManager.getInstance().forceStopCubes(cubeNames) : ROLAPCubeManager.getInstance().stopCubes(cubeNames);
                } else if (commandName.equals(PAUSE_CUBES)) {
                    adminCommandManagerTask = ROLAPCubeManager.getInstance().pauseCubes(cubeNames);
                } else if (commandName.equals(INCREMENTALLY_LOAD_CUBES)) {
                    String tid = null;
                    if (params != null && params.length == 1 && params[0] != null) {
                        tid = params[0].toString();
                    }
                    adminCommandManagerTask = ROLAPCubeManager.getInstance().incrementallyLoadCubes(cubeNames, tid);
                } else if (commandName.equals(CLEAR_CUBE_WORKLOAD_LOG)) {
                    adminCommandManagerTask = ROLAPCubeManager.getInstance().clearCubeWorkloadLog(cubeNames);
                }
                if (adminCommandManagerTask != null) {
                    while (!adminCommandManagerTask.isDone()) {
                        INFO_LOGGER.log(LogLevel.INFO, ROLAPCubeAdminCommandRequestUtility.getLogMessagePrefix(commandName, cubeNames) + "Command execution is pending.");
                        ROLAPCubeManager.adminWait(Long.MAX_VALUE, adminCommandManagerTask);
                    }
                    result = adminCommandManagerTask.getResult();
                }
            }
            INFO_LOGGER.log(LogLevel.INFO, ROLAPCubeAdminCommandRequestUtility.getLogMessagePrefix(commandName, cubeNames) + "Command execution finished.");
        }
        catch (XQERuntimeException e) {
            INFO_LOGGER.log(LogLevel.ERROR, ROLAPCubeAdminCommandRequestUtility.getLogMessagePrefix(commandName, cubeNames) + "Command execution failed.", (Throwable)e);
            throw e;
        }
        return result;
    }

    private static String toString(List<String> strings) {
        Iterator<String> stringIterator = strings.iterator();
        StringBuilder stringBuffer = new StringBuilder();
        while (stringIterator.hasNext()) {
            stringBuffer.append(stringIterator.next());
            if (!stringIterator.hasNext()) continue;
            stringBuffer.append(DELIMITER);
        }
        return stringBuffer.toString();
    }

    private static String getLogMessagePrefix(String commandName, List<String> cubeNames) {
        return "[" + commandName + "(" + ROLAPCubeAdminCommandRequestUtility.toString(cubeNames) + ")] ";
    }

    public static void logRequestBody(BIBusEnvelope requestEnvelope) {
        if (INFO_LOGGER.isOn(LogLevel.TRACE)) {
            try {
                Element requestBody = requestEnvelope.getBody();
                INFO_LOGGER.log(LogLevel.TRACE, "Request envelope body: " + XMLUtils.toString((Node)requestBody));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void logResponseBody(String commandName, List<String> cubeNames, BIBusEnvelope responseEnvelope) {
        if (INFO_LOGGER.isOn(LogLevel.TRACE)) {
            try {
                Element responseBody = responseEnvelope.getBody();
                INFO_LOGGER.log(LogLevel.TRACE, ROLAPCubeAdminCommandRequestUtility.getLogMessagePrefix(commandName, cubeNames) + "Response envelope body: " + XMLUtils.toString((Node)responseBody));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void setAdaptor(ROLAPCubeAdminCommandRequestUtlityAdaptor adaptor) {
        adaptorInst = adaptor;
    }

    public static class ROLAPCubeAdminCommandRequestUtlityAdaptor {
        public SimpleResponseAdapter executeRequest(String commandName, List<String> cubeNames, Object[] params, BIBusEnvelope requestEnvelope) throws XQEException {
            boolean hasCapabilities;
            try {
                hasCapabilities = ROLAPCubeAdminCommandRequestUtlityAdaptor.hasRequiredCapabilities(requestEnvelope);
            }
            catch (Exception e) {
                INFO_LOGGER.log(LogLevel.ERROR, ROLAPCubeAdminCommandRequestUtility.getLogMessagePrefix(commandName, cubeNames) + "Error.", (Throwable)e);
                throw new XQEException(XQEMessageKeys.ROL_CubeAdminCommandFailed, commandName, cubeNames.toString());
            }
            if (hasCapabilities) {
                WaitRequestAdapter.registerConversation(requestEnvelope);
                IROLAPCommandResult cubeResult = ROLAPCubeAdminCommandRequestUtility.executeCommand(commandName, cubeNames, params);
                BIBusEnvelope responseEnvelope = null;
                Element runElement = requestEnvelope.getBody().element("run");
                if (runElement != null) {
                    responseEnvelope = this.renderJobResult(requestEnvelope, runElement, cubeResult);
                }
                if (responseEnvelope == null) {
                    ROLAPAsyncBIBusXMLHelper asyncBIBusXMLHelper = new ROLAPAsyncBIBusXMLHelper();
                    responseEnvelope = asyncBIBusXMLHelper.createResponseEnvelope(requestEnvelope, commandName, cubeNames, cubeResult);
                }
                WaitRequestAdapter.cacheResponse(requestEnvelope, responseEnvelope);
                ROLAPCubeAdminCommandRequestUtility.logResponseBody(commandName, cubeNames, responseEnvelope);
                return new SimpleResponseAdapter(responseEnvelope, Collections.emptyList());
            }
            throw new XQEException(XQEMessageKeys.ROL_CubeAdminCommandCapabilitiesDoNotExist, commandName, (Object)cubeNames.toString(), (Object)"canUseDataSourcesTool, canUseServerAdministrationTool");
        }

        private BIBusEnvelope renderJobResult(BIBusEnvelope requestEnvelope, Element runElement, IROLAPCommandResult cubeResult) {
            ROLAPCubeCommandResult result = (ROLAPCubeCommandResult)cubeResult;
            String eventID = null;
            Element options = runElement.element("options");
            if (options != null) {
                Iterator iter = options.elementIterator();
                while (iter.hasNext()) {
                    Element value;
                    Element name;
                    Element item = (Element)iter.next();
                    String type = item.attributeValue("type");
                    if (type == null || !type.endsWith("asynchOptionStringArray") || (name = item.element("name")) == null || !"runContext".equals(name.getText()) || (value = item.element("value")) == null) continue;
                    List values = value.elements("value");
                    for (Object val : values) {
                        eventID = ((Element)val).getText();
                    }
                }
            }
            Map<String, ROLAPCubeCommandResult.ResultDetails> results = result.getResultMap();
            ArrayList<HistoryDetail> historyEntries = new ArrayList<HistoryDetail>();
            boolean jobFailed = false;
            for (Map.Entry<String, ROLAPCubeCommandResult.ResultDetails> entry : results.entrySet()) {
                HistoryDetail history = new HistoryDetail();
                SeverityEnumProp sev = new SeverityEnumProp();
                if (entry.getValue().isSuccess()) {
                    sev.setValue(SeverityEnum.info);
                } else {
                    sev.setValue(SeverityEnum.error);
                    jobFailed = true;
                }
                history.setSeverity(sev);
                StringProp str = new StringProp();
                str.setValue(entry.getValue().getMessage());
                history.setDetail(str);
                DateTimeProp time = new DateTimeProp();
                time.setValue(Calendar.getInstance());
                history.setDetailTime(time);
                historyEntries.add(history);
            }
            if (!historyEntries.isEmpty()) {
                if (eventID == null) {
                    INFO_LOGGER.log(LogLevel.ERROR, "Job event ID not found");
                } else {
                    URL cmURL = null;
                    try {
                        cmURL = new URL(ROLAPCubeManager.getInstance().getInternalDispatcherURI());
                        MonitorService_ServiceLocator monitorServiceLocator = new MonitorService_ServiceLocator();
                        MonitorService_PortType monitorService = monitorServiceLocator.getmonitorService(cmURL);
                        ROLAPCubeAdminCommandRequestUtlityAdaptor.setUpPassportHeader((Stub)monitorService, requestEnvelope);
                        AsynchReply reply = monitorService.add(eventID, (BaseClass[])historyEntries.toArray(new HistoryDetail[0]), new ParameterValue[0], new Option[0]);
                        AsynchReplyStatusEnum replyStatus = reply.getStatus();
                        while (replyStatus == AsynchReplyStatusEnum.working || replyStatus == AsynchReplyStatusEnum.stillWorking) {
                            reply = monitorService.wait(reply.getPrimaryRequest(), new ParameterValue[0], new Option[0]);
                            replyStatus = reply.getStatus();
                        }
                    }
                    catch (Exception e) {
                        INFO_LOGGER.log(LogLevel.ERROR, "Error posting job history", (Throwable)e);
                    }
                }
            }
            if (!jobFailed) {
                return null;
            }
            String message = XQEMessages.getMessage(XQEMessageKeys.ROL_AdminCommandFailed, XQEMessages.getCurrProductLocale());
            Fault fault = new Fault(message);
            fault.setDetailMessasge(message);
            return new BIBusEnvelope(fault.generateEnvelope().getAsDocument());
        }

        public static boolean hasRequiredCapabilities(BIBusEnvelope requestEnvelope) throws MalformedURLException, CCLConfigurationException, ServiceException, RemoteException {
            com.cognos.pogo.pdk.common.BiBusHeader biBusHeader = requestEnvelope.getBiBusHeader();
            UserCapabilityCache userCapabilityCache = biBusHeader.getUserCapabilityCache();
            if (!userCapabilityCache.hasItem("canUseDataSourcesTool") && !userCapabilityCache.hasItem("canUseServerAdministrationTool")) {
                return false;
            }
            for (UserCapabilityEnum capEnum : ROLAPCubeAdminCommandRequestUtlityAdaptor.queryForUserCapabilities(ROLAPCubeAdminCommandRequestUtlityAdaptor.getContentManagerService(requestEnvelope))) {
                if (!capEnum.getValue().equals("canUseDataSourcesTool") && !capEnum.getValue().equals("canUseServerAdministrationTool")) continue;
                return true;
            }
            return false;
        }

        private static ContentManagerService_PortType getContentManagerService(BIBusEnvelope requestEnvelope) throws MalformedURLException, CCLConfigurationException, ServiceException {
            ContentManagerService_ServiceLocator serviceLocator = new ContentManagerService_ServiceLocator();
            URL dispUrl = new URL(CCLConfigurationFactory.getInstance().getValue("internalDispatcher", false));
            ContentManagerService_PortType cmService = serviceLocator.getcontentManagerService(dispUrl);
            ROLAPCubeAdminCommandRequestUtlityAdaptor.initializeCMStub((ContentManagerServiceStub)cmService, requestEnvelope);
            return cmService;
        }

        private static UserCapabilityEnum[] queryForUserCapabilities(ContentManagerService_PortType cmService) throws RemoteException {
            SearchPathMultipleObject smo = new SearchPathMultipleObject("~~");
            PropEnum[] props = new PropEnum[]{PropEnum.defaultName, PropEnum.userCapabilities};
            QueryOptions options = new QueryOptions();
            BaseClass[] objs = cmService.query(smo, props, null, options);
            Session sessionObj = (Session)objs[0];
            UserCapabilityEnumArrayProp capabilites = sessionObj.getUserCapabilities();
            return capabilites.getValue();
        }

        private static BiBusHeader setUpPassportHeader(Stub stub, BIBusEnvelope requestEnvelope) {
            String passport = requestEnvelope.getBiBusHeader().getCam().getCAMPassport().getId();
            BiBusHeader header = new BiBusHeader();
            CAM cam = new CAM();
            CAMPassport campassport = new CAMPassport();
            if (passport != null && passport.length() > 0) {
                campassport.setId(passport);
            }
            cam.setCAMPassport(campassport);
            header.setCAM(cam);
            stub.setHeader(ROLAPCube.BI_BUS_HEADER_QNAME.getNamespaceURI(), ROLAPCube.BI_BUS_HEADER_QNAME.getLocalPart(), (Object)header);
            return header;
        }

        private static BiBusHeader initializeCMStub(ContentManagerServiceStub stub, BIBusEnvelope requestEnvelope) {
            BiBusHeader header = ROLAPCubeAdminCommandRequestUtlityAdaptor.setUpPassportHeader((Stub)stub, requestEnvelope);
            stub._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
            stub.setTimeout(600000);
            return header;
        }
    }
}

