/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import java.util.List;
import org.dom4j.Element;

public class ReleaseDatasetRequestAdapter
extends RequestAdapter {
    public static final String RELEASE_DATASET_ELEMENT_NAME = "releaseDataset";
    private static final String ID_ATTRIBUTE = "id";
    private static final String MASTER_DATASET = "masterDataset";
    public static final String PARTIAL_DATASET = "partialDataset";
    private static final String PLANNED_MASTER_DATASET = "plannedMasterDataset";
    private static final XQELogger ERROR_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "Exception", LogLevel.ERROR);

    @Override
    public ResponseAdapter executeRequest(RequestEnvironment environment) throws XQEException {
        MetricsService.collectMetricInfo(environment, "requestType", RELEASE_DATASET_ELEMENT_NAME);
        BIBusEnvelope requestEnvelope = environment.getRequestEnvelope();
        Element releaseDatasetElement = requestEnvelope.getBody().element(RELEASE_DATASET_ELEMENT_NAME);
        List masterDatasetElementList = releaseDatasetElement.elements(MASTER_DATASET);
        List partialDatasetElementList = releaseDatasetElement.elements(PARTIAL_DATASET);
        List plannedMasterDatasetElementList = releaseDatasetElement.elements(PLANNED_MASTER_DATASET);
        ReleaseDatasetRequestAdapter.releaseDataset(environment, masterDatasetElementList, partialDatasetElementList, plannedMasterDatasetElementList);
        return NULL_RESPONSE_ADAPTER;
    }

    @Override
    public String getOperationName() {
        return RELEASE_DATASET_ELEMENT_NAME;
    }

    @Override
    protected boolean requiresCancelableRegistration() {
        return false;
    }

    public static void releaseDataset(RequestEnvironment environment, List<Element> masterDatasetIDs, List<Element> partialDatasetIDs, List<Element> plannedMasterDatasetIDs) {
        String id;
        Throwable error = null;
        try {
            QueryEngine.getInstance().setCachedMultiRequestContext(environment);
        }
        catch (Throwable t) {
            error = t;
        }
        try {
            StringBuilder zipiObjPath = new StringBuilder();
            for (Element partialDatasetElement : partialDatasetIDs) {
                RSAPIDataset ds;
                String id2 = partialDatasetElement.attributeValue(ID_ATTRIBUTE);
                if (null == id2 || id2.length() <= 0) continue;
                String mdsID = null;
                RSAPIPartialDataset pds = QueryEngine.getInstance().getPartialDatasetByID(id2);
                if (pds != null && (ds = pds.getMasterDataset()) != null) {
                    mdsID = ds.getUniqueID();
                    zipiObjPath.append(ds.getName());
                }
                QueryEngine.getInstance().releasePartialDataset(id2);
                ROLAPContext.endFirstPage(mdsID);
            }
            ZipiBridge.setZipiContextAndObjPath(zipiObjPath.toString());
        }
        catch (Throwable t) {
            if (error != null) {
                ERROR_LOGGER.log(LogLevel.ERROR, error);
            }
            error = t;
        }
        try {
            for (Element masterDatasetElement : masterDatasetIDs) {
                id = masterDatasetElement.attributeValue(ID_ATTRIBUTE);
                if (null == id || id.length() <= 0) continue;
                QueryEngine.getInstance().releaseMasterDataset((ExecutionEnvironment)environment.getExecutionEnvironment(), id);
            }
        }
        catch (Throwable t) {
            if (error != null) {
                ERROR_LOGGER.log(LogLevel.ERROR, error);
            }
            error = t;
        }
        try {
            for (Element plannedDatasetElement : plannedMasterDatasetIDs) {
                id = plannedDatasetElement.attributeValue(ID_ATTRIBUTE);
                if (null == id || id.length() <= 0) continue;
                QueryEngine.getInstance().removeMasterDatasetAndMultiRequestContext(id, environment);
            }
        }
        catch (Throwable t) {
            if (error != null) {
                ERROR_LOGGER.log(LogLevel.ERROR, error);
            }
            error = t;
        }
        if (error != null) {
            throw new XQERuntimeException(error);
        }
    }
}

