/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.pogo.async.service.AsyncBIBusXMLHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.pdk.common.BiBusHeader;
import com.cognos.pogo.pdk.common.ConversationContext;
import com.cognos.pogo.pdk.common.Tracking;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqebifw.bibushandler.ROLAPAsyncBIBusXMLHelper;
import com.cognos.xqebifw.bibushandler.ROLAPCubeAdminCommandRequestUtility;
import com.cognos.xqebifw.bibushandler.RequestAdapter;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocumentFactory;

public class WaitRequestAdapter
extends RequestAdapter {
    private static final long MILLIS_TO_WAIT_FOR_CONVERSATION_ID = 250L;
    private static final int NUM_TIMES_TO_WAIT_FOR_CONVERSATION_ID_TO_BE_ADDED = 20;
    public static final String WAIT_ELEMENT_NAME = "wait";
    public static final String WAIT_RESPONSE_ELEMENT_NAME = "waitResponse";
    public static final long MILLIS_IN_SECOND = 1000L;
    public static final long EXPIRATION_PERIOD = TimeUnit.MINUTES.toNanos(30L);
    private static final String CONVERSATION_ID_UNAVAILABLE = "Conversation ID is missing from request envelope";
    private static ConcurrentHashMap<String, ConversationRecord> mResultMap = new ConcurrentHashMap();

    @Override
    public ResponseAdapter executeRequest(RequestEnvironment environment) throws XQEException, IOException {
        int threshold;
        boolean hasCapabilities;
        MetricsService.collectMetricInfo(environment, "requestType", WAIT_ELEMENT_NAME);
        BIBusEnvelope requestEnvelope = environment.getRequestEnvelope();
        try {
            hasCapabilities = ROLAPCubeAdminCommandRequestUtility.ROLAPCubeAdminCommandRequestUtlityAdaptor.hasRequiredCapabilities(requestEnvelope);
        }
        catch (Exception e) {
            throw new XQEException(e);
        }
        if (!hasCapabilities) {
            throw new XQEException(XQEMessageKeys.ROL_DynamicCubeAdminCommandCapabilitiesDoNotExist, "canUseDataSourcesTool,canUseServerAdministrationTool");
        }
        Element cachedResponse = WaitRequestAdapter.retrieveCachedResponse(requestEnvelope);
        if (cachedResponse == null && (threshold = AsyncBIBusXMLHelper.getPrimaryWaitThreshold((Element)((Element)requestEnvelope.getBody().elementIterator().next()))) > 0) {
            while (threshold > 0 && cachedResponse == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                cachedResponse = WaitRequestAdapter.retrieveCachedResponse(requestEnvelope);
                --threshold;
            }
        }
        BIBusEnvelope responseEnvelope = new BIBusEnvelope();
        if (cachedResponse == null) {
            Element commandResponseElement = DOMDocumentFactory.getInstance().createElement(WAIT_RESPONSE_ELEMENT_NAME);
            responseEnvelope.getBody().add(commandResponseElement);
            Element resultElement = commandResponseElement.addElement(ROLAPAsyncBIBusXMLHelper.QN_RESULT);
            resultElement.addAttribute(SOAPEnvelope.XSI_TYPE, ROLAPAsyncBIBusXMLHelper.QN_BUS_ASYNCH_REPLY.getQualifiedName());
            ROLAPAsyncBIBusXMLHelper.addStatusElement(responseEnvelope, resultElement, AsynchReplyStatusEnum.working);
        } else {
            responseEnvelope.getBody().add((Element)cachedResponse.clone());
        }
        return new SimpleResponseAdapter(responseEnvelope, Collections.emptyList());
    }

    @Override
    public String getOperationName() {
        return WAIT_ELEMENT_NAME;
    }

    @Override
    protected boolean requiresCancelableRegistration() {
        return false;
    }

    @Override
    public boolean requiresMultiRequestContext() {
        return false;
    }

    private static String getConversationID(BIBusEnvelope requestEnvelope) {
        ConversationContext context;
        Tracking tracking;
        BiBusHeader header = requestEnvelope.getBiBusHeader();
        String id = null;
        if (header != null && (tracking = header.getTracking()) != null && (context = tracking.getConversationContext()) != null) {
            id = context.getId();
        }
        return id;
    }

    public static void registerConversation(BIBusEnvelope requestEnvelope) {
        String id = WaitRequestAdapter.getConversationID(requestEnvelope);
        if (id == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, CONVERSATION_ID_UNAVAILABLE);
        }
        mResultMap.put(id, new ConversationRecord());
        WaitRequestAdapter.cleanMap();
    }

    public static void cacheResponse(BIBusEnvelope requestEnvelope, BIBusEnvelope responseEnvelope) {
        String id = WaitRequestAdapter.getConversationID(requestEnvelope);
        if (id == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, CONVERSATION_ID_UNAVAILABLE);
        }
        ConversationRecord rec = mResultMap.get(id);
        if (rec != null) {
            rec.setResponse((Element)responseEnvelope.getBody().elementIterator().next());
            rec.setTimestamp(System.nanoTime());
        }
    }

    private static Element retrieveCachedResponse(BIBusEnvelope requestEnvelope) {
        String id = WaitRequestAdapter.getConversationID(requestEnvelope);
        if (id == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, CONVERSATION_ID_UNAVAILABLE);
        }
        ConversationRecord rec = mResultMap.get(id);
        for (int i = 0; i < 20 && rec == null; ++i) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                throw new XQERuntimeException(e);
            }
            rec = mResultMap.get(id);
        }
        WaitRequestAdapter.cleanMap();
        if (rec == null) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_UnknownConversation, id);
        }
        return rec.getResponse();
    }

    private static void cleanMap() {
        for (String key : mResultMap.keySet()) {
            ConversationRecord conv = mResultMap.get(key);
            if (conv.getTimestamp() == 0L || conv.getTimestamp() + EXPIRATION_PERIOD >= System.nanoTime()) continue;
            mResultMap.remove(key);
        }
    }

    private static class ConversationRecord {
        private Element mResponse = null;
        private final AtomicLong mTimestamp = new AtomicLong(0L);

        private ConversationRecord() {
        }

        public Element getResponse() {
            return this.mResponse;
        }

        public void setResponse(Element response) {
            this.mResponse = response;
        }

        public long getTimestamp() {
            return this.mTimestamp.get();
        }

        public void setTimestamp(long timestamp) {
            this.mTimestamp.set(timestamp);
        }
    }
}

