/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.DecimalValue;
import com.cognos.xqe.data.values.ExactNumericValue;
import com.cognos.xqe.data.values.IntervalDayTimeValue;
import com.cognos.xqe.data.values.IntervalYearMonthValue;
import com.cognos.xqe.data.values.TimeValue;
import com.cognos.xqe.data.values.TimeWithTZValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.TimestampWithTZValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.rsapi.RSAPICell;
import com.cognos.xqe.rsapi.RSAPICellIterator;
import com.cognos.xqe.rsapi.RSAPICellRowset;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.rsapi.RSAPIValue;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.util.Queue;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.xml.XMLWriter;
import com.cognos.xqebifw.bibushandler.GetDetailQueriesRequestAdapter;
import com.cognos.xqebifw.bibushandler.GetPartialDatasetRequestAdapter;
import com.cognos.xqebifw.bibushandler.XQENodeSerializer;
import com.cognos.xqebifw.bibushandler.binaryprotocol.IVarLenByteBufferOutputStream;
import com.cognos.xqebifw.bibushandler.binaryprotocol.VarLenByteBufferOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class XQEBinaryNodeSerializer {
    private static final int EDGE_TAG = 1;
    private static final int ROW_TAG = 2;
    private static final int COLUMN_TAG = 3;
    private static final int VALUE_TAG = 4;
    private static final int FORMAT_TAG = 5;
    private static final int FORMATID_TAG = 6;
    private static final int MODELID_TAG = 7;
    private static final int CURRENCYCODE_TAG = 8;
    private static final int UNITOFMEASURE_TAG = 9;
    private static final int COLUMN_INFO_TAG = 10;
    private static final int BREAKER_TAG = 11;
    private static final int MASTERDATASET_TAG = 12;
    private static final int DATASETINFO_TAG = 13;
    private static final int ROWSETINFO_TAG = 14;
    private static final int CHILDROWSET_TAG = 15;
    private static final int PARENTROWSET_TAG = 16;
    private static final int NEXTROWSET_TAG = 17;
    private static final int HEADERROWSET_TAG = 18;
    private static final int FOOTERROWSET_TAG = 19;
    private static final int MEASUREROWSET_TAG = 20;
    private static final int TIMEROWSET_TAG = 21;
    private static final int QUERY_TAG = 22;
    private static final int DETAILQUERY_TAG = 23;
    private static final int LINK_TAG = 24;
    private static final int PARAMETERS_TAG = 25;
    private static final int RSVP_MAX_STRING_PRECISION = Short.MAX_VALUE;
    private static final int RSVP_MAX_DECIMAL_LENGTH = 39;
    private static final int RSVP_MAX_DECIMAL_PRECISION = 77;
    private static final int RSVP_MIN_DECIMAL_SCALE = -255;
    private static final String CELLS = "cells";
    private static final String CELLITERATOR = "c_it";
    private static final String STR_DOT_OPEN_BRACKET = ".[";
    private static final String STR_DOT = ".";
    private static boolean formatMissingValuesInListReports = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] buildPartialDataset(VarLenByteBufferOutputStream out, RSAPIPartialDataset partialDataset, String masterDatasetId, Map<String, GetPartialDatasetRequestAdapter.EdgeChunkInfo> edgeChunkInfoMap) throws IOException {
        ROLAPContext.queryEnter(ExecutionEnvironmentContext.getExecutionEnvironment());
        boolean needToRemoveCubeName = false;
        try {
            GetPartialDatasetRequestAdapter.EdgeChunkInfo chunkInfo;
            GetPartialDatasetRequestAdapter.EdgeChunkInfo chunkInfo2;
            RSAPIEdgeIterator edgeIterator;
            StringDictionary stringDictionary = new StringDictionary();
            out.putString(partialDataset.getUniqueID());
            out.putString(masterDatasetId);
            RSAPIDataset masterDataset = partialDataset.getMasterDataset();
            RSAPIEdge[] edges = masterDataset.getEdges();
            needToRemoveCubeName = ROLAPContext.setCurrentCubeName(masterDataset.getPlanningEnvironment());
            for (int i = 0; i < edges.length; ++i) {
                edgeIterator = partialDataset.edgeIterator(i);
                String edgeName = edges[i].getName();
                chunkInfo2 = edgeChunkInfoMap.get(edgeName);
                if (chunkInfo2 == null) continue;
                out.putInt(1);
                out.putInt(i);
                out.putString(edgeName);
            }
            if (partialDataset.cellIterator() != null && (chunkInfo = edgeChunkInfoMap.get(CELLS)) != null) {
                out.putInt(1);
                out.putInt(edges.length);
                out.putString(CELLITERATOR);
            }
            HashMap<Integer, Boolean> edgeEndingFlags = new HashMap<Integer, Boolean>();
            for (int i = 0; i < edges.length; ++i) {
                edgeIterator = partialDataset.edgeIterator(i);
                String edgeName = edges[i].getName();
                GetPartialDatasetRequestAdapter.EdgeChunkInfo chunkInfo3 = edgeChunkInfoMap.get(edgeName);
                if (chunkInfo3 == null) continue;
                XQEBinaryNodeSerializer.serializeEdge(out, i, edgeIterator, chunkInfo3, edges[i], stringDictionary);
                if (edgeIterator.hasNext()) {
                    edgeEndingFlags.put(i, false);
                    continue;
                }
                edgeEndingFlags.put(i, true);
            }
            RSAPICellIterator cellIterator = partialDataset.cellIterator();
            if (cellIterator != null && (chunkInfo2 = edgeChunkInfoMap.get(CELLS)) != null) {
                int rowCount = 0;
                while (cellIterator.hasNext()) {
                    RSAPICell aRow = cellIterator.next();
                    XQEBinaryNodeSerializer.buildRow(out, edges.length, aRow, true, false, stringDictionary);
                    if (++rowCount != chunkInfo2.getChunkSize()) continue;
                }
                if (cellIterator.hasNext()) {
                    edgeEndingFlags.put(edges.length, false);
                } else {
                    edgeEndingFlags.put(edges.length, true);
                }
            }
            Iterator iterator = edgeEndingFlags.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                out.putInt(10);
                out.putInt(i);
                out.putBoolean((Boolean)edgeEndingFlags.get(i));
            }
        }
        finally {
            ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
            ROLAPContext.queryExit(ExecutionEnvironmentContext.getExecutionEnvironment());
        }
        return out.getByteBuffer().array();
    }

    private static void serializeMasterDatasets(IVarLenByteBufferOutputStream outStream, IXQEQueryNode[] datasets) throws IOException {
        RSAPIDataset dataset = null;
        for (int i = 0; i < datasets.length; ++i) {
            dataset = (RSAPIDataset)datasets[i];
            outStream.putInt(12);
            outStream.putString(dataset.getUniqueID());
            outStream.putString(dataset.getName());
            if (dataset.getOptimizeForAllRows()) {
                outStream.putBoolean(true);
            } else {
                outStream.putBoolean(false);
            }
            XQEBinaryNodeSerializer.serializeDataSetInfo(outStream, dataset);
            PlannedV5QuerySet querySet = (PlannedV5QuerySet)dataset.getParent();
            MasterDetailProvider mdProvider = querySet.getMasterDetailProvider();
            List<MasterDetailLink> mdLinks = mdProvider.getMasterDetailLinks(dataset.getName());
            if (!mdLinks.isEmpty()) {
                XQEBinaryNodeSerializer.serializeDetailQueries(outStream, querySet, mdLinks);
                outStream.putInt(11);
                continue;
            }
            outStream.putInt(0);
        }
        outStream.putInt(11);
    }

    public static void serializeDetailQueries(IVarLenByteBufferOutputStream outStream, PlannedV5QuerySet querySet, List<MasterDetailLink> mdLinks) throws IOException {
        Map<String, List<MasterDetailLink>> detailQRDs = GetDetailQueriesRequestAdapter.arrangeMDLinksByDetailQueries(mdLinks);
        outStream.putInt(detailQRDs.size());
        Parameters parameters = querySet.getRequestParameters();
        for (Map.Entry<String, List<MasterDetailLink>> entry : detailQRDs.entrySet()) {
            List<MasterDetailLink> links = entry.getValue();
            if (links.size() == 0) continue;
            outStream.putInt(23);
            String datasetName = entry.getKey();
            RSAPIDataset detailRSAPIDataset = GetDetailQueriesRequestAdapter.findDatasetByName(querySet, datasetName);
            outStream.putString(detailRSAPIDataset.getUniqueID());
            XQEBinaryNodeSerializer.addMDLinkAttributes(outStream, links.get(0));
            Element parametersElem = Parameters.createParametersElement();
            for (MasterDetailLink mdLink : links) {
                outStream.putInt(24);
                outStream.putString(mdLink.getName());
                String parameterName = mdLink.getParameterName();
                if (!mdLink.isParameterLink()) {
                    parameterName = mdLink.getName();
                }
                parameterName = parameterName.trim();
                outStream.putString(parameterName);
                String refDataItem = mdLink.getMasterRefDataItem();
                String refParameterName = UniqueNameGenerator.createUniqueName(mdLink.getMasterQrdName(), refDataItem);
                outStream.putString(refParameterName);
                Parameter parameter = null;
                String queryName = detailRSAPIDataset.getRefQueryName();
                if (parameters != null) {
                    parameter = parameters.getParameter(parameterName, queryName);
                }
                if (parameter == null) {
                    parameter = parameters.getParameter(parameterName);
                }
                if (parameter == null || !parameter.isMasterDetailLinkParameter()) {
                    parameter = new Parameter(parameterName, queryName);
                    parameter.setMasterDetailLinkParameter(true);
                }
                Element paramItem = parameter.createParameterElement(refParameterName);
                parametersElem.add(paramItem);
            }
            Parameters.setParametersArraySize(parametersElem, links.size());
            StringWriter stringWriter = new StringWriter();
            parametersElem.write((Writer)stringWriter);
            outStream.putInt(25);
            outStream.putString(stringWriter.toString());
        }
    }

    private static void addMDLinkAttributes(IVarLenByteBufferOutputStream outStream, MasterDetailLink mdLink) {
        outStream.putString(mdLink.getDetailQueryName());
        if (mdLink.getDetailQueryNameOrig() != null) {
            outStream.putString(mdLink.getDetailQueryNameOrig());
        } else {
            outStream.putString("");
        }
        outStream.putString(mdLink.getDetailQrdName());
    }

    private static void serializeDataSetInfo(IVarLenByteBufferOutputStream outStream, RSAPIDataset rsapiDataSet) throws IOException {
        outStream.putInt(13);
        RSAPIEdge[] edges = rsapiDataSet.getEdges();
        int numEdges = edges.length;
        outStream.putInt(numEdges);
        outStream.putString(rsapiDataSet.getUniqueID());
        outStream.putString(rsapiDataSet.getName());
        if (rsapiDataSet.getOriginalRefQueryName() != null) {
            outStream.putString(rsapiDataSet.getOriginalRefQueryName());
        } else {
            outStream.putString(rsapiDataSet.getRefQueryName());
        }
        for (int i = 0; i < numEdges; ++i) {
            XQEBinaryNodeSerializer.serializeEdgeInfo(outStream, edges[i]);
        }
        RSAPICellRowset cellRowSet = rsapiDataSet.getCellRowset();
        if (cellRowSet != null) {
            XQEBinaryNodeSerializer.serializeCellRowsetInfo(outStream, cellRowSet);
        }
        outStream.putInt(11);
    }

    private static void serializeEdgeInfo(IVarLenByteBufferOutputStream outStream, RSAPIEdge anEdge) throws IOException {
        int numCoordinates = anEdge.getNumCoordinates(true);
        int numRowSets = anEdge.getNumRowsets();
        RSAPIEdgeRowset[] rowSets = anEdge.getRowsets();
        outStream.putInt(1);
        outStream.putInt(numCoordinates);
        outStream.putInt(numRowSets);
        outStream.putString(anEdge.getName());
        for (int i = 0; i < numRowSets; ++i) {
            XQEBinaryNodeSerializer.serializeEdgeRowSetInfo(outStream, rowSets[i]);
        }
        outStream.putInt(11);
    }

    private static void serializeEdgeRowSetInfo(IVarLenByteBufferOutputStream outStream, RSAPIEdgeRowset aRowSet) throws IOException {
        outStream.putInt(14);
        outStream.putString(aRowSet.getName());
        outStream.putInt(aRowSet.getNumColumns());
        outStream.putInt(aRowSet.getNumRows());
        outStream.putInt(aRowSet.getRowsetId());
        RSAPIEdgeRowset relativeRowset = aRowSet.getNestedRowset();
        if (relativeRowset != null) {
            outStream.putInt(15);
            outStream.putInt(relativeRowset.getRowsetId());
        }
        if ((relativeRowset = aRowSet.getParentRowset()) != null) {
            outStream.putInt(16);
            outStream.putInt(relativeRowset.getRowsetId());
        }
        if ((relativeRowset = aRowSet.getSiblingRowset()) != null) {
            outStream.putInt(17);
            outStream.putInt(relativeRowset.getRowsetId());
        }
        if ((relativeRowset = aRowSet.getHeaderRowset()) != null) {
            outStream.putInt(18);
            outStream.putInt(relativeRowset.getRowsetId());
        }
        if ((relativeRowset = aRowSet.getFooterRowset()) != null) {
            outStream.putInt(19);
            outStream.putInt(relativeRowset.getRowsetId());
        }
        if (aRowSet.isMeasureRowset()) {
            outStream.putInt(20);
        } else if (aRowSet.isTimeRowset()) {
            outStream.putInt(21);
        }
        RSAPIColumn[] columns = aRowSet.getColumns();
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                XQEBinaryNodeSerializer.serializeColumnInfo(outStream, columns[i]);
            }
        }
        outStream.putInt(11);
    }

    private static void serializeColumnInfo(IVarLenByteBufferOutputStream outStream, RSAPIColumn column) throws IOException {
        outStream.putInt(10);
        IDataType dataType = column.getDatatype();
        if (null == dataType) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "serializeColumnInfo requires dataType");
        }
        byte dType = dataType.getCCLTypeCode();
        outStream.putInt(dType);
        outStream.putString(column.getName());
        outStream.putBoolean(column.getNullsOK());
        if (dataType.isExactNumeric() && column.getPrecision() > 77) {
            int precision = column.getPrecision();
            int scale = column.getScale();
            if (scale > 15 && (scale = (int)((double)scale * (77.0 / (double)precision))) < 15) {
                scale = 15;
            }
            outStream.putInt(39);
            outStream.putInt(77);
            outStream.putInt(scale);
        } else {
            outStream.putInt(column.getLength());
            outStream.putInt(Math.min(column.getPrecision(), Short.MAX_VALUE));
            outStream.putInt(column.getScale());
        }
        outStream.putString(column.getUsage().toString());
        outStream.putString(column.getLabel());
        outStream.putString(column.getCurrencyCode());
        outStream.putString(column.getFormat());
        outStream.putString(column.getFormatIDString());
        outStream.putBoolean(column.getIsCanonicalProperty());
    }

    private static void serializeCellRowsetInfo(IVarLenByteBufferOutputStream outStream, RSAPIRowset aRowSet) throws IOException {
        outStream.putInt(14);
        outStream.putString(aRowSet.getName());
        outStream.putInt(aRowSet.getNumColumns());
        outStream.putInt(aRowSet.getNumRows());
        outStream.putInt(aRowSet.getRowsetId());
        if (aRowSet.isMeasureRowset()) {
            outStream.putInt(20);
        }
        RSAPIColumn[] columns = aRowSet.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            XQEBinaryNodeSerializer.serializeColumnInfo(outStream, columns[i]);
        }
        outStream.putInt(11);
    }

    public static byte[] generateBinaryExecuteResponse(VarLenByteBufferOutputStream outStream, IXQEQueryNode[] datasets, RequestEnvironment environment, XQENodeSerializer.AppendPlanIDs appendPlanIDs, Element queryFeedback) throws IOException {
        XQEBinaryNodeSerializer.serializeMasterDatasets(outStream, datasets);
        if (XQENodeSerializer.AppendPlanIDs.APPEND == appendPlanIDs) {
            XQEBinaryNodeSerializer.appendPlanIDs(datasets, outStream);
        }
        XQENodeSerializer.addSubqueryAndNagMessagesToResponseFolder(environment, datasets);
        XQEBinaryNodeSerializer.generateMessageResponse(outStream, environment);
        return outStream.getByteBuffer().array();
    }

    private static void appendPlanIDs(IXQEQueryNode[] datasets, IVarLenByteBufferOutputStream outStream) throws IOException {
        MasterDetailProvider masterDetailProvider;
        int numDatasets;
        IXQEQueryNode planTree = datasets.length == 0 ? null : datasets[0].getParent();
        PlannedV5QuerySet querySet = (PlannedV5QuerySet)planTree;
        if (null == planTree) {
            numDatasets = 0;
            masterDetailProvider = null;
        } else {
            numDatasets = planTree.getNumberChildren();
            masterDetailProvider = querySet.getMasterDetailProvider();
        }
        for (int i = 0; i < numDatasets; ++i) {
            RSAPIDataset dataset = (RSAPIDataset)planTree.getChild(i);
            boolean isDetail = masterDetailProvider.isDetailRSAPIDataset(dataset);
            if (isDetail) continue;
            outStream.putInt(22);
            outStream.putString(dataset.getUniqueID());
            XQEBinaryNodeSerializer.writeDetailProviderQuery(masterDetailProvider, dataset, outStream);
        }
        outStream.putInt(11);
    }

    private static void generateMessageResponse(VarLenByteBufferOutputStream outStream, RequestEnvironment environment) throws IOException {
        XMLWriter xmlWriter = new XMLWriter();
        OutputStreamWriter aWriter = new OutputStreamWriter((OutputStream)outStream, "UTF-8");
        xmlWriter.addStream(aWriter);
        xmlWriter.setSkipLineFeed(true);
        environment.getResponseMessageFolder().toXMLString(environment, xmlWriter, environment.getProductLocale());
        ((Writer)aWriter).flush();
    }

    private static void writeDetailProviderQuery(MasterDetailProvider masterDetailProvider, RSAPIDataset masterRSAPIDataset, IVarLenByteBufferOutputStream outStream) throws IOException {
        Collection<RSAPIDataset> detailDatasets = masterDetailProvider.getRSAPIDatasetSiblings(masterRSAPIDataset);
        for (RSAPIDataset detailDataSet : detailDatasets) {
            outStream.putInt(23);
            outStream.putString(detailDataSet.getUniqueID());
        }
    }

    private static void serializeEdge(IVarLenByteBufferOutputStream out, int edgeId, RSAPIEdgeIterator edgeIterator, GetPartialDatasetRequestAdapter.EdgeChunkInfo chunkInfo, RSAPIEdge edge, StringDictionary dictionary) throws IOException {
        if (chunkInfo.chunkStart == -5) {
            XQEBinaryNodeSerializer.serializeLastNRows(out, edgeId, edgeIterator, chunkInfo.chunkSize, edge.getNumRowsets(), dictionary);
        } else if (chunkInfo.chunkStart == -4) {
            edgeIterator.reset();
            XQEBinaryNodeSerializer.serializeNextNRows(out, edgeId, edgeIterator, chunkInfo.chunkSize, dictionary);
        } else {
            XQEBinaryNodeSerializer.serializeNextNRows(out, edgeId, edgeIterator, chunkInfo.chunkSize, dictionary);
        }
    }

    private static void serializeNextNRows(IVarLenByteBufferOutputStream out, int edgeId, RSAPIEdgeIterator edgeIterator, int nRows, StringDictionary dictionary) throws IOException {
        int rowCount = 0;
        while (edgeIterator.hasNext()) {
            RSAPIRow aRow = edgeIterator.next();
            XQEBinaryNodeSerializer.buildRow(out, edgeId, aRow, false, false, dictionary);
            if (++rowCount != nRows) continue;
            break;
        }
    }

    private static void serializeLastNRows(IVarLenByteBufferOutputStream out, int edgeId, RSAPIEdgeIterator edgeIterator, int nRows, int numRowsets, StringDictionary dictionary) throws IOException {
        Queue rows = new Queue();
        RSAPIRow[] lastRowForRowset = new RSAPIRow[numRowsets];
        XQEBinaryNodeSerializer.fetchLastNRowsAndStore(edgeIterator, nRows, rows, lastRowForRowset);
        if (rows.isEmpty()) {
            edgeIterator.reset();
            XQEBinaryNodeSerializer.serializeNextNRows(out, edgeId, edgeIterator, nRows, dictionary);
            XQEBinaryNodeSerializer.fetchLastNRowsAndStore(edgeIterator, nRows, rows, lastRowForRowset);
        }
        XQEBinaryNodeSerializer.serializeRowsFromBuffer(out, edgeId, rows, lastRowForRowset, dictionary);
    }

    private static void serializeRowsFromBuffer(IVarLenByteBufferOutputStream out, int edgeId, Queue rows, RSAPIRow[] lastRowForRowset, StringDictionary dictionary) throws IOException {
        for (RSAPIRow row : lastRowForRowset) {
            if (row == null || rows.containsObject(row)) continue;
            XQEBinaryNodeSerializer.buildRow(out, edgeId, row, false, true, dictionary);
        }
        while (rows.size() > 0) {
            RSAPIRow aRow = (RSAPIRow)rows.take();
            XQEBinaryNodeSerializer.buildRow(out, edgeId, aRow, false, false, dictionary);
        }
    }

    private static void fetchLastNRowsAndStore(RSAPIEdgeIterator edgeIterator, int nRows, Queue rows, RSAPIRow[] lastRowForRowset) {
        edgeIterator.reset();
        boolean storeAll = edgeIterator.positionOnRow(nRows, false) > 0L;
        CancelManager cancelManager = null;
        IExecutionEnvironment execEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
        if (execEnv != null) {
            cancelManager = execEnv.getCancelManager();
        }
        RSAPIRow rowCopy = null;
        while (edgeIterator.hasNext()) {
            if (cancelManager != null && cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            RSAPIRow aRow = edgeIterator.next();
            if (!storeAll && rows.size() == nRows) {
                rows.take();
            }
            rowCopy = (RSAPIRow)aRow.copy();
            rows.put(rowCopy);
            lastRowForRowset[rowCopy.getRowsetId()] = rowCopy;
        }
    }

    private static void buildRow(IVarLenByteBufferOutputStream out, int edgeId, RSAPIValue aRow, boolean cellRow, boolean isContextRow, StringDictionary dictionary) throws IOException {
        out.putInt(2);
        out.putInt(edgeId);
        out.putInt(aRow.getRowNumber());
        out.putInt(aRow.getRowsetId());
        out.putInt(aRow.getDetailRowNumber());
        out.putInt(aRow.getAncestorRowNumber());
        out.putInt(aRow.getAncestorRowsetId());
        out.putBoolean(isContextRow);
        out.putBoolean(cellRow);
        if (cellRow) {
            RSAPICell aCell = (RSAPICell)aRow;
            int[] coordinates = aCell.getEdgeCoordinates();
            out.putInt(coordinates.length);
            for (int i = 0; i < coordinates.length; ++i) {
                out.putInt(coordinates[i]);
            }
        } else {
            out.putInt(1);
            out.putInt(aRow.getCellCoordinate());
        }
        RSAPIColumn[] columnInfo = aRow.getRowset().getColumns();
        if (columnInfo != null) {
            for (int i = 0; i < aRow.getNumColumns(); ++i) {
                XQEBinaryNodeSerializer.buildColumn(out, (Value)aRow.getColumn(i), columnInfo[i], aRow.isListReport(), dictionary, i);
            }
        }
        out.putInt(11);
    }

    private static void buildColumn(IVarLenByteBufferOutputStream out, Value column, RSAPIColumn columnInfo, boolean isListReport, StringDictionary dictionary, int columnIdx) throws IOException {
        ValueState columnState;
        String currencyCode = null;
        String unitOfMeasure = null;
        String format = null;
        String formatId = null;
        FormatService service = FormatService.getInstance();
        if (null != service) {
            FormatId id = null;
            id = isListReport ? XQEBinaryNodeSerializer.computeFormatId(columnInfo.getFormatID(), column.getFormatId()) : XQEBinaryNodeSerializer.computeFormatId(column.getFormatId(), columnInfo.getFormatID());
            if (id != null) {
                currencyCode = service.getCurrencyCode(id);
                unitOfMeasure = service.getUnitOfMeasure(id);
                format = service.retrieveFormatString(id);
                formatId = service.getFormatStringId(id);
            }
        }
        if ((columnState = column.getState()) == ValueState.NULL) {
            boolean formatContainsWhenMissingProperty;
            boolean bl = formatContainsWhenMissingProperty = format != null && format.contains("whenMissing");
            if (!isListReport || formatMissingValuesInListReports && formatContainsWhenMissingProperty) {
                out.putInt(3);
                out.putByte((byte)columnState.getCCLDBState());
                out.putInt(columnIdx);
                if (format != null && format.length() > 0) {
                    StringDictionary.Entry entry = dictionary.getDictionaryEntry(format);
                    out.putInt(5);
                    out.putInt(entry.getId());
                    out.putString(entry.getValue());
                }
                XQEBinaryNodeSerializer.buildValue(out, column, dictionary, null);
            }
        } else {
            String moString;
            out.putInt(3);
            out.putByte((byte)columnState.getCCLDBState());
            out.putInt(columnIdx);
            if (format != null && format.length() > 0) {
                StringDictionary.Entry entry = dictionary.getDictionaryEntry(format);
                out.putInt(5);
                out.putInt(entry.getId());
                out.putString(entry.getValue());
            }
            if (formatId != null && !"".equals(formatId) && !"0".equals(formatId)) {
                out.putInt(6);
                out.putString(formatId);
            }
            if ((moString = columnInfo.getQueryItemModelId()) != null) {
                StringDictionary.Entry entry = dictionary.getDictionaryEntry(moString);
                out.putInt(7);
                out.putInt(entry.getId());
                out.putString(entry.getValue());
            }
            if (currencyCode == null) {
                currencyCode = columnInfo.getCurrencyCode();
            }
            if (currencyCode != null && currencyCode.length() > 0) {
                out.putInt(8);
                out.putString(currencyCode);
            }
            if (unitOfMeasure != null && unitOfMeasure.length() > 0) {
                out.putInt(9);
                out.putString(unitOfMeasure);
            }
            XQEBinaryNodeSerializer.buildValue(out, column, dictionary, moString);
        }
    }

    public static void buildValue(IVarLenByteBufferOutputStream out, Value column, StringDictionary dictionary, String modelQItemId) throws IOException {
        out.putInt(4);
        IDataType columnDataType = column.getDataType();
        byte dType = columnDataType.getCCLTypeCode();
        if (dType == 46 || dType == 100 || dType == 114 || dType == 102 || dType == 104 || dType == 51 || DataTypeCode.isPeriodType(dType)) {
            dType = 1;
        }
        if (dType == 18 || dType == 23 || dType == 24) {
            out.putByte((byte)1);
        } else {
            out.putByte(dType);
        }
        if (columnDataType.hasPrecision()) {
            int precision = columnDataType.getPrecision();
            if (columnDataType.isExactNumeric()) {
                if (columnDataType.isFloatingPointDecimal() && !column.isNull() && !column.isNA()) {
                    precision = ((DecimalValue)column).getPrecision();
                }
                if (precision > 77) {
                    precision = 77;
                }
            } else {
                precision = Math.min(Short.MAX_VALUE, precision);
            }
            out.putInt(precision);
        } else {
            out.putInt(0);
        }
        int scaleTrim = 0;
        if (columnDataType.hasScale() || columnDataType.isFloatingPointDecimal() && !column.isNull() && !column.isNA() && ((DecimalValue)column).getScale() != 0) {
            int scale = columnDataType.getScale();
            int precision = 0;
            if (columnDataType.isExactNumeric()) {
                if (columnDataType.isFloatingPointDecimal()) {
                    precision = ((DecimalValue)column).getPrecision();
                    scale = ((DecimalValue)column).getScale();
                } else {
                    precision = columnDataType.getPrecision();
                }
            }
            if (precision > 77) {
                scaleTrim = scale;
                if (scale > 15 && (scale = (int)((double)scale * (77.0 / (double)precision))) < 15) {
                    scale = 15;
                }
                scaleTrim -= scale;
            }
            out.putInt(scale);
        } else {
            out.putInt(0);
        }
        if (column.isOK() && !column.isNull()) {
            switch (XQEBinaryNodeSerializer.getOutDataType(dType)) {
                case 1: {
                    String tValue = column.getXSDLiteral();
                    StringDictionary.Entry entry = dictionary.getDictionaryEntry(tValue);
                    out.putInt(entry.getId());
                    String entryValue = entry.getValue();
                    if (modelQItemId != null && entryValue != null && !entryValue.isEmpty() && XQEBinaryNodeSerializer.needAliasPrefix(columnDataType.getTypeName())) {
                        String firstPart = StringUtils.substringBetween((String)entryValue, (String)"", (String)STR_DOT_OPEN_BRACKET);
                        String moduleAlias = StringUtils.substringBetween((String)modelQItemId, (String)"", (String)STR_DOT_OPEN_BRACKET);
                        if (moduleAlias != null && !moduleAlias.equals(firstPart)) {
                            entryValue = moduleAlias + STR_DOT + entryValue;
                        }
                    }
                    out.putString(entryValue);
                    break;
                }
                case 6: 
                case 7: {
                    if (columnDataType.hasScale()) {
                        out.putInt(column.getInteger(columnDataType.getPrecision(), columnDataType.getScale()));
                        break;
                    }
                    out.putInt(column.getInteger());
                    break;
                }
                case 8: 
                case 9: {
                    if (columnDataType.hasScale()) {
                        out.putLong(column.getLong(columnDataType.getPrecision(), columnDataType.getScale()));
                        break;
                    }
                    out.putLong(column.getLong());
                    break;
                }
                case 10: {
                    out.putFloat(column.getFloat());
                    break;
                }
                case 11: {
                    out.putDouble(column.getDouble());
                    break;
                }
                case 51: {
                    out.putBoolean(column.getBoolean());
                    break;
                }
                case 12: {
                    String value = ((ExactNumericValue)column).getUnscaledString();
                    int adjustedScale = columnDataType.getScale();
                    if (columnDataType.isFloatingPointDecimal()) {
                        adjustedScale = ((DecimalValue)column).getScale();
                    }
                    if (scaleTrim > 0 && scaleTrim < value.length()) {
                        value = value.substring(0, value.length() - scaleTrim);
                        adjustedScale -= scaleTrim;
                    }
                    if (value.length() > 77 || adjustedScale < -255) {
                        int length = value.length();
                        int integerPart = length - adjustedScale;
                        value = value.substring(0, integerPart) + STR_DOT + value.substring(integerPart, length);
                        if (adjustedScale < -255) {
                            throw new XQERuntimeException(XQEMessageKeys.DAT_DecimalOverflowError, (Object)value, (Object)Integer.toString(77), (Object)Integer.toString(-255));
                        }
                        throw new XQERuntimeException(XQEMessageKeys.DAT_DecimalOverflowError, (Object)value, (Object)Integer.toString(77), (Object)Integer.toString(adjustedScale));
                    }
                    out.putString(value);
                    break;
                }
                case 13: {
                    XQEBinaryNodeSerializer.writeCCLDTYPEDATE(out, column);
                    break;
                }
                case 14: {
                    XQEBinaryNodeSerializer.writeCCLDTYPETIME(out, column);
                    break;
                }
                case 15: {
                    XQEBinaryNodeSerializer.writeCCLDTYPEDATETIME(out, column);
                    break;
                }
                case 16: {
                    XQEBinaryNodeSerializer.writeCCLDTYPEDTINTERVAL(out, column);
                    break;
                }
                case 57: {
                    XQEBinaryNodeSerializer.writeCCLDTYPEDATE2(out, column);
                    break;
                }
                case 58: {
                    XQEBinaryNodeSerializer.writeCCLDTYPETIME2(out, column);
                    break;
                }
                case 59: {
                    XQEBinaryNodeSerializer.writeCCLDTYPETIMESTAMP2(out, column);
                    break;
                }
                case 60: {
                    XQEBinaryNodeSerializer.writeCCLDTYPEINTERVAL2(out, column);
                    break;
                }
                case 52: {
                    XQEBinaryNodeSerializer.writeCCLDTYPETIMETZ(out, column);
                    break;
                }
                case 53: {
                    XQEBinaryNodeSerializer.writeCCLDTYPETIMESTAMPTZ(out, column);
                    break;
                }
                case 17: {
                    XQEBinaryNodeSerializer.writeCCLDTYPEYMINTERVAL(out, column);
                    break;
                }
                case 18: 
                case 23: {
                    StringDictionary.Entry temp = dictionary.getDictionaryEntry(" ");
                    out.putInt(temp.getId());
                    out.putString(temp.getValue());
                    break;
                }
                default: {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_UnsupportedColumnDataType, columnDataType.getTypeName(), modelQItemId);
                }
            }
        }
    }

    private static boolean needAliasPrefix(String typeName) {
        return "memberUniqueName".equals(typeName) || "dimensionUniqueName".equals(typeName) || "hierarchyUniqueName".equals(typeName) || "levelUniqueName".equals(typeName) || "parentUniqueName".equals(typeName);
    }

    private static void writeCCLDTYPEDATE(IVarLenByteBufferOutputStream out, Value column) {
        if (column.getDataType().getCCLTypeCode() != 13) {
            return;
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, column.getDataType().getTypeName());
    }

    private static void writeCCLDTYPETIME(IVarLenByteBufferOutputStream out, Value column) {
        if (column.getDataType().getCCLTypeCode() != 14) {
            return;
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, column.getDataType().getTypeName());
    }

    private static void writeCCLDTYPEDATETIME(IVarLenByteBufferOutputStream out, Value column) {
        if (column.getDataType().getCCLTypeCode() != 15) {
            return;
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, column.getDataType().getTypeName());
    }

    private static void writeCCLDTYPEDTINTERVAL(IVarLenByteBufferOutputStream out, Value column) {
        if (column.getDataType().getCCLTypeCode() != 16) {
            return;
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, column.getDataType().getTypeName());
    }

    private static void writeCCLDTYPEDATE2(IVarLenByteBufferOutputStream out, Value column) throws IOException {
        if (column.getDataType().getCCLTypeCode() != 57) {
            return;
        }
        DateValue dateValue = (DateValue)column;
        out.putInt(dateValue.getYear());
        out.putInt(dateValue.getMonth());
        out.putInt(dateValue.getDay());
    }

    private static void writeCCLDTYPETIME2(IVarLenByteBufferOutputStream out, Value column) throws IOException {
        if (column.getDataType().getCCLTypeCode() != 58) {
            return;
        }
        TimeValue timeValue = (TimeValue)column;
        out.putInt(timeValue.getHour());
        out.putInt(timeValue.getMinute());
        out.putInt(timeValue.getSecond());
        out.putInt(timeValue.getNanoseconds());
    }

    private static void writeCCLDTYPETIMETZ(IVarLenByteBufferOutputStream out, Value column) throws IOException {
        if (column.getDataType().getCCLTypeCode() != 52) {
            return;
        }
        TimeWithTZValue timeValue = (TimeWithTZValue)column;
        out.putInt(timeValue.getHour());
        out.putInt(timeValue.getMinute());
        out.putInt(timeValue.getSecond());
        out.putInt(timeValue.getNanoseconds());
        out.putInt(timeValue.getTimeZoneHour());
        out.putInt(timeValue.getTimeZoneMinute());
    }

    private static void writeCCLDTYPETIMESTAMP2(IVarLenByteBufferOutputStream out, Value column) throws IOException {
        if (column.getDataType().getCCLTypeCode() != 59) {
            return;
        }
        TimestampValue timeValue = (TimestampValue)column;
        out.putInt(timeValue.getYear());
        out.putInt(timeValue.getMonth());
        out.putInt(timeValue.getDay());
        out.putInt(timeValue.getHour());
        out.putInt(timeValue.getMinute());
        out.putInt(timeValue.getSecond());
        out.putInt(timeValue.getNanoseconds());
    }

    private static void writeCCLDTYPETIMESTAMPTZ(IVarLenByteBufferOutputStream out, Value column) throws IOException {
        if (column.getDataType().getCCLTypeCode() != 53) {
            return;
        }
        TimestampWithTZValue timeValue = (TimestampWithTZValue)column;
        out.putInt(timeValue.getYear());
        out.putInt(timeValue.getMonth());
        out.putInt(timeValue.getDay());
        out.putInt(timeValue.getHour());
        out.putInt(timeValue.getMinute());
        out.putInt(timeValue.getSecond());
        out.putInt(timeValue.getNanoseconds());
        out.putInt(timeValue.getTimeZoneHour());
        out.putInt(timeValue.getTimeZoneMinute());
    }

    private static void writeCCLDTYPEYMINTERVAL(IVarLenByteBufferOutputStream out, Value column) throws IOException {
        if (column.getDataType().getCCLTypeCode() != 17) {
            return;
        }
        IntervalYearMonthValue intervalValue = (IntervalYearMonthValue)column;
        out.putInt(intervalValue.getSign());
        out.putInt(intervalValue.getYear());
        out.putInt(intervalValue.getMonth());
    }

    private static void writeCCLDTYPEINTERVAL2(IVarLenByteBufferOutputStream out, Value column) {
        if (column.getDataType().getCCLTypeCode() != 60) {
            return;
        }
        IntervalDayTimeValue intervalValue = (IntervalDayTimeValue)column;
        out.putInt(intervalValue.getSign());
        out.putInt(intervalValue.getDay());
        out.putInt(intervalValue.getHour());
        out.putInt(intervalValue.getMinute());
        out.putInt(intervalValue.getSecond());
        out.putInt(intervalValue.getNanoseconds());
    }

    private static byte getOutDataType(byte columnDataType) {
        switch (columnDataType) {
            case 1: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 55: 
            case 56: {
                return 1;
            }
            case 2: 
            case 4: 
            case 6: 
            case 33: 
            case 40: 
            case 42: 
            case 44: {
                return 6;
            }
            case 3: 
            case 5: 
            case 7: 
            case 37: 
            case 38: 
            case 39: {
                return 7;
            }
        }
        return columnDataType;
    }

    private static FormatId computeFormatId(FormatId id1, FormatId id2) {
        if (id1 == null || id1 == FormatId.INVALID_FORMAT_FID || id1 == FormatId.EMPTY_FORMAT_FID) {
            return id2;
        }
        return id1;
    }

    static {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        formatMissingValuesInListReports = config.getBooleanProperty("queryPlanning.formatMissingValuesInListReports[@enabled]", true);
    }

    public static final class StringDictionary {
        private Map<String, Integer> stringDictionary = new HashMap<String, Integer>();
        private int stringMapCurrentId = 1;

        public Entry getDictionaryEntry(String value) {
            if (value.length() == 0) {
                return new Entry(0, "");
            }
            Integer id = this.stringDictionary.get(value);
            if (id != null) {
                return new Entry(id, "");
            }
            id = XQEIntegerPool.getInteger(this.stringMapCurrentId++);
            this.stringDictionary.put(value, id);
            return new Entry(id, value);
        }

        public class Entry {
            private int id;
            private String value;

            public int getId() {
                return this.id;
            }

            public String getValue() {
                return this.value;
            }

            Entry(int i, String s) {
                this.id = i;
                this.value = s;
            }
        }
    }
}

