/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.DataTypeCode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.ExactNumericValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.Nag;
import com.cognos.xqe.query.engine.NagCollector;
import com.cognos.xqe.query.engine.NagSubquery;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.ResponseMessageFolder;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.rsapi.RSAPICell;
import com.cognos.xqe.rsapi.RSAPICellIterator;
import com.cognos.xqe.rsapi.RSAPICellRowset;
import com.cognos.xqe.rsapi.RSAPIColumn;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.rsapi.RSAPIValue;
import com.cognos.xqe.runtree.IXDataSource;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.runtree.relational.XTableFunction;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.Queue;
import com.cognos.xqe.util.StringSubstitutionEngine;
import com.cognos.xqe.util.datasets.DatasetInfoExtended;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.xml.XMLWriter;
import com.cognos.xqebifw.bibushandler.GetDetailQueriesRequestAdapter;
import com.cognos.xqebifw.bibushandler.GetPartialDatasetRequestAdapter;
import com.cognos.xqebifw.bibushandler.RSVP4JHelper;
import com.cognos.xqemoser.MoserParameterUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.axis.encoding.Base64;
import org.dom4j.Element;

public final class XQENodeSerializer {
    private static final char LEFT_ANGLE_BRACKET = '<';
    private static final char RIGHT_ANGLE_BRACKET = '>';
    private static final char SLASH = '/';
    private static final char SPACE = ' ';
    private static final char EQUALS = '=';
    private static final char DOUBLE_QUOTE = '\"';
    private static final String CATALOG = "catalog";
    private static final String COGNOS_COMMAND_TEXT_PROPERTY = "CognosCommandText";
    private static final String COLUMN_INFO = "columnInfo";
    private static final String CONNECTION = "connection";
    private static final String CONNECTIONS_PROPERTY = "connections";
    private static final String CURRENCY_CODE = "currencyCode";
    private static final String DATA_SET_INFO = "dataSetInfo";
    private static final String EDGE_INFO = "edgeInfo";
    private static final String FORMAT = "format";
    private static final String FORMAT_ID = "formatId";
    private static final String ITEM = "item";
    private static final String MASTER_DATASET = "masterDataset";
    private static final String MASTER_DATASET_ID = "masterDatasetId";
    private static final String MEASURE_ROW_SET = "isMeasureRowSet";
    private static final String MODELDSNAME = "modelDSName";
    private static final String NATIVE_COMMAND_TYPE_PROPERTY = "nativeCommandType";
    private static final String NATIVE_SQL = "nativeSQL";
    private static final String NUM_COLUMNS = "numColumns";
    private static final String NUM_ROWS = "numRows";
    public static final String PROPERTY = "property";
    private static final String QUALIFIEDDS = "qualifiedDS";
    private static final String QUERIES = "queries";
    private static final String QUERY_FEEDBACK_RESULT = "queryFeedbackResult";
    public static final String QUERY_NAME = "queryName";
    private static final String ROW_SET_INFO = "rowsetInfo";
    private static final String ROWSET_ID = "rowsetId";
    private static final String SCHEMA = "schema";
    private static final String SUBTYPE = "subType";
    private static final String UTF_8 = "UTF-8";
    private static final String VALUE = "value";
    public static final String COLUMN_LIST_PROPERTY = "columnList";
    public static final String NAME = "name";
    public static final String PRECISION = "precision";
    public static final String LENGTH = "length";
    public static final String NULLSALLOWED = "nullsAllowed";
    public static final String SCALE = "scale";
    public static final String TYPE = "type";
    public static final String RESPONSE = "response";
    public static final String SQLCOLUMNNAME = "sqlColumnName";
    public static final String SQLCOLUMNINDEX = "sqlColumnIndex";
    public static final String SQLCOLUMNMODELTYPE = "sqlColumnModelType";
    public static final String REF_QUERY_NAME = "refQueryName";
    public static final String CONNECTION_INFO = "connectionInfo";
    public static final String CONNECTION_MESSAGE = "message";
    private static final int RSVP_MAX_STRING_PRECISION = Short.MAX_VALUE;
    private static final int RSVP_MAX_DECIMAL_LENGTH = 39;
    private static final int RSVP_MAX_DECIMAL_PRECISION = 77;
    private static final int RSVP_MIN_DECIMAL_SCALE = -255;
    private static final String NEWLINE = "\r\n";
    private static final String GENERAL_CLOSE_TAG1 = "\">";
    private static final String GENERAL_CLOSE_TAG2 = "\"/>";
    private static final String RESOLVED_AGGREGATE = "resolvedAggregate";
    private static final byte[] OPEN_RESPONSE_TAG = "<response>".getBytes();
    private static final byte[] CLOSE_RESPONSE_TAG = "</response>".getBytes();
    private static final byte[] OPEN_PARTIAL_DATASET1 = "<p i=\"".getBytes();
    private static final byte[] OPEN_PARTIAL_DATASET2 = "\" m=\"".getBytes();
    private static final byte[] CLOSE_PARTIAL_DATASET = "</p>".getBytes();
    private static final byte[] GENERAL_END_OPENTAG = "\">".getBytes();
    private static final byte[] OPEN_EDGE1 = "<e n=\"".getBytes();
    private static final byte[] CLOSE_EDGE = "</e>".getBytes();
    private static final byte[] OPEN_CELLS = "<s>".getBytes();
    private static final byte[] CLOSE_CELLS = "</s>".getBytes();
    private static final byte[] OPEN_ROW1 = "<r o=\"".getBytes();
    private static final byte[] OPEN_ROW2 = "\" i=\"".getBytes();
    private static final byte[] OPEN_ROW3 = "\" n=\"".getBytes();
    private static final byte[] OPEN_ROW4 = "\" a=\"".getBytes();
    private static final byte[] OPEN_ROW5 = "\" d=\"".getBytes();
    private static final byte[] OPEN_ROW6 = "\" j=\"".getBytes();
    private static final byte[] OPEN_COORDINATE1 = "<o v=\"".getBytes();
    private static final byte[] OPEN_COORDINATE2 = "\"/>".getBytes();
    private static final byte[] CLOSE_ROW = "</r>".getBytes();
    private static final byte[] OPEN_COLUMN1 = "<c s=\"".getBytes();
    private static final byte[] OPEN_COLUMN2 = "\" t=\"".getBytes();
    private static final byte[] OPEN_COLUMN4 = "\" p=\"".getBytes();
    private static final byte[] OPEN_COLUMN5 = OPEN_ROW4;
    private static final byte[] OPEN_COLUMN6 = "\" q=\"".getBytes();
    private static final byte[] OPEN_COLUMN7 = "\" c=\"".getBytes();
    private static final byte[] OPEN_COLUMN8 = "\" f=\"".getBytes();
    private static final byte[] OPEN_COLUMN9 = OPEN_ROW2;
    private static final byte[] OPEN_COLUMN10 = "\" u=\"".getBytes();
    private static final byte[] OPEN_VALUE1 = OPEN_COORDINATE2;
    private static final byte[] OPEN_VALUE2 = "<v s=\"".getBytes();
    private static final byte[] OPEN_VALUE3 = "\"><v>".getBytes();
    private static final byte[] CLOSE_VALUE = "\"></v>".getBytes();
    private static final byte[] CLOSE_VALUE1 = "</v>".getBytes();
    private static final byte[] CLOSE_COLUMN = "</c>".getBytes();
    private static final byte[] OPEN_INFO = "<i e=\"".getBytes();
    private static final byte[] CLOSE_INFO = OPEN_COORDINATE2;
    private static final String DIGIT_ONE_STRING = "1";
    private static final byte[] DIGIT_ONE = "1".getBytes();
    private static final byte[] DIGIT_ZERO = "0".getBytes();
    private static final byte[] OPEN_STRING = "<t i=\"".getBytes();
    private static final byte[] OPEN_STRING_BASE64 = "<b i=\"".getBytes();
    private static final byte[] CLOSE_STRING = "</t>".getBytes();
    private static final byte[] CLOSE_STRING_BASE64 = "</b>".getBytes();
    private Map<String, Integer> stringDictionary = new HashMap<String, Integer>();
    private int stringMapCurrentId = 1;

    XQENodeSerializer() {
    }

    public static List<IXDataSource> findQuerySourceNodes(IXQEQueryNode root) {
        ArrayList<IXDataSource> nodeList = new ArrayList<IXDataSource>();
        XQENodeSerializer.findDataSourceNodes(root, nodeList);
        return nodeList;
    }

    private static void findDataSourceNodes(IXQEQueryNode aNode, List<IXDataSource> nodeList) {
        if (aNode instanceof IXDataSource) {
            nodeList.add((IXDataSource)((Object)aNode));
        }
        for (int i = 0; i < aNode.getNumberChildren(); ++i) {
            XQENodeSerializer.findDataSourceNodes(aNode.getChild(i), nodeList);
        }
    }

    private static IXQEQueryNode[] getRSAPIDatasetsToValidate(IXQEQueryNode planTree, List<String> datasetNames) {
        if (planTree == null) {
            return null;
        }
        IXQEQueryNode[] rsapiDataSets = planTree.getChildrenOfType(401005);
        if (datasetNames.size() == 0) {
            return rsapiDataSets;
        }
        LinkedList<RSAPIDataset> result = new LinkedList<RSAPIDataset>();
        for (int i = 0; i < rsapiDataSets.length; ++i) {
            RSAPIDataset dataset = (RSAPIDataset)rsapiDataSets[i];
            if (!datasetNames.contains(dataset.getName())) continue;
            result.add(dataset);
        }
        IXQEQueryNode[] requestedDataSets = new IXQEQueryNode[result.size()];
        Iterator it = result.iterator();
        for (int i = 0; i < requestedDataSets.length; ++i) {
            requestedDataSets[i] = (IXQEQueryNode)it.next();
        }
        return requestedDataSets;
    }

    private static List<Integer> getDatasetIndicesToProcess(IXQEQueryNode[] datasets, String queryName) {
        ArrayList<Integer> dsIndices4PropertyCreation = new ArrayList<Integer>();
        if (queryName == null || queryName.equals("")) {
            for (int iDataset = 0; iDataset < datasets.length; ++iDataset) {
                dsIndices4PropertyCreation.add(iDataset);
            }
        } else {
            for (int iDataset = 0; iDataset < datasets.length; ++iDataset) {
                RSAPIDataset rsapiDataset = (RSAPIDataset)datasets[iDataset];
                if (!rsapiDataset.getName().equals(queryName)) continue;
                dsIndices4PropertyCreation.add(iDataset);
                return dsIndices4PropertyCreation;
            }
        }
        return dsIndices4PropertyCreation;
    }

    static void generateValidateResponse(Writer writer, IXQEQueryNode planTree, List<String> datasetNames, RequestEnvironment environment, Element missingMembersElement, Element queryFeedback, String operationName) throws IOException {
        XQENodeSerializer.generateValidateResponse(writer, planTree, datasetNames, environment, missingMembersElement, queryFeedback, operationName, null);
    }

    static void generateValidateResponse(Writer writer, IXQEQueryNode planTree, List<String> datasetNames, RequestEnvironment environment, Element missingMembersElement, Element queryFeedback, String operationName, List<Object> rsvp4jDatasets) throws IOException {
        IXQEQueryNode[] rsapiDataSets;
        boolean isRSVP4J = rsvp4jDatasets != null;
        XQENodeSerializer.openTag(writer, RESPONSE, Collections.EMPTY_MAP);
        if (!isRSVP4J) {
            XQENodeSerializer.appendPlanIDsFromTree(planTree, writer);
        }
        if (environment.getMigrationBaseVersion() == RequestEnvironment.MigrationBaseVersionEnum.COMPATIBLE) {
            XQENodeSerializer.addMigrateMessagesInMessageFolder(environment);
        }
        if (null != missingMembersElement) {
            XQENodeSerializer.generateMissingMemberValidateResponse(writer, missingMembersElement, environment);
        }
        if ((rsapiDataSets = XQENodeSerializer.getRSAPIDatasetsToValidate(planTree, datasetNames)) != null) {
            for (int i = 0; i < rsapiDataSets.length; ++i) {
                String nativeCursorSQLText;
                RSAPIDataset rsapiDataSet = (RSAPIDataset)rsapiDataSets[i];
                if (rsapiDataSet == null) continue;
                List<IXDataSource> nodeList = XQENodeSerializer.findQuerySourceNodes(rsapiDataSet);
                StringBuilder nodeStr = new StringBuilder();
                ResponseMessage.ResponseMessageType responseMsgType = ResponseMessage.ResponseMessageType.UNKNOWN;
                String cognosSQL = rsapiDataSet.getCognosSQL();
                for (IXDataSource aNode : nodeList) {
                    if (aNode instanceof XMdx) {
                        if (nodeStr.length() != 0) {
                            nodeStr.append(NEWLINE);
                            nodeStr.append(NEWLINE);
                        }
                        nodeStr.append(aNode.getQueryText());
                        responseMsgType = ResponseMessage.ResponseMessageType.MDX_NODE_TYPE_INT;
                        cognosSQL = "";
                        continue;
                    }
                    if (aNode instanceof XSql) {
                        if (rsapiDataSet.forXtabRelational()) continue;
                        if (nodeStr.length() != 0) {
                            nodeStr.append(NEWLINE);
                            nodeStr.append(NEWLINE);
                        }
                        String nativeSQL = aNode.getQueryText();
                        Governors g = rsapiDataSet.getGovernors();
                        if (g != null && g.getUseSQLParameters() == Governors.UseSQLParameters.LITERAL) {
                            XSql xsql = (XSql)aNode;
                            MultiRequestContext mrc = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext();
                            Parameters parameters = mrc.getRequestParameters().getParameters();
                            String sqlText = xsql.substituteParameterInNativeSQLWithLiteral(parameters);
                            StringBuilder fullSql = new StringBuilder();
                            if (xsql.getCommentText() != null) {
                                fullSql.append(xsql.getCommentText());
                                fullSql.append(NEWLINE);
                            }
                            fullSql.append(sqlText);
                            nativeSQL = fullSql.toString();
                        }
                        nodeStr.append(nativeSQL);
                        responseMsgType = ResponseMessage.ResponseMessageType.SQL_NODE_TYPE_INT;
                        continue;
                    }
                    if (nodeStr.length() != 0) {
                        nodeStr.append(NEWLINE);
                        nodeStr.append(NEWLINE);
                    }
                    nodeStr.append(aNode.getQueryText());
                    responseMsgType = ResponseMessage.ResponseMessageType.SQL_NODE_TYPE_INT;
                }
                IXQEQueryNode[] datasetArray = new IXQEQueryNode[]{rsapiDataSet};
                XQENodeSerializer.serializeQueryFeedback(writer, datasetArray, queryFeedback, environment, null);
                if (!isRSVP4J) {
                    XQENodeSerializer.serializeMasterDataset(writer, rsapiDataSet);
                } else {
                    rsvp4jDatasets.addAll(RSVP4JHelper.generateExecuteResponse(datasetArray));
                }
                int maxSeverityLevel = environment.getMaxSeverityLevel();
                if (cognosSQL != null && !cognosSQL.equals("") && maxSeverityLevel >= 2) {
                    ResponseMessage responseMessage = new ResponseMessage(maxSeverityLevel, ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT, cognosSQL);
                    environment.getResponseMessageFolder().appendValidationResponseMessage(responseMessage);
                }
                XQENodeSerializer.addNagMessagesToResponseFolder(environment);
                XQENodeSerializer.addSubquerySQLNagsToResponseFolder(environment);
                if (rsapiDataSet.forDMRReport()) {
                    XQENodeSerializer.addSubqueryNagMessagesToResponseFolder(environment, rsapiDataSet, nodeStr.toString(), ResponseMessage.ResponseMessageType.DMR_NODE_TYPE_INT);
                    continue;
                }
                if (rsapiDataSet.forXtabRelational()) {
                    XQENodeSerializer.addSubqueryNagMessagesToResponseFolder(environment, rsapiDataSet, nodeStr.toString(), ResponseMessage.ResponseMessageType.XTAB_REL_NODE_TYPE_INT);
                    continue;
                }
                if (nodeStr.toString() != null && !nodeStr.toString().equals("") && environment.getMaxSeverityLevel() == 3) {
                    environment.getResponseMessageFolder().appendInfoResponseMessage(responseMsgType, nodeStr.toString(), operationName);
                }
                if ((nativeCursorSQLText = rsapiDataSet.getExecutionSQLCursors().getFormattedString()) == null || nativeCursorSQLText.equals("") || maxSeverityLevel != 2) continue;
                environment.getResponseMessageFolder().appendResponseMessage(maxSeverityLevel, ResponseMessage.ResponseMessageType.SQL_NODE_TYPE_INT, nativeCursorSQLText, operationName);
            }
        }
        XQENodeSerializer.generateMessageResponse(writer, environment);
        XQENodeSerializer.closeTag(writer, RESPONSE);
        writer.flush();
    }

    public static void addMigrateMessagesInMessageFolder(RequestEnvironment environment) {
        ResponseMessageFolder messageFolder = environment.getResponseMessageFolder();
        NagCollector nagCollector = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getNagCollector();
        List<Nag> nagMessages = nagCollector.getNagOfType(Nag.NagType.MIGRATE);
        for (Nag nag : nagMessages) {
            messageFolder.appendMigrateResponseMessage(nag.getMessage());
        }
    }

    public static void addNagMessagesToResponseFolder(RequestEnvironment environment) {
        int maxSeverity = environment.getMaxSeverityLevel();
        if (maxSeverity < 2) {
            return;
        }
        ResponseMessageFolder messageFolder = environment.getResponseMessageFolder();
        NagCollector nagCollector = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getNagCollector();
        List<Nag> nagMessages = nagCollector.getNagOfType(Nag.NagType.REUSE);
        for (Nag nag : nagMessages) {
            messageFolder.appendValidationKeyTransformationResponseMessage(ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, nag.getMessage());
        }
        List<Nag> nagMessages1 = nagCollector.getNagOfType(Nag.NagType.MASTER_DETAIL_OPTIMIZATION);
        for (Nag nag : nagMessages1) {
            messageFolder.appendValidationKeyTransformationResponseMessage(ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, nag.getMessage());
        }
        if (maxSeverity == 3) {
            nagMessages = nagCollector.getNagOfType(Nag.NagType.SIMPLE);
            for (Nag nag : nagMessages) {
                messageFolder.appendValidationInfoResponseMessage(ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, nag.getMessage());
            }
        }
    }

    public static void addSubqueryAndNagMessagesToResponseFolder(RequestEnvironment environment, IXQEQueryNode[] datasets) {
        XQENodeSerializer.addNagMessagesToResponseFolder(environment);
        for (int i = 0; i < datasets.length; ++i) {
            RSAPIDataset rsapiDataSet = (RSAPIDataset)datasets[i];
            ResponseMessage.ResponseMessageType msgType = null;
            if (rsapiDataSet.forDMRReport()) {
                msgType = ResponseMessage.ResponseMessageType.DMR_NODE_TYPE_INT;
            }
            if (rsapiDataSet.forXtabRelational()) {
                msgType = ResponseMessage.ResponseMessageType.XTAB_REL_NODE_TYPE_INT;
            }
            if (msgType == null) continue;
            StringBuffer mdxStrBuffer = new StringBuffer();
            for (IXDataSource node : XQENodeSerializer.findQuerySourceNodes(rsapiDataSet)) {
                if (!(node instanceof XMdx)) continue;
                XMdx mdxNode = (XMdx)node;
                if (!mdxStrBuffer.toString().equals("")) {
                    mdxStrBuffer.append(NEWLINE);
                    mdxStrBuffer.append(NEWLINE);
                }
                mdxStrBuffer.append(mdxNode.getMdxText());
            }
            XQENodeSerializer.addSubqueryNagMessagesToResponseFolder(environment, rsapiDataSet, mdxStrBuffer.toString(), msgType);
        }
    }

    public static void addSubquerySQLNagsToResponseFolder(RequestEnvironment environment) {
        XQENodeSerializer.addSubqueryTypeNagMessages(environment, NagSubquery.NagSubqueryType.PARAMETERMAP);
        XQENodeSerializer.addSubqueryTypeNagMessages(environment, NagSubquery.NagSubqueryType.FJO);
    }

    public static void addSubqueryTypeNagMessages(RequestEnvironment environment, NagSubquery.NagSubqueryType subqueryType) {
        if (environment.getMaxSeverityLevel() < 3) {
            return;
        }
        ResponseMessageFolder messageFolder = environment.getResponseMessageFolder();
        NagCollector nagCollector = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getNagCollector();
        List<Nag> nagMessages = nagCollector.getNagOfSubqueryType(subqueryType);
        for (Nag nags : nagMessages) {
            NagSubquery pmNag = (NagSubquery)nags;
            int infoSeverity = 3;
            StringBuilder msg = new StringBuilder();
            msg.append(pmNag.getMessage());
            msg.append(NEWLINE);
            msg.append(pmNag.getCognosSQL());
            ResponseMessage.ResponseMessageType msgType = ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT;
            ResponseMessage cognosSQLMsg = new ResponseMessage(infoSeverity, msgType, msg.toString());
            cognosSQLMsg.setQueryLanguage("cognosSQL");
            messageFolder.appendValidationResponseMessage(cognosSQLMsg);
            String nativeSQL = pmNag.getNativeSQL();
            if (nativeSQL == null || nativeSQL.isEmpty()) continue;
            msgType = ResponseMessage.ResponseMessageType.SQL_NODE_TYPE_INT;
            ResponseMessage nativeSQLMsg = new ResponseMessage(infoSeverity, msgType, nativeSQL);
            nativeSQLMsg.setQueryLanguage(NATIVE_SQL);
            messageFolder.appendValidationResponseMessage(nativeSQLMsg);
        }
    }

    public static void addSubqueryNagMessagesToResponseFolder(RequestEnvironment environment, RSAPIDataset rsapiDataset, String mdx, ResponseMessage.ResponseMessageType msgType) {
        int maxSeverityLevel = environment.getMaxSeverityLevel();
        if (maxSeverityLevel < 2) {
            return;
        }
        String name = rsapiDataset.getRefQueryName();
        ResponseMessageFolder newMessageFolder = environment.getResponseMessageFolder().appendResponseMessageFolder();
        ResponseMessage rmMDX = new ResponseMessage(maxSeverityLevel, msgType, mdx);
        rmMDX.setQueryLanguage("MDX");
        rmMDX.setReportQuery(name);
        newMessageFolder.appendValidationResponseMessage(rmMDX);
        NagCollector nagCollector = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getNagCollector();
        for (Nag nag : nagCollector.getNagOfType(Nag.NagType.SUBQUERY)) {
            String reportQueryName;
            NagSubquery nagDMRSql = (NagSubquery)nag;
            if (!nagDMRSql.canSQLBeLogged() || !name.equals(reportQueryName = nagDMRSql.getReportQueryName())) continue;
            StringBuilder msg = new StringBuilder();
            msg.append(nagDMRSql.getMessage());
            msg.append(NEWLINE);
            msg.append(NEWLINE);
            msg.append(nagDMRSql.getCognosSQL());
            ResponseMessage cognosSQLMsg = new ResponseMessage(maxSeverityLevel, msgType, msg.toString());
            cognosSQLMsg.setQueryLanguage("cognosSQL");
            cognosSQLMsg.setReportQuery(name);
            newMessageFolder.appendValidationResponseMessage(cognosSQLMsg);
            String nativeSQL = nagDMRSql.getNativeSQL();
            if (nativeSQL == null || nativeSQL.isEmpty()) continue;
            ResponseMessage nativeSQLMsg = new ResponseMessage(maxSeverityLevel, msgType, nativeSQL);
            nativeSQLMsg.setQueryLanguage(NATIVE_SQL);
            nativeSQLMsg.setReportQuery(name);
            newMessageFolder.appendValidationResponseMessage(nativeSQLMsg);
        }
    }

    private static void generateMissingMemberValidateResponse(Writer writer, Element missingMembersElement, RequestEnvironment environment) throws IOException {
        missingMembersElement.write(writer);
        XMLWriter xmlWriter = new XMLWriter();
        xmlWriter.addStream(writer);
        xmlWriter.setSkipLineFeed(true);
        environment.getResponseMessageFolder().toXMLString(environment, xmlWriter, environment.getProductLocale());
        writer.flush();
    }

    private static void generateMessageResponse(Writer writer, RequestEnvironment environment) throws IOException {
        XMLWriter xmlWriter = new XMLWriter();
        xmlWriter.addStream(writer);
        xmlWriter.setSkipLineFeed(true);
        environment.getResponseMessageFolder().toXMLString(environment, xmlWriter, environment.getProductLocale());
        writer.flush();
    }

    static void generateExecuteResponse(Writer writer, IXQEQueryNode[] datasets, RequestEnvironment environment, AppendPlanIDs appendPlanIDs, Element queryFeedback, String reportVersion) throws IOException {
        XQENodeSerializer.openTag(writer, RESPONSE, Collections.EMPTY_MAP);
        XQENodeSerializer.serializeQueryFeedback(writer, datasets, queryFeedback, environment, reportVersion);
        XQENodeSerializer.serializeMasterDatasets(writer, datasets);
        if (AppendPlanIDs.APPEND == appendPlanIDs) {
            XQENodeSerializer.appendPlanIDs(datasets, writer);
        }
        XQENodeSerializer.addSubqueryAndNagMessagesToResponseFolder(environment, datasets);
        XQENodeSerializer.generateMessageResponse(writer, environment);
        XQENodeSerializer.closeTag(writer, RESPONSE);
        writer.flush();
    }

    private static void serializeQueryFeedback(Writer writer, IXQEQueryNode[] datasets, Element queryFeedback, RequestEnvironment environment, String reportVersion) throws IOException {
        if (queryFeedback == null || queryFeedback.elements().size() == 0) {
            return;
        }
        XQENodeSerializer.openTag(writer, QUERY_FEEDBACK_RESULT, Collections.EMPTY_MAP);
        Iterator it = queryFeedback.elementIterator(PROPERTY);
        while (it.hasNext()) {
            Element propertyElement = (Element)it.next();
            String property = propertyElement.attributeValue(NAME);
            if (property == null || property.equals("")) continue;
            String queryName = propertyElement.attributeValue(QUERY_NAME);
            List<Integer> dsIndicesToProcess = XQENodeSerializer.getDatasetIndicesToProcess(datasets, queryName);
            for (Integer dsIndex : dsIndicesToProcess) {
                RSAPIDataset rsapiDataSet = (RSAPIDataset)datasets[dsIndex];
                XMdx mdxNode = null;
                XSql sqlNode = null;
                StringBuilder nodeStr = new StringBuilder();
                StringBuilder nativeQuerySpecificationSql = new StringBuilder();
                ResponseMessage.ResponseMessageType nodeType = ResponseMessage.ResponseMessageType.UNKNOWN;
                String cognosSQL = rsapiDataSet.getCognosSQL();
                ArrayList<IDataSource> dataSources = new ArrayList<IDataSource>();
                List<IXDataSource> nodes = XQENodeSerializer.findQuerySourceNodes(rsapiDataSet);
                for (IXDataSource node : nodes) {
                    XTableFunction xmlTableFunction;
                    IDataSource ds;
                    if (node instanceof XMdx) {
                        mdxNode = (XMdx)node;
                        if (nodeStr.length() != 0) {
                            nodeStr.append(NEWLINE);
                            nodeStr.append(NEWLINE);
                        }
                        nodeStr.append(mdxNode.getMdxText());
                        nodeType = ResponseMessage.ResponseMessageType.MDX_NODE_TYPE_INT;
                        cognosSQL = "";
                        if (dataSources.contains(mdxNode.getDataSource())) continue;
                        dataSources.add(mdxNode.getDataSource());
                        continue;
                    }
                    if (node instanceof XSql) {
                        sqlNode = (XSql)node;
                        if (!rsapiDataSet.forXtabRelational()) {
                            if (nodeStr.length() != 0) {
                                nodeStr.append(NEWLINE);
                                nodeStr.append(NEWLINE);
                            }
                            String nativeSQL = node.getQueryText();
                            Governors g = rsapiDataSet.getGovernors();
                            if (g != null && g.getUseSQLParameters() == Governors.UseSQLParameters.LITERAL) {
                                XSql xsql = (XSql)node;
                                MultiRequestContext mrc = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getMultiRequestContext();
                                Parameters parameters = mrc.getRequestParameters().getParameters();
                                String sqlText = xsql.substituteParameterInNativeSQLWithLiteral(parameters);
                                StringBuilder fullSql = new StringBuilder();
                                if (xsql.getCommentText() != null) {
                                    fullSql.append(xsql.getCommentText());
                                    fullSql.append(NEWLINE);
                                }
                                fullSql.append(sqlText);
                                nativeSQL = fullSql.toString();
                            }
                            nodeStr.append(nativeSQL);
                            nodeType = ResponseMessage.ResponseMessageType.SQL_NODE_TYPE_INT;
                            String sql = sqlNode.getQuerySpecificationSQL();
                            if (sql != null) {
                                if (nativeQuerySpecificationSql.length() > 0) {
                                    nativeQuerySpecificationSql.append(NEWLINE);
                                }
                                nativeQuerySpecificationSql.append(NEWLINE);
                                nativeQuerySpecificationSql.append(sql);
                                nativeQuerySpecificationSql.append(NEWLINE);
                            }
                        }
                        if (dataSources.contains(sqlNode.getDataSource())) continue;
                        dataSources.add(sqlNode.getDataSource());
                        continue;
                    }
                    if (node instanceof XTableFunction && (ds = (xmlTableFunction = (XTableFunction)node).getDataSource()) != null && !dataSources.contains(ds)) {
                        dataSources.add(xmlTableFunction.getDataSource());
                    }
                    if (nodeStr.length() != 0) {
                        nodeStr.append(NEWLINE);
                        nodeStr.append(NEWLINE);
                    }
                    nodeStr.append(node.getQueryText());
                }
                String rsapiName = rsapiDataSet.getName();
                boolean qualifiedDS = true;
                DatasetInfoExtended exDataSetInfo = rsapiDataSet.getExtendedDatasetInfo();
                if (property.equals(COGNOS_COMMAND_TEXT_PROPERTY) || property.equals("cognosCommandText") || property.equals("cognosSQL")) {
                    XQENodeSerializer.serializeProperty(writer, rsapiName, COGNOS_COMMAND_TEXT_PROPERTY, cognosSQL, false);
                    continue;
                }
                if (property.equals("nativeCommandText") || property.equals(NATIVE_SQL)) {
                    XQENodeSerializer.serializeProperty(writer, rsapiName, "nativeCommandText", nodeStr.toString(), false);
                    continue;
                }
                if (nodeType != ResponseMessage.ResponseMessageType.UNKNOWN && property.equals(NATIVE_COMMAND_TYPE_PROPERTY)) {
                    XQENodeSerializer.serializeProperty(writer, rsapiName, NATIVE_COMMAND_TYPE_PROPERTY, ResponseMessage.typeToString(nodeType), false);
                    continue;
                }
                if (property.equals(CATALOG)) {
                    XQENodeSerializer.serializeProperty(writer, rsapiName, CATALOG, "", false);
                    continue;
                }
                if (property.equals(COLUMN_LIST_PROPERTY)) {
                    XQENodeSerializer.serializeColumnList(writer, rsapiDataSet);
                    continue;
                }
                if (property.equals(CONNECTIONS_PROPERTY)) {
                    String qualifiedDSValue = propertyElement.attributeValue(QUALIFIEDDS);
                    if (qualifiedDSValue != null && qualifiedDSValue.equals("false")) {
                        qualifiedDS = false;
                    }
                    XQENodeSerializer.serializeConnections(writer, rsapiDataSet, dataSources, qualifiedDS);
                    continue;
                }
                if (property.equals("nativeQuerySpecificationText")) {
                    writer.append(NEWLINE);
                    XQENodeSerializer.serializeProperty(writer, rsapiName, "nativeQuerySpecificationText", nativeQuerySpecificationSql.toString(), false);
                    writer.append(NEWLINE);
                    continue;
                }
                if (property.equals("datasetInfoExtended")) {
                    if (null != exDataSetInfo) {
                        exDataSetInfo.serializeToXML(writer, reportVersion);
                        continue;
                    }
                    if (null == reportVersion || reportVersion.isEmpty()) continue;
                    DatasetInfoExtended newExDataSetInfo = rsapiDataSet.addExtendedDatasetInfoIfNotExist();
                    newExDataSetInfo.serializeToXML(writer, reportVersion);
                    continue;
                }
                if (!property.equals("usedParameterValue")) continue;
                MoserParameterUtil.serializeUsedParameterValueToXML(writer, environment);
            }
        }
        XQENodeSerializer.closeTag(writer, QUERY_FEEDBACK_RESULT);
    }

    private static void serializeColumnList(Writer writer, RSAPIDataset rsapiDataSet) throws IOException {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put(NAME, COLUMN_LIST_PROPERTY);
        attributeMap.put(QUERY_NAME, rsapiDataSet.getName());
        XQENodeSerializer.openTag(writer, PROPERTY, attributeMap);
        XQENodeSerializer.openTag(writer, COLUMN_LIST_PROPERTY, Collections.EMPTY_MAP);
        for (RSAPIEdge edge : rsapiDataSet.getEdges()) {
            for (RSAPIEdgeRowset rowset : edge.getRowsets()) {
                if (rowset.getNumColumns() == 0) continue;
                for (RSAPIColumn column : rowset.getColumns()) {
                    Governors governors;
                    attributeMap.clear();
                    attributeMap.put(NAME, column.getName());
                    attributeMap.put("sqlName", column.getName());
                    attributeMap.put(TYPE, column.getDatatype().getTypeName());
                    attributeMap.put(LENGTH, Integer.toString(column.getLength()));
                    attributeMap.put(PRECISION, Integer.toString(column.getPrecision()));
                    attributeMap.put(SCALE, Integer.toString(column.getScale()));
                    attributeMap.put(NULLSALLOWED, Boolean.toString(column.getNullsOK()));
                    if (column.getResolvedAggregateType() != null) {
                        attributeMap.put(RESOLVED_AGGREGATE, column.getResolvedAggregateType());
                    }
                    if ((governors = rsapiDataSet.getGovernors()) != null && governors.getReportAsDatasource()) {
                        attributeMap.put(SQLCOLUMNINDEX, Integer.toString(column.getSqlColumnIndex()));
                        attributeMap.put(SQLCOLUMNNAME, column.getSqlColumnName());
                        attributeMap.put(SQLCOLUMNMODELTYPE, column.getDatatype().toModelType());
                    }
                    XQENodeSerializer.openTag(writer, ITEM, attributeMap);
                    XQENodeSerializer.closeTag(writer, ITEM);
                }
            }
        }
        XQENodeSerializer.closeTag(writer, COLUMN_LIST_PROPERTY);
        XQENodeSerializer.closeTag(writer, PROPERTY);
    }

    private static void serializeConnections(Writer writer, RSAPIDataset rsapiDataSet, List<IDataSource> dataSources, boolean qualifiedDS) throws IOException {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put(NAME, CONNECTIONS_PROPERTY);
        String qualifiedDSValue = null;
        qualifiedDSValue = qualifiedDS ? "true" : "false";
        attributeMap.put(QUALIFIEDDS, qualifiedDSValue);
        attributeMap.put(QUERY_NAME, rsapiDataSet.getName());
        XQENodeSerializer.openTag(writer, PROPERTY, attributeMap);
        for (IDataSource dataSource : dataSources) {
            attributeMap.clear();
            Map<String, Object> properties = dataSource.getMetadataProperties();
            String value = null;
            if (qualifiedDS) {
                value = (String)properties.get(CATALOG);
                if (value != null) {
                    attributeMap.put(CATALOG, value);
                }
                if ((value = (String)properties.get(SCHEMA)) != null) {
                    attributeMap.put(SCHEMA, value);
                }
                if ((value = (String)properties.get(NAME)) != null) {
                    attributeMap.put(MODELDSNAME, value);
                }
            }
            if ((value = (String)properties.get("cmDataSource")) != null) {
                attributeMap.put(VALUE, value);
            }
            XQENodeSerializer.openTag(writer, CONNECTION, attributeMap);
            XQENodeSerializer.closeTag(writer, CONNECTION);
        }
        XQENodeSerializer.closeTag(writer, PROPERTY);
    }

    static void generateResponseMessageFolder(Writer aWriter, ResponseMessage.ResponseMessageType messageType, String messageStr, RequestEnvironment environment, String operationName) throws IOException {
        XMLWriter xmlWriter = new XMLWriter();
        xmlWriter.addStream(aWriter);
        if ((messageType != ResponseMessage.ResponseMessageType.TYPE_EXCEPTION || messageStr != null && !messageStr.equals("")) && environment.getMaxSeverityLevel() == 3) {
            environment.getResponseMessageFolder().appendInfoResponseMessage(messageType, messageStr, operationName);
            xmlWriter.setSkipLineFeed(true);
        }
        environment.getResponseMessageFolder().toXMLString(environment, xmlWriter, environment.getProductLocale());
    }

    static void generateResponseMessageFolderForDMR(Writer aWriter, ResponseMessage.ResponseMessageType messageType, String messageStr, RequestEnvironment environment, String operationName) throws IOException {
        XMLWriter xmlWriter = new XMLWriter();
        xmlWriter.addStream(aWriter);
        if ((messageType != ResponseMessage.ResponseMessageType.TYPE_EXCEPTION || messageStr != null && !messageStr.equals("")) && environment.getMaxSeverityLevel() >= 2) {
            ResponseMessage responseMessage = new ResponseMessage(environment.getMaxSeverityLevel(), messageType, messageStr);
            environment.getResponseMessageFolder().appendValidationResponseMessage(responseMessage);
            xmlWriter.setSkipLineFeed(true);
        }
        environment.getResponseMessageFolder().toXMLString(environment, xmlWriter, environment.getProductLocale());
    }

    private void serializeEdge(OutputStream outStream, RSAPIEdgeIterator edgeIterator, String edgeName, GetPartialDatasetRequestAdapter.EdgeChunkInfo chunkInfo, RSAPIEdge edge) throws IOException {
        outStream.write(OPEN_EDGE1);
        outStream.write(edgeName.getBytes(UTF_8));
        outStream.write(GENERAL_END_OPENTAG);
        if (chunkInfo.chunkStart == -5) {
            this.serializeLastNRows(outStream, edgeIterator, chunkInfo.chunkSize, edge.getNumRowsets());
        } else if (chunkInfo.chunkStart == -4) {
            edgeIterator.reset();
            this.serializeNextNRows(outStream, edgeIterator, chunkInfo.chunkSize);
        } else {
            this.serializeNextNRows(outStream, edgeIterator, chunkInfo.chunkSize);
        }
        this.serializeEdgeInfo(outStream, edgeIterator);
        outStream.write(CLOSE_EDGE);
    }

    private void serializeNextNRows(OutputStream outStream, RSAPIEdgeIterator edgeIterator, int nRows) throws IOException {
        int rowCount = 0;
        while (edgeIterator.hasNext()) {
            RSAPIRow aRow = edgeIterator.next();
            this.serializeRow(outStream, aRow, false, false);
            if (++rowCount != nRows) continue;
            break;
        }
    }

    private void serializeLastNRows(OutputStream outStream, RSAPIEdgeIterator edgeIterator, int nRows, int numRowsets) throws IOException {
        Queue rows = new Queue();
        RSAPIRow[] lastRowForRowset = new RSAPIRow[numRowsets];
        this.fetchLastNRowsAndStore(edgeIterator, nRows, rows, lastRowForRowset);
        this.serializeRowsFromBuffer(outStream, rows, lastRowForRowset);
    }

    private void serializeRowsFromBuffer(OutputStream outStream, Queue rows, RSAPIRow[] lastRowForRowset) throws IOException {
        for (RSAPIRow row : lastRowForRowset) {
            if (row == null || rows.contains(row)) continue;
            this.serializeRow(outStream, row, false, true);
        }
        while (rows.size() > 0) {
            RSAPIRow aRow = (RSAPIRow)rows.take();
            this.serializeRow(outStream, aRow, false, false);
        }
    }

    private void fetchLastNRowsAndStore(RSAPIEdgeIterator edgeIterator, int nRows, Queue rows, RSAPIRow[] lastRowForRowset) {
        RSAPIRow rowCopy = null;
        while (edgeIterator.hasNext()) {
            RSAPIRow aRow = edgeIterator.next();
            if (rows.size() == nRows) {
                rows.take();
            }
            rowCopy = (RSAPIRow)aRow.copy();
            rows.put(rowCopy);
            lastRowForRowset[rowCopy.getRowsetId()] = rowCopy;
        }
    }

    private void serializeCellInfo(OutputStream outStream, RSAPICellIterator anIterator) throws IOException {
        outStream.write(OPEN_INFO);
        if (anIterator.hasNext()) {
            outStream.write(DIGIT_ZERO);
        } else {
            outStream.write(DIGIT_ONE);
        }
        outStream.write(CLOSE_INFO);
    }

    private void serializeEdgeInfo(OutputStream outStream, RSAPIEdgeIterator anIterator) throws IOException {
        outStream.write(OPEN_INFO);
        if (anIterator.hasNext()) {
            outStream.write(DIGIT_ZERO);
        } else {
            outStream.write(DIGIT_ONE);
        }
        outStream.write(CLOSE_INFO);
    }

    void generateGetPartialDatasetResponse(OutputStream outStream, RSAPIPartialDataset partialDataset, String masterDatasetId, Map<String, GetPartialDatasetRequestAdapter.EdgeChunkInfo> edgeChunkInfoMap) throws IOException {
        GetPartialDatasetRequestAdapter.EdgeChunkInfo chunkInfo;
        outStream.write(OPEN_RESPONSE_TAG);
        outStream.write(OPEN_PARTIAL_DATASET1);
        outStream.write(partialDataset.getUniqueID().getBytes(UTF_8));
        outStream.write(OPEN_PARTIAL_DATASET2);
        outStream.write(masterDatasetId.getBytes(UTF_8));
        outStream.write(GENERAL_END_OPENTAG);
        RSAPIDataset masterDataset = partialDataset.getMasterDataset();
        RSAPIEdge[] edges = masterDataset.getEdges();
        for (int i = 0; i < edges.length; ++i) {
            RSAPIEdgeIterator edgeIterator = partialDataset.edgeIterator(i);
            String edgeName = edges[i].getName();
            GetPartialDatasetRequestAdapter.EdgeChunkInfo chunkInfo2 = edgeChunkInfoMap.get(edgeName);
            if (chunkInfo2 == null) continue;
            this.serializeEdge(outStream, edgeIterator, edgeName, chunkInfo2, edges[i]);
        }
        RSAPICellIterator cellIterator = partialDataset.cellIterator();
        if (cellIterator != null && (chunkInfo = edgeChunkInfoMap.get("cells")) != null) {
            outStream.write(OPEN_CELLS);
            int rowCount = 0;
            while (cellIterator.hasNext()) {
                RSAPICell aRow = cellIterator.next();
                this.serializeRow(outStream, aRow, true, false);
                if (++rowCount != chunkInfo.chunkSize) continue;
            }
            this.serializeCellInfo(outStream, cellIterator);
            outStream.write(CLOSE_CELLS);
        }
        outStream.write(CLOSE_PARTIAL_DATASET);
        outStream.write(CLOSE_RESPONSE_TAG);
        outStream.flush();
    }

    private void serializeRow(OutputStream outStream, RSAPIValue aRow, boolean cellRow, boolean isContextRow) throws IOException {
        outStream.write(OPEN_ROW1);
        outStream.write(XQEIntegerPool.encodeIntegerAsString(aRow.getRowNumber()));
        outStream.write(OPEN_ROW2);
        outStream.write(XQEIntegerPool.encodeIntegerAsString(aRow.getRowsetId()));
        outStream.write(OPEN_ROW3);
        outStream.write(XQEIntegerPool.encodeIntegerAsString(aRow.getDetailRowNumber()));
        outStream.write(OPEN_ROW4);
        outStream.write(XQEIntegerPool.encodeIntegerAsString(aRow.getAncestorRowNumber()));
        outStream.write(OPEN_ROW5);
        outStream.write(XQEIntegerPool.encodeIntegerAsString(aRow.getAncestorRowsetId()));
        if (isContextRow) {
            outStream.write(OPEN_ROW6);
            outStream.write(XQEIntegerPool.encodeIntegerAsString(1));
        }
        outStream.write(GENERAL_END_OPENTAG);
        if (cellRow) {
            RSAPICell aCell = (RSAPICell)aRow;
            int[] coordinates = aCell.getEdgeCoordinates();
            for (int i = 0; i < coordinates.length; ++i) {
                outStream.write(OPEN_COORDINATE1);
                outStream.write(XQEIntegerPool.encodeIntegerAsString(coordinates[i]));
                outStream.write(OPEN_COORDINATE2);
            }
        } else {
            outStream.write(OPEN_COORDINATE1);
            outStream.write(XQEIntegerPool.encodeIntegerAsString(aRow.getCellCoordinate()));
            outStream.write(OPEN_COORDINATE2);
        }
        RSAPIColumn[] columnInfo = aRow.getRowset().getColumns();
        if (columnInfo != null) {
            for (int i = 0; i < aRow.getNumColumns(); ++i) {
                this.serializeColumn(outStream, (Value)aRow.getColumn(i), columnInfo[i], aRow.isListReport());
            }
        }
        outStream.write(CLOSE_ROW);
    }

    private String handleStringDictionary(OutputStream outStream, String value) throws IOException {
        if (value == null) {
            return null;
        }
        Integer id = this.stringDictionary.get(value);
        if (id != null) {
            return id.toString();
        }
        id = XQEIntegerPool.getInteger(this.stringMapCurrentId++);
        this.stringDictionary.put(value, id);
        if (StringSubstitutionEngine.hasInvalidXMLCharacter(value)) {
            String escapedStringBase64 = Base64.encode((byte[])value.getBytes(UTF_8));
            this.serializeBase64StringTag(outStream, id, escapedStringBase64);
        } else {
            String escapedString = StringSubstitutionEngine.escapeString(value);
            this.serializeStringTag(outStream, id, escapedString);
        }
        return id.toString();
    }

    private void serializeColumn(OutputStream outStream, Value column, RSAPIColumn columnInfo, boolean isListReport) throws IOException {
        IDataType columnDataType = column.getDataType();
        String currencyCode = null;
        String unitOfMeasure = null;
        String format = null;
        String formatId = null;
        FormatService service = FormatService.getInstance();
        int scaleTrim = 0;
        if (null != service) {
            FormatId id = null;
            id = isListReport ? this.computeFormatId(columnInfo.getFormatID(), column.getFormatId()) : this.computeFormatId(column.getFormatId(), columnInfo.getFormatID());
            if (id != null) {
                currencyCode = service.getCurrencyCode(id);
                unitOfMeasure = service.getUnitOfMeasure(id);
                format = service.retrieveFormatString(id);
                formatId = service.getFormatStringId(id);
            }
        }
        if (currencyCode == null) {
            currencyCode = columnInfo.getCurrencyCode();
        }
        format = this.handleStringDictionary(outStream, format);
        String moString = columnInfo.getQueryItemModelId();
        if (moString != null) {
            moString = this.handleStringDictionary(outStream, moString);
        }
        byte dType = columnDataType.getCCLTypeCode();
        String value = null;
        if (column.isOK() && !column.isNumeric()) {
            if (dType == 18 || dType == 23 || dType == 24) {
                value = this.handleStringDictionary(outStream, "");
            } else {
                String tValue = column.getXSDLiteral();
                if (tValue.length() > Short.MAX_VALUE) {
                    tValue = tValue.substring(0, Short.MAX_VALUE);
                }
                value = this.handleStringDictionary(outStream, tValue);
            }
        }
        outStream.write(OPEN_COLUMN1);
        outStream.write(column.getState().getCCLDBStateAsByteArray());
        outStream.write(OPEN_COLUMN2);
        if (dType == 46 || dType == 100 || dType == 18 || dType == 23 || dType == 24 || DataTypeCode.isPeriodType(dType)) {
            dType = 1;
        }
        outStream.write(XQEIntegerPool.encodeIntegerAsString(dType));
        if (moString != null) {
            outStream.write(OPEN_COLUMN6);
            outStream.write(moString.getBytes(UTF_8));
        }
        if (format != null) {
            outStream.write(OPEN_COLUMN8);
            outStream.write(format.getBytes(UTF_8));
        }
        if (formatId != null) {
            outStream.write(OPEN_COLUMN9);
            outStream.write(formatId.getBytes(UTF_8));
        }
        if (columnDataType.hasPrecision()) {
            outStream.write(OPEN_COLUMN4);
            if (columnDataType.isExactNumeric() && columnDataType.getPrecision() > 77) {
                outStream.write(XQEIntegerPool.encodeIntegerAsString(77));
            } else {
                outStream.write(XQEIntegerPool.encodeIntegerAsString(Math.min(Short.MAX_VALUE, columnDataType.getPrecision())));
            }
        }
        if (columnDataType.hasScale()) {
            outStream.write(OPEN_COLUMN5);
            if (columnDataType.isExactNumeric() && columnDataType.getPrecision() > 77) {
                int scale;
                int precision = columnDataType.getPrecision();
                scaleTrim = scale = columnDataType.getScale();
                if (scale > 15 && (scale = (int)((double)scale * (77.0 / (double)precision))) < 15) {
                    scale = 15;
                }
                scaleTrim -= scale;
                outStream.write(XQEIntegerPool.encodeIntegerAsString(scale));
            } else {
                outStream.write(XQEIntegerPool.encodeIntegerAsString(columnDataType.getScale()));
            }
        }
        if (currencyCode != null) {
            outStream.write(OPEN_COLUMN7);
            outStream.write(currencyCode.getBytes(UTF_8));
        }
        if (unitOfMeasure != null) {
            outStream.write(OPEN_COLUMN10);
            outStream.write(unitOfMeasure.getBytes(UTF_8));
        }
        if (!column.isOK()) {
            outStream.write(OPEN_VALUE1);
        } else if (column.isNumeric()) {
            outStream.write(OPEN_VALUE3);
            if (columnDataType.isExactNumeric() && columnDataType.getPrecision() > 77) {
                int adjustedScale = columnDataType.getScale();
                value = ((ExactNumericValue)column).getUnscaledString();
                if (scaleTrim > 0 && scaleTrim < value.length()) {
                    value = value.substring(0, value.length() - scaleTrim);
                    adjustedScale -= scaleTrim;
                }
                if (value.length() > 77 || adjustedScale < -255) {
                    int length = value.length();
                    int integerPart = length - adjustedScale;
                    value = value.substring(0, integerPart) + "." + value.substring(integerPart, length);
                    if (adjustedScale < -255) {
                        throw new XQERuntimeException(XQEMessageKeys.DAT_DecimalOverflowError, (Object)value, (Object)Integer.toString(77), (Object)Integer.toString(-255));
                    }
                    throw new XQERuntimeException(XQEMessageKeys.DAT_DecimalOverflowError, (Object)value, (Object)Integer.toString(77), (Object)Integer.toString(adjustedScale));
                }
                outStream.write(value.getBytes(UTF_8));
            } else if (columnDataType.hasScale()) {
                outStream.write(((ExactNumericValue)column).getUnscaledString().getBytes(UTF_8));
            } else {
                outStream.write(column.toString().getBytes(UTF_8));
            }
            outStream.write(CLOSE_VALUE1);
            outStream.write(CLOSE_COLUMN);
        } else {
            outStream.write(GENERAL_END_OPENTAG);
            outStream.write(OPEN_VALUE2);
            outStream.write(value.getBytes(UTF_8));
            outStream.write(CLOSE_VALUE);
            outStream.write(CLOSE_COLUMN);
        }
    }

    FormatId computeFormatId(FormatId id1, FormatId id2) {
        if (id1 == null || id1 == FormatId.INVALID_FORMAT_FID || id1 == FormatId.EMPTY_FORMAT_FID) {
            return id2;
        }
        return id1;
    }

    private void serializeStringTag(OutputStream outStream, Integer id, String value) throws IOException {
        outStream.write(OPEN_STRING);
        outStream.write(XQEIntegerPool.encodeIntegerAsString(id));
        outStream.write(GENERAL_END_OPENTAG);
        outStream.write(value.getBytes(UTF_8));
        outStream.write(CLOSE_STRING);
    }

    private void serializeBase64StringTag(OutputStream outStream, Integer id, String value) throws IOException {
        outStream.write(OPEN_STRING_BASE64);
        outStream.write(XQEIntegerPool.encodeIntegerAsString(id));
        outStream.write(GENERAL_END_OPENTAG);
        outStream.write(value.getBytes(UTF_8));
        outStream.write(CLOSE_STRING_BASE64);
    }

    private static void serializeMasterDatasets(Writer writer, IXQEQueryNode[] datasets) throws IOException {
        RSAPIDataset dataset = null;
        for (int i = 0; i < datasets.length; ++i) {
            HashMap<String, Object> attributeMap = new HashMap<String, Object>();
            dataset = (RSAPIDataset)datasets[i];
            attributeMap.put(NAME, dataset.getName());
            attributeMap.put(MASTER_DATASET_ID, dataset.getUniqueID());
            XQENodeSerializer.openTag(writer, MASTER_DATASET, attributeMap);
            XQENodeSerializer.serializeDataSetInfo(writer, dataset);
            PlannedV5QuerySet querySet = (PlannedV5QuerySet)dataset.getParent();
            MasterDetailProvider mdProvider = querySet.getMasterDetailProvider();
            List<MasterDetailLink> mdLinks = mdProvider.getMasterDetailLinks(dataset.getName());
            if (!mdLinks.isEmpty()) {
                StringWriter stringWriter = new StringWriter();
                Element detailQueriesElement = GetDetailQueriesRequestAdapter.generateDetailQueriesResponse(querySet, mdLinks);
                detailQueriesElement.write((Writer)stringWriter);
                writer.write(stringWriter.toString());
            }
            XQENodeSerializer.closeTag(writer, MASTER_DATASET);
        }
    }

    private static void serializeMasterDataset(Writer writer, IXQEQueryNode dataset) throws IOException {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        RSAPIDataset masterDataset = (RSAPIDataset)dataset;
        attributeMap.put(NAME, masterDataset.getName());
        attributeMap.put(MASTER_DATASET_ID, masterDataset.getUniqueID());
        XQENodeSerializer.openTag(writer, MASTER_DATASET, attributeMap);
        XQENodeSerializer.serializeDataSetInfo(writer, masterDataset);
        PlannedV5QuerySet querySet = (PlannedV5QuerySet)masterDataset.getParent();
        MasterDetailProvider mdProvider = querySet.getMasterDetailProvider();
        List<MasterDetailLink> mdLinks = mdProvider.getMasterDetailLinks(masterDataset.getName());
        if (!mdLinks.isEmpty()) {
            StringWriter stringWriter = new StringWriter();
            Element detailQueriesElement = GetDetailQueriesRequestAdapter.generateDetailQueriesResponse(querySet, mdLinks);
            detailQueriesElement.write((Writer)stringWriter);
            writer.write(stringWriter.toString());
        }
        XQENodeSerializer.closeTag(writer, MASTER_DATASET);
    }

    private static void serializeDataSetInfo(Writer writer, RSAPIDataset rsapiDataSet) throws IOException {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        RSAPIEdge[] edges = rsapiDataSet.getEdges();
        int numEdges = edges.length;
        attributeMap.put("numEdges", Integer.toString(numEdges));
        attributeMap.put(NAME, rsapiDataSet.getName());
        if (rsapiDataSet.getOriginalRefQueryName() != null) {
            attributeMap.put(REF_QUERY_NAME, rsapiDataSet.getOriginalRefQueryName());
        } else {
            attributeMap.put(REF_QUERY_NAME, rsapiDataSet.getRefQueryName());
        }
        if (rsapiDataSet.getOptimizeForAllRows()) {
            attributeMap.put("allRows", DIGIT_ONE_STRING);
        }
        XQENodeSerializer.openTag(writer, DATA_SET_INFO, attributeMap);
        for (int i = 0; i < numEdges; ++i) {
            XQENodeSerializer.serializeEdgeInfo(writer, edges[i]);
        }
        RSAPICellRowset cellRowSet = rsapiDataSet.getCellRowset();
        if (cellRowSet != null) {
            XQENodeSerializer.serializeCellRowsetInfo(writer, cellRowSet);
        }
        XQENodeSerializer.closeTag(writer, DATA_SET_INFO);
    }

    private static void serializeEdgeInfo(Writer writer, RSAPIEdge anEdge) throws IOException {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        int numCoordinates = anEdge.getNumCoordinates(true);
        int numRowSets = anEdge.getNumRowsets();
        RSAPIEdgeRowset[] rowSets = anEdge.getRowsets();
        attributeMap.put("numCoordinates", Integer.toString(numCoordinates));
        attributeMap.put("numRowsets", Integer.toString(numRowSets));
        attributeMap.put(NAME, anEdge.getName());
        XQENodeSerializer.openTag(writer, EDGE_INFO, attributeMap);
        for (int i = 0; i < numRowSets; ++i) {
            XQENodeSerializer.serializeEdgeRowSetInfo(writer, rowSets[i]);
        }
        XQENodeSerializer.closeTag(writer, EDGE_INFO);
    }

    private static void serializeEdgeRowSetInfo(Writer writer, RSAPIEdgeRowset aRowSet) throws IOException {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put(NAME, aRowSet.getName());
        attributeMap.put(NUM_COLUMNS, Integer.toString(aRowSet.getNumColumns()));
        attributeMap.put(NUM_ROWS, Integer.toString(aRowSet.getNumRows()));
        attributeMap.put(ROWSET_ID, Integer.toString(aRowSet.getRowsetId()));
        RSAPIEdgeRowset temp = aRowSet.getNestedRowset();
        if (temp != null) {
            attributeMap.put("childRowsetId", Integer.toString(temp.getRowsetId()));
        }
        if ((temp = aRowSet.getParentRowset()) != null) {
            attributeMap.put("parentRowsetId", Integer.toString(temp.getRowsetId()));
        }
        if ((temp = aRowSet.getSiblingRowset()) != null) {
            attributeMap.put("nextRowsetId", Integer.toString(temp.getRowsetId()));
        }
        if ((temp = aRowSet.getHeaderRowset()) != null) {
            attributeMap.put("headerRowsetId", Integer.toString(temp.getRowsetId()));
        }
        if ((temp = aRowSet.getFooterRowset()) != null) {
            attributeMap.put("footerRowsetId", Integer.toString(temp.getRowsetId()));
        }
        attributeMap.put(MEASURE_ROW_SET, Boolean.toString(aRowSet.isMeasureRowset()));
        attributeMap.put("timeRowSet", Boolean.toString(aRowSet.isTimeRowset()));
        RSAPIColumn[] columns = aRowSet.getColumns();
        XQENodeSerializer.openTag(writer, ROW_SET_INFO, attributeMap);
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                XQENodeSerializer.serializeColumnInfo(writer, columns[i]);
            }
        }
        XQENodeSerializer.closeTag(writer, ROW_SET_INFO);
    }

    private static void serializeColumnInfo(Writer writer, RSAPIColumn column) throws IOException {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        IDataType dataType = column.getDatatype();
        if (null == dataType) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "serializeColumnInfo requires dataType");
        }
        byte dType = dataType.getCCLTypeCode();
        attributeMap.put("dataType", Integer.toString(dType));
        attributeMap.put(NAME, column.getName());
        attributeMap.put("nullsOk", Boolean.toString(column.getNullsOK()));
        if (dataType.isExactNumeric() && dataType.getPrecision() > 77) {
            int precision = dataType.getPrecision();
            int scale = dataType.getScale();
            if (scale > 15 && (scale = (int)((double)scale * (77.0 / (double)precision))) < 15) {
                scale = 15;
            }
            attributeMap.put(LENGTH, Integer.toString(39));
            attributeMap.put(PRECISION, Integer.toString(77));
            attributeMap.put(SCALE, Integer.toString(scale));
        } else {
            attributeMap.put(LENGTH, Integer.toString(column.getLength()));
            attributeMap.put(PRECISION, Integer.toString(Math.min(Short.MAX_VALUE, column.getPrecision())));
            attributeMap.put(SCALE, Integer.toString(column.getScale()));
        }
        attributeMap.put(SUBTYPE, column.getUsage().toString());
        attributeMap.put("label", column.getLabel());
        attributeMap.put(CURRENCY_CODE, column.getCurrencyCode());
        attributeMap.put(FORMAT, column.getFormat());
        attributeMap.put(FORMAT_ID, column.getFormatIDString());
        attributeMap.put("isPropertyColumn", Boolean.toString(column.getIsCanonicalProperty()));
        XQENodeSerializer.openTag(writer, COLUMN_INFO, attributeMap);
        XQENodeSerializer.closeTag(writer, COLUMN_INFO);
    }

    private static void serializeCellRowsetInfo(Writer writer, RSAPIRowset aRowSet) throws IOException {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put(NAME, aRowSet.getName());
        attributeMap.put(NUM_COLUMNS, Integer.toString(aRowSet.getNumColumns()));
        attributeMap.put(NUM_ROWS, Integer.toString(aRowSet.getNumRows()));
        attributeMap.put(ROWSET_ID, Integer.toString(aRowSet.getRowsetId()));
        attributeMap.put(MEASURE_ROW_SET, Boolean.toString(aRowSet.isMeasureRowset()));
        XQENodeSerializer.openTag(writer, ROW_SET_INFO, attributeMap);
        RSAPIColumn[] columns = aRowSet.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            XQENodeSerializer.serializeColumnInfo(writer, columns[i]);
        }
        XQENodeSerializer.closeTag(writer, ROW_SET_INFO);
    }

    public static void openTag(Writer writer, String tagName, Map<String, Object> attributes) throws IOException {
        XQENodeSerializer.openTag(writer, tagName, attributes, false);
    }

    public static void openTag(Writer writer, String tagName, Map<String, Object> attributes, boolean closeTag) throws IOException {
        StringBuilder str = new StringBuilder();
        str.append('<');
        str.append(tagName);
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String name = entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) continue;
            str.append(' ');
            str.append(name);
            str.append('=');
            str.append('\"');
            str.append(StringSubstitutionEngine.escapeString(value));
            str.append('\"');
        }
        if (closeTag) {
            str.append('/');
        }
        str.append('>');
        writer.write(str.toString());
    }

    public static void closeTag(Writer writer, String tagName) throws IOException {
        writer.write(60);
        writer.write(47);
        writer.write(tagName);
        writer.write(62);
    }

    private static void serializeProperty(Writer writer, String queryName, String name, String value, boolean serializeAsAttribute) throws IOException {
        queryName = StringSubstitutionEngine.escapeString(queryName);
        name = StringSubstitutionEngine.escapeString(name);
        value = StringSubstitutionEngine.escapeString(value);
        writer.write(60);
        writer.write(PROPERTY);
        writer.write(32);
        writer.write(NAME);
        writer.write(61);
        writer.write(34);
        writer.write(name);
        writer.write(34);
        writer.write(32);
        writer.write(QUERY_NAME);
        writer.write(61);
        writer.write(34);
        writer.write(queryName);
        writer.write(34);
        if (serializeAsAttribute) {
            writer.write(32);
            writer.write(VALUE);
            writer.write(61);
            writer.write(34);
            writer.write(value);
            writer.write(34);
            writer.write(62);
        } else {
            writer.write(62);
            writer.write(value);
        }
        XQENodeSerializer.closeTag(writer, PROPERTY);
    }

    private static void writeDetailProviderQuery(MasterDetailProvider masterDetailProvider, RSAPIDataset masterRSAPIDataset, Writer aWriter) throws IOException {
        Collection<RSAPIDataset> detailDatasets = masterDetailProvider.getRSAPIDatasetSiblings(masterRSAPIDataset);
        for (RSAPIDataset detailDataSet : detailDatasets) {
            aWriter.write("<detailProviderQuery id=\"");
            aWriter.write(detailDataSet.getUniqueID());
            aWriter.write(GENERAL_CLOSE_TAG2);
        }
    }

    public static void generateMissingMemberExecuteResponse(Writer writer, Element missingMembersElement) throws IOException {
        missingMembersElement.write(writer);
        XMLWriter xmlWriter = new XMLWriter();
        xmlWriter.addStream(writer);
        xmlWriter.setSkipLineFeed(true);
    }

    private static void appendPlanIDs(IXQEQueryNode[] datasets, Writer aWriter) throws IOException {
        IXQEQueryNode planTree = datasets.length == 0 ? null : datasets[0].getParent();
        XQENodeSerializer.appendPlanIDsFromTree(planTree, aWriter);
    }

    private static void appendPlanIDsFromTree(IXQEQueryNode planTree, Writer aWriter) throws IOException {
        MasterDetailProvider masterDetailProvider;
        int numDatasets;
        XQENodeSerializer.openTag(aWriter, "querySet", Collections.EMPTY_MAP);
        XQENodeSerializer.openTag(aWriter, QUERIES, Collections.EMPTY_MAP);
        PlannedV5QuerySet querySet = (PlannedV5QuerySet)planTree;
        if (null == planTree) {
            numDatasets = 0;
            masterDetailProvider = null;
        } else {
            numDatasets = planTree.getNumberChildren();
            masterDetailProvider = querySet.getMasterDetailProvider();
        }
        for (int i = 0; i < numDatasets; ++i) {
            RSAPIDataset dataset = (RSAPIDataset)planTree.getChild(i);
            boolean isDetail = masterDetailProvider.isDetailRSAPIDataset(dataset);
            if (isDetail) continue;
            aWriter.write("<providerQuery name=\"");
            aWriter.write(StringSubstitutionEngine.escapeString(dataset.getName()));
            aWriter.write("\" id=\"");
            aWriter.write(dataset.getUniqueID());
            aWriter.write(GENERAL_CLOSE_TAG1);
            XQENodeSerializer.writeDetailProviderQuery(masterDetailProvider, dataset, aWriter);
            aWriter.write("</providerQuery>");
        }
        XQENodeSerializer.closeTag(aWriter, QUERIES);
        XQENodeSerializer.closeTag(aWriter, "querySet");
    }

    static enum AppendPlanIDs {
        APPEND,
        DO_NOT_APPEND;

    }
}

