/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cclcfgapi.base64;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAF;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.CAMSettings;
import com.cognos.developer.schemas.bibus._3.ContentManagerCacheService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerCacheService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.CookieVar;
import com.cognos.developer.schemas.bibus._3.DispatcherTransportVar;
import com.cognos.developer.schemas.bibus._3.EnvironmentVar;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.FormatEnum;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.SetCookieVar;
import com.cognos.developer.schemas.bibus._3.UserCapabilityCache;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.ObjectPool;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;

public abstract class BaseCMCommand {
    private static final String ELEMENT_VALUE = "value";
    private static final String ELEMENT_NAME = "name";
    private static final String UTF8 = "UTF8";
    private static final String PART_NAME = "biBusHeader";
    private static final String NAMESPACE = "http://developer.cognos.com/schemas/bibus/3/";
    private static volatile URL gDispatcherURL = null;
    private static ContentManagerService_ServiceLocator gCMServiceLocator = new ContentManagerService_ServiceLocator();
    private static ObjectPool<ContentManagerService_PortType> cmServicePool;
    private static ContentManagerCacheService_ServiceLocator gCMCacheServiceLocator;

    public BaseCMCommand() {
        if (cmServicePool == null) {
            cmServicePool = new ObjectPool(20);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static URL getDispatcherURL() throws MalformedURLException, CCLConfigurationException {
        if (gDispatcherURL == null) {
            ContentManagerService_ServiceLocator contentManagerService_ServiceLocator = gCMServiceLocator;
            synchronized (contentManagerService_ServiceLocator) {
                if (gDispatcherURL != null) {
                    return gDispatcherURL;
                }
                ICCLConfiguration config = CCLConfigurationFactory.getInstance();
                config.init();
                String value = config.getValue("internalDispatcher", false);
                gDispatcherURL = new URL(value);
            }
        }
        return gDispatcherURL;
    }

    public static ContentManagerService_PortType getContentManagerServicePort(BiBusHeader header) throws MalformedURLException, ServiceException, CCLConfigurationException {
        ContentManagerService_PortType port = cmServicePool.borrow();
        if (port == null) {
            port = gCMServiceLocator.getcontentManagerService(BaseCMCommand.getDispatcherURL());
        }
        ((Stub)port).setHeader(NAMESPACE, PART_NAME, (Object)header);
        ((Stub)port)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
        return port;
    }

    protected static void returnContentManagerServicePort(ContentManagerService_PortType port) {
        cmServicePool.returnTo(port);
    }

    public static ContentManagerCacheService_PortType getContentManagerCacheServicePort(BiBusHeader header) throws MalformedURLException, ServiceException, CCLConfigurationException {
        ContentManagerCacheService_PortType port = gCMCacheServiceLocator.getcontentManagerCacheService(BaseCMCommand.getDispatcherURL());
        ((Stub)port).setHeader(NAMESPACE, PART_NAME, (Object)header);
        ((Stub)port)._setProperty("sendMultiRefs", (Object)Boolean.FALSE);
        return port;
    }

    public static BiBusHeader buildBiBusHeaderFrom(BIBusEnvelope clientEnvelope) {
        BiBusHeader header = new BiBusHeader();
        try {
            BaseCMCommand.copyCAMToService(clientEnvelope, header);
            BaseCMCommand.copyCAFToService(clientEnvelope, header);
            BaseCMCommand.copyCookiesToService(clientEnvelope, header);
            BaseCMCommand.copySetCookiesToService(clientEnvelope, header);
            BaseCMCommand.copyPrefsToService(clientEnvelope, header);
            BaseCMCommand.copyEnvironmentVarsToService(clientEnvelope, header);
            BaseCMCommand.copyFormFieldVarsToService(clientEnvelope, header);
            BaseCMCommand.copyUserCapabilitiesCache(clientEnvelope, header);
            BaseCMCommand.copyDispatcherTransportVarsToService(clientEnvelope, header);
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        return header;
    }

    private static void copyCAFToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        CAF caf = bibus.getCAF();
        if (caf == null) {
            caf = new CAF();
            bibus.setCAF(caf);
        }
        String secureState = clientEnvelope.getCAFSecureState();
        caf.setSecureState(secureState);
    }

    private static void copyCAMToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) throws UnsupportedEncodingException {
        Element settings;
        Element userSessionID;
        Element camCredentialPath;
        Element securityBlob;
        CAMPassport cPassport;
        CAM cSecurity = bibus.getCAM();
        if (cSecurity == null) {
            cSecurity = new CAM();
            bibus.setCAM(cSecurity);
        }
        if (null == (cPassport = cSecurity.getCAMPassport())) {
            cPassport = new CAMPassport();
        }
        cPassport.setId(clientEnvelope.getPassportID());
        Element canCallLogon = null;
        Element generation = null;
        Element ipfLogEnabled = null;
        Element isAnnoymous = null;
        Element cam = clientEnvelope.getCAM();
        Element camPassport = cam.element("CAMPassport");
        if (camPassport != null) {
            canCallLogon = camPassport.element("canCallLogon");
            generation = camPassport.element("generation");
            ipfLogEnabled = camPassport.element("ipfLogEnabled");
            isAnnoymous = camPassport.element("isAnonymous");
        }
        if (canCallLogon != null) {
            boolean canCall = Boolean.parseBoolean(canCallLogon.getText());
            cPassport.setCanCallLogon(canCall);
        }
        if (generation != null) {
            try {
                cPassport.setGeneration(Integer.parseInt(generation.getText()));
            }
            catch (NumberFormatException canCall) {
                // empty catch block
            }
        }
        if (ipfLogEnabled != null) {
            cPassport.setLogEnabled(Boolean.parseBoolean(ipfLogEnabled.getText()));
        }
        if (isAnnoymous != null) {
            cPassport.setIsAnonymous(Boolean.parseBoolean(isAnnoymous.getText()));
        }
        cSecurity.setCAMPassport(cPassport);
        if (cSecurity.getException() != null) {
            cSecurity.setException(null);
        }
        cSecurity.setAction(clientEnvelope.getCAMAction());
        Element authencityToken = cam.element("authenticityToken");
        if (BaseCMCommand.hasTextChild((Node)authencityToken)) {
            cSecurity.setAuthenticityToken(authencityToken.getText().getBytes(UTF8));
        }
        if (BaseCMCommand.hasTextChild((Node)(securityBlob = cam.element("securityBlob")))) {
            cSecurity.setSecurityBlob(securityBlob.getText().getBytes(UTF8));
        }
        if (BaseCMCommand.hasTextChild((Node)(camCredentialPath = cam.element("CAMCredentialPath")))) {
            cSecurity.setCAMCredentialPath(camCredentialPath.getText());
        }
        if (BaseCMCommand.hasTextChild((Node)(userSessionID = cam.element("userSessionID")))) {
            cSecurity.setUserSessionID(userSessionID.getText().getBytes(UTF8));
        }
        if ((settings = cam.element("settings")) != null) {
            Element annoymousAllowed = settings.element("anonymousAllowed");
            Element namespacesConfigured = settings.element("namespacesConfigured");
            CAMSettings camSettings = new CAMSettings();
            if (annoymousAllowed != null) {
                camSettings.setAnonymousAllowed(Boolean.parseBoolean(annoymousAllowed.getText()));
            }
            if (namespacesConfigured != null) {
                camSettings.setNamespacesConfigured(Boolean.parseBoolean(namespacesConfigured.getText()));
            }
            cSecurity.setSettings(camSettings);
        }
    }

    private static void copyCookiesToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmCookieVars = clientEnvelope.getCookieVars();
        if (elmCookieVars == null) {
            return;
        }
        List listCookieVars = elmCookieVars.elements();
        if (listCookieVars == null || listCookieVars.isEmpty()) {
            return;
        }
        CookieVar[] cVars = new CookieVar[listCookieVars.size()];
        for (int idx = 0; idx < listCookieVars.size(); ++idx) {
            Element eCookieNode = (Element)listCookieVars.get(idx);
            CookieVar cCookie = new CookieVar();
            Element eCookieName = eCookieNode.element(ELEMENT_NAME);
            Element eCookieValue = eCookieNode.element(ELEMENT_VALUE);
            if (BaseCMCommand.hasTextChild((Node)eCookieName)) {
                cCookie.setName(eCookieName.getTextTrim());
            }
            if (BaseCMCommand.hasTextChild((Node)eCookieValue)) {
                cCookie.setValue(eCookieValue.getTextTrim());
            }
            cVars[idx] = cCookie;
        }
        if (bibus.getHdrSession() == null) {
            bibus.setHdrSession(new HdrSession());
        }
        bibus.getHdrSession().setCookieVars(cVars);
    }

    private static void copyDispatcherTransportVarsToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmDispVars = clientEnvelope.getDispatcherTransportVars();
        if (elmDispVars == null) {
            return;
        }
        List listDispVars = elmDispVars.elements();
        if (listDispVars == null || listDispVars.isEmpty()) {
            return;
        }
        DispatcherTransportVar[] cVars = new DispatcherTransportVar[listDispVars.size()];
        for (int idx = 0; idx < listDispVars.size(); ++idx) {
            Element eFormFieldVarNode = (Element)listDispVars.get(idx);
            DispatcherTransportVar dispVar = new DispatcherTransportVar();
            Element eFormFieldVarName = eFormFieldVarNode.element(ELEMENT_NAME);
            Element eFormFieldVarValue = eFormFieldVarNode.element(ELEMENT_VALUE);
            if (BaseCMCommand.hasTextChild((Node)eFormFieldVarName)) {
                dispVar.setName(eFormFieldVarName.getTextTrim());
            }
            if (BaseCMCommand.hasTextChild((Node)eFormFieldVarValue)) {
                dispVar.setValue(eFormFieldVarValue.getTextTrim());
            }
            cVars[idx] = dispVar;
        }
        bibus.setDispatcherTransportVars(cVars);
    }

    private static void copyEnvironmentVarsToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmEnvVars = clientEnvelope.getEnvironmentVars();
        if (elmEnvVars == null) {
            return;
        }
        List listEnvVars = elmEnvVars.elements();
        if (listEnvVars == null || listEnvVars.isEmpty()) {
            return;
        }
        EnvironmentVar[] cVars = new EnvironmentVar[listEnvVars.size()];
        for (int idx = 0; idx < listEnvVars.size(); ++idx) {
            Element eEnvVarNode = (Element)listEnvVars.get(idx);
            EnvironmentVar envVar = new EnvironmentVar();
            Element eEnvVarName = eEnvVarNode.element(ELEMENT_NAME);
            Element eEnvVarValue = eEnvVarNode.element(ELEMENT_VALUE);
            if (BaseCMCommand.hasTextChild((Node)eEnvVarName)) {
                envVar.setName(eEnvVarName.getTextTrim());
            }
            if (BaseCMCommand.hasTextChild((Node)eEnvVarValue)) {
                envVar.setValue(eEnvVarValue.getTextTrim());
            }
            cVars[idx] = envVar;
        }
        if (bibus.getHdrSession() == null) {
            bibus.setHdrSession(new HdrSession());
        }
        bibus.getHdrSession().setEnvironmentVars(cVars);
    }

    private static void copyFormFieldVarsToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmFormFieldVars = clientEnvelope.getFormFieldVars();
        if (elmFormFieldVars == null) {
            return;
        }
        List listFormFieldVars = elmFormFieldVars.elements();
        if (listFormFieldVars == null || listFormFieldVars.isEmpty()) {
            return;
        }
        FormFieldVar[] cVars = new FormFieldVar[listFormFieldVars.size()];
        for (int idx = 0; idx < listFormFieldVars.size(); ++idx) {
            Element eFormFieldVarNode = (Element)listFormFieldVars.get(idx);
            FormFieldVar formFieldVar = new FormFieldVar();
            Element eFormFieldVarName = eFormFieldVarNode.element(ELEMENT_NAME);
            Element eFormFieldVarValue = eFormFieldVarNode.element(ELEMENT_VALUE);
            if (BaseCMCommand.hasTextChild((Node)eFormFieldVarName)) {
                formFieldVar.setName(eFormFieldVarName.getTextTrim());
            }
            if (BaseCMCommand.hasTextChild((Node)eFormFieldVarValue)) {
                formFieldVar.setValue(eFormFieldVarValue.getTextTrim());
            }
            formFieldVar.setFormat(FormatEnum.not_encrypted);
            cVars[idx] = formFieldVar;
        }
        if (bibus.getHdrSession() == null) {
            bibus.setHdrSession(new HdrSession());
        }
        bibus.getHdrSession().setFormFieldVars(cVars);
    }

    private static void copyPrefsToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmUserPrefs = clientEnvelope.getUserPreferenceVars();
        if (elmUserPrefs == null) {
            return;
        }
        List listUserPrefs = elmUserPrefs.elements();
        if (listUserPrefs == null || listUserPrefs.isEmpty()) {
            return;
        }
        UserPreferenceVar[] uPrefs = new UserPreferenceVar[listUserPrefs.size()];
        for (int idx = 0; idx < listUserPrefs.size(); ++idx) {
            Element eNode = (Element)listUserPrefs.get(idx);
            UserPreferenceVar uVar = new UserPreferenceVar();
            Element eName = eNode.element(ELEMENT_NAME);
            Element eValue = eNode.element(ELEMENT_VALUE);
            if (BaseCMCommand.hasTextChild((Node)eName)) {
                uVar.setName(eName.getText());
            }
            if (BaseCMCommand.hasTextChild((Node)eValue)) {
                uVar.setValue(eValue.getText());
            }
            uPrefs[idx] = uVar;
        }
        bibus.setUserPreferenceVars(uPrefs);
    }

    private static void copySetCookiesToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmSetCookieVars = clientEnvelope.getSetCookieVars();
        if (elmSetCookieVars == null) {
            return;
        }
        List listSetCookieVars = elmSetCookieVars.elements();
        if (listSetCookieVars == null || listSetCookieVars.isEmpty()) {
            return;
        }
        SetCookieVar[] cVars = new SetCookieVar[listSetCookieVars.size()];
        for (int idx = 0; idx < listSetCookieVars.size(); ++idx) {
            Element eCookieNode = (Element)listSetCookieVars.get(idx);
            SetCookieVar cCookie = new SetCookieVar();
            Element eCookieName = eCookieNode.element(ELEMENT_NAME);
            Element eCookieValue = eCookieNode.element(ELEMENT_VALUE);
            if (BaseCMCommand.hasTextChild((Node)eCookieName)) {
                cCookie.setName(eCookieName.getTextTrim());
            }
            if (BaseCMCommand.hasTextChild((Node)eCookieValue)) {
                cCookie.setValue(eCookieValue.getTextTrim());
            }
            cVars[idx] = cCookie;
        }
        if (bibus.getHdrSession() == null) {
            bibus.setHdrSession(new HdrSession());
        }
        bibus.getHdrSession().setSetCookieVars(cVars);
    }

    private static void copyUserCapabilitiesCache(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmUserCapabilitiesCache = clientEnvelope.getUserCapabilitiesCache();
        if (elmUserCapabilitiesCache == null) {
            return;
        }
        Element elmCapabilities = elmUserCapabilitiesCache.element("userCapabilities");
        if (elmCapabilities == null) {
            return;
        }
        Element elmSignature = elmUserCapabilitiesCache.element("signature");
        if (!BaseCMCommand.hasTextChild((Node)elmSignature)) {
            return;
        }
        List listCapabilities = elmCapabilities.elements();
        if (listCapabilities == null || listCapabilities.isEmpty()) {
            return;
        }
        UserCapabilityEnum[] eCapabilities = new UserCapabilityEnum[listCapabilities.size()];
        for (int idx = 0; idx < listCapabilities.size(); ++idx) {
            Node anItem = (Node)listCapabilities.get(idx);
            if (!BaseCMCommand.hasTextChild(anItem)) continue;
            eCapabilities[idx] = UserCapabilityEnum.fromValue((String)((Element)anItem).getTextTrim());
        }
        UserCapabilityCache myCache = new UserCapabilityCache();
        myCache.setUserCapabilities(eCapabilities);
        byte[] decodedValue = base64.decode((int)0, (String)elmSignature.getText());
        myCache.setSignature(decodedValue);
        bibus.setUserCapabilityCache(myCache);
    }

    private static boolean hasTextChild(Node aNode) {
        if (aNode == null || aNode.getNodeType() != 1) {
            return false;
        }
        String txt = aNode.getText();
        return txt != null && txt.length() > 0;
    }

    protected static final BiBusHeader getBiBusHeader(Stub aStub) throws Exception {
        SOAPHeaderElement she = aStub.getResponseHeader(NAMESPACE, PART_NAME);
        if (she == null) {
            she = aStub.getHeader(NAMESPACE, PART_NAME);
        }
        return (BiBusHeader)she.getObjectValue(BiBusHeader.class);
    }

    protected static final BIBusEnvelope getBIBusEnvelope(Stub aStub) throws Exception {
        SOAPHeaderElement she = aStub.getResponseHeader(NAMESPACE, PART_NAME);
        if (she == null) {
            she = aStub.getHeader(NAMESPACE, PART_NAME);
        }
        BIBusEnvelope envelope = new BIBusEnvelope();
        envelope.setBIBusHeader(BaseCMCommand.convert(she.getAsDocument()));
        return envelope;
    }

    public static Element convert(org.w3c.dom.Document doc) throws ParserConfigurationException {
        DOMReader reader = new DOMReader();
        Document doc2 = reader.read(doc);
        return doc2.getRootElement();
    }

    static {
        gCMCacheServiceLocator = new ContentManagerCacheService_ServiceLocator();
    }
}

