/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.ICryptoHandle;
import com.cognos.xqe.data.providers.secbridge.CAMImpersonate;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.resource.AutoReleaseResource;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import java.util.Locale;

public class CAMCryptoHandle
extends AutoReleaseResource
implements ICryptoHandle {
    private final String mHandleId;

    protected CAMCryptoHandle(String handleId, Object parent) {
        super(parent);
        this.mHandleId = handleId;
    }

    @Override
    public String getHandleId() {
        return this.mHandleId;
    }

    @Override
    public void releaseImpl() {
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        Locale errMsgLocale = Locale.US;
        if (null != env) {
            errMsgLocale = ((RequestEnvironment)env.getRequestEnvironment()).getProductLocale();
        }
        try {
            if (this.mHandleId != null) {
                CMEntityPool.instance().removeCryptoHandle(this.mHandleId);
                CAMImpersonate.releaseHandle(errMsgLocale, this.mHandleId);
            }
        }
        catch (NativeException ex) {
            throw new XQERuntimeException(XQEMessageKeys.WSB_CAM_COULD_NOT_RELEASE);
        }
    }
}

