/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content.CMCacheService;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.ContentManagerCacheService_PortType;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.QueryCacheResult;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnumArrayProp;
import com.cognos.developer.schemas.bibus._3._package;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.Timer;
import com.cognos.xqebifw.bibushandler.content.BaseCMCommand;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import com.cognos.xqebifw.bibushandler.content.CMPackage;
import com.cognos.xqebifw.bibushandler.content.CMQuery;
import com.cognos.xqebifw.bibushandler.content.CMUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Stub;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.message.SOAPHeaderElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CMPackageViaCMCService
extends CMPackage {
    private static final ClassEnum PACKAGE_CLASSENUM = ClassEnum.fromString((String)"package");

    public static CMPackage create(String thePackageName, IRequestEnvironment env) {
        CMPackageViaCMCService cmP = null;
        cmP = new CMPackageViaCMCService(thePackageName, env);
        if (!CMEntityPool.tryUsingCMCacheService()) {
            return null;
        }
        return cmP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMPackageViaCMCService(String thePackageName, IRequestEnvironment env) {
        super(thePackageName);
        if (!this.initialized) {
            Timer timer = CMQuery.getAndStartTimerForUsageStats();
            try {
                this.queryForCMInfo(env);
            }
            finally {
                CMQuery.updateCMUsageStats(timer);
            }
        }
    }

    private void queryForCMInfo(IRequestEnvironment env) {
        BiBusHeader bibusHeader = CMUtils.buildBiBusHeader(env);
        ContentManagerCacheService_PortType port = null;
        try {
            BaseClass[] resultObjects;
            port = BaseCMCommand.getContentManagerCacheServicePort(bibusHeader);
            SearchPathSingleObject searchPathSingleObject = new SearchPathSingleObject();
            searchPathSingleObject.set_value(this.packageName);
            ClassEnum searchType = PACKAGE_CLASSENUM;
            ClassEnum[] entries = new ClassEnum[]{PACKAGE_CLASSENUM};
            ArrayList<Option> optionList = new ArrayList<Option>();
            CMUtils.setOptionsForQueryCache(optionList, env);
            Option[] options = new Option[]{};
            if (optionList.size() > 0) {
                options = optionList.toArray(new Option[optionList.size()]);
            }
            QueryCacheResult qcResult = port.queryCache(searchPathSingleObject, searchType, entries, options);
            CMEntityPool.setIsCMCacheServiceEnabled(true);
            CMUtils.updateCMCacheContext(qcResult.getOptions(), env);
            for (BaseClass object : resultObjects = qcResult.getObjects()) {
                UserCapabilityEnum[] userCapEnums;
                if (!(object instanceof _package)) continue;
                _package thePackage = (_package)object;
                SOAPHeaderElement[] responseHeaders = ((Stub)port).getResponseHeaders();
                SOAPEnvelope soapEnvelope = responseHeaders[0].getEnvelope();
                NodeList userCapsList = soapEnvelope.getElementsByTagName("userCapabilities");
                Node userCapabilities = userCapsList.item(0);
                NodeList childList = userCapabilities.getChildNodes();
                for (int iItem = 0; iItem < childList.getLength(); ++iItem) {
                    String capability;
                    Node anItem = childList.item(iItem);
                    if (!(anItem instanceof MessageElement) || !this.supportedCapabilities.contains(capability = ((MessageElement)anItem).getValue())) continue;
                    this.globalCapabilities.add(capability);
                }
                UserCapabilityEnumArrayProp effectiveUserCaps = thePackage.getEffectiveUserCapabilities();
                if (effectiveUserCaps == null || effectiveUserCaps.getValue() == null) continue;
                for (UserCapabilityEnum capEnum : userCapEnums = effectiveUserCaps.getValue()) {
                    String capability = capEnum.getValue();
                    if (!this.globalCapabilities.contains(capability)) continue;
                    this.packageCapabilities.add(capability);
                }
            }
        }
        catch (RemoteException e) {
            boolean bIsCMCacheDisabled = false;
            if (e instanceof AxisFault) {
                bIsCMCacheDisabled = CMUtils.parseFaultForDisabledCMCache((AxisFault)e);
            }
            if (!bIsCMCacheDisabled) {
                throw new XQERuntimeException(e);
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }
}

