/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.DataSourceConnection;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.bibushandler.Commands;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.ICMConnection;
import com.cognos.xqe.bibushandler.content.ICMObject;
import com.cognos.xqe.bibushandler.content.ICMSignon;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnectionCommandBlock;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSourceConnectionCommandBlock;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQESOAPFaultException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.MapCast;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import com.cognos.xqebifw.bibushandler.content.CMObject;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.map.Flat3Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CMConnection
extends CMObject
implements ICMConnection {
    public static final String CMD_BLOCK_CACHE = "CommandBlockCache";
    private static final XQELogger TRACE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CommandBlockCache", LogLevel.INFO);
    private static final String ELEM_SQL = "sql";
    private static final String ELEM_ARGUMENTS = "arguments";
    private static final String ELEM_COMMANDS = "commands";
    private static final String ELEM_VALUE = "value";
    private static final String ELEM_NAME = "name";
    private static final String CONNECTION_STRING_PROPERTY = "connectionString";
    private static final String DISABLED_STRING_PROPERTY = "disabled";
    private static final String CMD_SESSION_START = "sessionStartCommand";
    private static final String CMD_SESSION_END = "sessionEndCommand";
    private static final String CMD_SQL = "sqlCommand";
    private static final String POUND_SIGN = "#";
    private final String namespace;
    private final Map<String, ICMSignon> signons = MapCast.uncheckedCast(new Flat3Map());
    private CommandBlockCache originalCommandBlockCache = null;
    private final MultiRequestReference<CommandBlockCache> commandBlockCacheRef = new MultiRequestReference();
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private volatile String userGroups = null;

    public CMConnection(Element itemElement) {
        super(itemElement);
        List<ICMObject> arrayProperties = this.getArrayProperty(PropEnum.credentialNamespaces.getValue());
        if (arrayProperties != null && !arrayProperties.isEmpty()) {
            ICMObject obj = arrayProperties.get(0);
            this.namespace = obj.getStringProperty(PropEnum.searchPath.getValue());
        } else {
            this.namespace = null;
        }
    }

    public CMConnection(DataSourceConnection dsConnection) {
        super((BaseClass)dsConnection);
        this.extractConnectionProperties(dsConnection);
        Object obj = this.getProperty(PropEnum.credentialNamespaces.getValue());
        if (obj != null) {
            BaseClass[] props = (BaseClass[])obj;
            String searchPath = null;
            for (BaseClass prop : props) {
                if (prop == null || prop.getSearchPath().getValue() == null) continue;
                searchPath = prop.getSearchPath().getValue();
                break;
            }
            this.namespace = searchPath;
        } else {
            this.namespace = null;
        }
    }

    @Override
    public void addSignon(ICMSignon theSignon) {
        if (theSignon != null) {
            this.signons.put(theSignon.getDefaultName(), theSignon);
        }
    }

    @Override
    public String getConnectionString() {
        String connStr = this.getStringProperty(CONNECTION_STRING_PROPERTY);
        connStr = this.resolveMacro(connStr);
        return connStr;
    }

    @Override
    public boolean isDisabled() {
        return this.getBooleanProperty(DISABLED_STRING_PROPERTY, false);
    }

    @Override
    public Collection<ICMSignon> getSignons() {
        return this.signons.values();
    }

    @Override
    public ICMSignon getSignon(String name) {
        return this.signons.get(name);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getUserGroups() {
        return this.userGroups;
    }

    @Override
    public void setUserGroups(String sUserGroups) {
        this.userGroups = sUserGroups;
    }

    private CommandBlockCache getOrCreateCommandBlockCache(RequestEnvironment reqEnv) {
        CommandBlockCache cache;
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
            TRACE_LOGGER.log(LogLevel.INFO, "Calling getOrCreateCommandBlockCache");
        }
        if (null == (cache = this.commandBlockCacheRef.get(execEnv))) {
            if (this.originalCommandBlockCache != null && !this.originalCommandBlockCache.hasMacros()) {
                if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                    TRACE_LOGGER.log(LogLevel.INFO, "Not found. Using original command block cache (i.e. no macros)");
                }
                cache = this.originalCommandBlockCache;
            } else {
                Element commandElement = null;
                Document reqDoc = execEnv.getMultiRequestContext().getRequestDocument();
                if (reqDoc != null) {
                    commandElement = reqDoc.getRootElement();
                }
                reqEnv.initializeRequestPAC(commandElement);
                if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                    TRACE_LOGGER.log(LogLevel.INFO, "Not found. Creating new command block cache (has macros)");
                }
                cache = new CommandBlockCache(this);
                if (this.originalCommandBlockCache == null) {
                    this.originalCommandBlockCache = cache;
                }
            }
            if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                TRACE_LOGGER.log(LogLevel.INFO, "CommandBlockCache content: " + cache.toString());
            }
            this.commandBlockCacheRef.set(execEnv, cache);
        } else if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
            TRACE_LOGGER.log(LogLevel.INFO, "Found command block cache");
        }
        return cache;
    }

    @Override
    public List<IDataSourceConnectionCommandBlock> getCommandBlocks(RequestEnvironment reqEnv, Locale locale, Commands key) {
        return this.getOrCreateCommandBlockCache(reqEnv).getCommandBlocks(locale, key);
    }

    @Override
    public String toString() {
        return super.toString() + ":Signons=" + this.signons;
    }

    private void extractConnectionProperties(DataSourceConnection dsConnection) {
        if (dsConnection.getOpenConnectionCommands().getValue() != null) {
            this.addProperty(PropEnum.openConnectionCommands.toString(), dsConnection.getOpenConnectionCommands().getValue().toString());
        }
        if (dsConnection.getOpenSessionCommands().getValue() != null) {
            this.addProperty(PropEnum.openSessionCommands.toString(), dsConnection.getOpenSessionCommands().getValue().toString());
        }
        if (dsConnection.getCloseSessionCommands().getValue() != null) {
            this.addProperty(PropEnum.closeSessionCommands.toString(), dsConnection.getCloseSessionCommands().getValue().toString());
        }
        if (dsConnection.getCloseConnectionCommands().getValue() != null) {
            this.addProperty(PropEnum.closeConnectionCommands.toString(), dsConnection.getCloseConnectionCommands().getValue().toString());
        }
        if (dsConnection.getIsolationLevel().getValue() != null) {
            this.addProperty(PropEnum.isolationLevel.toString(), dsConnection.getIsolationLevel().getValue());
        }
        if (dsConnection.getConnectionString().getValue() != null) {
            this.addProperty(PropEnum.connectionString.toString(), dsConnection.getConnectionString().getValue());
        }
        if (dsConnection.getCredentialNamespaces().getValue() != null) {
            this.addProperty(PropEnum.credentialNamespaces.toString(), dsConnection.getCredentialNamespaces().getValue());
        }
        if (dsConnection.getApiToken() != null && dsConnection.getApiToken().getValue() != null) {
            this.addProperty(PropEnum.apiToken.toString(), dsConnection.getApiToken().getValue());
        }
    }

    private String resolveMacro(String input) {
        String result = input;
        if (result != null && result.indexOf(POUND_SIGN) >= 0) {
            ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(env.getRequestEnvironment());
            MacroExpander expander = new MacroExpander();
            result = expander.expand(null, planEnv, result);
        }
        return result;
    }

    private final class CommandBlockCache {
        private boolean hasMacros = false;
        private final Map<Locale, EnumMap<Commands, List<IDataSourceConnectionCommandBlock>>> mapCmdBlockCache = new HashMap<Locale, EnumMap<Commands, List<IDataSourceConnectionCommandBlock>>>();
        private final CMObject cmobject;

        CommandBlockCache(CMObject cmObj) {
            this.cmobject = cmObj;
            this.populateCommandBlockCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<IDataSourceConnectionCommandBlock> getCommandBlocks(Locale runLocale, Commands command) {
            EnumMap<Commands, List<IDataSourceConnectionCommandBlock>> commandBlocks = null;
            CMConnection.this.rwLock.readLock().lock();
            try {
                commandBlocks = this.mapCmdBlockCache.get(runLocale);
            }
            finally {
                CMConnection.this.rwLock.readLock().unlock();
            }
            if (commandBlocks != null) {
                if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                    TRACE_LOGGER.log(LogLevel.INFO, "(readlock) Command block found for locale: " + runLocale.toString());
                }
                return commandBlocks.get((Object)command);
            }
            if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                TRACE_LOGGER.log(LogLevel.INFO, "(readlock) Command block NOT found for locale: " + runLocale.toString());
            }
            CMConnection.this.rwLock.writeLock().lock();
            try {
                String localeStr = runLocale.toString();
                if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                    TRACE_LOGGER.log(LogLevel.INFO, "(writelock) Getting cached command block for locale: " + localeStr);
                }
                if ((commandBlocks = this.mapCmdBlockCache.get(runLocale)) != null) {
                    TRACE_LOGGER.log(LogLevel.INFO, "(writelock) Command block found for locale: " + localeStr);
                    List<IDataSourceConnectionCommandBlock> list = commandBlocks.get((Object)command);
                    return list;
                }
                if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                    TRACE_LOGGER.log(LogLevel.INFO, "(writelock) Command block NOT found for locale: " + localeStr);
                }
                commandBlocks = this.getCommandBlocksForNewLocale();
                List<IDataSourceConnectionCommandBlock> list = commandBlocks.get((Object)command);
                return list;
            }
            finally {
                CMConnection.this.rwLock.writeLock().unlock();
            }
        }

        public boolean hasMacros() {
            return this.hasMacros;
        }

        private void populateCommandBlockCache() {
            ExecutionEnvironment env;
            if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                TRACE_LOGGER.log(LogLevel.INFO, "Calling populateCommandBlockCache");
            }
            if ((env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment()) == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
            }
            EnumMap<Commands, List<IDataSourceConnectionCommandBlock>> commands = this.parseCommandBlocks(env, this.cmobject);
            if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                TRACE_LOGGER.log(LogLevel.INFO, "Adding command blocks to cache for locale: " + ((RequestEnvironment)env.getRequestEnvironment()).getRunLocale());
            }
            this.mapCmdBlockCache.put(((RequestEnvironment)env.getRequestEnvironment()).getRunLocale(), commands);
        }

        private EnumMap<Commands, List<IDataSourceConnectionCommandBlock>> parseCommandBlocks(ExecutionEnvironment env, CMObject obj) {
            PlanningEnvironment planEnv;
            if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                TRACE_LOGGER.log(LogLevel.INFO, "Calling parseCommandBlocks");
            }
            if ((planEnv = QueryPlanner.setupEnvironment(env.getRequestEnvironment())).getMetadataConnection() == null) {
                planEnv.setMetdataConnection(env.getMetadataConnection());
            }
            EnumMap<Commands, List<IDataSourceConnectionCommandBlock>> commands = new EnumMap<Commands, List<IDataSourceConnectionCommandBlock>>(Commands.class);
            for (Commands command : Commands.values()) {
                String commandBlockString = obj.getStringProperty(command.getName());
                if (commandBlockString == null || commandBlockString.length() <= 0) continue;
                commandBlockString = commandBlockString.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
                List<IDataSourceConnectionCommandBlock> commandBlocks = this.parseCommandBlock(planEnv, commandBlockString);
                commands.put(command, commandBlocks);
            }
            return commands;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<IDataSourceConnectionCommandBlock> parseCommandBlock(PlanningEnvironment planEnv, String input) {
            ArrayList<IDataSourceConnectionCommandBlock> commandBlocks = new ArrayList<IDataSourceConnectionCommandBlock>();
            XQESAXReaderPool pool = XQESAXReaderPool.getInstance();
            try {
                SAXReader reader = pool.borrowReader();
                try {
                    Document doc = reader.read((Reader)new StringReader(input));
                    List commandElements = doc.getRootElement().element(CMConnection.ELEM_COMMANDS).elements();
                    for (Element commandElement : commandElements) {
                        DataSourceConnectionCommandBlock commandBlock = null;
                        String comandName = commandElement.getName();
                        if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                            TRACE_LOGGER.log(LogLevel.INFO, "Parsing command block name: " + comandName);
                        }
                        HashMap<String, Object> commandProps = new HashMap<String, Object>();
                        if (comandName.equals(CMConnection.CMD_SESSION_START) || comandName.equals(CMConnection.CMD_SESSION_END)) {
                            commandBlock = comandName.equals(CMConnection.CMD_SESSION_START) ? new DataSourceConnectionCommandBlock(IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_START_COMMAND, commandProps) : new DataSourceConnectionCommandBlock(IDataSourceConnectionCommandBlock.CommandBlockType.SESSION_END_COMMAND, commandProps);
                            Element argumentsElement = commandElement.element(CMConnection.ELEM_ARGUMENTS);
                            if (argumentsElement != null) {
                                List arguments = argumentsElement.elements();
                                for (int j = 0; j < arguments.size(); ++j) {
                                    Element argument = (Element)arguments.get(j);
                                    Element nameElement = argument.element(CMConnection.ELEM_NAME);
                                    if (nameElement == null) continue;
                                    String nameStr = nameElement.getText();
                                    String valueStr = null;
                                    Element valueElement = argument.element(CMConnection.ELEM_VALUE);
                                    if (valueElement == null) {
                                        throw new XQERuntimeException(XQEMessageKeys.XML_MissingXMLElement, CMConnection.ELEM_VALUE);
                                    }
                                    valueStr = valueElement.getText();
                                    valueStr = this.resolveMacro(planEnv, valueStr);
                                    Parameters parameters = ((RequestEnvironment)planEnv.getRequestEnvironment()).getRequestParameters();
                                    Parameters unresolvedParams = parameters.getUnresolvedParameters();
                                    Parameters parameterWithDefaultValue = new Parameters();
                                    for (Parameter p : unresolvedParams.values()) {
                                        if (!p.getCapabilities().isOptional() || p.isExplicitValueRequired()) continue;
                                        parameterWithDefaultValue.put(p.getName(), p);
                                    }
                                    for (Parameter p : parameterWithDefaultValue.values()) {
                                        unresolvedParams.removeParameter(p.getName());
                                        parameters.removeParameter(p.getName());
                                    }
                                    if ("OCI_ATTR_USERNAME".equals(nameStr)) {
                                        commandProps.put("userName", valueStr);
                                        continue;
                                    }
                                    if (!"OCI_ATTR_PASSWORD".equals(nameStr)) continue;
                                    commandProps.put("password", valueStr);
                                }
                            }
                        } else if (comandName.equals(CMConnection.CMD_SQL)) {
                            commandBlock = new DataSourceConnectionCommandBlock(IDataSourceConnectionCommandBlock.CommandBlockType.SQL_COMMAND, commandProps);
                            Element sqlElement = commandElement.element(CMConnection.ELEM_SQL);
                            if (sqlElement != null) {
                                String sqlStr = sqlElement.getText();
                                if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                                    TRACE_LOGGER.log(LogLevel.INFO, "sqlCommand (before macro resolve): " + sqlStr);
                                }
                                sqlStr = this.resolveMacro(planEnv, sqlStr);
                                Parameters parameters = ((RequestEnvironment)planEnv.getRequestEnvironment()).getRequestParameters();
                                Parameters unresolvedParams = parameters.getUnresolvedParameters();
                                Parameters parameterWithDefaultValue = new Parameters();
                                for (Parameter p : unresolvedParams.values()) {
                                    if (!p.getCapabilities().isOptional() || p.isExplicitValueRequired()) continue;
                                    parameterWithDefaultValue.put(p.getName(), p);
                                }
                                for (Parameter p : parameterWithDefaultValue.values()) {
                                    unresolvedParams.removeParameter(p.getName());
                                    parameters.removeParameter(p.getName());
                                }
                                if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                                    TRACE_LOGGER.log(LogLevel.INFO, "sqlCommand (after macro resolve): " + sqlStr);
                                }
                                commandProps.put(CMConnection.ELEM_SQL, sqlStr);
                            } else {
                                throw new XQERuntimeException(XQEMessageKeys.XML_MissingXMLElement, CMConnection.ELEM_SQL);
                            }
                        }
                        if (commandBlock == null) continue;
                        commandBlocks.add(commandBlock);
                    }
                }
                finally {
                    pool.returnReader(reader);
                }
            }
            catch (Exception e) {
                throw new XQERuntimeException(XQEMessageKeys.CM_UnableToParseCommandBlock, (Throwable)e, input);
            }
            return commandBlocks;
        }

        private EnumMap<Commands, List<IDataSourceConnectionCommandBlock>> getCommandBlocksForNewLocale() {
            ExecutionEnvironment execEnv;
            if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                TRACE_LOGGER.log(LogLevel.INFO, "Calling getCommandBlocksForNewLocale");
            }
            if ((execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment()) == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
            }
            final RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
            final AtomicReference commands = new AtomicReference();
            reqEnv.getCMRequestExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    reqEnv.resetEnvelopeFromExecutor();
                    ContentManagerQueryCommand query = CMEntityPool.instance().createCMQuery();
                    query.setQueryObject(CMConnection.this.getSearchPath());
                    Locale runLocale = reqEnv.getRunLocale();
                    if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                        TRACE_LOGGER.log(LogLevel.INFO, "Executing CM query to get command blocks for locale: " + runLocale.toString());
                    }
                    query.setBIBusHeader((Element)((Element)reqEnv.getBibusHeader().clone()).detach());
                    for (Commands cmd : Commands.values()) {
                        query.addQueryPropertyName(cmd.getName());
                    }
                    List resultList = null;
                    try {
                        query.execute();
                        resultList = CollectionCast.uncheckedCast(query.getResultList());
                    }
                    catch (SoapFaultException sfe) {
                        BIBusEnvelope faultEnvelope = query.getResponseEnvelope();
                        throw new XQESOAPFaultException(faultEnvelope, (Throwable)sfe);
                    }
                    catch (CommandExecutionException e) {
                        throw new XQERuntimeException(XQEMessageKeys.CM_UnableToRetrieveCommandBlocks, (Throwable)e, (Object)runLocale, (Object)CMConnection.this.getDefaultName());
                    }
                    if (resultList == null || resultList.size() != 1) {
                        throw new XQERuntimeException(XQEMessageKeys.CM_UnableToRetrieveCommandBlocks, LocaleConverter.toString(runLocale), CMConnection.this.getDefaultName());
                    }
                    CMObject obj = new CMObject(((CMClass)resultList.get(0)).getItemElement());
                    commands.set(CommandBlockCache.this.parseCommandBlocks(execEnv, obj));
                    if (TRACE_LOGGER.isOnIgnoreSLF4JLogger(LogLevel.INFO)) {
                        TRACE_LOGGER.log(LogLevel.INFO, "Adding command blocks to the cache for locale: " + runLocale.toString());
                    }
                    CommandBlockCache.this.mapCmdBlockCache.put(runLocale, commands.get());
                }
            });
            return (EnumMap)commands.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String resolveMacro(PlanningEnvironment planEnv, String input) {
            RequestEnvironment reqEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
            String result = input;
            if (result.indexOf(CMConnection.POUND_SIGN) >= 0) {
                try {
                    reqEnv.setMacroInCommandBlocks(true);
                    MacroExpander expander = new MacroExpander();
                    result = expander.expand(null, planEnv, result);
                    if (!result.equals(input)) {
                        this.hasMacros = true;
                    }
                }
                finally {
                    reqEnv.setMacroInCommandBlocks(false);
                }
            }
            return result;
        }
    }
}

