/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content;

import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.util.xml.XMLUtils;
import com.cognos.xqebifw.bibushandler.content.CMDataSource;
import com.cognos.xqebifw.bibushandler.content.CMModel;
import com.cognos.xqebifw.bibushandler.content.CMPackage;
import com.cognos.xqebifw.bibushandler.content.CMSession;
import com.cognos.xqebifw.bibushandler.content.CMUser;
import com.cognos.xqebifw.bibushandler.content.Dispatcher.CMSessionViaDispatcher;
import com.cognos.xqebifw.bibushandler.content.SessionCommand;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CMEntity {
    private static final String SEARCHPATH_PREFIX = "/content/package[@name=";
    private volatile boolean valid = true;
    private final long creationTime;
    private volatile long lastAccessedAt;
    private final ConcurrentHashMap<String, CMDataSource> dsCache = new ConcurrentHashMap();
    private final Map<String, CMPackage> cmPackages = new HashMap<String, CMPackage>();
    private CMSession session;
    private final SessionCommand sessionCmd = new SessionCommand();
    private CMUser user;
    private Map<String, Set<String>> packageViews = new HashMap<String, Set<String>>();
    private final Lock dsLock = new ReentrantLock();

    public CMEntity() {
        this.lastAccessedAt = this.creationTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMDataSource getDataSource(String name, IRequestEnvironment env) {
        this.lastAccessedAt = System.currentTimeMillis();
        CMDataSource ds = null;
        ds = this.dsCache.get(this.makeKey(env, name));
        if (ds == null || ds.isConnectionFailed()) {
            this.dsLock.lock();
            try {
                ds = this.dsCache.get(this.makeKey(env, name));
                if (ds != null && !ds.isConnectionFailed()) {
                    CMDataSource cMDataSource = ds;
                    return cMDataSource;
                }
                ds = CMDataSource.create(name, this, env);
                this.dsCache.put(this.makeKey(env, name), ds);
            }
            finally {
                this.dsLock.unlock();
            }
        }
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataSourceCached(IRequestEnvironment env, String name) {
        this.dsLock.lock();
        try {
            boolean bl = this.dsCache.containsKey(this.makeKey(env, name));
            return bl;
        }
        finally {
            this.dsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMSession getSession(IRequestEnvironment env) {
        this.lastAccessedAt = System.currentTimeMillis();
        CMEntity cMEntity = this;
        synchronized (cMEntity) {
            if (this.session == null) {
                this.session = CMSession.create(env);
            }
        }
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMSession getSessionViaDispatcher(IRequestEnvironment env, boolean needToGetGlobalParamsFromCM) {
        this.lastAccessedAt = System.currentTimeMillis();
        CMEntity cMEntity = this;
        synchronized (cMEntity) {
            this.session = CMSessionViaDispatcher.create(env, needToGetGlobalParamsFromCM);
        }
        return this.session;
    }

    public SessionCommand getSessionCommand() {
        this.lastAccessedAt = System.currentTimeMillis();
        return this.sessionCmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMUser getUser(IRequestEnvironment env) {
        this.lastAccessedAt = System.currentTimeMillis();
        CMEntity cMEntity = this;
        synchronized (cMEntity) {
            if (this.user == null) {
                this.user = CMUser.create(env);
            }
        }
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMPackage getPackage(String searchPath, IRequestEnvironment env) {
        String packageName = CMEntity.getPackageName(searchPath);
        Map<String, CMPackage> map = this.cmPackages;
        synchronized (map) {
            CMPackage pkg = this.cmPackages.get(packageName);
            if (pkg == null) {
                pkg = CMPackage.create(packageName, env);
                this.cmPackages.put(packageName, pkg);
            }
            return pkg;
        }
    }

    private static String getPackageName(String searchPath) {
        String modelXml = "model.xml";
        int noOfChars = modelXml.length();
        int i = searchPath.indexOf(modelXml);
        String packageName = null;
        packageName = i != -1 && i + noOfChars == searchPath.length() ? searchPath : ((i = searchPath.lastIndexOf("/model")) == -1 ? (searchPath.startsWith(SEARCHPATH_PREFIX) ? searchPath : SEARCHPATH_PREFIX + XMLUtils.xPathLiteral(searchPath) + "]") : searchPath.substring(0, i));
        return packageName;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public long lastAccessedAt() {
        return this.lastAccessedAt;
    }

    public void invalidate() {
        this.valid = false;
    }

    public void validate() {
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setSession(CMSession mockSession) {
        this.session = mockSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackage(String searchPath, CMPackage mockPackage) {
        String packageName = CMEntity.getPackageName(searchPath);
        Map<String, CMPackage> map = this.cmPackages;
        synchronized (map) {
            this.cmPackages.put(packageName, mockPackage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPackageViews(IRequestEnvironment rEnv, String searchPath) {
        Set<String> views = null;
        Map<String, Set<String>> map = this.packageViews;
        synchronized (map) {
            String packageName = CMEntity.getPackageName(searchPath);
            views = this.packageViews.get(packageName);
            if (views == null) {
                CMModel model = new CMModel(packageName);
                views = model.getViews(rEnv);
                this.packageViews.put(packageName, views);
            }
        }
        return views;
    }

    private String makeKey(IRequestEnvironment env, String dsName) {
        if (null != env && null != env.getCAMPassport()) {
            return dsName.concat(env.getCAMPassport());
        }
        return dsName;
    }
}

