/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.ICMModelViewSearchKey;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.dom4j.Element;

public class CMModel {
    private final Map<ICMModelViewSearchKey, Set<String>> cachedModelViews = new ConcurrentHashMap<ICMModelViewSearchKey, Set<String>>();
    private static final String MODELVIEW_TYPE = "cm:modelView";
    private static final String VALUE_ELEMENT_NAME = "value";
    private static final String DEFAULTNAME_STR = "defaultName";
    private static final String DEFAULTNAME_PROPERTY = "defaultName";
    private static final String DEFAULTNAME_ELEMENT_NAME = "defaultName";
    private static final String PERMISSION_PROPERTY = "permissions";
    private static final XQELogger SECBRIDGE_EXCEPTION_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static final XQELogger SECBRIDGE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "SecBridge", LogLevel.TRACE);
    private static final String POLICIES_PROPERTY = "policies";
    protected final String modelSearchPath;
    protected final String modelViewSearchPath;
    private Map<String, List<String>> modelViewSearchPaths = new ConcurrentHashMap<String, List<String>>();

    public CMModel(String parentSearchPath) {
        this.modelSearchPath = parentSearchPath + "/model";
        this.modelViewSearchPath = this.modelSearchPath + "/modelView[permission('execute') or permission('read')]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getModelViews(ICMModelViewSearchKey key, IRequestEnvironment env) {
        Set<String> modelViews = null;
        if (key != null) {
            Map<ICMModelViewSearchKey, Set<String>> map = this.cachedModelViews;
            synchronized (map) {
                modelViews = this.cachedModelViews.get(key);
            }
            if (modelViews == null) {
                modelViews = this.queryModelViews(key.getSearchPath(), env);
                map = this.cachedModelViews;
                synchronized (map) {
                    this.cachedModelViews.put(key, modelViews);
                }
                if (SECBRIDGE_LOGGER.isOn()) {
                    SECBRIDGE_LOGGER.log("Model view cache miss for user : " + CMEntityPool.instance().get(env.getCAMPassport()).getUser(env).getName());
                }
            } else if (SECBRIDGE_LOGGER.isOn()) {
                SECBRIDGE_LOGGER.log("Model view cache hit for user : " + CMEntityPool.instance().get(env.getCAMPassport()).getUser(env).getName());
            }
        }
        return modelViews;
    }

    public Set<String> getViews(IRequestEnvironment rEnv) {
        return this.queryModelViews(this.modelViewSearchPath, rEnv);
    }

    private Set<String> queryModelViews(final String searchPath, final IRequestEnvironment env) {
        final HashSet<String> modelViewList = new HashSet<String>();
        ((RequestEnvironment)env).getCMRequestExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ((RequestEnvironment)env).resetEnvelopeFromExecutor();
                Element biBusHeader = env.getBibusHeader();
                ContentManagerQueryCommand query = CMEntityPool.instance().createCMQuery();
                query.setBIBusHeader((Element)((Element)biBusHeader.clone()).detach());
                query.setQueryObject(searchPath);
                query.addQueryPropertyName("defaultName");
                query.addQueryPropertyName(CMModel.PERMISSION_PROPERTY);
                query.addQueryPropertyName(CMModel.POLICIES_PROPERTY);
                try {
                    query.execute();
                    List resultList = query.getResultList();
                    for (CMClass cls : resultList) {
                        Element item;
                        Element name;
                        if (!cls.getCMClassName().equals(CMModel.MODELVIEW_TYPE) || (name = (item = cls.getItemElement()).element("defaultName")) == null) continue;
                        String viewName = name.element(CMModel.VALUE_ELEMENT_NAME).getText();
                        modelViewList.add(viewName);
                        CMModel.this.setModelViewSearchPaths(viewName, item);
                    }
                }
                catch (CommandExecutionException ce) {
                    SECBRIDGE_EXCEPTION_LOGGER.log("Unexpected CommandExecutionException exception occurred " + ce.toString());
                    throw new XQERuntimeException(ce);
                }
                catch (Exception e) {
                    SECBRIDGE_EXCEPTION_LOGGER.log("Unexpected exception occurred " + e.toString());
                    throw XQERuntimeException.wrap(e);
                }
            }
        });
        return modelViewList;
    }

    public void setModelViewSearchPaths(String viewName, Element item) {
        List policyElems;
        Element value;
        Element policies = item.element(POLICIES_PROPERTY);
        ArrayList<String> searchPaths = new ArrayList<String>();
        if (policies != null && (value = policies.element(VALUE_ELEMENT_NAME)) != null && (policyElems = value.elements("item")) != null) {
            for (Element policy : policyElems) {
                String camid;
                Element value2;
                Element searchPath;
                Element securityObject = policy.element("securityObject");
                if (securityObject == null || (searchPath = securityObject.element("searchPath")) == null || (value2 = searchPath.element(VALUE_ELEMENT_NAME)) == null || (camid = value2.getText()) == null) continue;
                searchPaths.add(camid);
            }
        }
        this.modelViewSearchPaths.put(viewName, searchPaths);
    }

    public List<String> getViewSearchPaths(String modelView) {
        return this.modelViewSearchPaths.get(modelView);
    }
}

