/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.http.ConnectionPool;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.Timer;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import java.io.IOException;
import java.net.URL;

public class CMQuery
extends ContentManagerQueryCommand {
    private static final String NAME_ATTRIBUTE = "[@name=";
    private static String dispatcherUrl;
    private static ConnectionPool dispatcherConnectionPool;
    private static IUsageIndicator queryCountIndicator;
    private static IUsageIndicator queryTimeIndicator;
    private static boolean initialized;
    public static final int MAX_DISPATCHER_CONNECTIONS = 20;
    private static final XQELogger REQ_LOGGER;
    private static final XQELogger RES_LOGGER;
    private static final XQELogger PERF_LOGGER;

    public CMQuery(String objectName) {
        super(objectName);
    }

    public static synchronized void initialize() {
        try {
            if (initialized) {
                return;
            }
            ICCLConfiguration config = CCLConfigurationFactory.getInstance();
            config.init();
            String localDispatcher = config.getValue("internalDispatcher", false);
            URL dispatcherURL = new URL(localDispatcher);
            dispatcherConnectionPool = new ConnectionPool(dispatcherURL.getHost(), dispatcherURL.getPort(), "https".equals(dispatcherURL.getProtocol()), 20);
            queryCountIndicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.RESOURCES, "cmQueryCount");
            queryTimeIndicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.RESOURCES, "cmQueryExecTime");
            dispatcherUrl = dispatcherURL.getPath();
            initialized = true;
        }
        catch (Exception t) {
            throw XQERuntimeException.wrap(t);
        }
    }

    protected ServerConnection fetchServerConnection() {
        ServerConnection aConnection = dispatcherConnectionPool.getConnection();
        aConnection.getHttpClient().getState().clearCookies();
        return aConnection;
    }

    protected String fetchRequestContext() {
        return dispatcherUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws CommandExecutionException {
        long startTime = 0L;
        if (UsageTrackingService.isEnabled()) {
            startTime = System.currentTimeMillis();
        }
        if (!initialized) {
            CMQuery.initialize();
        }
        CMQuery.incrementNumCallsCounter();
        PERF_LOGGER.log(OperationEnum.START, "Start CM Query.");
        boolean success = false;
        try {
            super.execute();
            success = true;
        }
        finally {
            block18: {
                block17: {
                    if (REQ_LOGGER.isOn()) {
                        try {
                            REQ_LOGGER.log(this.getRequestEnvelope().getAsString());
                        }
                        catch (IOException e) {
                            if (!success) break block17;
                            throw new XQERuntimeException(e);
                        }
                    }
                }
                if (RES_LOGGER.isOn()) {
                    try {
                        RES_LOGGER.log(this.getResponseEnvelope().getAsString());
                    }
                    catch (IOException e) {
                        if (!success) break block18;
                        throw new XQERuntimeException(e);
                    }
                }
            }
            if (UsageTrackingService.isEnabled()) {
                CMQuery.incrementElapsedTimeCounter(System.currentTimeMillis() - startTime);
            }
            PERF_LOGGER.log(OperationEnum.END, "Finished CM Query.");
        }
    }

    private static void incrementNumCallsCounter() {
        if (!initialized) {
            CMQuery.initialize();
        }
        queryCountIndicator.increment();
    }

    private static void incrementElapsedTimeCounter(long elapsedTimeInMilliseconds) {
        if (!initialized) {
            CMQuery.initialize();
        }
        queryTimeIndicator.add(elapsedTimeInMilliseconds);
    }

    public static void updateCMUsageStats(Timer timer) {
        if (timer != null) {
            timer.stop();
            CMQuery.incrementNumCallsCounter();
            CMQuery.incrementElapsedTimeCounter(timer.getElapsedTimeInMilliseconds());
        }
    }

    public static Timer getAndStartTimerForUsageStats() {
        Timer timer = null;
        if (UsageTrackingService.isEnabled()) {
            timer = new Timer();
            timer.start();
        }
        return timer;
    }

    public static String getSearchPathPropName(String searchPath, String property) {
        int startingIndex;
        String quote;
        int quoteIndex;
        int nameIndex;
        int propertyIndex;
        String ret = null;
        if (searchPath != null && (propertyIndex = searchPath.indexOf(property)) >= 0 && (nameIndex = searchPath.indexOf(NAME_ATTRIBUTE, propertyIndex + property.length())) >= 0 && (quoteIndex = searchPath.indexOf(quote = searchPath.substring((startingIndex = nameIndex + NAME_ATTRIBUTE.length() + 1) - 1, startingIndex), startingIndex)) >= 0) {
            ret = searchPath.substring(startingIndex, quoteIndex);
        }
        return ret;
    }

    public static long getCMQueryCountIndicator() {
        return queryCountIndicator.getValue();
    }

    static {
        queryCountIndicator = null;
        queryTimeIndicator = null;
        initialized = false;
        REQ_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CMQuery.Request", LogLevel.INFO);
        RES_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CMQuery.Response", LogLevel.INFO);
        PERF_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CMQuery.Performance", LogLevel.INFO);
    }
}

