/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.OrderEnum;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.RefProp;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Session;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.content.ICMSessionIdentity;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqebifw.bibushandler.content.BaseCMCommand;
import com.cognos.xqebifw.bibushandler.content.CMCacheService.CMSessionViaCMCService;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import com.cognos.xqebifw.bibushandler.content.CMSessionIdentity;
import com.cognos.xqebifw.bibushandler.content.CMUtils;
import com.cognos.xqebifw.bibushandler.content.Dispatcher.CMSessionViaDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CMSession {
    protected volatile List<ICMSessionIdentity> identities = new ArrayList<ICMSessionIdentity>();
    protected volatile List<ICMSessionIdentity> identitiesForMacroProcessing = null;
    private volatile String userClassIds = null;
    protected volatile String sessionTenantID = "";
    protected volatile Map<String, Parameter> effectiveGlobalParametersMap = null;

    public static CMSession create(IRequestEnvironment env) {
        CMSession cmS = null;
        if (CMEntityPool.tryUsingCMCacheService()) {
            cmS = CMSessionViaCMCService.create(env);
        }
        if (cmS == null) {
            cmS = CMSessionViaDispatcher.create(env);
        }
        return cmS;
    }

    protected CMSession() {
    }

    public List<ICMSessionIdentity> getIdentitiesList(List<String> filters) {
        List<ICMSessionIdentity> ans = Collections.unmodifiableList(this.identities);
        if (filters != null && filters.size() > 0) {
            ans = new ArrayList<ICMSessionIdentity>();
            for (ICMSessionIdentity id : this.identities) {
                if (filters.contains(id.getType())) continue;
                ans.add(id);
            }
        }
        return ans;
    }

    public List<ICMSessionIdentity> getIdentitiesList() {
        ArrayList<String> filters = new ArrayList<String>();
        return this.getIdentitiesList(filters);
    }

    public String getUserClassIDs() {
        ArrayList<String> filters = new ArrayList<String>();
        return this.getUserClassIDs(filters);
    }

    public String getUserClassIDs(List<String> filters) {
        List<ICMSessionIdentity> ids;
        if (this.userClassIds == null && (ids = this.getIdentitiesList(filters)) != null) {
            StringBuilder buffer = new StringBuilder();
            for (ICMSessionIdentity obj : ids) {
                buffer.append(obj.getIdentity());
                buffer.append(";");
            }
            this.userClassIds = buffer.toString();
        }
        return this.userClassIds;
    }

    public String getSessionTenantID() {
        return this.sessionTenantID;
    }

    public Map<String, Parameter> getEffectiveGlobalParametersMap() {
        return this.effectiveGlobalParametersMap;
    }

    public synchronized List<ICMSessionIdentity> loadIdentityDefaultNamesFromCM(IRequestEnvironment env) {
        if (this.identitiesForMacroProcessing == null) {
            ArrayList<ICMSessionIdentity> identitiesForMacroProcessingTemp = new ArrayList<ICMSessionIdentity>();
            BiBusHeader bibusHeader = CMUtils.buildBiBusHeader(env);
            ContentManagerService_PortType port = null;
            try {
                port = BaseCMCommand.getContentManagerServicePort(bibusHeader);
                SearchPathMultipleObject smo = new SearchPathMultipleObject("~~");
                PropEnum[] props = new PropEnum[]{PropEnum.identity};
                PropEnum[] referenceProps = new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName, PropEnum.objectClass};
                Sort[] sortOrder = new Sort[]{new Sort(OrderEnum.ascending, PropEnum.identity)};
                RefProp[] refPropArray = new RefProp[]{new RefProp(referenceProps, PropEnum.identity)};
                QueryOptions options = new QueryOptions();
                options.setRefProps(refPropArray);
                BaseClass[] res = port.query(smo, props, sortOrder, options);
                for (int i = 0; i < res.length; ++i) {
                    BaseClass[] values;
                    BaseClass baseClass = res[i];
                    if (!(baseClass instanceof Session)) continue;
                    Session session = (Session)baseClass;
                    BaseClassArrayProp identity = session.getIdentity();
                    for (BaseClass bclass : values = identity.getValue()) {
                        String defaultName = null;
                        String searchPath = null;
                        String objectClass = null;
                        if (null != bclass.getDefaultName()) {
                            defaultName = bclass.getDefaultName().getValue();
                        }
                        if (null != bclass.getSearchPath()) {
                            searchPath = bclass.getSearchPath().getValue();
                        }
                        if (null != bclass.getObjectClass() && null != bclass.getObjectClass().getValue()) {
                            objectClass = bclass.getObjectClass().getValue().getValue();
                        }
                        if (null == defaultName) continue;
                        CMSessionIdentity id = new CMSessionIdentity(defaultName, searchPath, objectClass);
                        identitiesForMacroProcessingTemp.add(id);
                    }
                }
            }
            catch (Exception e) {
                throw XQERuntimeException.wrap(e);
            }
            this.identitiesForMacroProcessing = identitiesForMacroProcessingTemp;
        }
        return this.identitiesForMacroProcessing;
    }

    public void setIdentitiesList(List<ICMSessionIdentity> idList) {
        this.identities = idList;
    }
}

