/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.GenericOptionXMLEncodedXML;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqebifw.bibushandler.content.BaseCMCommand;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import java.util.List;
import org.apache.axis.AxisFault;

public class CMUtils {
    static final String CM_CACHESERVICE_DISABLED = "contentManagerCacheService is disabled";
    static final String CMCACHE_CONTEXT_NAME = "http://developer.cognos.com/ceba/constants/contentManagerCacheOptionEnum#context";

    public static BiBusHeader buildBiBusHeader(IRequestEnvironment env) {
        CAMPassport pass;
        CAM cam;
        BIBusEnvelope clientEnvelope = ((RequestEnvironment)env).getRequestEnvelope();
        BiBusHeader header = BaseCMCommand.buildBiBusHeaderFrom(clientEnvelope);
        if (env.getCAMUserPassport() != null && !env.getCAMUserPassport().equals(env.getCAMPassport()) && (cam = header.getCAM()) != null && (pass = cam.getCAMPassport()) != null) {
            pass.setId(env.getCAMUserPassport());
        }
        return header;
    }

    public static boolean parseFaultForDisabledCMCache(AxisFault aFault) {
        return CMUtils.parseFaultForDisabledCMCache(aFault.dumpToString());
    }

    public static boolean parseFaultForDisabledCMCache(String axisFaultDumpedToString) {
        if (axisFaultDumpedToString.indexOf(CM_CACHESERVICE_DISABLED) != -1) {
            CMEntityPool.setIsCMCacheServiceEnabled(false);
            return true;
        }
        return false;
    }

    public static void updateCMCacheContext(Option[] options, IRequestEnvironment env) {
        if (env.getCMCacheContext() != null || options.length == 0) {
            return;
        }
        if (options[0] instanceof GenericOptionXMLEncodedXML) {
            GenericOptionXMLEncodedXML encodedXMLOption = (GenericOptionXMLEncodedXML)options[0];
            XmlEncodedXML encodedXML = encodedXMLOption.getValue();
            env.setCMCacheContext(encodedXML.get_value());
        }
    }

    public static void setOptionsForQueryCache(List<Option> optionList, IRequestEnvironment env) {
        if (env.getCMCacheContext() == null) {
            return;
        }
        XmlEncodedXML xmlEncodedXML = new XmlEncodedXML();
        xmlEncodedXML.set_value(env.getCMCacheContext());
        GenericOptionXMLEncodedXML genericOptionXMLEncodedXML = new GenericOptionXMLEncodedXML();
        genericOptionXMLEncodedXML.setName(CMCACHE_CONTEXT_NAME);
        genericOptionXMLEncodedXML.setValue(xmlEncodedXML);
        optionList.add((Option)genericOptionXMLEncodedXML);
    }
}

