/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content;

import com.cognos.ccl4j.bibus.CAMCookie;
import com.cognos.ccl4j.bibus.CAMCookieImpl;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerEmptyCommand;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.CMException;
import com.cognos.xqe.bibushandler.content.CMModelViewSearchKey;
import com.cognos.xqe.bibushandler.content.ICMConnection;
import com.cognos.xqe.bibushandler.content.ICMDataSource;
import com.cognos.xqe.bibushandler.content.ICMModelViewSearchKey;
import com.cognos.xqe.bibushandler.content.ICMSessionIdentity;
import com.cognos.xqe.bibushandler.content.ICMUser;
import com.cognos.xqe.bibushandler.content.IContentManager;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQESOAPFaultException;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqebifw.bibushandler.content.BaseCMCommand;
import com.cognos.xqebifw.bibushandler.content.CMDataSource;
import com.cognos.xqebifw.bibushandler.content.CMEntity;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import com.cognos.xqebifw.bibushandler.content.CMModel;
import com.cognos.xqebifw.bibushandler.content.CMPackage;
import com.cognos.xqebifw.bibushandler.content.CMQuery;
import com.cognos.xqebifw.bibushandler.content.CMUtils;
import com.cognos.xqebifw.bibushandler.content.LogonCommand;
import com.cognos.xqebifw.bibushandler.content.UpdateAggregatesCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ContentManagerImpl
implements IContentManager {
    private static final int CONTEXT_PROCESS_ID = 1234;
    private static final String SEARCH_PATH = "~";
    private static final String LOGOFF_ACTION = "logoff";
    private static final String LOGON_ACTION = "logon";
    private static final String LOGONAS_ACTION = "logonAs";
    private static final String CAMPASSPORT_ELEMENT_NAME = "CAMPassport";
    private static final String ID_ELEMENT_NAME = "id";
    private static final String CREDENTIAL_STEP = "/credential";
    private static final String CAM_ELEMENT_NAME = "CAM";
    private static final String ACTION_ELEMENT_NAME = "action";
    private static final String CAMCREDENTIALPATH_ELEMENT_NAME = "CAMCredentialPath";
    private CMEntityPool entityPool = CMEntityPool.instance();

    @Override
    public void initialize() {
        try {
            LogonCommand logonCmd = new LogonCommand("\"aValue1\"", "aValue2", "aValue3");
            logonCmd.logon();
        }
        catch (XQERuntimeException ex) {
            XQEDebugLog.out.println("Loading Axis at initialization.");
        }
    }

    @Override
    public BiBusHeader buildBiBusHeader(IRequestEnvironment reqEnv) {
        return CMUtils.buildBiBusHeader(reqEnv);
    }

    @Override
    public ICMDataSource getDataSource(IRequestEnvironment reqEnv, String dsName) {
        CMEntity entity = this.entityPool.get(reqEnv.getCAMPassport());
        return entity.getDataSource(dsName, reqEnv);
    }

    @Override
    public ICMConnection getConnection(IRequestEnvironment reqEnv, String dsName, String connectionName) {
        CMEntity entity = this.entityPool.get(reqEnv.getCAMPassport());
        return entity.getDataSource(dsName, reqEnv).getConnection(connectionName);
    }

    @Override
    public Collection<ICMConnection> getConnections(IRequestEnvironment reqEnv, String dsName) {
        CMEntity entity = this.entityPool.get(reqEnv.getCAMPassport());
        CMDataSource ds = entity.getDataSource(dsName, reqEnv);
        return ds.getConnections();
    }

    @Override
    public ICMUser getUser(IRequestEnvironment reqEnv) {
        CMEntity entity = this.entityPool.get(reqEnv.getCAMPassport());
        return entity.getUser(reqEnv);
    }

    @Override
    public String getUserClassIDs(IRequestEnvironment reqEnv, List<String> filter, boolean useSeries7Security) {
        BIBusEnvelope envelope = ((RequestEnvironment)reqEnv).getRequestEnvelope();
        BiBusHeader header = BaseCMCommand.buildBiBusHeaderFrom(envelope);
        CMEntity entity = this.entityPool.get(reqEnv.getCAMPassport());
        return entity.getSessionCommand().getUserClassIDs(header, filter, useSeries7Security);
    }

    @Override
    public String getUserClassIDs(IRequestEnvironment reqEnv, String namespace, List<String> filter, boolean useSeries7Security) {
        BIBusEnvelope envelope = ((RequestEnvironment)reqEnv).getRequestEnvelope();
        BiBusHeader header = BaseCMCommand.buildBiBusHeaderFrom(envelope);
        CMEntity entity = this.entityPool.get(reqEnv.getCAMPassport());
        return entity.getSessionCommand().getUserClassIDs(header, filter, useSeries7Security);
    }

    @Override
    public List<ICMSessionIdentity> getIdentitiesList(IRequestEnvironment reqEnv) {
        CMEntity entity = this.entityPool.get(reqEnv.getCAMPassport());
        return entity.getSession(reqEnv).getIdentitiesList();
    }

    @Override
    public List<ICMSessionIdentity> getUserIdentitiesList(IRequestEnvironment reqEnv) {
        if (reqEnv.getIdentities() == null) {
            reqEnv.setIdentities(this.loadIdentitiesfromCM(reqEnv));
        }
        return reqEnv.getIdentities();
    }

    @Override
    public String getUserName(IRequestEnvironment reqEnv) {
        CMEntity entity = this.entityPool.get(reqEnv.getCAMPassport());
        return entity.getUser(reqEnv).getName();
    }

    @Override
    public Set<String> getModelViews(IRequestEnvironment reqEnv, String dsName, ICMModelViewSearchKey searchKey) {
        CMEntity entity = this.entityPool.get(reqEnv.getCAMPassport());
        CMDataSource ds = entity.getDataSource(dsName, reqEnv);
        CMModel model = ds.getModel();
        return model.getModelViews(searchKey, reqEnv);
    }

    @Override
    public boolean isDataSourceCached(IRequestEnvironment reqEnv, String name) {
        CMEntity entity = this.entityPool.get(reqEnv.getCAMPassport());
        return entity.isDataSourceCached(reqEnv, name);
    }

    @Override
    public Map<String, ArrayList<String>> getParameterMap(IRequestEnvironment reqEnv) {
        CMEntity entity = this.entityPool.get(reqEnv.getCAMPassport(), false);
        return entity.getUser(reqEnv).getParameterMap();
    }

    @Override
    public String getSearchPathPropName(IRequestEnvironment reqEnv, String searchPath, String property) {
        return CMQuery.getSearchPathPropName(searchPath, property);
    }

    @Override
    public ICMModelViewSearchKey createModelViewSearchKey(IRequestEnvironment reqEnv, String modelPath, String predicate) {
        return new CMModelViewSearchKey(modelPath, predicate);
    }

    public List<ICMSessionIdentity> loadIdentitiesfromCM(IRequestEnvironment reqEnv) {
        CMEntity entity = this.entityPool.get(reqEnv.getCAMUserPassport());
        return entity.getSession(reqEnv).getIdentitiesList();
    }

    public List<ICMSessionIdentity> loadIdentityDefaultNamesFromCM(IRequestEnvironment reqEnv) {
        CMEntity entity = this.entityPool.get(reqEnv.getCAMUserPassport());
        return entity.getSession(reqEnv).loadIdentityDefaultNamesFromCM(reqEnv);
    }

    @Override
    public List<ICMSessionIdentity> getUserDefaultIdentityNames(IRequestEnvironment reqEnv) {
        if (reqEnv.getDefaultIdentityNames() == null) {
            reqEnv.setDefaultIdentityNames(this.loadIdentityDefaultNamesFromCM(reqEnv));
        }
        return reqEnv.getDefaultIdentityNames();
    }

    public String prettyPrintUserIdentities(IRequestEnvironment reqEnv) {
        List<ICMSessionIdentity> identities = reqEnv.getIdentities();
        if (identities == null) {
            identities = this.loadIdentitiesfromCM(reqEnv);
            reqEnv.setIdentities(identities);
        }
        StringBuilder strBuf = new StringBuilder();
        for (ICMSessionIdentity cmIdentity : identities) {
            if (!cmIdentity.getType().equals("group") && !cmIdentity.getType().equals("role")) continue;
            if (strBuf.length() > 0) {
                strBuf.append(", ");
            }
            strBuf.append(cmIdentity.getDefaultName());
        }
        return strBuf.toString();
    }

    @Override
    public Set<String> getUserCapabilities(IRequestEnvironment reqEnv) {
        if (reqEnv.getUserCapabilities() == null) {
            this.loadCapabilitiesfromCM(reqEnv);
        }
        return reqEnv.getUserCapabilities();
    }

    @Override
    public Element createBiBusHeader() {
        Element busElement;
        CMQuery queryCommand = new CMQuery("/");
        try {
            BIBusEnvelope queryEnvelope = new BIBusEnvelope();
            queryEnvelope.setCAMaction(LOGON_ACTION);
            Element queryBIBusHeader = queryEnvelope.getBIBusHeader();
            queryBIBusHeader.detach();
            queryCommand.setBIBusHeader(queryBIBusHeader);
            queryCommand.execute();
            BIBusEnvelope responseEnvelope = queryCommand.getResponseEnvelope();
            String conversationContextID = responseEnvelope.getRequestContext();
            responseEnvelope.setConversationContextID(conversationContextID);
            responseEnvelope.setConversationContextNodeID("TestEnvironment.getOrCreateBiBusHeader()FakeNodeId");
            responseEnvelope.setConversationContextProcessID(1234);
            busElement = responseEnvelope.getBIBusHeader();
            busElement.detach();
        }
        catch (SoapFaultException sfe) {
            BIBusEnvelope faultEnvelope = queryCommand.getResponseEnvelope();
            throw new XQESOAPFaultException(faultEnvelope);
        }
        catch (Exception ex) {
            XQELog.logConsole("TestEnvironment: CM is not running. Creating dummy BiBusHeader.");
            BIBusEnvelope env = new BIBusEnvelope();
            busElement = env.getBIBusHeader();
            busElement.detach();
        }
        return (Element)busElement.clone();
    }

    @Override
    public BiBusHeader buildBiBusHeaderFrom(BIBusEnvelope envelope) {
        return BaseCMCommand.buildBiBusHeaderFrom(envelope);
    }

    @Override
    public BiBusHeader buildBiBusHeader(String nameSpace, String userName, String password) {
        LogonCommand logonCommand = new LogonCommand(nameSpace, userName, password);
        return logonCommand.buildHeader();
    }

    public Set<String> getPackageUserCapabilitiesfromCM(IRequestEnvironment reqEnv, String modelPath) {
        CMPackage cmPackage;
        Element biBusHeader = reqEnv.getBibusHeader();
        String cookiePassport = reqEnv.getCAMCapabilityPassport();
        if (cookiePassport != null) {
            Element camCookieXML;
            CAMCookie camCookie = CAMCookieImpl.createCookie((String)cookiePassport);
            String capabilityPassport = camCookie.getPassportID();
            BIBusEnvelope queryEnvelope = new BIBusEnvelope();
            queryEnvelope.setBIBusHeader((Element)((Element)biBusHeader.clone()).detach());
            try {
                camCookieXML = camCookie.asXML();
            }
            catch (DocumentException e) {
                throw new XQERuntimeException(e);
            }
            queryEnvelope.setCAM(camCookieXML);
            Element queryBiBusHeader = queryEnvelope.getBIBusHeader();
            Element localBiBusHeader = (Element)((Element)queryBiBusHeader.clone()).detach();
            CMEntity e = this.entityPool.get(capabilityPassport);
            cmPackage = e.getPackage(modelPath, new RequestEnvironment(localBiBusHeader));
        } else {
            CMEntity e = CMEntityPool.instance().get(reqEnv.getCAMUserPassport());
            cmPackage = e.getPackage(modelPath, reqEnv);
        }
        return cmPackage.getPackageCapabilities();
    }

    private void loadCapabilitiesfromCM(IRequestEnvironment reqEnv) {
        reqEnv.setUserCapabilities(this.getPackageUserCapabilitiesfromCM(reqEnv, reqEnv.getModelPath()));
    }

    @Override
    public List<CMClass> getProperties(String queryObject, String ... properties) throws CMException {
        BIBusEnvelope queryEnvelope = new BIBusEnvelope();
        Element queryBIBusHeader = queryEnvelope.getBIBusHeader();
        queryBIBusHeader.detach();
        ContentManagerQueryCommand query = this.entityPool.createCMQuery();
        query.setQueryObject(queryObject);
        query.setDoTrustedRequest(true, "XQE");
        query.setBIBusHeader(queryBIBusHeader);
        for (String property : properties) {
            query.addQueryPropertyName(property);
        }
        try {
            query.execute();
            return query.getResultList();
        }
        catch (CommandExecutionException e) {
            throw new CMException(e);
        }
    }

    @Override
    public boolean isRunning() {
        BIBusEnvelope queryEnvelope = new BIBusEnvelope();
        Element queryBIBusHeader = queryEnvelope.getBIBusHeader();
        queryBIBusHeader.detach();
        ContentManagerQueryCommand query = CMEntityPool.instance().createCMQuery();
        query.setQueryObject(SEARCH_PATH);
        query.setBIBusHeader(queryBIBusHeader);
        boolean cmRunning = true;
        try {
            query.execute();
        }
        catch (Exception e1) {
            cmRunning = false;
        }
        return cmRunning;
    }

    @Override
    public BIBusEnvelope logonToAccessAccount(String accessAccount) throws CMException {
        BIBusEnvelope envelop = new BIBusEnvelope();
        ContentManagerQueryCommand query = CMEntityPool.instance().createCMQuery();
        query.setQueryObject(SEARCH_PATH);
        if (accessAccount != null) {
            Element camElement = DocumentHelper.createElement((String)CAM_ELEMENT_NAME);
            Element action = DocumentHelper.createElement((String)ACTION_ELEMENT_NAME);
            action.addText(LOGONAS_ACTION);
            Element camCredentialPath = DocumentHelper.createElement((String)CAMCREDENTIALPATH_ELEMENT_NAME);
            camCredentialPath.addText(accessAccount + CREDENTIAL_STEP);
            camElement.add(action);
            camElement.add(camCredentialPath);
            envelop.setCAM(camElement);
            query.setDoTrustedRequest(true, "XQE");
        } else {
            envelop.setCAMaction(LOGON_ACTION);
        }
        Element header = envelop.getBIBusHeader();
        header.detach();
        query.setBIBusHeader(header);
        try {
            query.execute();
        }
        catch (CommandExecutionException e) {
            throw new CMException(e);
        }
        BIBusEnvelope responseEnvelope = query.getResponseEnvelope();
        return responseEnvelope;
    }

    @Override
    public void logOffAccessAccount(Element validBiBusHeader) throws CMException {
        BIBusEnvelope envelop = new BIBusEnvelope();
        Element camElement = DocumentHelper.createElement((String)CAM_ELEMENT_NAME);
        Element camPassportElement = DocumentHelper.createElement((String)CAMPASSPORT_ELEMENT_NAME);
        Element idElement = DocumentHelper.createElement((String)ID_ELEMENT_NAME);
        idElement.addText(validBiBusHeader.element(CAM_ELEMENT_NAME).element(CAMPASSPORT_ELEMENT_NAME).elementText(ID_ELEMENT_NAME));
        camPassportElement.add(idElement);
        Element action = DocumentHelper.createElement((String)ACTION_ELEMENT_NAME);
        action.addText(LOGOFF_ACTION);
        camElement.add(action);
        camElement.add(camPassportElement);
        envelop.setCAM(camElement);
        ContentManagerEmptyCommand query = new ContentManagerEmptyCommand();
        Element header = envelop.getBIBusHeader();
        header.detach();
        query.setBIBusHeader(header);
        try {
            query.execute();
        }
        catch (CommandExecutionException e) {
            throw new CMException(e);
        }
    }

    @Override
    public void updateInMemoryAggregateXML(String dataSourceSearchPath, String inMemoryAggregateXML) throws CMException {
        UpdateAggregatesCommand updateCommand = new UpdateAggregatesCommand();
        BIBusEnvelope biBusEnvelope = new BIBusEnvelope();
        Element biBusHeaderElement = biBusEnvelope.getBIBusHeader();
        biBusHeaderElement.detach();
        updateCommand.setBIBusHeader(biBusHeaderElement);
        updateCommand.setDataSourceSearchPath(dataSourceSearchPath);
        updateCommand.setInMemoryAggregateXML(inMemoryAggregateXML);
        updateCommand.setDoTrustedRequest(true, "XQE");
        try {
            updateCommand.execute();
        }
        catch (CommandExecutionException e) {
            throw new CMException(e);
        }
    }

    @Override
    public List<String> getModelViewSearchPaths(IRequestEnvironment reqEnv, String modelView) {
        CMEntity entity = this.entityPool.get(reqEnv.getCAMPassport());
        CMPackage pkg = entity.getPackage(reqEnv.getModelPath(), reqEnv);
        return pkg.getModelViewSearchPaths(reqEnv, modelView);
    }

    @Override
    public Set<String> getModelViews(IRequestEnvironment reqEnv, String modelPath) {
        CMEntity entity = this.entityPool.get(reqEnv.getCAMPassport());
        return entity.getPackageViews(reqEnv, modelPath);
    }
}

