/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content.Dispatcher;

import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQESOAPFaultException;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import com.cognos.xqebifw.bibushandler.content.CMPackage;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public final class CMPackageViaDispatcher
extends CMPackage {
    public static CMPackage create(String thePackageName, IRequestEnvironment env) {
        return new CMPackageViaDispatcher(thePackageName, env);
    }

    private CMPackageViaDispatcher(String thePackageName, IRequestEnvironment env) {
        super(thePackageName);
        if (!this.initialized) {
            this.queryForCMInfo(env);
        }
    }

    private void queryForCMInfo(IRequestEnvironment env) {
        Element biBusHeader = env.getBibusHeader();
        ContentManagerQueryCommand queryCapabilities = CMEntityPool.instance().createCMQuery();
        queryCapabilities.setQueryObject(this.packageName);
        queryCapabilities.setBIBusHeader((Element)((Element)biBusHeader.clone()).detach());
        queryCapabilities.addQueryPropertyName(PropEnum.effectiveUserCapabilities.getValue());
        List<CMClass> rl = null;
        try {
            queryCapabilities.execute();
            rl = CollectionCast.uncheckedCast(queryCapabilities.getResultList());
        }
        catch (SoapFaultException sfe) {
            BIBusEnvelope faultEnvelope = queryCapabilities.getResponseEnvelope();
            throw new XQESOAPFaultException(faultEnvelope, (Throwable)sfe);
        }
        catch (CommandExecutionException e) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidPackage, (Throwable)e, this.packageName);
        }
        BIBusEnvelope responseEnvelope = queryCapabilities.getResponseEnvelope();
        Element capabilityCache = responseEnvelope.getOptionalUserCapabilitiesCache();
        if (capabilityCache != null) {
            Iterator c1 = CollectionCast.uncheckedCast(capabilityCache.elementIterator(PropEnum.userCapabilities.getValue()));
            while (c1.hasNext()) {
                Element c = (Element)c1.next();
                Iterator itr1 = CollectionCast.uncheckedCast(c.elementIterator());
                while (itr1.hasNext()) {
                    Element c2 = (Element)itr1.next();
                    String capability = c2.getText();
                    if (!this.supportedCapabilities.contains(capability)) continue;
                    this.globalCapabilities.add(capability);
                }
            }
        }
        if (rl != null && !rl.isEmpty()) {
            for (CMClass cmResult : rl) {
                Iterator itr = CollectionCast.uncheckedCast(cmResult.getItemElement().elementIterator());
                while (itr.hasNext()) {
                    String arrayType;
                    Element e = (Element)itr.next();
                    Element valueElement = e.element("value");
                    if (valueElement == null || (arrayType = valueElement.attributeValue(new QName("arrayType", new Namespace("SOAP-ENC", "http://schemas.xmlsoap.org/soap/encoding/")))) == null) continue;
                    Iterator itr1 = CollectionCast.uncheckedCast(valueElement.elementIterator());
                    while (itr1.hasNext()) {
                        Element c = (Element)itr1.next();
                        String capability = c.getText();
                        if (!this.globalCapabilities.contains(capability)) continue;
                        this.packageCapabilities.add(capability);
                    }
                }
            }
        }
    }
}

