/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content.Dispatcher;

import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.exception.XQESOAPFaultException;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.parameters.GlobalParametersUtil;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.Timer;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import com.cognos.xqebifw.bibushandler.content.CMQuery;
import com.cognos.xqebifw.bibushandler.content.CMSession;
import com.cognos.xqebifw.bibushandler.content.CMSessionIdentity;
import java.util.List;
import org.dom4j.Element;

public final class CMSessionViaDispatcher
extends CMSession {
    private static final String ITEM_PROPERTY = "item";
    private static final String VALUE_PROPERTY = "value";
    private static final String NAME_PROPERTY = "name";
    private static final String EFFECTIVE_GLOBAL_PARAMS = "effectiveGlobalParameters";
    private boolean mNeedToGetGlobalParamsFromCM = false;

    public static CMSession create(IRequestEnvironment env) {
        boolean needToGetGlobalParamsFromCM = false;
        return new CMSessionViaDispatcher(env, needToGetGlobalParamsFromCM);
    }

    public static CMSession create(IRequestEnvironment env, boolean needToGetGlobalParamsFromCM) {
        return new CMSessionViaDispatcher(env, needToGetGlobalParamsFromCM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CMSessionViaDispatcher(final IRequestEnvironment env, boolean needToGetGlobalParamsFromCM) {
        this.mNeedToGetGlobalParamsFromCM = needToGetGlobalParamsFromCM;
        Timer timer = CMQuery.getAndStartTimerForUsageStats();
        try {
            ((RequestEnvironment)env).getCMRequestExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ((RequestEnvironment)env).resetEnvelopeFromExecutor();
                    CMSessionViaDispatcher.this.queryForCMInfo(env);
                }
            });
        }
        finally {
            CMQuery.updateCMUsageStats(timer);
        }
    }

    private void queryForCMInfo(IRequestEnvironment env) {
        Element biBusHeader = env.getBibusHeader();
        ContentManagerQueryCommand queryCommand = CMEntityPool.instance().createCMQuery();
        queryCommand.setQueryObject("~~");
        queryCommand.setBIBusHeader((Element)((Element)biBusHeader.clone()).detach());
        queryCommand.addQueryPropertyName(PropEnum.defaultName.getValue());
        queryCommand.addQueryPropertyName(PropEnum.searchPath.getValue());
        queryCommand.addQueryPropertyName(PropEnum.identity.getValue());
        queryCommand.addQueryPropertyName(PropEnum.tenantID.getValue());
        if (this.mNeedToGetGlobalParamsFromCM) {
            queryCommand.addQueryPropertyName(PropEnum.effectiveGlobalParameters.getValue());
        }
        List<CMClass> resultList = null;
        try {
            queryCommand.execute();
            resultList = CollectionCast.uncheckedCast(queryCommand.getResultList());
            for (CMClass aClass : resultList) {
                Element anElement = aClass.getPropertyAsElement(PropEnum.identity.getValue());
                Element value = anElement.element(VALUE_PROPERTY);
                List<Element> items = CollectionCast.uncheckedCast(value.elements(ITEM_PROPERTY));
                for (Element anItem : items) {
                    this.identities.add(new CMSessionIdentity(anItem.element("searchPath").element(VALUE_PROPERTY).getText(), anItem.attributeValue("type")));
                }
                if (aClass.getPropertyList().contains(PropEnum.tenantID.getValue())) {
                    Element tenantIDProp = aClass.getPropertyAsElement(PropEnum.tenantID.getValue());
                    Element tenantIDVal = tenantIDProp.element(VALUE_PROPERTY);
                    this.sessionTenantID = tenantIDVal.getText();
                }
                if (!this.mNeedToGetGlobalParamsFromCM || !aClass.getPropertyList().contains(EFFECTIVE_GLOBAL_PARAMS)) continue;
                Element globParamElement = aClass.getPropertyAsElement(EFFECTIVE_GLOBAL_PARAMS);
                Element globParamValueElement = globParamElement.element(VALUE_PROPERTY);
                if (globParamValueElement != null) {
                    MultiRequestContext mrc = env.getExecutionEnvironment().getMultiRequestContext();
                    this.effectiveGlobalParametersMap = GlobalParametersUtil.parseGlobalParametersFromElement(globParamValueElement, mrc);
                }
                this.mNeedToGetGlobalParamsFromCM = false;
            }
        }
        catch (SoapFaultException sfe) {
            BIBusEnvelope faultEnvelope = queryCommand.getResponseEnvelope();
            throw new XQESOAPFaultException(faultEnvelope, (Throwable)sfe);
        }
        catch (CommandExecutionException e) {
            throw new XQERuntimeException(XQEMessageKeys.CM_UnableToRetrieveSessionIdentities, (Throwable)e);
        }
        if (resultList == null || resultList.isEmpty()) {
            throw new XQERuntimeException(XQEMessageKeys.CM_UnableToRetrieveSessionIdentities);
        }
    }
}

