/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.FormatEnum;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqebifw.bibushandler.content.BaseCMCommand;
import java.math.BigInteger;
import org.apache.axis.client.Stub;

public class LogonCommand
extends BaseCMCommand {
    private static final String READ = "read";
    private static final String SEARCH_PATH = "~";
    private static final String QUOTE = "\"";
    private static final int FORM_FIELD_SIZE = 3;
    private final String username;
    private final String password;
    private final String namespace;
    private BiBusHeader bibusHeader;
    private BIBusEnvelope envelope;

    public LogonCommand(String aNamespace, String aUsername, String aPassword) {
        this.username = aUsername;
        this.password = aPassword;
        this.namespace = aNamespace.substring(aNamespace.indexOf(QUOTE) + 1, aNamespace.lastIndexOf(QUOTE));
    }

    public BiBusHeader getBiBusHeader() {
        return this.bibusHeader;
    }

    public BIBusEnvelope getEnvelope() {
        return this.envelope;
    }

    public BiBusHeader buildHeader() {
        BiBusHeader header = new BiBusHeader();
        CAM cam = new CAM();
        if (this.namespace != null && !"".equals(this.namespace) && this.username != null && !"".equals(this.username)) {
            cam.setAction("logonAs");
            HdrSession hdrSession = new HdrSession();
            FormFieldVar[] vars = new FormFieldVar[3];
            vars[0] = new FormFieldVar();
            vars[0].setName("CAMNamespace");
            vars[0].setFormat(FormatEnum.not_encrypted);
            vars[0].setValue(this.namespace);
            vars[1] = new FormFieldVar();
            vars[1].setName("CAMUsername");
            vars[1].setValue(this.username);
            vars[1].setFormat(FormatEnum.not_encrypted);
            vars[2] = new FormFieldVar();
            vars[2].setName("CAMPassword");
            if (this.password != null && !"".equals(this.password)) {
                vars[2].setValue(this.password);
            }
            vars[2].setFormat(FormatEnum.not_encrypted);
            hdrSession.setFormFieldVars(vars);
            header.setHdrSession(hdrSession);
        } else {
            cam.setAction("logon");
        }
        header.setCAM(cam);
        return header;
    }

    public void logon() {
        ContentManagerService_PortType port = null;
        try {
            BiBusHeader header = this.buildHeader();
            port = LogonCommand.getContentManagerServicePort(header);
            SearchPathMultipleObject smo = new SearchPathMultipleObject(SEARCH_PATH);
            PropEnum[] props = new PropEnum[]{PropEnum.defaultName};
            QueryOptions options = new QueryOptions();
            options.setSchemaInfo(false);
            options.setPermission(READ);
            options.setMaxObjects(BigInteger.ZERO);
            options.setSkipObjects(BigInteger.ZERO);
            options.setDataEncoding(EncodingEnum.base64);
            options.setMaxDataBytes(BigInteger.ZERO);
            options.setSkipDataBytes(BigInteger.ZERO);
            port.query(smo, props, null, options);
            this.bibusHeader = LogonCommand.getBiBusHeader((Stub)port);
            this.envelope = LogonCommand.getBIBusEnvelope((Stub)port);
        }
        catch (Throwable e) {
            throw new XQERuntimeException(XQEMessageKeys.CM_UnableToLogonToNamespace, e, (Object)this.namespace, (Object)this.username);
        }
        finally {
            if (port != null) {
                LogonCommand.returnContentManagerServicePort(port);
            }
        }
    }

    public void logoff() {
        if (this.bibusHeader != null) {
            ContentManagerService_PortType port = null;
            try {
                port = LogonCommand.getContentManagerServicePort(this.bibusHeader);
                this.bibusHeader = null;
            }
            catch (Throwable e) {
                throw new XQERuntimeException(XQEMessageKeys.CM_UnableToLogoffFromNamespace, e, this.namespace);
            }
            finally {
                if (port != null) {
                    LogonCommand.returnContentManagerServicePort(port);
                }
            }
        }
    }
}

