/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.content;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.AncestorInfo;
import com.cognos.developer.schemas.bibus._3.AncestorInfoArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.OrderEnum;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.RefProp;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Session;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqebifw.bibushandler.content.BaseCMCommand;
import com.cognos.xqebifw.bibushandler.content.CMSessionIdentity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SessionCommand
extends BaseCMCommand {
    private static final String SEMI_COLON = ";";
    private static final String STR_NAMESPACE = "namespace";
    private static final String SEARCH_PATH_SESSION = "~~";
    private ArrayList<CMSessionIdentity> allIdentities;
    private Map<String, ArrayList<CMSessionIdentity>> filteredIdentities = null;

    public ArrayList<CMSessionIdentity> getIdentities(BiBusHeader biBusHeader) {
        this.init(biBusHeader);
        return this.allIdentities;
    }

    public ArrayList<CMSessionIdentity> getIdentities(BiBusHeader biBusHeader, List<String> objectClassFilter) {
        this.init(biBusHeader);
        return SessionCommand.filterIdentities(this.allIdentities, objectClassFilter);
    }

    public ArrayList<CMSessionIdentity> getIdentities(BiBusHeader biBusHeader, String namespace) {
        this.init(biBusHeader);
        ArrayList<CMSessionIdentity> ids = this.filteredIdentities.get(namespace);
        if (ids == null) {
            ids = new ArrayList();
        }
        return ids;
    }

    public ArrayList<CMSessionIdentity> getIdentities(BiBusHeader biBusHeader, String namespace, List<String> objectClassFilter) {
        this.init(biBusHeader);
        ArrayList<CMSessionIdentity> ids = this.filteredIdentities.get(namespace);
        if (ids == null) {
            ids = new ArrayList();
        }
        return SessionCommand.filterIdentities(ids, objectClassFilter);
    }

    public String getUserClassIDs(BiBusHeader biBusHeader, boolean useSeries7Security) {
        this.init(biBusHeader);
        if (useSeries7Security) {
            return SessionCommand.generateS7UserClassIDs(this.allIdentities);
        }
        return SessionCommand.generateUserClassIDs(this.allIdentities);
    }

    public String getUserClassIDs(BiBusHeader biBusHeader, List<String> objectClassFilter, boolean useSeries7Security) {
        this.init(biBusHeader);
        if (useSeries7Security) {
            return SessionCommand.generateS7UserClassIDs(this.allIdentities);
        }
        ArrayList<CMSessionIdentity> ids = SessionCommand.filterIdentities(this.allIdentities, objectClassFilter);
        return SessionCommand.generateUserClassIDs(ids);
    }

    public String getUserClassIDs(BiBusHeader biBusHeader, String namespace, boolean useSeries7Security) {
        this.init(biBusHeader);
        ArrayList<CMSessionIdentity> ids = this.filteredIdentities.get(namespace);
        if (useSeries7Security) {
            return SessionCommand.generateS7UserClassIDs(ids);
        }
        return SessionCommand.generateUserClassIDs(namespace, ids);
    }

    public String getUserClassIDs(BiBusHeader biBusHeader, String namespace, List<String> objectClassFilter, boolean useSeries7Security) {
        this.init(biBusHeader);
        ArrayList<CMSessionIdentity> ids = this.filteredIdentities.get(namespace);
        if (useSeries7Security) {
            return SessionCommand.generateS7UserClassIDs(ids);
        }
        return SessionCommand.generateUserClassIDs(namespace, SessionCommand.filterIdentities(ids, objectClassFilter));
    }

    private static String generateUserClassIDs(ArrayList<CMSessionIdentity> ids) {
        return SessionCommand.generateUserClassIDs("", ids);
    }

    private static String generateUserClassIDs(String namespace, ArrayList<CMSessionIdentity> ids) {
        if (ids == null || ids.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (CMSessionIdentity id : ids) {
            buffer.append(id.getIdentity());
            buffer.append(SEMI_COLON);
        }
        buffer.append(namespace);
        return buffer.toString();
    }

    private static String generateS7UserClassIDs(ArrayList<CMSessionIdentity> ids) {
        if (ids == null || ids.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (CMSessionIdentity id : ids) {
            String userClassID = id.getParameterValue("userClassID");
            if (userClassID == null) continue;
            buffer.append(userClassID);
            buffer.append(SEMI_COLON);
        }
        return buffer.toString();
    }

    private static ArrayList<CMSessionIdentity> filterIdentities(ArrayList<CMSessionIdentity> identities, List<String> objectClassFilter) {
        if (identities == null) {
            return new ArrayList<CMSessionIdentity>();
        }
        if (objectClassFilter == null || objectClassFilter.isEmpty()) {
            return identities;
        }
        ArrayList<CMSessionIdentity> ans = new ArrayList<CMSessionIdentity>();
        for (CMSessionIdentity id : identities) {
            if (objectClassFilter.contains(id.getType())) continue;
            ans.add(id);
        }
        return ans;
    }

    private PropEnum[] createReferenceProperty() {
        return new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName, PropEnum.objectClass, PropEnum.ancestors, PropEnum.parameters};
    }

    private synchronized void init(BiBusHeader biBusHeader) {
        if (this.allIdentities == null || this.filteredIdentities == null) {
            this.allIdentities = new ArrayList();
            this.filteredIdentities = new HashMap<String, ArrayList<CMSessionIdentity>>();
            ContentManagerService_PortType port = null;
            try {
                port = SessionCommand.getContentManagerServicePort(biBusHeader);
                SearchPathMultipleObject smo = new SearchPathMultipleObject(SEARCH_PATH_SESSION);
                PropEnum[] props = new PropEnum[]{PropEnum.identity};
                PropEnum[] referenceProps = this.createReferenceProperty();
                Sort[] sortOrder = new Sort[]{new Sort(OrderEnum.ascending, PropEnum.identity)};
                RefProp[] refPropArray = new RefProp[]{new RefProp(referenceProps, PropEnum.identity)};
                QueryOptions options = new QueryOptions();
                options.setRefProps(refPropArray);
                BaseClass[] res = port.query(smo, props, sortOrder, options);
                for (int i = 0; i < res.length; ++i) {
                    BaseClass[] values;
                    BaseClass baseClass = res[i];
                    if (!(baseClass instanceof Session)) continue;
                    Session session = (Session)baseClass;
                    BaseClassArrayProp identity = session.getIdentity();
                    for (BaseClass bclass : values = identity.getValue()) {
                        String defaultName = null;
                        String searchPath = null;
                        String objectClass = null;
                        if (null != bclass.getDefaultName()) {
                            defaultName = bclass.getDefaultName().getValue();
                        }
                        if (null != bclass.getSearchPath()) {
                            searchPath = bclass.getSearchPath().getValue();
                        }
                        if (null != bclass.getObjectClass() && null != bclass.getObjectClass().getValue()) {
                            objectClass = bclass.getObjectClass().getValue().getValue();
                        }
                        if (null == defaultName) continue;
                        CMSessionIdentity id = new CMSessionIdentity(defaultName, searchPath, objectClass);
                        this.allIdentities.add(id);
                        if (bclass instanceof Account) {
                            this.processAccountParameters(bclass, id);
                        }
                        this.processAncestors(bclass, id);
                    }
                }
            }
            catch (Exception e) {
                throw XQERuntimeException.wrap(e);
            }
            finally {
                SessionCommand.returnContentManagerServicePort(port);
            }
        }
    }

    private void processAccountParameters(BaseClass baseClass, CMSessionIdentity identity) {
        Account account = (Account)baseClass;
        if (account.getParameters() != null && account.getParameters().getValue() != null) {
            ParameterValue[] parameters;
            for (ParameterValue param : parameters = account.getParameters().getValue()) {
                ParmValueItem[] values = param.getValue();
                String parameterName = param.getName();
                for (ParmValueItem value : values) {
                    if (!(value instanceof SimpleParmValueItem)) continue;
                    SimpleParmValueItem simpleValue = (SimpleParmValueItem)value;
                    String parameterValue = simpleValue.getUse();
                    identity.addParameter(parameterName, parameterValue);
                }
            }
        }
    }

    private void processAncestors(BaseClass bclass, CMSessionIdentity id) {
        AncestorInfoArrayProp ancestorInfoArray = bclass.getAncestors();
        for (AncestorInfo info : ancestorInfoArray.getValue()) {
            if (!info.getObjectClass().equals((Object)ClassEnum.fromString((String)STR_NAMESPACE))) continue;
            String nsSearchPath = info.getSearchPath();
            ArrayList<CMSessionIdentity> ids = this.filteredIdentities.get(nsSearchPath);
            if (ids == null) {
                ids = new ArrayList();
                this.filteredIdentities.put(nsSearchPath, ids);
            }
            ids.add(id);
        }
    }
}

