/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.bibushandler.datasource;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.gss.CAM_GSSHelper;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.util.base64;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.util.CollectionCast;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.ietf.jgss.GSSCredential;

public class JCAMImpersonator {
    public static final String JAAS_CONFIGURATION_ENTRY = "com.cognos.biserver.security.xqe";
    private static final int MAXIMUM_BLOB_PARTS = 3;
    CAM_GSSHelper gssHelper = null;
    Subject dqSubject = null;
    static CAMFactory cf = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCAMImpersonator() {
        try {
            LoginContext lc = this.createLoginContext();
            lc.login();
            Class<JCAMImpersonator> clazz = JCAMImpersonator.class;
            synchronized (JCAMImpersonator.class) {
                if (cf == null) {
                    cf = new CAMFactory("XQE");
                }
                // ** MonitorExit[var2_4] (shouldn't be in output)
                this.dqSubject = lc.getSubject();
                XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "SecBridge", LogLevel.TRACE).log("New gssHelper");
                this.gssHelper = cf.createGSSHelper(this.dqSubject);
            }
        }
        catch (LoginException ex) {
            throw new XQERuntimeException(XQEMessageKeys.WSB_JCAM_INIT_ERROR, (Throwable)ex);
        }
        catch (CAMCryptoException ex) {
            throw new XQERuntimeException(XQEMessageKeys.WSB_JCAM_INIT_ERROR, (Throwable)ex);
        }
    }

    private LoginContext createLoginContext() throws LoginException {
        LoginContext lc = null;
        try {
            lc = new LoginContext(JAAS_CONFIGURATION_ENTRY);
        }
        catch (LoginException e) {
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "SecBridge", LogLevel.TRACE).log("Got exception " + e.getMessage() + ", will create default configuration.");
        }
        if (lc == null) {
            lc = new LoginContext(JAAS_CONFIGURATION_ENTRY, null, null, new LocalSSOConfiguration());
        }
        return lc;
    }

    public String camImpUsrNegotiate(String securityBlob) {
        try {
            if (this.gssHelper.isEstablished()) {
                return null;
            }
            String[] blob = this.decodeAndSplitBlobString(securityBlob);
            byte[] outToken = this.gssHelper.acceptSecContext(blob[1].getBytes());
            if (outToken == null) {
                return null;
            }
            return this.createCryptoBlobString(blob[0], new String(outToken), true);
        }
        catch (Exception ex) {
            throw new XQERuntimeException(XQEMessageKeys.WSB_JCAM_DELEGATION_ERROR, (Throwable)ex);
        }
    }

    private String[] decodeAndSplitBlobString(String sSecurityBlob) {
        String[] stuff = new String[]{"", ""};
        byte[] data = base64.decode((int)0, (String)sSecurityBlob);
        try {
            String tmp = new String(data, "UTF-8");
            String[] parts = tmp.split(":", 3);
            if (parts.length > 1) {
                stuff[0] = parts[0];
            }
            if (parts.length == 3) {
                stuff[1] = parts[2];
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new XQERuntimeException(XQEMessageKeys.WSB_JCAM_DELEGATION_ERROR, (Throwable)ex);
        }
        return stuff;
    }

    private String createCryptoBlobString(String camId, String blob, boolean status) {
        String newBlob = camId;
        newBlob = status ? newBlob + ":0:" : newBlob + ":1:";
        newBlob = newBlob + blob;
        return newBlob;
    }

    public DelegatedCredential getDelegatedCredential() {
        Object credential;
        XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "SecBridge", LogLevel.TRACE).log("Calling getDelegatedSubject.");
        try {
            credential = this.gssHelper.getDelegatedSubject();
        }
        catch (CAMCryptoException ex) {
            throw new XQERuntimeException(XQEMessageKeys.WSB_JCAM_DELEGATION_ERROR, (Throwable)ex);
        }
        if (credential instanceof GSSCredential) {
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "SecBridge", LogLevel.TRACE).log("Returning GSSCredential.");
            return new DelegatedCredential(this.dqSubject, (GSSCredential)credential);
        }
        XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "SecBridge", LogLevel.TRACE).log("Returning Subject.");
        return new DelegatedCredential((Subject)credential);
    }

    public static class DelegatedCredential {
        private Subject subject;
        private GSSCredential credential;

        public DelegatedCredential(Subject theSubject) {
            this.subject = theSubject;
        }

        public DelegatedCredential(Subject theDQSubject, GSSCredential userCredential) {
            this.subject = theDQSubject;
            this.credential = userCredential;
        }

        public boolean isConstrained() {
            return this.credential != null;
        }

        public Subject getSubject() {
            return this.subject;
        }

        public GSSCredential getCredential() {
            return this.credential;
        }

        public boolean equals(Object theOther) {
            if (theOther == null) {
                return false;
            }
            if (!(theOther instanceof DelegatedCredential)) {
                return false;
            }
            DelegatedCredential otherCredential = (DelegatedCredential)theOther;
            if (this.isConstrained() != otherCredential.isConstrained()) {
                return false;
            }
            if (this.isConstrained()) {
                return this.getCredential().equals(otherCredential.getCredential());
            }
            return this.getSubject().getPrincipals().equals(otherCredential.getSubject().getPrincipals());
        }

        public int hashCode() {
            if (this.isConstrained()) {
                return this.getCredential().hashCode();
            }
            return this.getSubject().getPrincipals().hashCode();
        }
    }

    public static class LocalSSOConfiguration
    extends Configuration {
        private static final String KEYTAB_FILENAME = "ibmcognosba.keytab";
        private static final String TRUE = "true";
        private static final String DQM_PRINCIPAL = "principal";
        static String keytabLocation = null;
        static String principalName = null;

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String arg0) {
            String loginModuleClass;
            HashMap<String, String> map = new HashMap<String, String>();
            String keyTabPath = LocalSSOConfiguration.getKeytabLocation();
            String sPrincipalName = LocalSSOConfiguration.getPrincipalName();
            if (System.getProperty("java.vendor").toUpperCase().contains("IBM")) {
                loginModuleClass = "com.ibm.security.auth.module.Krb5LoginModule";
                map.put(DQM_PRINCIPAL, sPrincipalName);
                map.put("useKeytab", keyTabPath);
                map.put("credsType", "both");
                map.put("useDefaultCcache", "false");
            } else {
                loginModuleClass = "com.sun.security.auth.module.Krb5LoginModule";
                map.put(DQM_PRINCIPAL, sPrincipalName);
                map.put("useKeyTab", TRUE);
                map.put("keyTab", keyTabPath);
                map.put("refreshKrb5Config", TRUE);
                map.put("storeKey", TRUE);
            }
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "SecBridge", LogLevel.TRACE).log("Principal name: " + sPrincipalName);
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "SecBridge", LogLevel.TRACE).log("Keytab location: " + keyTabPath);
            AppConfigurationEntry entry = new AppConfigurationEntry(loginModuleClass, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, map);
            return new AppConfigurationEntry[]{entry};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getKeytabLocation() {
            Class<LocalSSOConfiguration> clazz = LocalSSOConfiguration.class;
            synchronized (LocalSSOConfiguration.class) {
                if (keytabLocation == null) {
                    String filename = "../configuration/ibmcognosba.keytab";
                    ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
                    keytabLocation = cfg.resolveEffectivePath(filename);
                    File tmp = new File(keytabLocation);
                    if (!tmp.exists()) {
                        throw new XQERuntimeException(XQEMessageKeys.WSB_JCAM_KEYTAB_FILE_MISSING, keytabLocation);
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return keytabLocation;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String getPrincipalName() {
            Class<LocalSSOConfiguration> clazz = LocalSSOConfiguration.class;
            synchronized (LocalSSOConfiguration.class) {
                if (principalName == null) {
                    try {
                        XQECCLConfigurationFactory.getInstance().init();
                        Element element = XQECCLConfigurationFactory.getInstance().getValueElement("AAA", false);
                        if (null != element) {
                            principalName = LocalSSOConfiguration.extractSPName(element);
                        }
                    }
                    catch (CCLConfigurationException e) {
                        throw new XQERuntimeException(XQEMessageKeys.WSB_JCAM_COGNOS_CONFIG_ERROR, (Throwable)e);
                    }
                }
                if (principalName == null) {
                    throw new XQERuntimeException(XQEMessageKeys.WSB_JCAM_DQM_PRINCIPAL_MISSING);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return principalName;
            }
        }

        private static String extractSPName(Element element) {
            Namespace ns = element.getNamespace();
            String nsPrefix = ns.getPrefix();
            String actualPrefix = null != nsPrefix && nsPrefix.length() > 0 ? nsPrefix + ':' : "";
            XPath xpath = DocumentHelper.createXPath((String)(actualPrefix + "instances[@name=\"authProvider\"]/" + actualPrefix + "instance[@class=\"ActiveDirectory\"]/" + actualPrefix + "parameter[@name=\"DQ_SPNName\"]/" + actualPrefix + "value"));
            List<Node> nodeList = CollectionCast.uncheckedCast(xpath.selectNodes((Object)element));
            for (Node node : nodeList) {
                if (node.getText().trim().isEmpty()) continue;
                return node.getText();
            }
            return null;
        }
    }
}

