/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationUtils;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogTypedLogger;
import com.cognos.pogo.async.service.connection.bibustkserver.BIBusTKServerComponentFactory;
import com.cognos.pogo.async.service.connection.bibustkserver.BIBusTKServerManager;
import com.cognos.pogo.bibus.CryptoFacility;
import com.cognos.pogo.bibus.SOAPMessageOutputter;
import com.cognos.pogo.http.ConnectionOwner;
import com.cognos.pogo.http.StandaloneServerConnection;
import com.cognos.pogo.http.httpclient.MsgBodyGenerator;
import com.cognos.pogo.monitoring.jmx.report.InteractiveReportExecutingRequests;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPXMLSource;
import com.cognos.pogo.reportservice.ProcessFacade;
import com.cognos.pogo.reportservice.ProcessList;
import com.cognos.pogo.reportservice.ProcessManager;
import com.cognos.pogo.reportservice.ProcessReaper;
import com.cognos.pogo.reportservice.RSComponentFactory;
import com.cognos.pogo.reportservice.ReportServerConnection;
import com.cognos.pogo.reportservice.ReportServerConnectionPool;
import com.cognos.pogo.reportservice.ReportServerProcess;
import com.cognos.pogo.reportservice.ReportServerQueue;
import com.cognos.pogo.reportservice.ReportServerQueueCallback;
import com.cognos.pogo.reportservice.ReportServerRequest;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.config.XQESubConfiguration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqebifw.bibushandler.CAMCryptoProvider;
import com.cognos.xqebifw.bibushandler.ROLAPAsyncBIBusXMLHelper;
import com.cognos.xqebifw.config.CCLConfigurationFactoryImpl;
import com.cognos.xqebifw.cubingservices.CubingServicesConnectionFactory;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import com.ibm.bi.org.apache.hadoop.io.ICryptoProvider;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.mail.internet.InternetHeaders;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.dom4j.Element;

public class CubingServicesComponentFactory
extends BIBusTKServerComponentFactory {
    private static final int EIGHT_K = 8192;
    private static final int SERVER_SOCKET_TIMEOUT_MS = 60000;
    private static final int PORT_NUMBER_EXCHANGE_TIMEOUT_MS = 300000;
    private static final int DELAY_ON_FAILURE_EXCHANGE_MS = 5000;
    private static final double ONE_MILLSEC_IN_NANOSECS = 1000000.0;
    private static final String STATUS_KEY = "status";
    private static final String SHUTDOWN_STR = "shutdown";
    private static final String SHUTDOWN_ELEMENT = "shutdown";
    private static final int EXPECTED_MAX_PROCESS_COUNT = 1;
    private static final int MAX_AFFINE_CONNECTION_COUNT = 1;
    private static final int MAX_NON_AFFINE_CONNECTION_COUNT = 100;
    private static final String MAX_NON_AFFINE_CONNECTION_COUNT_PROPERTY = "QS_MAX_NON_AFFINE_CONNECTION_COUNT";
    private static final boolean ALLOW_RS_CONNECTION_RETRY = true;
    private static final String SOAPACTION = "SOAPAction";
    private static final String SOAP_ACTION_XQE = "http://www.ibm.com/xmlns/prod/cognos/queryService/201404/.local";
    private static final String STOP = "--stop";
    private static Lock configurationLock;
    private V5DataServerProcess proc = null;
    private static final XQELogger DISP_LOGGER;
    private static boolean newDispatcher;

    private static boolean runningNewDispatcher() {
        boolean isAliveExists = false;
        try {
            Method m = ProcessFacade.class.getMethod("isAlive", new Class[0]);
            isAliveExists = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isAliveExists;
    }

    public ReportServerConnection newReportServerConnection(ConnectionOwner owner, int poolLocation, boolean affineRequestsOnly) {
        V5DataServerConnection rsConn = new V5DataServerConnection((RSComponentFactory)this, owner, poolLocation, affineRequestsOnly);
        rsConn.setAutoRetry(true);
        return rsConn;
    }

    public ReportServerProcess newReportServerProcess(String[] args, String workingDir) {
        this.proc = new V5DataServerProcess(args, workingDir);
        return this.proc;
    }

    public ProcessManager newProcessManager(String procManThreadName, ReportServerQueue externalProcessQueue, String[] args, Element targetElement, String externalProcessHost, int externalProcessPort, boolean usessl) {
        return new BIBusTKServerManager(this, procManThreadName, (ReportServerQueueCallback)externalProcessQueue, args, targetElement, externalProcessHost, externalProcessPort, usessl){

            public void setProcessCleanerInterval(int processCleanerInterval) {
                super.setProcessCleanerInterval(processCleanerInterval);
                CubingServicesComponentFactory.getLogger().info("processCheckInterval = " + processCleanerInterval);
            }

            protected ProcessList createProcessList(String serviceName, ProcessReaper processReaper) {
                return new ProcessList(processReaper, (ProcessManager)this, serviceName){

                    public void ping() {
                        if (newDispatcher) {
                            super.ping();
                        }
                        if (this.getProcesListView().size() == 0) {
                            this.createAnotherProcess();
                        }
                    }
                };
            }
        };
    }

    public ProcessFacade newProcessFacade(String[] args, Element config, String host, int port, boolean ssl, int pid, ReportServerQueueCallback callback, int maxAffineConnectionCount, int maxNonAffineConnectionCount, Element cclconfig, ProcessManager theManager) throws Exception {
        if (1 != theManager.getMaxProcessCount()) {
            throw new Exception("The expected maximum number of QueryService processes must be 1");
        }
        if ("localhost".compareTo(host) == 0) {
            URL internalDispatcherURL = V5DataServerProcess.getDispatcherURL();
            host = internalDispatcherURL.getHost();
        }
        int localMaxNonAffineConnectionCount = 100;
        String maxNonAffineConnectionCountProp = System.getProperty(MAX_NON_AFFINE_CONNECTION_COUNT_PROPERTY);
        if (maxNonAffineConnectionCountProp != null) {
            localMaxNonAffineConnectionCount = Integer.parseInt(maxNonAffineConnectionCountProp);
        }
        return new V5DataServerProcessFacade((RSComponentFactory)this, args, config, host, port, ssl, pid, callback, 1, localMaxNonAffineConnectionCount, cclconfig, theManager);
    }

    public ReportServerRequest newReportServerRequest(MessageContext mc, BIBusEnvelope envelope, InternetHeaders headers, ReportServerQueue queue, String dispatcherGuid, InteractiveReportExecutingRequests executingRequests) {
        return new V5ServerRequest(this, envelope, headers, this.getHandler().getReportServerQueue(), dispatcherGuid, executingRequests);
    }

    private static Logger getLogger() {
        return Hierarchy.getDefaultHierarchy().getLoggerFor(ProcessFacade.class.getName());
    }

    private static ProcessBuilder createProcessBuilder(List<String> commandLine) {
        ProcessBuilder pb = new ProcessBuilder(commandLine);
        File startupDir = new File(CCLConfigurationUtils.resolveEffectivePath((String)"../wlp"));
        pb.directory(startupDir);
        pb.redirectErrorStream(true);
        return pb;
    }

    static {
        XQECCLConfigurationFactory.initialize(new CCLConfigurationFactoryImpl());
        configurationLock = new ReentrantLock();
        DISP_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Disp", LogLevel.ERROR);
        newDispatcher = CubingServicesComponentFactory.runningNewDispatcher();
    }

    private static class V5ServerRequest
    extends ReportServerRequest {
        V5ServerRequest(BIBusTKServerComponentFactory factory, BIBusEnvelope anEnvelope, InternetHeaders headers, ReportServerQueue queue, String dispatcherGuid, InteractiveReportExecutingRequests executingRequests) {
            super((RSComponentFactory)factory, anEnvelope, headers, queue, dispatcherGuid, executingRequests);
        }

        public boolean isInProgress() {
            if (ROLAPAsyncBIBusXMLHelper.isAsynchRequest(this.getRequestEnvelope())) {
                return super.isInProgress();
            }
            return false;
        }
    }

    private static final class V5DataServerConnection
    extends ReportServerConnection {
        V5DataServerConnection(RSComponentFactory factory, ConnectionOwner newOwner, int newPoolLocation, boolean affineRequestsOnly) {
            super(factory, newOwner, newPoolLocation, affineRequestsOnly);
        }

        public int sendRequest(String path) throws IOException {
            int result = 500;
            this.setRequestHeader(CubingServicesComponentFactory.SOAPACTION, CubingServicesComponentFactory.SOAP_ACTION_XQE);
            try {
                result = super.sendRequest(path);
            }
            catch (IOException ioe) {
                if (DISP_LOGGER.isOn(LogLevel.ERROR)) {
                    DISP_LOGGER.log(LogLevel.ERROR, "Query Service - V5DataServerConnection.sendRequest failure. ", (Throwable)ioe);
                }
                throw ioe;
            }
            return result;
        }
    }

    private static final class V5DataServerProcess
    extends ReportServerProcess {
        private static final int CONSOLE_MAX_SIZE = 1000;
        private StringBuilder console;
        public static final String HTTPS_PROTOCOL = "https";
        private static final String WINDOWS = "Windows";
        private static final String OS_NAME = "os.name";
        private static final String VALUE_KEY = "[@value]";
        private static final String NAME_KEY = "[@name]";
        private static final String ENABLE_64BIT_JAVA = "-d64";
        private static final String HTTP_PORT = "http.port";
        private static final String INSTALL_DIR = "install.dir";
        private static final String BOOTSTRAP_FILENAME = "bootstrap.properties";
        private static final String SERVER_CONFIG_DIR = System.getProperty("server.config.dir");
        private static final String DATASET_SERVICE_NAME = "dataset-service";
        private static final String PARENT_DIR = "..";
        private static final String DSS_BOOTSTRAP_PROPERTIES_FILE = new StringJoiner(File.separator).add(SERVER_CONFIG_DIR).add("..").add("dataset-service").add("bootstrap.properties").toString();
        private static final int PORT_RANGE = 100;
        private static HttpClient statusHttpClient = null;
        private static final String NULL_BODY_EXCEPTION_MSG = "Response Body is null.";
        private int processID = 0;
        private static final String LOGGER_NAME = "Audit.RTUsage.XQE.V5DataServer";
        private static final String COMP_NAME = "XQE";
        private static final String OPERATION_NAME = "StartService";

        public int getProcessID() {
            return this.processID;
        }

        protected boolean readPort() {
            return false;
        }

        private boolean is64bitSunJavaOnUnix() {
            String vendor;
            String bit;
            String os = System.getProperty(OS_NAME);
            return os != null && !os.contains(WINDOWS) && "64".equals(bit = System.getProperty("sun.arch.data.model")) && (vendor = System.getProperty("java.vendor")) != null && !vendor.contains("IBM");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() throws Exception {
            configurationLock.lock();
            try {
                int parentProcessPort;
                String installDir = System.getProperty(INSTALL_DIR);
                int wlpPort = this.setupServerPort();
                V5DataServerProcess.saveBootstrapProperties(installDir, wlpPort);
                List<String> commandLine = CubingServicesConnectionFactory.getCommandLine();
                XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
                CubingServicesConnectionFactory.removeDQServerFilestamps(config);
                try (ServerSocket serverSocket = null;){
                    URL dispURL = V5DataServerProcess.getDispatcherURL();
                    int callbackPort = 0;
                    if (config != null) {
                        callbackPort = config.getIntProperty("network.dispatcherCallback[@port]", 0);
                    }
                    if (dispURL.getProtocol().equalsIgnoreCase(HTTPS_PROTOCOL)) {
                        CryptoProvider.initialize((ICryptoProvider)new CAMCryptoProvider());
                        serverSocket = CryptoProvider.createServerSocket((int)callbackPort, (boolean)true);
                    } else {
                        serverSocket = new ServerSocket(callbackPort);
                    }
                    parentProcessPort = serverSocket.getLocalPort();
                }
                if (this.is64bitSunJavaOnUnix()) {
                    commandLine.add(1, ENABLE_64BIT_JAVA);
                }
                ListIterator<String> it = commandLine.listIterator();
                while (it.hasNext()) {
                    String part = it.next();
                    if (!part.startsWith("-DParentProcessPort=")) continue;
                    it.set("-DParentProcessPort=" + parentProcessPort);
                    break;
                }
                ProcessBuilder pb = CubingServicesComponentFactory.createProcessBuilder(commandLine);
                Map<String, String> env = pb.environment();
                env.remove("JAVA_ENDORSED_DIRS");
                this.setupTuningEnvironmentParams(env);
                this.log("Starting QueryService with the following Environment variables: ", env.toString());
                this.log("Starting QueryService with the following command-line arguments: ", commandLine.toString());
                Process process = pb.start();
                this.setNativeProcess(process);
                Thread t = new Thread(new StreamForwarder(process));
                t.setDaemon(true);
                t.start();
                try {
                    CubingServicesComponentFactory.getLogger().debug("Waiting for QueryService to initialize...");
                    RemoteInfo remoteInfo = this.waitForRemoteInformation(wlpPort);
                    CubingServicesComponentFactory.getLogger().debug("QueryService initialized successfully.");
                    this.setReportServerPort(wlpPort);
                    this.processID = remoteInfo.pid;
                    this.log("Startup of server status: ", this.console.toString());
                }
                catch (Exception ex) {
                    LogTypedLogger logger = LogTypedLogger.getInstance((String)LOGGER_NAME, LogAuditIndication.class);
                    LogAuditAccessIndication indication = new LogAuditAccessIndication(COMP_NAME, 0);
                    indication.setLevel(50000);
                    indication.setThreadID(String.valueOf(Thread.currentThread().getId()));
                    indication.setOperation(OPERATION_NAME);
                    indication.setLogData("QueryService failed to start with the following command-line arguments: " + commandLine.toString() + " with console output: " + this.console);
                    logger.log((Object)indication);
                    this.stopProcess(process);
                    throw ex;
                }
                this.console = null;
            }
            catch (Exception e) {
                CubingServicesComponentFactory.getLogger().debug("Exception thrown during start ", (Throwable)e);
                throw e;
            }
            finally {
                configurationLock.unlock();
            }
        }

        private void stopProcess(Process process) {
            try {
                V5DataServerProcessFacade.sendAction(CubingServicesComponentFactory.STOP);
                process.destroy();
            }
            catch (Exception e) {
                CubingServicesComponentFactory.getLogger().debug("Exception thrown while trying to stop server ", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RemoteInfo waitForRemoteInformation(int port) throws Exception {
            RemoteInfo remoteInfo = new RemoteInfo();
            Exception lastException = new RuntimeException("Something went wrong with the dataset-service status request...");
            String dssPingUrl = V5DataServerProcess.createPingUrl(port);
            URI uri = new URI(dssPingUrl, false);
            HttpClient httpClient = V5DataServerProcess.getStatusHTTPClient(dssPingUrl);
            GetMethod getMethod = new GetMethod();
            if (dssPingUrl.startsWith(HTTPS_PROTOCOL)) {
                getMethod.setPath(uri.getPath());
            } else {
                getMethod.setURI(uri);
            }
            long begin = System.nanoTime();
            while ((double)(System.nanoTime() - begin) / 1000000.0 < 300000.0) {
                try {
                    int statusCode = httpClient.executeMethod((HttpMethod)getMethod);
                    if (statusCode == 200) {
                        String responseBody = getMethod.getResponseBodyAsString();
                        if (responseBody != null) {
                            JSONObject rObject = (JSONObject)JSON.parse((String)responseBody);
                            if (!"running".equals(rObject.get((Object)CubingServicesComponentFactory.STATUS_KEY))) continue;
                            remoteInfo.pid = Integer.parseInt(rObject.get((Object)"pid").toString());
                            break;
                        }
                        throw new NullPointerException(NULL_BODY_EXCEPTION_MSG);
                    }
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    lastException = e;
                    Thread.sleep(5000L);
                }
                finally {
                    getMethod.releaseConnection();
                }
            }
            if (remoteInfo.pid == 0) {
                throw lastException;
            }
            return remoteInfo;
        }

        public static synchronized HttpClient getStatusHTTPClient(String dssStatusUrl) throws URIException, CAMCryptoException {
            URI uri = new URI(dssStatusUrl, false);
            if (null == statusHttpClient) {
                statusHttpClient = dssStatusUrl.startsWith(HTTPS_PROTOCOL) ? CryptoFacility.getCAMFactory().createSecurePooledHttpClient(uri.getHost(), uri.getPort()) : new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
            } else if (dssStatusUrl.startsWith(HTTPS_PROTOCOL) && null != statusHttpClient.getHostConfiguration() && uri.getPort() != statusHttpClient.getHostConfiguration().getPort()) {
                statusHttpClient = CryptoFacility.getCAMFactory().createSecurePooledHttpClient(uri.getHost(), uri.getPort());
            }
            return statusHttpClient;
        }

        public static String createPingUrl(int port) throws MalformedURLException, CCLConfigurationException, UnknownHostException {
            URL internalDispURL = V5DataServerProcess.getDispatcherURL();
            String servletPath = CubingServicesConnectionFactory.getServletPath();
            String path = servletPath.substring(0, servletPath.lastIndexOf("/"));
            return internalDispURL.getProtocol() + "://" + internalDispURL.getHost() + ":" + port + path + "/service-status";
        }

        private void setupTuningEnvironmentParams(Map<String, String> env) {
            String os = System.getProperty(OS_NAME);
            if (os.startsWith(WINDOWS)) {
                os = WINDOWS;
            }
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            boolean override = configuration.getBooleanProperty("environment[@override]", false);
            XQESubConfiguration tuningConfig = configuration.getChildren("environment.os");
            while (tuningConfig.hasNext()) {
                tuningConfig.next();
                String name = tuningConfig.getString(NAME_KEY, "");
                if (!os.equals(name)) continue;
                XQESubConfiguration envvars = tuningConfig.getChildren("envvar");
                while (envvars.hasNext()) {
                    envvars.next();
                    String var = envvars.getString(NAME_KEY, null);
                    String val = envvars.getString(VALUE_KEY, null);
                    if (override) {
                        env.put(var, val);
                        continue;
                    }
                    if (env.containsKey(var)) continue;
                    env.put(var, val);
                }
            }
        }

        public static URL getDispatcherURL() throws CCLConfigurationException, MalformedURLException {
            ICCLConfiguration cclConfig = XQECCLConfigurationFactory.getInstance();
            String dispAddr = cclConfig.getValue("internalDispatcher", false);
            return new URL(dispAddr);
        }

        private int setupServerPort() {
            int serverPort = this.getReportServerPort();
            if (serverPort == 0) {
                try {
                    Properties properties = V5DataServerProcess.getBootstrapProperties();
                    boolean malformedPortDetected = false;
                    try {
                        serverPort = Integer.parseInt(properties.getProperty(HTTP_PORT));
                    }
                    catch (NumberFormatException ne) {
                        CubingServicesComponentFactory.getLogger().warn("Malformed port number detected. Attempting to assign port automatically.", (Throwable)ne);
                        malformedPortDetected = true;
                    }
                    if (serverPort == 0 || malformedPortDetected) {
                        serverPort = V5DataServerProcess.findPort();
                    }
                }
                catch (Exception e) {
                    CubingServicesComponentFactory.getLogger().error("Unable to setup wlp port", (Throwable)e);
                }
            }
            return serverPort;
        }

        /*
         * Loose catch block
         */
        private static Properties getBootstrapProperties() throws ConfigurationException {
            Properties props = new Properties();
            FileInputStream in = null;
            try {
                in = new FileInputStream(DSS_BOOTSTRAP_PROPERTIES_FILE);
                props.load(in);
            }
            catch (FileNotFoundException e) {
                CubingServicesComponentFactory.getLogger().error("Cannot find bootstrap.properties file for dataset-service.", (Throwable)e);
                IOUtils.closeQuietly((InputStream)in);
            }
            catch (IOException e2) {
                CubingServicesComponentFactory.getLogger().error("Cannot load bootstrap.properties file for dataset-service.", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)in);
            }
            IOUtils.closeQuietly((InputStream)in);
            return props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void saveBootstrapProperties(String installDir, int wlpPort) {
            File dssBootstrapFile = new File(DSS_BOOTSTRAP_PROPERTIES_FILE);
            FileOutputStream out = null;
            try {
                Properties props = V5DataServerProcess.getBootstrapProperties();
                dssBootstrapFile.delete();
                dssBootstrapFile.createNewFile();
                out = new FileOutputStream(dssBootstrapFile);
                props.setProperty(INSTALL_DIR, installDir);
                props.setProperty(HTTP_PORT, String.valueOf(wlpPort));
                props.store(out, null);
                IOUtils.closeQuietly((OutputStream)out);
            }
            catch (Exception e) {
                CubingServicesComponentFactory.getLogger().error("Unable to update the bootstrap.properties file", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly(out);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Set<Integer> getAvailablePorts(int fromPort, int toPort) {
            TreeSet<Integer> result = new TreeSet<Integer>();
            for (int i = fromPort; i <= toPort; ++i) {
                ServerSocket s = null;
                try {
                    s = new ServerSocket(i);
                    result.add(i);
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                finally {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean available(int port) {
            ServerSocket s = null;
            try {
                s = new ServerSocket(port);
                s.setReuseAddress(true);
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return false;
        }

        private static int findPort() throws MalformedURLException, CCLConfigurationException {
            int port = 0;
            int dispatcherPort = V5DataServerProcess.getDispatcherURL().getPort();
            Set<Integer> availablePorts = V5DataServerProcess.getAvailablePorts(dispatcherPort + 1, dispatcherPort + 100);
            for (int current : availablePorts) {
                if (!V5DataServerProcess.available(current)) continue;
                port = current;
                break;
            }
            if (port == 0) {
                throw new XQERuntimeException(XQEMessageKeys.CFG_FailToFindPort);
            }
            return port;
        }

        private void log(String msg, String data) {
            LogTypedLogger logger = LogTypedLogger.getInstance((String)LOGGER_NAME, LogAuditIndication.class);
            LogAuditAccessIndication indication = new LogAuditAccessIndication(COMP_NAME, 0);
            indication.setLevel(10000);
            indication.setThreadID(String.valueOf(Thread.currentThread().getId()));
            indication.setOperation(OPERATION_NAME);
            indication.setLogData(msg + data);
            logger.log((Object)indication);
            XQELogger xqeLogger = XQELog.getLogger(ServiceEnumeration.XQE, COMP_NAME, "InitTerm", LogLevel.ERROR);
            if (xqeLogger.isOn(LogLevel.TRACE)) {
                xqeLogger.log(LogLevel.TRACE, msg + data);
            }
        }

        V5DataServerProcess(String[] args, String workingDir) {
            super(args, workingDir);
        }

        private class StreamForwarder
        implements Runnable {
            private final Process process;

            StreamForwarder(Process p) {
                this.process = p;
                V5DataServerProcess.this.console = new StringBuilder(1000);
            }

            @Override
            public void run() {
                byte[] buffer = new byte[8192];
                int bytesRead = -1;
                try {
                    InputStream inStream = this.process.getInputStream();
                    bytesRead = inStream.read(buffer);
                    while (bytesRead != -1) {
                        System.out.write(buffer, 0, bytesRead);
                        if (V5DataServerProcess.this.console != null && V5DataServerProcess.this.console.length() < 1000) {
                            String output = new String(buffer, 0, bytesRead);
                            V5DataServerProcess.this.console.append(output);
                        }
                        bytesRead = inStream.read(buffer);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }

        class RemoteInfo {
            int pid = 0;

            RemoteInfo() {
            }
        }
    }

    private static final class SOAPBodyGenerator
    implements MsgBodyGenerator {
        private final SOAPMessageOutputter messageOutputter;

        SOAPBodyGenerator(SOAPMessageOutputter newMessageOutputter) {
            this.messageOutputter = newMessageOutputter;
        }

        public void writeBody(OutputStream os) throws IOException {
            this.messageOutputter.setOutputStream(os);
            this.messageOutputter.write();
        }

        public boolean rewind() {
            return this.messageOutputter.canResend();
        }
    }

    protected static final class V5DataServerProcessFacade
    extends ProcessFacade {
        private static final String CONTENT_TYPE = "text/xml;charset=utf-8";

        public V5DataServerProcessFacade(RSComponentFactory componentfactory, String[] args, Element config, String host, int port, boolean ssl, int pid, ReportServerQueueCallback callback, int maxAffineConnectionCount, int maxNonAffineConnectionCount, Element cclconfig, ProcessManager theManager) throws Exception {
            super(componentfactory, args, config, host, port, ssl, pid, callback, maxAffineConnectionCount, maxNonAffineConnectionCount, cclconfig, theManager);
        }

        public void setupConnectionPool(ReportServerConnectionPool aPool, boolean affineOnly, boolean getMethod) {
            super.setupConnectionPool(aPool, affineOnly, getMethod);
            aPool.setDisposeUponFailure(false);
        }

        public boolean isAlive() {
            try {
                ReportServerProcess proc = this.getServerProcess();
                if (proc != null) {
                    proc.getNativeProcess().exitValue();
                }
                return false;
            }
            catch (IllegalThreadStateException e) {
                try {
                    String statusEndpoint = V5DataServerProcess.createPingUrl(this.getReportServerPort());
                    return V5DataServerProcessFacade.getShutdownStatus(statusEndpoint);
                }
                catch (Exception ex) {
                    DISP_LOGGER.log(LogLevel.ERROR, "Query Service Status Endpoint is a malformed URL. ", (Throwable)ex);
                    return true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean getShutdownStatus(String statusEndpoint) {
            boolean isUpAndRunning;
            block8: {
                isUpAndRunning = true;
                GetMethod getMethod = new GetMethod();
                try {
                    URI uri = new URI(statusEndpoint, false);
                    HttpClient httpClient = V5DataServerProcess.getStatusHTTPClient(statusEndpoint);
                    if (statusEndpoint.startsWith("https")) {
                        getMethod.setPath(uri.getPath());
                    } else {
                        getMethod.setURI(uri);
                    }
                    int statusCode = httpClient.executeMethod((HttpMethod)getMethod);
                    if (statusCode != 200) break block8;
                    String responseBody = getMethod.getResponseBodyAsString();
                    if (responseBody != null) {
                        JSONObject rObject = (JSONObject)JSON.parse((String)responseBody);
                        if ("shutdown".equals(rObject.get((Object)CubingServicesComponentFactory.STATUS_KEY))) {
                            isUpAndRunning = false;
                        }
                        break block8;
                    }
                    throw new NullPointerException("Response Body is null.");
                }
                catch (Exception exception) {
                }
                finally {
                    getMethod.releaseConnection();
                }
            }
            return isUpAndRunning;
        }

        private static boolean sendAction(String action) {
            CubingServicesComponentFactory.getLogger().debug("Sending action " + action);
            ArrayList<String> commandLine = new ArrayList<String>(CubingServicesConnectionFactory.getSimpleCommandLine());
            commandLine.add(action);
            ProcessBuilder processBuilder = CubingServicesComponentFactory.createProcessBuilder(commandLine);
            try {
                Process stopProcess = processBuilder.start();
                int exitValue = stopProcess.waitFor();
                CubingServicesComponentFactory.getLogger().debug("finished action " + action + " exit value= " + exitValue);
                return exitValue == 0;
            }
            catch (IOException e) {
                CubingServicesComponentFactory.getLogger().debug("IOException sending action ", (Throwable)e);
            }
            catch (InterruptedException e) {
                CubingServicesComponentFactory.getLogger().debug("InterruptedException sending action ", (Throwable)e);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendStop() {
            try {
                CubingServicesComponentFactory.getLogger().info("Query Service - V5DataServerProcessFacade.sendStop. ");
                StandaloneServerConnection connection = new StandaloneServerConnection(this.getReportServerHost(), this.getReportServerPort(), this.getIsSSL());
                try {
                    BIBusEnvelope requestEnvelope = new BIBusEnvelope();
                    Element soapBody = requestEnvelope.getBody();
                    soapBody.addElement("shutdown");
                    SOAPMessageOutputter messageOutputter = new SOAPMessageOutputter((SOAPXMLSource)requestEnvelope, null, null);
                    connection.setRequestHeader(CubingServicesComponentFactory.SOAPACTION, CubingServicesComponentFactory.SOAP_ACTION_XQE);
                    connection.setRequestContentType(CONTENT_TYPE);
                    connection.setRequestBodySource((MsgBodyGenerator)new SOAPBodyGenerator(messageOutputter));
                    connection.setSocketTimeout(60000);
                    try {
                        connection.sendRequest(CubingServicesConnectionFactory.getServletPath());
                    }
                    finally {
                        InputStream isResponse = connection.getInputStream();
                        if (isResponse != null) {
                            isResponse.close();
                        }
                    }
                }
                catch (IOException e) {
                    CubingServicesComponentFactory.getLogger().error("Query Service - V5DataServerProcessFacade.sendStop failure. ", (Throwable)e);
                }
                finally {
                    connection.release();
                }
                V5DataServerProcessFacade.sendAction(CubingServicesComponentFactory.STOP);
            }
            finally {
                this.disposePools();
            }
        }

        protected void configureProcess() throws IOException {
            configurationLock.lock();
            try {
                this.sendRuntimeConfiguration("configure");
            }
            finally {
                configurationLock.unlock();
            }
        }

        protected void reconfigureProcess(Configuration config) throws IOException {
            configurationLock.lock();
            try {
                this.sendRuntimeConfiguration("reconfigure");
            }
            finally {
                configurationLock.unlock();
            }
        }

        protected static void updateConfiguration(Configuration config) {
            configurationLock.lock();
            try {
                CubingServicesConnectionFactory.setCurrentConfiguration(config);
                CubingServicesConnectionFactory.reconstructCommandLine(config);
            }
            finally {
                configurationLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendRuntimeConfiguration(String requestType) throws IOException {
            StandaloneServerConnection connection = new StandaloneServerConnection(this.getReportServerHost(), this.getReportServerPort(), this.getIsSSL());
            CubingServicesComponentFactory.getLogger().debug("sendRuntimeConfiguration starting");
            try {
                Configuration currentConfig = CubingServicesConnectionFactory.getCurrentConfiguration();
                Element cmResponseElement = currentConfig.getCmResponse("queryService");
                BIBusEnvelope requestEnvelope = new BIBusEnvelope();
                Element soapBody = requestEnvelope.getBody();
                Element configureElement = soapBody.addElement("configure");
                configureElement.addAttribute("requestType", requestType);
                configureElement.add(cmResponseElement);
                SOAPMessageOutputter messageOutputter = new SOAPMessageOutputter((SOAPXMLSource)requestEnvelope, null, null);
                connection.setRequestHeader(CubingServicesComponentFactory.SOAPACTION, CubingServicesComponentFactory.SOAP_ACTION_XQE);
                connection.setRequestContentType(CONTENT_TYPE);
                connection.setRequestBodySource((MsgBodyGenerator)new SOAPBodyGenerator(messageOutputter));
                connection.setSocketTimeout(60000);
                connection.sendRequest(CubingServicesConnectionFactory.getServletPath());
                CubingServicesComponentFactory.getLogger().debug("sendRuntimeConfiguration done");
            }
            finally {
                InputStream isResponse = connection.getInputStream();
                if (isResponse != null) {
                    isResponse.close();
                }
                connection.release();
            }
        }

        public boolean isIdle() {
            return false;
        }

        public boolean isExpired() {
            return false;
        }
    }
}

