/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices;

import com.cognos.cclcfgapi.CCLConfigurationUtils;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.async.AsyncContext;
import com.cognos.pogo.async.service.connection.IConnection;
import com.cognos.pogo.async.service.connection.bibustkserver.BIBusTKServerConnection;
import com.cognos.pogo.async.service.connection.bibustkserver.BIBusTKServerConnectionFactory;
import com.cognos.pogo.async.service.connection.bibustkserver.BIBusTKServerRequestInvoker;
import com.cognos.pogo.monitoring.QueueableRequestReporter;
import com.cognos.pogo.monitoring.ServiceStatus;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationAdapter;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.config.XQESubConfiguration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPConfiguration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqebifw.adminconsole.fragmentproducer.registration.AdminConsoleAutoRegistration;
import com.cognos.xqebifw.cubingservices.DQServer;
import com.cognos.xqebifw.cubingservices.QueryServiceRequestReporter;
import com.cognos.xqebifw.cubingservices.V5ServerProcessException;
import com.cognos.xqebifw.management.cogadmin.AdminConsoleMetricsMBean;
import com.cognos.xqebifw.metrics.XqeSystemMetricsManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.dom4j.Element;

public class CubingServicesConnectionFactory
extends BIBusTKServerConnectionFactory {
    private static final int SERVER_COMMAND_LCATION_START = 4;
    private static final String JAVA_VENDOR = "java.vendor";
    private static final String DATA_DIRECTORY = "data";
    private static final String DRIVERS_DIRECTORY = "drivers";
    private static final String PARENT_DIRECTORY = "..";
    private static final String ASTERISK = "*";
    private static final String SPACE = " ";
    private static final String XMS = "-Xms";
    private static final String XMX = "-Xmx";
    private static final String JVM_VENDOR_IBM = "IBM";
    private static final String MB = "m";
    private static final int DEFAULT_MAX_NURSERY_SMALL_HEAP_SIZE_DIVISOR = 2;
    private static final int DEFAULT_MAX_NURSERY_LARGE_HEAP_SIZE_DIVISOR = 6;
    private static final int DEFAULT_MAX_NURSERY_LARGE_HEAP_THRESHOLD = 10240;
    private static final int CM_SYSTEM_GENERATE_NURSERY_SIZE = 0;
    private static final int ONE_K = 1024;
    private static final String JVM_VENDOR_OPTIONS_KEY = "jvm.vendor";
    private static final String JVM_NAME_KEY = "[@name]";
    private static final String JVM_OPTIONS_KEY = "[@options]";
    private static String operationalStatus = ServiceStatus.PARTIALLYAVAILABLE;
    private static Date operationalStatusLastUpdateTime = null;
    private static final String JVM_GC_LOGGING = "-verbose:gc";
    private static final String XMNX = "-Xmnx";
    private static final String XMNS = "-Xmns";
    private static final String IBM_JVM_GC_VERBOSE_LOG = "-Xverbosegclog:";
    private static final String IBM_JVM_GC_VERBOSE_LOG_FILENAME = "dq_verbosegc_%Y%m%d.%H%M%S.%pid.log";
    private static final String COMMA = ",";
    public static final String IBM_BALANCED = "-Xgcpolicy:balanced";
    public static final String IBM_GENERATIONAL = "-Xgcpolicy:gencon";
    public static final String XQE_STAMP_FILENAME = ".xqe.";
    private static final String WINDOWS_EXEC = "cmd.exe /c del /f /s .xqe. > nul";
    private static final String UNIX_EXEC = "rm -f .xqe. > /dev/null";
    private static final String IBM_JVM_OOM = "-Xdump:tool:events=systhrow,filter=java/lang/OutOfMemoryError,exec=";
    private static final String JVM_OOM = "-XX:OnOutOfMemoryError=";
    private static final String JVM_IBM_PID = "%pid";
    private static final String JVM_PID = "%p";
    private static final String IBM_WINDOWS_OUTOFMEMORY = "-Xdump:tool:events=systhrow,filter=java/lang/OutOfMemoryError,exec=cmd.exe /c del /f /s .xqe. > nul";
    private static final String IBM_UNIX_OUTOFMEMORY = "-Xdump:tool:events=systhrow,filter=java/lang/OutOfMemoryError,exec=rm -f .xqe. > /dev/null";
    private static final String WINDOWS_OUTOFMEMORY = "-XX:OnOutOfMemoryError=cmd.exe /c del /f /s .xqe. > nul";
    private static final String UNIX_OUTOFMEMORY = "-XX:OnOutOfMemoryError=rm -f .xqe. > /dev/null";
    private static final String COG_ROOT = "COG_ROOT";
    private static final String XXMAXNEWSIZE = "-XX:MaxNewSize=";
    private static final String XXNEWSIZE = "-XX:NewSize=";
    private static final String JVM_GC_VEBOSE_LOG = "-Xloggc:";
    private static final String JVM_GC_VERBOSE_LOG_FILENAME = "dq_verbosegc.log";
    private static final String[] GENERATIONAL = new String[]{"-XX:+UseConcMarkSweepGC", "-XX:+UseParNewGC", "-XX:SurvivorRatio=8", "-XX:TargetSurvivorRatio=90", "-XX:MaxTenuringThreshold=15"};
    private static final int DEFAULT_VERBOSE_GC_CYCLES_LOGGED = 1000;
    private static final String SIXTY_FOUR = "64";
    private static final double MIN_VM_VERSION = 2.6;
    private static final String SEMI_COLON = ";";
    private static final String BIN = "bin";
    private static final String LIB = "lib";
    private static final int DEFAULT_QUEUE_TIMEOUT_MS = 30000;
    public static final String PARENT_PROCESS_PORT_NAME = "-DParentProcessPort=";
    public static final String PARENT_PROCESS_ID = "-DParentProcessID=";
    public static final String MINUS_D = "-D";
    public static final String EQUAL = "=";
    private static List<Element> dispChildProcCmdList;
    private static Map<String, String> dispInitParamMap;
    private static List<String> commandLine;
    private static List<String> simpleCommandLine;
    private static Configuration currentConfiguration;
    private static String v5DataServerHome;
    private static String servletPath;
    private static final String[] ONE_EMPTY_STRING_ARRAY;
    private static String databaseClasspathLocationFile;
    private static V5ServerProcessException lastError;
    private static XQELogger sLogger;

    public static Date getOperationalStatusLastUpdateTime() {
        return operationalStatusLastUpdateTime;
    }

    public static String getOperationalStatus() {
        return operationalStatus;
    }

    public static void setOperationalStatus(String opStatus) {
        operationalStatus = opStatus;
        operationalStatusLastUpdateTime = new Date(System.currentTimeMillis());
    }

    public void init() {
        this.processManager.setRequestReporter((QueueableRequestReporter)new QueryServiceRequestReporter("QueryService", "queryService"));
    }

    protected static String getServletPath() {
        return servletPath;
    }

    public String[] getProcessArguments(List<Element> childProcCmdList, Map<String, String> initParamMap) {
        dispChildProcCmdList = childProcCmdList;
        dispInitParamMap = initParamMap;
        servletPath = dispInitParamMap.get("worker_request_path");
        return ONE_EMPTY_STRING_ARRAY;
    }

    private static void constructCommandLine(ICCLConfiguration cclConfig) {
        String csHome = dispInitParamMap.get("CS_HOME");
        v5DataServerHome = cclConfig.resolveEffectivePath(csHome);
        StringBuilder strBldr = CubingServicesConnectionFactory.createJavaCommand();
        String javaExecuteable = strBldr.toString();
        File java = new File(javaExecuteable);
        if (!java.exists()) {
            lastError = new V5ServerProcessException(XQEMessageKeys.GEN_JVMLoadError, javaExecuteable);
            throw lastError;
        }
        databaseClasspathLocationFile = v5DataServerHome + File.separator + "databaseDriverLocations.properties";
        Properties databaseLocationProperties = CubingServicesConnectionFactory.loadDatabaseDriverLocationProperties();
        commandLine.add(javaExecuteable);
        String vendor = System.getProperty(JAVA_VENDOR);
        String vmVersion = System.getProperty("java.vm.version");
        String arch = System.getProperty("sun.arch.data.model");
        if (sLogger.isOn(LogLevel.TRACE)) {
            sLogger.log(LogLevel.TRACE, "Setting JVM parameters for " + vendor);
        }
        String jvmMaxNurserySizeFlag = XMNX;
        String jvmInitialNurserySizeFlag = XMNS;
        if (!CubingServicesConnectionFactory.isIBMJava()) {
            jvmMaxNurserySizeFlag = XXMAXNEWSIZE;
            jvmInitialNurserySizeFlag = XXNEWSIZE;
        }
        int unspecifiedHeapSize = -1;
        int jvmInitialHeapSizeFromRolapConfig = -1;
        int jvmMaxHeapSizeFromRolapConfig = -1;
        int jvmMaxNurseryHeapSizeFromRolapConfig = -1;
        int jvmInitialNurseryHeapSizeFromRolapConfig = -1;
        String additionalJVMArgsFromRolapConfig = null;
        ROLAPConfiguration rolapConfiguration = ROLAPConfiguration.loadLocalConfig();
        if (rolapConfiguration != null) {
            if (rolapConfiguration.isParameterSpecifiedInLocalConfigFile(ROLAPConfiguration.JVM_INITIAL_HEAP_SIZE_QNAME.getLocalPart())) {
                jvmInitialHeapSizeFromRolapConfig = rolapConfiguration.getInitialJVMHeapSize();
            }
            if (rolapConfiguration.isParameterSpecifiedInLocalConfigFile(ROLAPConfiguration.JVM_MAX_HEAP_SIZE_QNAME.getLocalPart())) {
                jvmMaxHeapSizeFromRolapConfig = rolapConfiguration.getMaxJVMHeapSize();
            }
            if (rolapConfiguration.isParameterSpecifiedInLocalConfigFile(ROLAPConfiguration.JVM_ADDITIONAL_ARGS_QNAME.getLocalPart()) && (additionalJVMArgsFromRolapConfig = rolapConfiguration.getAdditionalJVMArgs()) != null && additionalJVMArgsFromRolapConfig.length() > 0) {
                jvmMaxNurseryHeapSizeFromRolapConfig = CubingServicesConnectionFactory.getMemorySize(new StringBuilder(additionalJVMArgsFromRolapConfig), jvmMaxNurserySizeFlag, -1);
                jvmInitialNurseryHeapSizeFromRolapConfig = CubingServicesConnectionFactory.getMemorySize(new StringBuilder(additionalJVMArgsFromRolapConfig), jvmInitialNurserySizeFlag, -1);
            }
            if (jvmMaxNurseryHeapSizeFromRolapConfig == -1 && jvmMaxHeapSizeFromRolapConfig != -1) {
                jvmMaxNurseryHeapSizeFromRolapConfig = CubingServicesConnectionFactory.calculateJvmMaxNurseryHeapSize(jvmMaxHeapSizeFromRolapConfig);
            }
            if (jvmInitialNurseryHeapSizeFromRolapConfig == -1 && jvmInitialHeapSizeFromRolapConfig != -1) {
                jvmInitialNurseryHeapSizeFromRolapConfig = CubingServicesConnectionFactory.calculateJvmMaxNurseryHeapSize(jvmInitialHeapSizeFromRolapConfig);
            }
        }
        if (sLogger.isOn(LogLevel.TRACE)) {
            if (rolapConfiguration == null) {
                sLogger.log(LogLevel.TRACE, "xqe.rolap.dev.config.xml JVM settings do not exist.");
            } else {
                sLogger.log(LogLevel.TRACE, String.format("xqe.rolap.dev.config.xml JVM settings: %s=%s, %s=%s, %s=\"%s\" (%s%s%s) (%s%s%s)", ROLAPConfiguration.JVM_INITIAL_HEAP_SIZE_QNAME.getLocalPart(), jvmInitialHeapSizeFromRolapConfig, ROLAPConfiguration.JVM_MAX_HEAP_SIZE_QNAME.getLocalPart(), jvmMaxHeapSizeFromRolapConfig, ROLAPConfiguration.JVM_ADDITIONAL_ARGS_QNAME.getLocalPart(), additionalJVMArgsFromRolapConfig, jvmMaxNurserySizeFlag, jvmMaxNurseryHeapSizeFromRolapConfig, MB, jvmInitialNurserySizeFlag, jvmInitialNurseryHeapSizeFromRolapConfig, MB));
            }
        }
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        int jvmInitialHeapSizeFromCM = configuration.getIntProperty("jvm.qsInitialJVMHeapSize", -1);
        int jvmMaxHeapSizeFromCM = configuration.getIntProperty("jvm.qsJVMHeapSizeLimit", -1);
        String jvmAdditionalArgsFromCM = CubingServicesConnectionFactory.escapeArgument(configuration.getStringProperty("jvm.qsAdditionalJVMArguments", ""));
        int jvmMaxNurserySizeFromCM = configuration.getIntProperty("jvm.qsJVMNurserySizeLimit", -1);
        int jvmInitialNurserySizeFromCM = configuration.getIntProperty("jvm.qsInitialJVMNurserySize", -1);
        boolean jvmDisableVerboseGCLogging = configuration.getBooleanProperty("jvm.qsDisableVerboseGCLogging", false);
        int jvmVerboseGCLogLimit = configuration.getIntProperty("jvm.qsVerboseGCLogLimit", 1000);
        String jvmGCPolicy = configuration.getStringProperty("jvm.qsGCPolicy", "http://developer.cognos.com/ceba/constants/gcPolicyEnum#Generational");
        if (sLogger.isOn(LogLevel.TRACE)) {
            sLogger.log(LogLevel.TRACE, String.format("CM JVM settings: %s=%s, %s=%s, %s=\"%s\", %s=%s, %s=%s, %s=%s, %s=%s, %s=%s)", "qsInitialJVMHeapSize", jvmInitialHeapSizeFromCM, "qsJVMHeapSizeLimit", jvmMaxHeapSizeFromCM, "qsAdditionalJVMArguments", jvmAdditionalArgsFromCM, "qsInitialJVMNurserySize", jvmMaxNurserySizeFromCM, "qsJVMNurserySizeLimit", jvmInitialNurserySizeFromCM, "qsDisableVerboseGCLogging", jvmDisableVerboseGCLogging, "qsVerboseGCLogLimit", jvmVerboseGCLogLimit, "qsGCPolicy", jvmGCPolicy));
        }
        int jvmMaxHeapSizeFromXQE = -1;
        XQESubConfiguration jvmConfig = configuration.getChildren(JVM_VENDOR_OPTIONS_KEY);
        StringBuilder options = new StringBuilder();
        while (jvmConfig.hasNext()) {
            jvmConfig.next();
            String name = jvmConfig.getString(JVM_NAME_KEY, "");
            if ("all".equals(name)) {
                options.append(jvmConfig.getString(JVM_OPTIONS_KEY, ""));
                options.append(SPACE);
                if (jvmMaxHeapSizeFromXQE != -1) continue;
                jvmMaxHeapSizeFromXQE = CubingServicesConnectionFactory.getMemorySize(options, XMX, -1);
                continue;
            }
            if (!vendor.equals(name)) continue;
            String opt = CubingServicesConnectionFactory.escapeArgument(jvmConfig.getString(JVM_OPTIONS_KEY, ""));
            options.append(opt);
            options.append(SPACE);
            if (jvmMaxHeapSizeFromXQE == -1) {
                jvmMaxHeapSizeFromXQE = CubingServicesConnectionFactory.getMemorySize(options, XMX, -1);
            }
            if (!arch.equals(SIXTY_FOUR)) continue;
            int maxMemory = Integer.MAX_VALUE;
            int max = Integer.parseInt(jvmConfig.getString("[@max]", "0"));
            if (jvmMaxHeapSizeFromCM != -1) {
                maxMemory = jvmMaxHeapSizeFromCM;
            }
            if (jvmMaxHeapSizeFromXQE != -1) {
                maxMemory = jvmMaxHeapSizeFromXQE;
            }
            if (jvmMaxHeapSizeFromRolapConfig != -1) {
                maxMemory = jvmMaxHeapSizeFromRolapConfig;
            }
            if (maxMemory <= max) {
                options.append(jvmConfig.getString("[@compressedrefs]", ""));
                options.append(SPACE);
                continue;
            }
            sLogger.log(LogLevel.INFO, "Not using compressed refs");
        }
        int jvmInitialHeapSize = 1024;
        int jvmMaxHeapSize = 1024;
        int jvmMaxNurseryHeapSize = -1;
        int jvmInitialNurseryHeapSize = -1;
        if (jvmInitialHeapSizeFromCM != -1) {
            jvmInitialHeapSize = jvmInitialHeapSizeFromCM;
        }
        if (jvmMaxHeapSizeFromCM != -1) {
            jvmMaxHeapSize = jvmMaxHeapSizeFromCM;
        }
        if (jvmMaxNurserySizeFromCM != 0) {
            jvmMaxNurseryHeapSize = jvmMaxNurserySizeFromCM;
        }
        if (jvmInitialNurserySizeFromCM != 0) {
            jvmInitialNurseryHeapSize = jvmInitialNurserySizeFromCM;
        }
        if (jvmMaxHeapSizeFromXQE != -1) {
            jvmMaxHeapSize = jvmMaxHeapSizeFromXQE;
        }
        if (jvmInitialHeapSizeFromRolapConfig != -1) {
            jvmInitialHeapSize = jvmInitialHeapSizeFromRolapConfig;
        }
        if (jvmMaxHeapSizeFromRolapConfig != -1) {
            jvmMaxHeapSize = jvmMaxHeapSizeFromRolapConfig;
        }
        if (jvmMaxNurseryHeapSizeFromRolapConfig != -1) {
            jvmMaxNurseryHeapSize = jvmMaxNurseryHeapSizeFromRolapConfig;
        }
        if (jvmInitialNurseryHeapSizeFromRolapConfig != -1) {
            jvmInitialNurseryHeapSize = jvmInitialNurseryHeapSizeFromRolapConfig;
        }
        if (jvmMaxNurseryHeapSize == -1) {
            jvmMaxNurseryHeapSize = CubingServicesConnectionFactory.calculateJvmMaxNurseryHeapSize(jvmMaxHeapSize);
        }
        if (jvmInitialNurseryHeapSize == -1) {
            jvmInitialNurseryHeapSize = CubingServicesConnectionFactory.calculateJvmMaxNurseryHeapSize(jvmInitialHeapSize);
        }
        if (sLogger.isOn(LogLevel.TRACE)) {
            sLogger.log(LogLevel.TRACE, String.format("Validating JVM heap sizes: %s%s%s, %s%s%s, %s%s%s, %s%s%s", XMS, jvmInitialHeapSize, MB, XMX, jvmMaxHeapSize, MB, jvmMaxNurserySizeFlag, jvmMaxNurseryHeapSize, MB, jvmInitialNurserySizeFlag, jvmInitialNurseryHeapSize, MB));
        }
        if (jvmInitialHeapSize < 0) {
            sLogger.log(String.format("Error: initial heap size (%s) < 0.  Will set initial heap size to %s.", jvmInitialHeapSize, 1024));
            jvmInitialHeapSize = 1024;
        }
        if (jvmMaxHeapSize < 0) {
            sLogger.log(String.format("Error: maximum heap size (%s) < 0.  Will set maximum heap size to %s.", jvmMaxHeapSize, 1024));
            jvmMaxHeapSize = 1024;
        }
        if (jvmMaxNurseryHeapSize < 0) {
            jvmMaxNurseryHeapSize = CubingServicesConnectionFactory.calculateJvmMaxNurseryHeapSize(jvmMaxHeapSize);
            sLogger.log(String.format("Error: maximum nursery heap size (%s) < 0.  Will set maximum nursery heap size to default value %s.", jvmMaxNurseryHeapSize, jvmMaxNurseryHeapSize));
        }
        if (jvmInitialNurseryHeapSize < 0) {
            sLogger.log(String.format("Error: Initial nursery heap size (%s) < 0.  Will set initial nursery heap size to maximum nursery heap size (%s).", jvmInitialNurseryHeapSize, jvmMaxNurseryHeapSize));
            jvmInitialNurseryHeapSize = jvmMaxNurseryHeapSize;
        }
        if (jvmInitialHeapSize > jvmMaxHeapSize) {
            sLogger.log(String.format("Error: initial heap size (%s) > maximum heap size (%s).  Will set initial heap size to maximum heap size.", jvmInitialHeapSize, jvmMaxHeapSize));
            jvmInitialHeapSize = jvmMaxHeapSize;
        }
        if (jvmMaxNurseryHeapSize > jvmMaxHeapSize) {
            jvmMaxNurseryHeapSize = CubingServicesConnectionFactory.calculateJvmMaxNurseryHeapSize(jvmMaxHeapSize);
            sLogger.log(String.format("Error: maximum nursery heap size (%s) > maximum heap size (%s).  Will set maximum nursery heap size to %s.", jvmMaxNurseryHeapSize, jvmMaxHeapSize, jvmMaxNurseryHeapSize));
        }
        if (jvmInitialNurseryHeapSize > jvmMaxNurseryHeapSize) {
            sLogger.log(String.format("Error: Initial nursery heap size (%s) > maximum nursery heap size (%s).  Will set initial nursery heap size to maximum heap size.", jvmInitialNurseryHeapSize, jvmMaxNurseryHeapSize));
            jvmInitialNurseryHeapSize = jvmMaxNurseryHeapSize;
        }
        if (sLogger.isOn(LogLevel.TRACE)) {
            sLogger.log(LogLevel.TRACE, String.format("Using JVM heap sizes: %s%s%s, %s%s%s, %s%s%s, %s%s%s", XMS, jvmInitialHeapSize, MB, XMX, jvmMaxHeapSize, MB, jvmMaxNurserySizeFlag, jvmMaxNurseryHeapSize, MB, jvmInitialNurserySizeFlag, jvmInitialNurseryHeapSize, MB));
        }
        commandLine.add(XMS + jvmInitialHeapSize + MB);
        commandLine.add(XMX + jvmMaxHeapSize + MB);
        commandLine.add(jvmMaxNurserySizeFlag + jvmMaxNurseryHeapSize + MB);
        commandLine.add(jvmInitialNurserySizeFlag + jvmInitialNurseryHeapSize + MB);
        String[] ignoreOptions = new String[]{XMNX, XMNS, jvmMaxNurserySizeFlag, jvmInitialNurserySizeFlag};
        if (additionalJVMArgsFromRolapConfig != null) {
            CubingServicesConnectionFactory.addOptionsToCommandLine(additionalJVMArgsFromRolapConfig, "xqe.rolap.dev.config.xml", ignoreOptions);
        } else {
            CubingServicesConnectionFactory.addOptionsToCommandLine(jvmAdditionalArgsFromCM, "CM", ignoreOptions);
        }
        String[] ignoreOptionsXQE = new String[]{XMX, XMNX, XMNS, jvmMaxNurserySizeFlag, jvmInitialNurserySizeFlag};
        if (options != null) {
            CubingServicesConnectionFactory.addOptionsToCommandLine(options.toString(), "xqe.config.xml", ignoreOptionsXQE);
        }
        if (!jvmDisableVerboseGCLogging) {
            commandLine.add(JVM_GC_LOGGING);
            StringBuilder verboseFileOption = new StringBuilder();
            if (vendor.startsWith(JVM_VENDOR_IBM)) {
                verboseFileOption.append(IBM_JVM_GC_VERBOSE_LOG);
                verboseFileOption.append(configuration.getXqeLogsDirectory());
                verboseFileOption.append(File.separator);
                verboseFileOption.append(IBM_JVM_GC_VERBOSE_LOG_FILENAME);
                verboseFileOption.append(COMMA);
                verboseFileOption.append("1");
                verboseFileOption.append(COMMA);
                verboseFileOption.append(jvmVerboseGCLogLimit);
            } else {
                verboseFileOption.append(JVM_GC_VEBOSE_LOG);
                verboseFileOption.append(configuration.getXqeLogsDirectory());
                verboseFileOption.append(File.separator);
                verboseFileOption.append(JVM_GC_VERBOSE_LOG_FILENAME);
            }
            commandLine.add(verboseFileOption.toString());
        }
        String dataDirectory = CubingServicesConnectionFactory.getDataDirectory();
        try {
            dataDirectory = new File(dataDirectory).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String xqeStampFilename = dataDirectory + File.separator + XQE_STAMP_FILENAME;
        if (CubingServicesConnectionFactory.isIBMJava()) {
            if (arch.equals(SIXTY_FOUR) && Double.valueOf(vmVersion) >= 2.6 && jvmGCPolicy.equals("http://developer.cognos.com/ceba/constants/gcPolicyEnum#Balanced")) {
                commandLine.add(IBM_BALANCED);
            } else if (!jvmGCPolicy.equals("http://developer.cognos.com/ceba/constants/gcPolicyEnum#Custom")) {
                commandLine.add(IBM_GENERATIONAL);
            }
            if (CubingServicesConnectionFactory.isWindows()) {
                commandLine.add(IBM_WINDOWS_OUTOFMEMORY.replace(XQE_STAMP_FILENAME, CubingServicesConnectionFactory.quoteSpacesInPath(xqeStampFilename + JVM_IBM_PID)));
            } else {
                commandLine.add(IBM_UNIX_OUTOFMEMORY.replace(XQE_STAMP_FILENAME, CubingServicesConnectionFactory.quoteSpacesInPath(xqeStampFilename + JVM_IBM_PID)));
            }
        } else {
            if (!jvmGCPolicy.equals("http://developer.cognos.com/ceba/constants/gcPolicyEnum#Custom")) {
                commandLine.addAll(Arrays.asList(GENERATIONAL));
            }
            if (CubingServicesConnectionFactory.isWindows()) {
                commandLine.add(WINDOWS_OUTOFMEMORY.replace(XQE_STAMP_FILENAME, CubingServicesConnectionFactory.quoteSpacesInPath(xqeStampFilename + JVM_PID)));
            } else {
                commandLine.add(UNIX_OUTOFMEMORY.replace(XQE_STAMP_FILENAME, CubingServicesConnectionFactory.quoteSpacesInPath(xqeStampFilename + JVM_PID)));
            }
        }
        String cogRoot = CCLConfigurationUtils.resolveEffectivePath((String)PARENT_DIRECTORY);
        if (cogRoot != null) {
            commandLine.add("-DCOG_ROOT=" + cogRoot);
        }
        commandLine.add(PARENT_PROCESS_ID + String.valueOf(DQServer.getLocalProcessId()));
        commandLine.add("-Dorg.xerial.snappy.tempdir=" + System.getProperty("org.xerial.snappy.tempdir"));
        commandLine.add("-Dcubingservices_home=" + v5DataServerHome);
        commandLine.add("-Dcubingservices_data=" + dataDirectory);
        commandLine.add(PARENT_PROCESS_PORT_NAME);
        commandLine.add(CubingServicesConnectionFactory.getJavaLibraryPath(databaseLocationProperties, cclConfig));
        String rmiHostnameKey = "java.rmi.server.hostname";
        String rmiHostnameValue = System.getProperty(rmiHostnameKey);
        if (rmiHostnameValue != null & !rmiHostnameValue.isEmpty()) {
            commandLine.add(MINUS_D + rmiHostnameKey + EQUAL + rmiHostnameValue);
        }
        CubingServicesConnectionFactory.addDispProcCmds(commandLine);
        if (sLogger.isOn(LogLevel.TRACE)) {
            sLogger.log(LogLevel.TRACE, "Setting command line: " + commandLine.toString());
        }
    }

    private static void addDispProcCmds(List<String> commandList) {
        Iterator<Element> iterator = dispChildProcCmdList.iterator();
        while (iterator.hasNext()) {
            commandList.add(iterator.next().getTextTrim());
        }
    }

    private static StringBuilder createJavaCommand() {
        String javaHome = System.getProperty("java.home");
        String exeName = dispInitParamMap.get("exe_name");
        StringBuilder strBldr = new StringBuilder(javaHome);
        strBldr.append(File.separator);
        strBldr.append(BIN);
        strBldr.append(File.separator);
        strBldr.append(exeName);
        sLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "InitTerm", LogLevel.ERROR);
        if (sLogger.isOn(LogLevel.TRACE)) {
            sLogger.log(LogLevel.TRACE, "CubingServicesConnectionFactory Information (java.home):" + javaHome);
            sLogger.log(LogLevel.TRACE, "CubingServicesConnectionFactory Information (constructCommandLine>>strBldr):" + strBldr.toString());
        }
        return strBldr;
    }

    private static String escapeArgument(String argument) {
        return argument.replace('^', ',');
    }

    private static boolean isWindows() {
        boolean bWindows = false;
        String os = System.getProperty("os.name");
        if (os.startsWith("Windows")) {
            bWindows = true;
        }
        return bWindows;
    }

    public static boolean isIBMJava() {
        String vendor = System.getProperty(JAVA_VENDOR);
        return vendor.startsWith(JVM_VENDOR_IBM);
    }

    private static String quoteSpacesInPath(String path) {
        if (path.contains(SPACE)) {
            String quote = "\\\"";
            return "\\\"" + path + "\\\"";
        }
        return path;
    }

    private static int calculateJvmMaxNurseryHeapSize(int jvmMaxHeapSize) {
        int jvmSmallHeapPortion = Math.min(jvmMaxHeapSize, 10240);
        int jvmMaxNurseryHeapSize = jvmSmallHeapPortion / 2;
        if (jvmMaxHeapSize > 10240) {
            jvmMaxNurseryHeapSize += (jvmMaxHeapSize - jvmSmallHeapPortion) / 6;
        }
        return jvmMaxNurseryHeapSize;
    }

    private static void addOptionsToCommandLine(String options, String source, String[] ignoreOptions) {
        if (options != null && options.length() > 0) {
            if (sLogger.isOn(LogLevel.TRACE)) {
                sLogger.log(LogLevel.TRACE, String.format("Appending additional JVM args from %s to the command line: %s", source, options));
            }
            StringTokenizer tokenizer = new StringTokenizer(options);
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken();
                boolean addToken = true;
                for (String option : ignoreOptions) {
                    if (!token.startsWith(option)) continue;
                    if (sLogger.isOn(LogLevel.TRACE)) {
                        sLogger.log(LogLevel.TRACE, String.format("Ignoring additional JVM arg: %s", token));
                    }
                    addToken = false;
                    break;
                }
                if (!addToken) continue;
                commandLine.add(token);
            }
        }
    }

    private static int getMemorySize(StringBuilder options, String memoryOption, int defaultMemorySize) {
        int start = options.indexOf(memoryOption);
        int memorySize = defaultMemorySize;
        if (start != -1) {
            String memoryString;
            int end = options.indexOf(SPACE, start);
            if (end == -1) {
                end = options.length();
            }
            if ((memoryString = options.substring(start + memoryOption.length(), end - 1)) != null) {
                memorySize = Integer.parseInt(memoryString);
            }
            try {
                switch (options.charAt(end - 1)) {
                    case 'm': {
                        break;
                    }
                    case 'g': {
                        memorySize *= 1024;
                        break;
                    }
                    default: {
                        sLogger.log(LogLevel.TRACE, "Unknown size for " + memoryOption);
                        break;
                    }
                }
            }
            catch (IndexOutOfBoundsException ex) {
                sLogger.log("Error parsing memory size unit of measure for " + memoryOption);
                memorySize = defaultMemorySize;
            }
        }
        return memorySize;
    }

    private static String buildClassPath(Map<String, String> initParamMap, ICCLConfiguration cclConfig, Properties properties) {
        String jarDirs = initParamMap.get("JAR_DIRS");
        sLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "InitTerm", LogLevel.ERROR);
        sLogger.log(LogLevel.TRACE, "CubingServicesConnectionFactory Information (buildClassPath>>>jarDirs(Before)):" + jarDirs);
        jarDirs = jarDirs.replaceAll(SEMI_COLON, File.pathSeparator);
        sLogger.log(LogLevel.TRACE, "CubingServicesConnectionFactory Information (buildClassPath>>>jarDirs(After)):" + jarDirs);
        StringTokenizer tokenizer = new StringTokenizer(jarDirs, File.pathSeparator);
        sLogger.log(LogLevel.TRACE, "CubingServicesConnectionFactory Information (File.pathSeparator):" + File.pathSeparator);
        String[] directories = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            directories[i] = tokenizer.nextToken();
            directories[i] = cclConfig.resolveEffectivePath(directories[i]);
            ++i;
        }
        StringBuilder strBldr = new StringBuilder();
        String jars = initParamMap.get("JARS");
        if (jars != null) {
            jars = jars.replaceAll(SEMI_COLON, File.pathSeparator);
            tokenizer = new StringTokenizer(jars, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                strBldr.append(cclConfig.resolveEffectivePath(tokenizer.nextToken()));
                strBldr.append(File.pathSeparator);
            }
        }
        String classesDirs = initParamMap.get("CLASSES_DIRS");
        classesDirs = classesDirs.replaceAll(SEMI_COLON, File.pathSeparator);
        tokenizer = new StringTokenizer(classesDirs, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            strBldr.append(cclConfig.resolveEffectivePath(tokenizer.nextToken()));
            strBldr.append(File.pathSeparator);
        }
        FileFilter jarFileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String lowerCasePath = pathname.getName().toLowerCase();
                return lowerCasePath.endsWith(".jar") || lowerCasePath.endsWith(".zip");
            }
        };
        for (int i2 = 0; i2 < directories.length; ++i2) {
            File aFile = new File(directories[i2]);
            if (!aFile.isDirectory()) continue;
            strBldr.append(aFile.getAbsolutePath());
            strBldr.append(File.separator);
            strBldr.append(ASTERISK);
            strBldr.append(File.pathSeparator);
        }
        CubingServicesConnectionFactory.addDatabaseDrivers(strBldr, properties);
        CubingServicesConnectionFactory.addEssbaseClientJars(strBldr, jarFileFilter);
        sLogger.log(LogLevel.TRACE, "CubingServicesConnectionFactory Information (buildClassPath>>>ClassPath string): " + strBldr.toString());
        return strBldr.toString();
    }

    private static Properties loadDatabaseDriverLocationProperties() {
        Properties properties = new Properties();
        File propertiesXMLFile = new File(databaseClasspathLocationFile);
        if (propertiesXMLFile.exists()) {
            try {
                BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(propertiesXMLFile));
                properties.load(inStream);
            }
            catch (Exception e) {
                lastError = new V5ServerProcessException(XQEMessageKeys.GEN_UnableToLoadDatabaseLocationFiles, (Throwable)e, databaseClasspathLocationFile);
                throw lastError;
            }
        }
        return properties;
    }

    private static void addDatabaseDrivers(StringBuilder strBldr, Properties properties) {
        String databaseClasspath = properties.getProperty("databaseClasspath");
        if (databaseClasspath == null || "".equals(databaseClasspath)) {
            return;
        }
        if (databaseClasspath.indexOf(32) != -1) {
            lastError = new V5ServerProcessException(XQEMessageKeys.GEN_SpacesInClasspathNotAllowed, databaseClasspathLocationFile);
            throw lastError;
        }
        strBldr.append(databaseClasspath);
    }

    private static void addEssbaseClientJars(StringBuilder strBldr, FileFilter jarFileFilter) {
        String arborpath = null;
        try {
            arborpath = System.getenv("ARBORPATH");
        }
        catch (SecurityException e) {
            sLogger.log(LogLevel.INFO, "System.getenv() call is not permitted by security policy.");
            sLogger.log(LogLevel.INFO, "To permit it add a RuntimePermission \"getenv.*\" to ~/.java.policy file.");
            return;
        }
        if (arborpath == null) {
            sLogger.log(LogLevel.INFO, "Environment variable ARBORPATH for Oracle/Essbase is not set.");
            return;
        }
        String essClientDir = CubingServicesConnectionFactory.buildPath(arborpath, "JavaAPI", LIB);
        File essbaseDir = new File(essClientDir);
        if (!essbaseDir.exists() && !(essbaseDir = new File(essClientDir = CubingServicesConnectionFactory.buildPath(arborpath, LIB))).exists()) {
            sLogger.log(LogLevel.INFO, "Cannot find the directory with Essbase client JAR files.");
            return;
        }
        strBldr.append(essbaseDir.getAbsolutePath());
        strBldr.append(File.separator);
        strBldr.append(ASTERISK);
        strBldr.append(File.pathSeparator);
        String epmOracleHome = System.getenv("EPM_ORACLE_HOME");
        if (epmOracleHome != null) {
            String essbaseJar = CubingServicesConnectionFactory.buildPath(epmOracleHome, "common", "loggers", "ODL", "1.0.0", LIB, "ojdl.jar");
            strBldr.append(essbaseJar);
            strBldr.append(File.pathSeparator);
        }
    }

    private static String buildPath(String ... strings) {
        if (strings.length > 0) {
            StringBuilder sb = new StringBuilder(strings[0]);
            for (int i = 1; i < strings.length; ++i) {
                sb.append(File.separator);
                sb.append(strings[i]);
            }
            return sb.toString();
        }
        return "";
    }

    private static String getBinDirectory() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (config == null) {
            XQEConfigurationManager.getInstance().add(ServiceEnumeration.XQE, XQECCLConfigurationAdapter.createDefaultConfiguration());
        }
        return config.getBinDirectory();
    }

    private static String getDataDirectory() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (config == null) {
            XQEConfigurationManager.getInstance().add(ServiceEnumeration.XQE, XQECCLConfigurationAdapter.createDefaultConfiguration());
        }
        return config.getDataDirectory();
    }

    private static String getJavaLibraryPath(Properties properties, ICCLConfiguration cclConfig) {
        StringBuilder strBldr = new StringBuilder("-Djava.library.path=");
        sLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "InitTerm", LogLevel.ERROR);
        sLogger.log(LogLevel.TRACE, "CubingServicesConnectionFactory Information (XQEConfiguration->BinDirectory):" + CubingServicesConnectionFactory.getBinDirectory());
        strBldr.append(CubingServicesConnectionFactory.getBinDirectory());
        strBldr.append(File.pathSeparator);
        strBldr.append(CubingServicesConnectionFactory.getDriversDirectory());
        strBldr.append(File.pathSeparator);
        sLogger.log(LogLevel.TRACE, "CubingServicesConnectionFactory Information (getJavaLibraryPath-strBldr):" + strBldr.toString());
        String databaseJNIPath = properties.getProperty("databaseJNIPath");
        if (databaseJNIPath == null || "".equals(databaseJNIPath)) {
            return strBldr.toString();
        }
        if (databaseJNIPath.indexOf(32) != -1) {
            lastError = new V5ServerProcessException(XQEMessageKeys.GEN_SpacesInClasspathNotAllowed, databaseClasspathLocationFile);
            throw lastError;
        }
        strBldr.append(databaseJNIPath);
        return strBldr.toString();
    }

    private static String getDriversDirectory() {
        return CubingServicesConnectionFactory.getBinDirectory() + File.separator + PARENT_DIRECTORY + File.separator + DRIVERS_DIRECTORY;
    }

    private static void constructCommandLine(Configuration configuration) {
        ICCLConfiguration cclConfig = configuration.getICCLConfiguration();
        XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (xqeConfig == null) {
            XQEConfigurationManager.getInstance().add(ServiceEnumeration.XQE, XQECCLConfigurationAdapter.createDefaultConfiguration(cclConfig));
        } else {
            xqeConfig.update(cclConfig);
        }
        if (commandLine.isEmpty()) {
            CubingServicesConnectionFactory.constructCommandLine(cclConfig);
            CubingServicesConnectionFactory.constructSimpleCommandLine(cclConfig);
        }
    }

    private static void constructSimpleCommandLine(ICCLConfiguration cclConfig) {
        simpleCommandLine.clear();
        StringBuilder javaCmd = CubingServicesConnectionFactory.createJavaCommand();
        simpleCommandLine.add(javaCmd.toString());
        ArrayList<String> listFromFile = new ArrayList<String>();
        CubingServicesConnectionFactory.addDispProcCmds(listFromFile);
        simpleCommandLine.addAll(listFromFile.subList(listFromFile.size() - 4, listFromFile.size()));
    }

    protected static void reconstructCommandLine(Configuration configuration) {
        commandLine.clear();
        CubingServicesConnectionFactory.constructCommandLine(configuration);
    }

    public void configure(Configuration configuration) {
        super.configure(configuration);
        currentConfiguration = configuration;
        CubingServicesConnectionFactory.constructCommandLine(configuration);
        AdminConsoleAutoRegistration.addXqeJMXMBean();
        AdminConsoleMetricsMBean.createMBean(PogoMBeanServer.getInstance().getServer());
        XqeSystemMetricsManager.createProxyMBean();
    }

    public static void removeDQServerFilestamps(XQEConfiguration xqeConfig) {
        String xqeStampDirectoryName = xqeConfig.getDataDirectory();
        CubingServicesConnectionFactory.removeDQServerFilestamps(xqeStampDirectoryName);
    }

    public static void removeDQServerFilestamps(String xqeStampDirectoryName) {
        File xqeStampDirectory = new File(xqeStampDirectoryName);
        File[] xqeFilestamps = xqeStampDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.startsWith(CubingServicesConnectionFactory.XQE_STAMP_FILENAME);
            }
        });
        if (xqeFilestamps == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid or inaccessible directory: " + xqeStampDirectoryName);
        }
        for (File xqeFilestamp : xqeFilestamps) {
            xqeFilestamp.delete();
        }
    }

    protected void configureRequestInvoker(Configuration configuration) {
        super.configureRequestInvoker(configuration);
        this.getRequestInvoker().setDefaultTimeout(30000L);
    }

    protected static List<String> getCommandLine() {
        if (commandLine.isEmpty()) {
            throw lastError;
        }
        return commandLine;
    }

    protected static Configuration getCurrentConfiguration() {
        return currentConfiguration;
    }

    protected static void setCurrentConfiguration(Configuration config) {
        currentConfiguration = config;
    }

    protected static String getV5DataServerHome() {
        return v5DataServerHome;
    }

    public void start() {
        super.start();
        CubingServicesConnectionFactory.setOperationalStatus(ServiceStatus.AVAILABLE);
    }

    public void stop() {
        super.stop();
        CubingServicesConnectionFactory.setOperationalStatus(ServiceStatus.UNAVAILABLE);
    }

    public void suspend(boolean arg0) {
        super.suspend(arg0);
        CubingServicesConnectionFactory.setOperationalStatus(ServiceStatus.PARTIALLYAVAILABLE);
    }

    public void resume() {
        super.resume();
        this.getProcessManager().createAnotherProcess();
        CubingServicesConnectionFactory.setOperationalStatus(ServiceStatus.AVAILABLE);
    }

    public synchronized IConnection getConnection() {
        return new CubingServicesConnection(this.getRequestInvoker());
    }

    public static List<String> getSimpleCommandLine() {
        return simpleCommandLine;
    }

    static {
        commandLine = new ArrayList<String>();
        simpleCommandLine = new ArrayList<String>();
        currentConfiguration = null;
        v5DataServerHome = null;
        servletPath = null;
        ONE_EMPTY_STRING_ARRAY = new String[]{""};
        sLogger = null;
    }

    private static class CubingServicesConnection
    extends BIBusTKServerConnection {
        CubingServicesConnection(BIBusTKServerRequestInvoker requestInvoker) {
            super(requestInvoker);
        }

        public boolean waitReceivedForRequest(MessageContext mc, AsyncContext ac) {
            return false;
        }
    }
}

