/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices;

import com.cognos.xqe.bibushandler.XQEService;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.system.PingCommand;
import com.cognos.xqebifw.cubingservices.CubingServicesConnectionFactory;
import com.cognos.xqebifw.cubingservices.RequestDispatcher;
import com.cognos.xqebifw.cubingservices.SSLRequestDispatcher;
import com.cognos.xqebifw.cubingservices.ServerStartException;
import com.cognos.xqebifw.cubingservices.V5QueryHandler;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DQServer {
    private static final String OS_NAME = "os.name";
    private static final String QUOTE = "'";
    private static final int FIVE = 5;
    private static final int LOG_CUSHION = 32768;
    private static final int SHUTDOWN_CUSHION = 32768;
    private static final String PROP_MEMBER_CACHE_ROOT_DIR = "MemberCacheRootDir";
    private static final String PROP_DATA_CACHE_ROOT_DIR = "DataCacheRootDir";
    private static final String DEFAULT_MEMBER_CACHE_ROOT_DIR = "cache";
    private static final String SERVER_CONFIG_FILENAME = "cubeserver.xml";
    private static final String PROP_CUBESERVER_HOME = "cubingservices_home";
    private static final String PROP_CUBESERVER_DATA = "cubingservices_data";
    private static String homeDir = null;
    private V5QueryHandler v5QueryHandler;
    private boolean pingErrorLogged = false;
    private static byte[] shutdownLogCushion = new byte[32768];
    private static byte[] shutdownCushion = new byte[32768];
    private RequestDispatcher reqDispatcher;
    private int parentProcessID = -1;
    private File xqeStampFile = null;
    private File xqeRunningIndicatorFile = null;
    private static boolean mIsRecoveringFromCrash = false;
    public static final String XQE_RUNNING_INDICATOR_FILENAME = ".xqe_running.";

    public static void main(String[] args) {
        DQServer ds = new DQServer();
        ds.run();
    }

    public static void operatingSystemSpecifics() {
        if (System.getProperty(OS_NAME).toLowerCase().startsWith("aix") && System.getProperty("java.vm.vendor").toLowerCase().indexOf("ibm") >= 0 && System.getProperty("java.version").startsWith("1.6") && DQServer.isJVMAtLeastSRLevel(5)) {
            String selectorProviderProperty = "java.nio.channels.spi.SelectorProvider";
            String selectorProviderValue = "sun.nio.ch.PollSelectorProvider";
            System.setProperty("java.nio.channels.spi.SelectorProvider", "sun.nio.ch.PollSelectorProvider");
        }
    }

    public static boolean isJVMAtLeastSRLevel(int srLevel) {
        String sr = "sr";
        String javaRuntimeVersion = System.getProperty("java.runtime.version").toLowerCase();
        int beginSRIndex = javaRuntimeVersion.indexOf(sr);
        String srNumberString = "";
        if (beginSRIndex > -1) {
            char character;
            for (int i = beginSRIndex + 2; i < javaRuntimeVersion.length() && Character.isDigit(character = javaRuntimeVersion.charAt(i)); ++i) {
                srNumberString = srNumberString + character;
            }
        }
        if (srNumberString.length() > 0) {
            try {
                int srNumber = Integer.parseInt(srNumberString);
                return srNumber >= srLevel;
            }
            catch (NumberFormatException e) {
                String srLevelString = sr + srLevel;
                return javaRuntimeVersion.contains(srLevelString);
            }
        }
        String srLevelString = sr + srLevel;
        return javaRuntimeVersion.contains(srLevelString);
    }

    public void run() {
        try {
            this.prepare();
            this.reqDispatcher.run();
        }
        catch (ServerStartException e) {
            String errorMsg = "DQServer initialization failed";
            DQServer.output(errorMsg, e);
            try {
                XQELogger errorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
                errorLogger.log(errorMsg, (Throwable)e);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            String errorMsg = "Unexpected exception happened while DQ server is dispatching the requests. DQ server is shutting down ...";
            DQServer.output(errorMsg, e);
            DQServer.logException(e);
        }
        catch (VirtualMachineError vme) {
            DQServer.logException(vme);
            this.shutdown(ExitCode.CRITICAL);
        }
        catch (Throwable t) {
            DQServer.logException(t);
            this.shutdown(ExitCode.CRITICAL);
        }
        this.shutdown(ExitCode.NORMAL);
    }

    private void prepare() throws ServerStartException {
        try {
            DQServer.output("Starting DQServer...");
            this.v5QueryHandler = V5QueryHandler.getInstance();
            DQServer.operatingSystemSpecifics();
            DQServer.initHomeDir();
            this.loadJDBCDrivers();
            DQServer.initServerProperties();
            this.reqDispatcher = XQEService.isSSLProtocol() ? new SSLRequestDispatcher() : new RequestDispatcher();
            if (!this.reqDispatcher.initialize(this.v5QueryHandler)) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unable to initialize Request Dispatcher");
            }
            this.parentProcessID = this.getParentProcessID();
            this.xqeStampFile = DQServer.putServerStampFile();
            this.xqeRunningIndicatorFile = this.initRunningIndicatorFile();
            Thread monitoringThread = new Thread("StartFileStampMonitor"){

                @Override
                public void run() {
                    int sleepDelay = 15000;
                    int stampfileCheckPeriod = 15000;
                    int parentPingPeriod = 90000;
                    int parentPing = 0;
                    while (DQServer.this.xqeStampFile != null) {
                        if (!DQServer.this.xqeStampFile.exists()) {
                            try {
                                1.sleep(15000L);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            DQServer.this.shutdown(ExitCode.OUT_OF_MEMORY);
                        }
                        if (parentPing >= 90000) {
                            parentPing = 0;
                            if (DQServer.this.parentProcessID >= 0) {
                                boolean alive = false;
                                int maxAttempts = 5;
                                int sleepAttempts = 3000;
                                for (int attempt = 0; !alive && attempt < 5; ++attempt) {
                                    block17: {
                                        try {
                                            alive = PingCommand.ping(DQServer.this.parentProcessID);
                                        }
                                        catch (Throwable ex) {
                                            alive = true;
                                            if (DQServer.this.pingErrorLogged) break block17;
                                            DQServer.logException(ex);
                                            DQServer.this.pingErrorLogged = true;
                                        }
                                    }
                                    if (alive) continue;
                                    try {
                                        1.sleep(3000L);
                                        continue;
                                    }
                                    catch (InterruptedException interruptedException) {
                                        continue;
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                if (!alive) {
                                    ExitCode.PARENT_DEATH.setDetail(". Parent pid is " + String.valueOf(DQServer.this.parentProcessID));
                                    DQServer.this.shutdown(ExitCode.PARENT_DEATH);
                                }
                            }
                        }
                        parentPing += 15000;
                        try {
                            1.sleep(15000L);
                        }
                        catch (InterruptedException alive) {
                        }
                        catch (Throwable t) {
                            DQServer.logException(t);
                            DQServer.this.shutdown(ExitCode.CRITICAL);
                        }
                    }
                }
            };
            monitoringThread.setDaemon(true);
            monitoringThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread thread, Throwable t) {
                    DQServer.logException(t);
                    DQServer.this.shutdown(ExitCode.CRITICAL);
                }
            });
            monitoringThread.start();
            DQServer.output("DQServer started.");
        }
        catch (Exception e) {
            throw new ServerStartException(e);
        }
    }

    private File initRunningIndicatorFile() {
        String dataDir = System.getProperty(PROP_CUBESERVER_DATA);
        File xqeRunningIndicatorDirectory = new File(dataDir);
        File[] xqeRunningIndicators = xqeRunningIndicatorDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.startsWith(DQServer.XQE_RUNNING_INDICATOR_FILENAME);
            }
        });
        if (xqeRunningIndicators == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid or inaccessible directory: " + dataDir);
        }
        for (File xqeRunningIndicator : xqeRunningIndicators) {
            mIsRecoveringFromCrash = true;
            xqeRunningIndicator.delete();
        }
        String xqeRunningIndicatorFilename = dataDir + File.separator + XQE_RUNNING_INDICATOR_FILENAME + String.valueOf(DQServer.getLocalProcessId());
        File runningIndicatorFile = new File(xqeRunningIndicatorFilename);
        try {
            runningIndicatorFile.createNewFile();
        }
        catch (IOException e1) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Can not create xqe running indicator file: " + xqeRunningIndicatorFilename);
        }
        return runningIndicatorFile;
    }

    public static void initHomeDir() {
        homeDir = System.getProperty(PROP_CUBESERVER_HOME);
        if (homeDir == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Home folder 'cubingservices_home' must be defined");
        }
        File hd = new File(homeDir);
        homeDir = null;
        try {
            homeDir = hd.getCanonicalPath();
        }
        catch (IOException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, (Throwable)e, "Unable to normalize home folder path '" + homeDir + QUOTE);
        }
    }

    private static void output(String message, Exception e) {
        DQServer.output(message);
        if (e != null) {
            e.printStackTrace(System.out);
        }
    }

    private static void output(String message) {
        System.out.println(message);
    }

    public static String getMemberCacheRootDir(String dir) {
        String cacheDirName = DQServer.getDirectoryPathProperty(dir, PROP_MEMBER_CACHE_ROOT_DIR);
        if (cacheDirName == null || cacheDirName.length() == 0) {
            cacheDirName = DEFAULT_MEMBER_CACHE_ROOT_DIR;
        }
        return cacheDirName;
    }

    public static String getDataCacheRootDir(String dir) {
        String cacheDirName = DQServer.getDirectoryPathProperty(dir, PROP_DATA_CACHE_ROOT_DIR);
        if (cacheDirName == null || cacheDirName.length() == 0) {
            cacheDirName = DQServer.getMemberCacheRootDir(dir);
        }
        return cacheDirName;
    }

    public static String getDirectoryPathProperty(String dir, String property) {
        String value;
        String cacheDirName = value = System.getProperty(property);
        if (value != null && value.length() > 0) {
            File cacheDir = new File(value);
            cacheDirName = cacheDir.isAbsolute() ? value : (dir != null ? dir + File.separator + value : value);
        }
        return cacheDirName;
    }

    public static void initServerProperties() {
        System.setProperty(PROP_MEMBER_CACHE_ROOT_DIR, DQServer.getMemberCacheRootDir(homeDir));
        System.setProperty(PROP_DATA_CACHE_ROOT_DIR, DQServer.getDataCacheRootDir(homeDir));
    }

    private void loadJDBCDrivers() {
        File dsConfigFile = null;
        String confFN = homeDir + File.separator + SERVER_CONFIG_FILENAME;
        File configFile = new File(confFN);
        try {
            if (configFile.exists()) {
                dsConfigFile = configFile;
            }
        }
        catch (SecurityException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, (Throwable)e, "Unable to access configuration file '" + confFN + QUOTE);
        }
        ArrayList<String> driverList = this.getJDBCDrivers(dsConfigFile);
        for (String driverClassName : driverList) {
            try {
                Class.forName(driverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, (Throwable)e, "Unable to find JDBC driver '" + driverClassName + QUOTE);
            }
        }
    }

    public ArrayList<String> getJDBCDrivers(File dsConfigFile) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        ArrayList<String> driverList = new ArrayList<String>();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(dsConfigFile);
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, (Throwable)e, "Error parsing configuration file '" + dsConfigFile.getPath() + QUOTE);
        }
        for (Node node = document.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
            Properties props;
            String enabled;
            if (!node.getNodeName().equalsIgnoreCase("JDBCDriver") || !"true".equalsIgnoreCase(enabled = (props = this.getNodeProperties(node)).getProperty("ENABLED"))) continue;
            driverList.add(props.getProperty("CLASSNAME"));
        }
        return driverList;
    }

    public Properties getNodeProperties(Node node) {
        Properties props = new Properties();
        NamedNodeMap attrs = node.getAttributes();
        int len = attrs.getLength();
        for (int i = 0; i < len; ++i) {
            Attr attr = (Attr)attrs.item(i);
            String nm = attr.getNodeName();
            String val = attr.getNodeValue();
            props.setProperty(nm.toUpperCase(), val);
        }
        return props;
    }

    private static File putServerStampFile() {
        String dataDir = System.getProperty(PROP_CUBESERVER_DATA);
        CubingServicesConnectionFactory.removeDQServerFilestamps(dataDir);
        String xqeStampFilename = dataDir + File.separator + ".xqe." + String.valueOf(DQServer.getLocalProcessId());
        File stampFile = new File(xqeStampFilename);
        try {
            stampFile.createNewFile();
            stampFile.deleteOnExit();
        }
        catch (IOException e1) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Can not create xqe timestamp file: " + xqeStampFilename);
        }
        return stampFile;
    }

    public static int getLocalProcessId() {
        String beanName = ManagementFactory.getRuntimeMXBean().getName();
        return Integer.parseInt(beanName.substring(0, beanName.indexOf("@")));
    }

    private int getParentProcessID() {
        String parentProcessIDString = System.getProperty("ParentProcessID");
        int processID = -1;
        if (parentProcessIDString != null) {
            processID = Integer.valueOf(parentProcessIDString);
        }
        return processID;
    }

    public void shutdown(ExitCode exitCode) {
        shutdownCushion = null;
        try {
            if (this.xqeStampFile != null) {
                this.xqeStampFile.delete();
            }
            this.xqeStampFile = null;
            if (exitCode == ExitCode.NORMAL) {
                if (this.xqeRunningIndicatorFile != null) {
                    this.xqeRunningIndicatorFile.delete();
                }
                this.xqeRunningIndicatorFile = null;
            }
            DQServer.output("Terminating DQServer...");
            shutdownLogCushion = null;
            try {
                XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Resources", LogLevel.ERROR).log(exitCode.getMessage());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.v5QueryHandler != null) {
                this.v5QueryHandler.release();
            }
        }
        catch (Throwable t) {
            DQServer.logException(t);
        }
        System.exit(exitCode.getCode());
    }

    private static void logException(Throwable t) {
        try {
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR).log(t);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setRecoveringFromCrash(boolean v) {
        mIsRecoveringFromCrash = v;
    }

    public static boolean isRecoveringFromCrash() {
        return mIsRecoveringFromCrash;
    }

    public static enum ExitCode {
        NORMAL(0, "DQServer: shutdown"),
        CRITICAL(1, "DQServer: shutdown due to the critical error"),
        OUT_OF_MEMORY(2, "DQServer: shutdown due to the OutOfMemoryError"),
        PARENT_DEATH(3, "DQServer: shutdown due to the parent death");

        private int code;
        private String message;
        private String detail;

        private ExitCode(int theCode, String theMessage) {
            this.code = theCode;
            this.message = theMessage;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            if (this.detail == null) {
                return this.message;
            }
            return this.message + this.detail;
        }

        public void setDetail(String theDetail) {
            this.detail = theDetail;
        }
    }
}

