/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;

public final class DQThreadContext {
    private static ConcurrentMap<String, ConcurrentLinkedQueue<Thread>> dqThreads = null;
    private long startTime = System.currentTimeMillis();
    private int cleanTimeInterval = 86400000;
    private long cleanTime = this.startTime + (long)this.cleanTimeInterval;
    private static final String SPACE = " ";
    private static XQELogger mLogger = null;
    private static final SingletonHelper<DQThreadContext> SINGLETON_HELPER = new SingletonHelper<DQThreadContext>(){

        @Override
        protected DQThreadContext newInstance() {
            return new DQThreadContext();
        }

        @Override
        protected void initializeImpl(DQThreadContext dqThreadContext) {
            dqThreads = new ConcurrentHashMap();
        }

        @Override
        protected void releaseImpl(DQThreadContext dqThreadContext) {
            dqThreads.clear();
            dqThreads = null;
        }
    };

    private DQThreadContext() {
        String prop = System.getProperty("dqThreadCleanupInterval");
        if (prop != null) {
            this.cleanTimeInterval = Integer.parseInt(prop);
            this.cleanTime = this.startTime + (long)this.cleanTimeInterval;
        }
    }

    public static DQThreadContext getInstance() {
        return SINGLETON_HELPER.getInstance(false);
    }

    private static XQELogger getLogger() {
        if (mLogger == null) {
            mLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Cancel", LogLevel.INFO);
        }
        return mLogger;
    }

    private static boolean isTracing() {
        return DQThreadContext.getLogger().isOn(LogLevel.INFO);
    }

    public void addRequestThread(String requestID, Thread theThread) {
        if (requestID != null) {
            ConcurrentLinkedQueue<Thread> storedThreads = (ConcurrentLinkedQueue<Thread>)dqThreads.get(requestID);
            if (storedThreads == null) {
                storedThreads = new ConcurrentLinkedQueue<Thread>();
            }
            storedThreads.add(theThread);
            dqThreads.putIfAbsent(requestID, storedThreads);
            if (DQThreadContext.isTracing()) {
                StringBuilder logMessage = new StringBuilder("Add thread: id = ").append(theThread.getId()).append(SPACE).append(theThread.getName());
                DQThreadContext.getLogger().log(logMessage.toString());
            }
        }
    }

    public ConcurrentLinkedQueue<Thread> getRequestedThreads(String requestID) {
        return (ConcurrentLinkedQueue)dqThreads.get(requestID);
    }

    public void removeThread(String requestID, Thread threadToRemove) {
        if (requestID != null) {
            ConcurrentLinkedQueue threads = (ConcurrentLinkedQueue)dqThreads.get(requestID);
            if (threads != null) {
                threads.remove(threadToRemove);
                if (DQThreadContext.isTracing()) {
                    StringBuilder logMessage = new StringBuilder("Remove thread: id = ").append(threadToRemove.getId()).append(SPACE).append(threadToRemove.getName());
                    DQThreadContext.getLogger().log(logMessage.toString());
                    DQThreadContext.getLogger().log("Number of Cancel Threads = " + threads.size());
                }
            }
            if (System.currentTimeMillis() > this.cleanTime && !dqThreads.isEmpty()) {
                for (Map.Entry entry : dqThreads.entrySet()) {
                    threads = (ConcurrentLinkedQueue)entry.getValue();
                    if (threads != null) {
                        for (Thread thread : threads) {
                            if (thread.getState() != Thread.State.TERMINATED) continue;
                            threads.remove(thread);
                        }
                    }
                    if (threads == null || !threads.isEmpty()) continue;
                    dqThreads.remove(entry.getKey());
                }
                this.cleanTime = System.currentTimeMillis() + (long)this.cleanTimeInterval;
            }
        }
    }

    public void removeThreads(String requestID) {
        if (requestID != null) {
            dqThreads.remove(requestID);
        }
    }

    public void releaseInstance() {
        SINGLETON_HELPER.releaseInstance();
    }
}

