/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices;

import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.cubingservices.messaging.Message;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.Context;
import com.cognos.xqe.util.context.UsageSummaryContext;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.cognos.xqebifw.cubingservices.RequestDispatcher;
import com.cognos.xqebifw.cubingservices.SOAPFaultException;
import com.cognos.xqebifw.cubingservices.Session;
import com.cognos.xqebifw.cubingservices.messaging.IHttpResponse;
import com.cognos.xqebifw.cubingservices.messaging.MsgBox;
import com.cognos.xqebifw.cubingservices.messaging.SOAPFaultHttpResponse;
import com.cognos.xqebifw.cubingservices.messaging.SOAPMultipartHttpResponse;
import com.cognos.xqebifw.cubingservices.messaging.XMLAMessage;
import com.cognos.xqebifw.cubingservices.messaging.XMLAResponseMessage;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.io.InputStream;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.concurrent.Callable;

public class RequestWorker
implements Callable<Session> {
    private final Session session;
    private final RequestDispatcher reqDispatcher;
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Disp", LogLevel.ERROR);
    private HighPrecisionStopWatch totalTimeTimer = new HighPrecisionStopWatch();
    private HighPrecisionStopWatch processInputTimer = new HighPrecisionStopWatch();
    private HighPrecisionStopWatch processOutputTimer = new HighPrecisionStopWatch();
    private IUsageIndicator xqeTotalTime;
    private IUsageIndicator readXQECPPInput;
    private IUsageIndicator sendResponseXQEPCPP;

    public RequestWorker(RequestDispatcher dispatcher, Session sess) {
        this.session = sess;
        this.reqDispatcher = dispatcher;
        this.xqeTotalTime = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.XQE_SUMMARY, "xqeTotalTime");
        this.readXQECPPInput = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.XQE_SUMMARY, "readXQECPPInput");
        this.sendResponseXQEPCPP = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.XQE_SUMMARY, "sendResponseXQEPCPP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session call() throws Exception {
        MsgBox inBox = null;
        UsageSummaryContext reportContext = null;
        this.totalTimeTimer.start();
        SelectionKey selectionKey = this.session.getSelKey();
        try {
            if (UsageTrackingService.recordPerReportEnabled()) {
                reportContext = UsageSummaryContext.enter();
            }
            if (this.reqDispatcher.isShutDown()) {
                this.reqDispatcher.terminateSession(this.session);
                Session session = this.session;
                return session;
            }
            this.processInputTimer.start();
            inBox = this.reqDispatcher.getQueryMsgBox();
            if (inBox == null) {
                this.reqDispatcher.terminateSession(this.session);
                LOGGER.log(LogLevel.ERROR, "Unable to get inbound MsgBox.");
                Session session = this.session;
                return session;
            }
            MsgBox.CommState inStatus = inBox.unwrapXMLAMsg(this.session);
            if (inStatus != MsgBox.CommState.OK) {
                this.reqDispatcher.returnQueryMsgBox(inBox);
                this.reqDispatcher.terminateSession(this.session);
                LOGGER.log(LogLevel.TRACE, "Error reading message box: " + (Object)((Object)inStatus));
                Session nonEmptyStacks = this.session;
                return nonEmptyStacks;
            }
            this.readXQECPPInput.add(this.processInputTimer.getElapsedTimeInMilliseconds());
            Message msg = this.session.getLastInputMessage();
            ZipiBridge.clearCurrentContext();
            ZipiTimer zipiTimer = ZipiBridge.startTimer(msg);
            try {
                this.processQueryInputMsg(inBox);
            }
            finally {
                ZipiContext.clearQRDName();
                if (zipiTimer != null) {
                    zipiTimer.stopAndClear();
                }
            }
            this.session.runSocketReader();
        }
        catch (Throwable e) {
            if (inBox != null) {
                this.reqDispatcher.returnQueryMsgBox(inBox);
            }
            if (e instanceof XQERuntimeException) {
                this.processSOAPFaultMessage((XQERuntimeException)e);
            } else {
                this.processSOAPFaultMessage(new XQERuntimeException(e));
            }
        }
        finally {
            String nonEmptyStacks;
            this.reqDispatcher.markForRead(selectionKey);
            this.xqeTotalTime.add(this.totalTimeTimer.getElapsedTimeInMilliseconds());
            if (UsageTrackingService.recordPerReportEnabled()) {
                reportContext.exit();
            }
            if (null != (nonEmptyStacks = Context.emptyAll())) {
                String errorDetail = "Non empty context stacks: " + nonEmptyStacks;
                XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Resources", LogLevel.ERROR).log(errorDetail);
            }
        }
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSOAPFaultMessage(XQERuntimeException e) {
        try {
            MsgBox box;
            MsgBox.CommState inStatus;
            SOAPEnvelope envelope = e.getFault().generateEnvelope();
            if (envelope != null && envelope.getFault() != null && (inStatus = (box = RequestDispatcher.createOneTimeUseMsgBox()).unwrapXMLAMsg(this.session)) == MsgBox.CommState.OK) {
                Message msg = this.session.getLastInputMessage();
                XMLAMessage requestMsg = (XMLAMessage)msg;
                requestMsg.setStatus(MsgBox.CommState.HTTP_SOAP_MESSAGE_ERROR);
                SOAPFaultHttpResponse faultResponse = new SOAPFaultHttpResponse(envelope);
                XMLAResponseMessage responseMsg = new XMLAResponseMessage(requestMsg, faultResponse);
                responseMsg.setContentType(faultResponse.getContentType());
                this.session.setLastOutputMessage(responseMsg);
                this.processOutput(box, false);
            }
        }
        finally {
            LOGGER.log(LogLevel.ERROR, (Throwable)e);
        }
    }

    private Session processOutput(MsgBox usedBox, boolean returnMsgBox) {
        this.processOutputTimer.start();
        if (this.reqDispatcher.isShutDown()) {
            this.reqDispatcher.terminateSession(this.session);
            return this.session;
        }
        MsgBox outBox = usedBox;
        if (outBox == null) {
            outBox = this.reqDispatcher.getQueryMsgBox();
        } else {
            outBox.reset();
        }
        if (outBox == null) {
            this.reqDispatcher.terminateSession(this.session);
            LOGGER.log(LogLevel.ERROR, "Unable to get outbound MsgBox.");
            return this.session;
        }
        MsgBox.CommState outStatus = outBox.wrapXMLAMsg(this.session);
        if (outStatus != MsgBox.CommState.OK) {
            this.reqDispatcher.returnQueryMsgBox(outBox);
            this.reqDispatcher.terminateSession(this.session);
            LOGGER.log(LogLevel.ERROR, "Error writing message box: " + (Object)((Object)outStatus));
            return this.session;
        }
        if (returnMsgBox) {
            this.reqDispatcher.returnQueryMsgBox(outBox);
        }
        if (this.session.isTerminated()) {
            return this.session;
        }
        this.session.cleanup();
        this.sendResponseXQEPCPP.add(this.processOutputTimer.getElapsedTimeInMilliseconds());
        return this.session;
    }

    private void processQueryInputMsg(MsgBox inBox) {
        Message msg = this.session.getLastInputMessage();
        XMLAMessage m = (XMLAMessage)msg;
        XMLAResponseMessage rm = null;
        if (m.getStatus() != MsgBox.CommState.OK) {
            rm = new XMLAResponseMessage(m);
        } else if (!m.getServletName().equals("IBMXmlAnalysis")) {
            m.setStatus(MsgBox.CommState.HTTP_UNKNOWN_SERVLET);
            rm = new XMLAResponseMessage(m);
        } else {
            String action = m.getSOAPaction();
            if (action == null || action.length() == 0) {
                m.setStatus(MsgBox.CommState.HTTP_NO_SOAP_ACTION);
                rm = new XMLAResponseMessage(m);
            } else if (!XMLAMessage.XQE_SOAP_ACTION_SET.contains(action)) {
                m.setStatus(MsgBox.CommState.HTTP_BAD_SOAP_ACTION);
                rm = new XMLAResponseMessage(m);
            } else {
                rm = this.processMessage(m);
            }
        }
        this.session.setLastOutputMessage(rm);
        this.processOutput(inBox, true);
    }

    protected XMLAResponseMessage processMessage(XMLAMessage requestMsg) {
        XMLAResponseMessage responseMsg = null;
        IHttpResponse handlerResponse = null;
        try {
            ResponseAdapter response;
            try {
                response = this.reqDispatcher.getQueryHandler().execute(requestMsg.getInputStream());
            }
            catch (Exception e) {
                throw XQERuntimeException.wrap(e);
            }
            SOAPEnvelope envelope = response.getSOAPResponse();
            Iterator<InputStream> attachments = response.getAttachmentIterator();
            if (envelope != null && envelope.getFault() != null) {
                throw new SOAPFaultException(new SOAPFaultHttpResponse(envelope));
            }
            handlerResponse = new SOAPMultipartHttpResponse(envelope, attachments);
        }
        catch (SOAPFaultException e) {
            handlerResponse = e.getFault();
            requestMsg.setStatus(MsgBox.CommState.HTTP_SOAP_MESSAGE_ERROR);
        }
        catch (Throwable t) {
            requestMsg.setStatus(MsgBox.CommState.HTTP_SOAP_MESSAGE_ERROR);
            responseMsg = new XMLAResponseMessage(requestMsg);
            return responseMsg;
        }
        responseMsg = new XMLAResponseMessage(requestMsg, handlerResponse);
        responseMsg.setContentType(handlerResponse.getContentType());
        return responseMsg;
    }
}

