/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices;

import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqebifw.cubingservices.SSLRequestDispatcher;
import com.cognos.xqebifw.cubingservices.Session;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import javax.net.ssl.SSLSocket;

public class SSLSession
extends Session {
    private SSLSocket mSSLSocket;
    private InputStream inputstream;
    private BufferedInputStream bufferedInputStream;
    private boolean eofReached = false;
    protected static final int EOF = -1;

    public SSLSocket getSSLSocket() {
        return this.mSSLSocket;
    }

    public BufferedInputStream getBufInputStream() {
        try {
            if (this.inputstream == null) {
                this.inputstream = this.mSSLSocket.getInputStream();
                this.bufferedInputStream = new BufferedInputStream(this.inputstream);
            }
            return this.bufferedInputStream;
        }
        catch (IOException ioe) {
            LOGGER.log(ioe);
            return null;
        }
    }

    public void setSSLSocket(SSLSocket sslSocket) {
        try {
            this.mSSLSocket = sslSocket;
            this.inputstream = this.mSSLSocket.getInputStream();
            this.bufferedInputStream = new BufferedInputStream(this.inputstream);
        }
        catch (IOException ioe) {
            LOGGER.log(ioe);
        }
    }

    public void closeSocket() {
        if (this.mSSLSocket != null) {
            try {
                OutputStream os;
                InputStream is = this.mSSLSocket.getInputStream();
                if (is != null) {
                    try {
                        is.close();
                        is = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((os = this.mSSLSocket.getOutputStream()) != null) {
                    try {
                        os.close();
                        os = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.mSSLSocket.close();
                this.mSSLSocket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setEOFReached() {
        this.eofReached = true;
    }

    public boolean isEOFReached() {
        return this.eofReached;
    }

    @Override
    public void setFree() {
        this.isUsed.set(false);
        if (LOGGER.isOn(LogLevel.TRACE)) {
            LOGGER.log("\nFree " + this.toString());
        }
    }

    @Override
    public void runSocketReader() {
        if (!this.eofReached) {
            SSLRequestDispatcher.getSocketReaderPool().submit(new SocketReader(this));
        }
    }

    private class SocketReader<V>
    implements Callable<V> {
        SSLSession currentSession = null;

        SocketReader(SSLSession sslSession) {
            this.currentSession = sslSession;
        }

        @Override
        public V call() {
            try {
                int num = 0;
                SSLSession.this.bufferedInputStream.mark(1);
                while (!SSLSession.this.isTerminated() && !SSLSession.this.inUse() && num == 0) {
                    num = SSLSession.this.bufferedInputStream.read();
                }
                if (num == -1) {
                    SSLSession.this.mSSLSocket.close();
                } else {
                    SSLSession.this.bufferedInputStream.reset();
                    SSLRequestDispatcher.addAvailableSession(this.currentSession);
                }
            }
            catch (Exception ioe) {
                Session.LOGGER.log(ioe);
            }
            return null;
        }
    }
}

