/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.cubingservices.messaging.Message;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class Session
implements Cloneable {
    protected AtomicBoolean isUsed = new AtomicBoolean();
    protected AtomicBoolean isTerminated = new AtomicBoolean();
    protected long mId = 0L;
    private SelectionKey mSelKey = null;
    private SocketChannel mChannel = null;
    private CountDownLatch mDispatched = null;
    private Message lastInputMessage = null;
    private Message lastOutputMessage = null;
    private static final long LMAX = (long)Math.sqrt(9.223372036854776E18) - 1L;
    private long comTick = 0L;
    protected static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Disp", LogLevel.TRACE);

    public void cleanup() {
        if (LOGGER.isOn(LogLevel.TRACE)) {
            LOGGER.log("\nCleanup " + this.toString());
        }
        this.isTerminated.set(false);
        this.isUsed.set(false);
    }

    public void setTerminated() {
        if (LOGGER.isOn(LogLevel.TRACE)) {
            LOGGER.log("\nTerminate " + this.toString());
        }
        this.isTerminated.set(true);
        this.isUsed.set(false);
    }

    public boolean isTerminated() {
        return this.isTerminated.get();
    }

    public boolean inUse() {
        return this.isUsed.get();
    }

    public void setUsed() {
        this.isUsed.set(true);
    }

    public void setFree() {
        this.isUsed.set(false);
        if (LOGGER.isOn(LogLevel.TRACE)) {
            LOGGER.log("\nFree " + this.toString());
        }
    }

    public long getId() {
        return this.mId;
    }

    public void setId(long pId) {
        this.mId = pId;
    }

    public SelectionKey getSelKey() {
        return this.mSelKey;
    }

    public void setSelKey(SelectionKey selKey) {
        this.mSelKey = selKey;
    }

    public SocketChannel getChannel() {
        return this.mChannel;
    }

    public void setChannel(SocketChannel channel) {
        this.mChannel = channel;
    }

    public Message getLastInputMessage() {
        return this.lastInputMessage;
    }

    public void setLastInputMessage(Message msg) {
        this.lastInputMessage = msg;
    }

    public Message getLastOutputMessage() {
        return this.lastOutputMessage;
    }

    public void setLastOutputMessage(Message msg) {
        this.lastOutputMessage = msg;
    }

    public void setDispatched(CountDownLatch dispatched) {
        this.mDispatched = dispatched;
        this.setUsed();
        if (LOGGER.isOn(LogLevel.TRACE)) {
            LOGGER.log("\nUsed " + this.toString());
        }
    }

    public void setRunning() {
        if (this.mDispatched != null) {
            this.mDispatched.countDown();
            if (LOGGER.isOn(LogLevel.TRACE)) {
                LOGGER.log("\nDispatched " + this.toString());
            }
        }
        this.mDispatched = null;
    }

    public void addTick() {
        if (this.comTick == Long.MAX_VALUE) {
            return;
        }
        long tick = this.comTick + 1L;
        this.comTick = tick >= LMAX ? Long.MAX_VALUE : tick * tick;
    }

    public long getTick() {
        return this.comTick;
    }

    public void removeTick() {
        this.comTick = 0L;
    }

    public String toString() {
        String msg = null;
        msg = this.mSelKey != null ? String.format("Session %d,   Key: %s", this.mId, this.mSelKey.toString()) : String.format("Session %d", this.mId);
        return msg;
    }

    public void runSocketReader() {
    }
}

