/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices;

import com.cognos.xqe.util.io.ByteBufferOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class V5QueryPlanKeyBuilder
extends FilterInputStream {
    private static final String ENCODING_NAME = "UTF-8";
    private static final String GT = ">";
    private static final String LT = "<";
    private static final String LT_END = "</";
    private static final String QUERY_SET_BEGIN = "<querySet";
    private static final String QUERY_SET_END = "</querySet>";
    private static final String PROPERTY_BEGIN = "<property";
    private static final String RETRIEVEDATASET_BEGIN = "<retrieveDataset";
    private static final String ELEMENT_END = "/>";
    private ByteBufferOutputStream buff = new ByteBufferOutputStream();
    private String planKeyString = null;

    public V5QueryPlanKeyBuilder(InputStream bis) {
        super(bis);
    }

    public String getPlanKey() {
        if (this.planKeyString == null) {
            this.planKeyString = this.buildPlanKey();
        }
        if (this.planKeyString.length() > 0) {
            return this.planKeyString;
        }
        return null;
    }

    private String buildPlanKey() {
        StringBuilder planKeyBuff = new StringBuilder();
        try {
            planKeyBuff.append(new String(this.buff.getBuf(), ENCODING_NAME));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
        int querySetStart = planKeyBuff.indexOf(QUERY_SET_BEGIN);
        if (querySetStart < 0) {
            return "";
        }
        int querySetEnd = planKeyBuff.indexOf(QUERY_SET_END, querySetStart + QUERY_SET_BEGIN.length());
        if (querySetEnd < 0) {
            return "";
        }
        StringBuilder key = new StringBuilder();
        key.append(planKeyBuff.subSequence(querySetStart, querySetEnd + QUERY_SET_END.length()));
        planKeyBuff.delete(querySetStart, querySetEnd + QUERY_SET_END.length());
        int propertyStart = planKeyBuff.indexOf(PROPERTY_BEGIN);
        while (propertyStart >= 0) {
            int propertyEnd = planKeyBuff.indexOf(ELEMENT_END, propertyStart + PROPERTY_BEGIN.length());
            key.append(planKeyBuff.subSequence(propertyStart, propertyEnd + ELEMENT_END.length()));
            planKeyBuff.delete(propertyStart, propertyEnd + ELEMENT_END.length());
            propertyStart = planKeyBuff.indexOf(PROPERTY_BEGIN);
        }
        int retrieveStart = planKeyBuff.indexOf(RETRIEVEDATASET_BEGIN);
        while (retrieveStart >= 0) {
            int retrieveEnd = planKeyBuff.indexOf(ELEMENT_END, retrieveStart + PROPERTY_BEGIN.length());
            key.append(planKeyBuff.subSequence(retrieveStart, retrieveEnd + ELEMENT_END.length()));
            planKeyBuff.delete(retrieveStart, retrieveEnd + ELEMENT_END.length());
            retrieveStart = planKeyBuff.indexOf(PROPERTY_BEGIN);
        }
        return key.toString();
    }

    @Override
    public int read() throws IOException {
        int i = this.in.read();
        this.buff.write(i);
        return i;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int lenRead = this.in.read(b, off, len);
        if (lenRead > -1) {
            this.buff.write(b, off, lenRead);
        }
        return lenRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int lenRead = this.in.read(b);
        if (lenRead > -1) {
            this.buff.write(b);
        }
        return lenRead;
    }
}

