/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices.messaging;

import com.cognos.xqebifw.cubingservices.messaging.SocketChannelOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class HTTPSocketChannelOutputStream
extends SocketChannelOutputStream {
    public HTTPSocketChannelOutputStream(ByteBuffer buffer, SocketChannel channel) {
        super(buffer, channel);
    }

    @Override
    public void flush() throws IOException {
        if (this.byteBuffer.position() > 0) {
            if (this.chunking) {
                this.writeChunkSize();
                this.writeChunkData();
            } else {
                super.flush();
            }
        }
    }

    private void writeChunkSize() throws IOException {
        if (this.byteBuffer.position() <= 0) {
            throw new IllegalArgumentException("The buffer is empty.  Only the last chunk should have a size of zero.");
        }
        this.writeSize(this.byteBuffer.position());
        this.writeCRLF();
    }

    private void writeSize(int size) throws IOException {
        byte[] sizeHexBytes = HTTPSocketChannelOutputStream.getHexBytes(size);
        ByteBuffer sizeBuffer = this.getSizeByteBuffer();
        sizeBuffer.clear();
        sizeBuffer.put(sizeHexBytes);
        this.write(sizeBuffer);
    }

    @Override
    public void writeCRLF() throws IOException {
        ByteBuffer crlfBuffer = this.getCRLFByteBuffer();
        this.write(crlfBuffer);
    }

    protected void writeChunkData() throws IOException {
        super.flush();
        this.writeCRLF();
    }

    @Override
    public void writeLastChunk() throws IOException {
        if (this.byteBuffer.position() != 0) {
            throw new IllegalArgumentException("The buffer is not empty.  It should be flushed before the last chunk is written.");
        }
        this.writeSize(0);
        this.writeCRLF();
    }

    private ByteBuffer getSizeByteBuffer() throws UnsupportedEncodingException {
        if (this.sizeByteBuffer == null) {
            byte[] bufferCapacityHexBytes = HTTPSocketChannelOutputStream.getHexBytes(this.byteBuffer.capacity());
            this.sizeByteBuffer = ByteBuffer.allocate(bufferCapacityHexBytes.length);
        }
        return this.sizeByteBuffer;
    }

    private ByteBuffer getCRLFByteBuffer() throws UnsupportedEncodingException {
        if (this.crlfByteBuffer == null) {
            this.crlfByteBuffer = ByteBuffer.allocate(2);
            this.crlfByteBuffer.put("\r".getBytes("UTF-8"));
            this.crlfByteBuffer.put("\n".getBytes("UTF-8"));
        }
        return this.crlfByteBuffer;
    }
}

