/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices.messaging;

import com.cognos.xqebifw.cubingservices.messaging.IHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Random;

public class MultipartHttpResponse
implements IHttpResponse {
    private static final short EIGHT_K = 8192;
    private static final int BUF_SIZE = 128;
    private static final String CRLF_DASH = "\r\n--";
    private static final String CRLF = "\r\n";
    private static Random rand = new Random();
    private String boundary;
    protected String contentType;
    protected Iterator<InputStream> partsIterator;
    protected byte[] boundaryBytes;
    private byte[] endBoundaryBytes;

    protected MultipartHttpResponse() {
    }

    public MultipartHttpResponse(Iterator<InputStream> attachmentParts) {
        this.boundary = MultipartHttpResponse.getUniqueValue();
        this.partsIterator = attachmentParts;
        StringBuilder strBuf = new StringBuilder(CRLF_DASH);
        strBuf.append(this.boundary);
        strBuf.append(CRLF);
        this.boundaryBytes = strBuf.toString().getBytes();
        strBuf = new StringBuilder(CRLF_DASH);
        strBuf.append(this.boundary);
        strBuf.append("--");
        strBuf.append(CRLF);
        this.endBoundaryBytes = strBuf.toString().getBytes();
        strBuf = new StringBuilder("multipart/related; boundary=\"");
        strBuf.append(this.boundary).append("\"");
        this.contentType = strBuf.toString();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void writeResponseBody(OutputStream outStream) throws IOException {
        byte[] buffer = new byte[8192];
        while (this.partsIterator.hasNext()) {
            outStream.write(this.boundaryBytes);
            InputStream attachmentStream = this.partsIterator.next();
            int bytesRead = attachmentStream.read(buffer);
            while (bytesRead != -1) {
                outStream.write(buffer, 0, bytesRead);
                bytesRead = attachmentStream.read(buffer);
            }
        }
        outStream.write(this.endBoundaryBytes);
    }

    private static String getUniqueValue() {
        StringBuilder s = new StringBuilder(128);
        s.append(System.currentTimeMillis()).append('.').append(rand.nextLong()).append('.').append(s.hashCode());
        return s.toString();
    }

    @Override
    public int getHttpStatusCode() {
        return 200;
    }

    @Override
    public boolean isXMLA() {
        return false;
    }
}

