/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices.messaging;

import com.cognos.xqebifw.cubingservices.messaging.AbstractSocketOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.net.ssl.SSLSocket;

public class SSLSocketOutputStream
extends AbstractSocketOutputStream {
    protected byte[] byteBuffer = new byte[262144];
    protected SSLSocket mSSLSocket;
    protected int limit;
    protected int position;
    private OutputStream outputstream;
    private BufferedOutputStream bufOutputStream;
    private static final int BUF_SIZE = 262144;
    private static final String TEST = " bytes are written.\n";

    public SSLSocketOutputStream(SSLSocket sslSockect) {
        this.mSSLSocket = sslSockect;
        this.limit = 262144;
        this.position = 0;
    }

    @Override
    public void flush() throws IOException {
        if (this.position > 0) {
            this.writePartial(this.byteBuffer);
            this.limit = this.byteBuffer.length;
            this.position = 0;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.hasRemaining()) {
            this.flush();
        }
        this.byteBuffer[this.position] = (byte)(b & 0xFF);
        ++this.position;
        --this.limit;
    }

    public boolean hasRemaining() {
        return this.byteBuffer.length - this.position > 0;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (b.length == 0) {
            return;
        }
        if (off < 0 || len < 0 || off + len > b.length || off >= b.length) {
            throw new IndexOutOfBoundsException();
        }
        int amount = 0;
        int pos = 0;
        while (len > 0) {
            if (this.limit <= 0) {
                this.flush();
            }
            amount = len > this.limit ? this.limit : len;
            System.arraycopy(b, off + pos, this.byteBuffer, this.position, amount);
            this.position += amount;
            this.limit -= amount;
            if ((len -= amount) <= 0) continue;
            pos += amount;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void writeFull(byte[] buffer) throws IOException {
        if (this.outputstream == null) {
            this.outputstream = this.mSSLSocket.getOutputStream();
            this.bufOutputStream = new BufferedOutputStream(this.outputstream);
        }
        this.bufOutputStream.write(buffer);
        this.bufOutputStream.flush();
    }

    public void writePartial(byte[] buffer) throws IOException {
        if (this.outputstream == null) {
            this.outputstream = this.mSSLSocket.getOutputStream();
            this.bufOutputStream = new BufferedOutputStream(this.outputstream);
        }
        this.bufOutputStream.write(buffer, 0, this.position);
        this.bufOutputStream.flush();
    }
}

