/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.cubingservices.messaging;

import com.cognos.xqe.cubingservices.messaging.Message;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqebifw.cubingservices.messaging.AbstractSocketOutputStream;
import com.cognos.xqebifw.cubingservices.messaging.IHttpResponse;
import com.cognos.xqebifw.cubingservices.messaging.MsgBox;
import com.cognos.xqebifw.cubingservices.messaging.XMLAMessage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class XMLAResponseMessage
extends Message {
    public static final String PROTOCOL_VERSION = "HTTP/1.1";
    public static final String CRLF = new String(new char[]{'\r', '\n'});
    public static final int I_CONTINUE = 100;
    public static final String IS_CONTINUE = "Continue";
    public static final int I_SWITCHING_PROTOCOLS = 101;
    public static final String IS_SWITCHING_PROTOCOLS = "Switching Protocols";
    public static final int I_PROCESSING = 102;
    public static final String IS_PROCESSING = "Processing";
    public static final int OK = 200;
    public static final String SOK = "OK";
    public static final int CREATED = 201;
    public static final String SCREATED = "Created";
    public static final int ACCEPTED = 202;
    public static final String SACCEPTED = "Accepted";
    public static final int NON_AUTHORITATIVE_INFORMATION = 203;
    public static final String SNON_AUTHORITATIVE_INFORMATION = "Non-Authoritative Information";
    public static final int NO_CONTENT = 204;
    public static final String SNO_CONTENT = "No Content";
    public static final int RESET_CONTENT = 205;
    public static final String SRESET_CONTENT = "Reset Content";
    public static final int PARTIAL_CONTENT = 206;
    public static final String SPARTIAL_CONTENT = "Partial Content";
    public static final int MULTI_STATUS = 207;
    public static final int X_MULTIPLE_CHOICES = 300;
    public static final String XS_PARTIAL_CONTENT = "Mutliple Choices";
    public static final int X_MOVED_PERMANENTLY = 301;
    public static final String XS_MOVED_PERMANENTLY = "Moved Permanently";
    public static final int X_FOUND = 302;
    public static final String XS_FOUND = "Found";
    public static final int X_SEE_OTHER = 303;
    public static final String XS_SEE_OTHER = "See Other";
    public static final int X_NOT_MODIFIED = 304;
    public static final String XS_NOT_MODIFIED = "Not Modified";
    public static final int X_USE_PROXY = 305;
    public static final String XS_USE_PROXY = "Use Proxy";
    public static final int X_TEMPORARY_REDIRECT = 307;
    public static final String XS_TEMPORARY_REDIRECT = "Temporary Redirect";
    public static final int E_BAD_REQUEST = 400;
    public static final String ES_BAD_REQUEST = "Bad Request";
    public static final int E_UNAUTHORIZED = 401;
    public static final String ES_UNAUTHORIZED = "Unauthorized";
    public static final String AUTH_CHALLENGE = "WWW-Authenticate";
    public static final String CS_AUTH_PARAM = "Basic realm=\"IBMCubingServices\"";
    public static final int E_PAYMENT_REQUIRED = 402;
    public static final String ES_PAYMENT_REQUIRED = "Payment Required";
    public static final int E_FORBIDDEN = 403;
    public static final String ES_FORBIDDEN = "Forbidden";
    public static final int E_NOT_FOUND = 404;
    public static final String ES_NOT_FOUND = "Not Found";
    public static final int E_METHOD_NOT_ALLOWED = 405;
    public static final String ES_METHOD_NOT_ALLOWED = "Method Not Allowed";
    public static final int E_NOT_ACCEPTABLE = 406;
    public static final String ES_NOT_ACCEPTABLE = "Not Acceptable";
    public static final int E_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final String ES_PROXY_AUTHENTICATION_REQUIRED = "Proxy Authentication Required";
    public static final int E_REQUEST_TIMEOUT = 408;
    public static final String ES_REQUEST_TIMEOUT = "Request Time-out";
    public static final int E_CONFLICT = 409;
    public static final String ES_CONFLICT = "Conflict";
    public static final int E_GONE = 410;
    public static final String ES_GONE = "Gone";
    public static final int E_LENGTH_REQUIRED = 411;
    public static final String ES_LENGTH_REQUIRED = "Length Required";
    public static final int E_PRECONDITION_FAILED = 412;
    public static final String ES_PRECONDITION_FAILED = "Precondition Failed";
    public static final int E_REQUEST_ENTITY_TOO_LARGE = 413;
    public static final String ES_REQUEST_ENTITY_TOO_LARGE = "Request Entity Too Large";
    public static final int E_REQUEST_URI_TOO_LARGE = 414;
    public static final String ES_REQUEST_URI_TOO_LARGE = "Request-URI Too Large";
    public static final int E_UNSUPPORTED_MEDIA_TYPE = 415;
    public static final String ES_UNSUPPORTED_MEDIA_TYPE = "Unsupported Media Type";
    public static final int E_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final String ES_REQUESTED_RANGE_NOT_SATISFIABLE = "Requested range not satisfiable";
    public static final int E_EXPECTATION_FAILED = 417;
    public static final String ES_EXPECTATION_FAILED = "Expectation Failed";
    public static final int E_UNPROCESSABLE_ENTITY = 422;
    public static final String ES_UNPROCESSABLE_ENTITY = "Unprocessable Entity";
    public static final int E_LOCKED = 423;
    public static final String ES_LOCKED = "Locked";
    public static final int E_FAILED_DEPENDENCY = 424;
    public static final String ES_FAILED_DEPENDENCY = "Failed Dependency";
    public static final int F_INTERNAL_SERVER_ERROR = 500;
    public static final String FS_INTERNAL_SERVER_ERROR = "Internal Server Error";
    public static final int F_NOT_IMPLEMENTED = 501;
    public static final String FS_NOT_IMPLEMENTED = "Not Implemented";
    public static final int F_BAD_GATEWAY = 502;
    public static final String FS_BAD_GATEWAY = "Bad Gateway";
    public static final int F_SERVICE_UNAVAILABLE = 503;
    public static final String FS_SERVICE_UNAVAILABLE = "Service Unavailable";
    public static final int F_GATEWAY_TIMEOUT = 504;
    public static final String FS_GATEWAY_TIMEOUT = "Gateway Time-out";
    public static final int F_HTTP_VERSION_NOT_SUPPORTED = 505;
    public static final String FS_HTTP_VERSION_NOT_SUPPORTED = "HTTP Version not supported";
    public static final int F_INSUFFICIENT_STORAGE = 507;
    public static final String FS_INSUFFICIENT_STORAGE = "Insufficient Storage";
    public static final String CNTN_TYP = "Content-Type";
    public static final String TEXT_XML_PARAM = "text/xml; charset=utf-8";
    public static final String CNTN_LEN = "Content-Length";
    public static final String HDR_PRAGMA = "Pragma";
    public static final String HDR_PRAGMA_PARAM = "No-Cache";
    public static final String HDR_EXP_DATE = "Expires";
    public static final String HDR_EXP_DATE_PARAM = "Thu, 01 Jan 1970 00:00:00 GMT";
    public static final String HDR_CACHE_CTRL = "Cache-Control";
    public static final String HDR_CACHE_CTRL_PARAM = "no-Cache";
    public static final String HDR_CODEC = "Content-Encoding";
    public static final String HDR_DEFLATE_PARAM = "deflate";
    public static final String HDR_GZIP_PARAM = "gzip";
    private String statusLine = "";
    private StringBuilder msgHeader = null;
    private boolean identity = true;
    private boolean deflate = false;
    private boolean gzip = false;
    private String contentType = "text/xml; charset=utf-8";
    private static final int HEADER_BUF_SIZE = 256;
    private static final String SPACE = " ";
    private static final String COLON = ":";
    public static final String COLON_SPACE = ": ";
    private IHttpResponse httpResponse;

    public byte[] getMessageStatus() {
        byte[] response = null;
        try {
            response = this.statusLine.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            response = null;
        }
        return response;
    }

    public byte[] getMessageHeader() {
        byte[] response = null;
        if (this.msgHeader != null) {
            try {
                response = this.msgHeader.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                response = null;
            }
        }
        return response;
    }

    public void setIdentity(boolean trueOrFalse) {
        this.identity = trueOrFalse;
    }

    public boolean getIdentity() {
        return this.identity;
    }

    public void setDeflate(boolean trueOrFalse) {
        this.deflate = trueOrFalse;
    }

    public boolean getDeflate() {
        return this.deflate;
    }

    public void setGzip(boolean trueOrFalse) {
        this.gzip = trueOrFalse;
    }

    public boolean getGzip() {
        return this.gzip;
    }

    public XMLAResponseMessage(XMLAMessage m) {
        super((byte)56, (byte)2);
        MsgBox.CommState status = m.getStatus();
        switch (status) {
            case OK: {
                this.statusLine = "HTTP/1.1 200 OK";
                break;
            }
            case HTTP_UNKNOWN_SERVLET: {
                this.statusLine = "HTTP/1.1 501 Not Implemented";
                break;
            }
            case HTTP_METHOD_UNSUPPORTED: {
                this.statusLine = "HTTP/1.1 405 Method Not Allowed";
                break;
            }
            case HTTP_HDR_PARSE_ERROR: {
                this.statusLine = "HTTP/1.1 400 Bad Request";
                break;
            }
            case HTTP_HDR_CODEC_UNSUPP: {
                this.statusLine = "HTTP/1.1 415 Unsupported Media Type";
                break;
            }
            case HTTP_HDR_ENCRYPT_UNSUPP: {
                this.statusLine = "HTTP/1.1 403 Forbidden";
                break;
            }
            case HTTP_UNAUTHORIZED: {
                this.statusLine = "HTTP/1.1 401 Unauthorized";
                this.msgHeader = new StringBuilder("WWW-Authenticate: Basic realm=\"IBMCubingServices\"" + CRLF);
                break;
            }
            case HTTP_FORBIDDEN: {
                this.statusLine = "HTTP/1.1 403 Forbidden";
                break;
            }
            case HTTP_BAD_SOAP_ACTION: {
                this.statusLine = "HTTP/1.1 501 Not Implemented";
                break;
            }
            case HTTP_INTERNAL_ERROR: 
            case HTTP_SOAP_MESSAGE_ERROR: {
                this.statusLine = "HTTP/1.1 500 Internal Server Error";
                break;
            }
            default: {
                this.statusLine = "HTTP/1.1 400 Bad Request";
            }
        }
        this.statusLine = this.statusLine + CRLF;
    }

    public XMLAResponseMessage(XMLAMessage requestMessage, IHttpResponse handlerResponse) {
        this(requestMessage);
        this.httpResponse = handlerResponse;
    }

    @Override
    public void unpack() throws Exception {
    }

    @Override
    public void pack() throws Exception {
        if (this.httpResponse != null) {
            if (this.msgHeader == null) {
                this.msgHeader = new StringBuilder(256);
            }
            this.msgHeader.append("Pragma: No-Cache" + CRLF);
            this.msgHeader.append("Expires: Thu, 01 Jan 1970 00:00:00 GMT" + CRLF);
            this.msgHeader.append("Cache-Control: no-Cache" + CRLF);
            this.msgHeader.append("Content-Type: " + this.contentType + CRLF);
            this.msgHeader.append("Transfer-Encoding: chunked" + CRLF);
            if (this.getGzip()) {
                this.msgHeader.append("Content-Encoding: gzip" + CRLF);
            }
            if (this.getDeflate()) {
                this.msgHeader.append("Content-Encoding: deflate" + CRLF);
            }
            ZipiBridge.addZipiHeaders(this.msgHeader);
            this.msgHeader.append(CRLF);
        } else {
            this.msgHeader = new StringBuilder(CRLF);
        }
    }

    public void setContentType(String newContentType) {
        this.contentType = newContentType;
    }

    public void writeMessageInfo(AbstractSocketOutputStream httpSocketOutputStream, byte[] info) throws IOException {
        if (httpSocketOutputStream != null && info != null && info.length > 0) {
            boolean originalIsChunking = httpSocketOutputStream.isChunking();
            httpSocketOutputStream.setChunking(false);
            httpSocketOutputStream.write(info);
            httpSocketOutputStream.flush();
            httpSocketOutputStream.setChunking(originalIsChunking);
        }
    }

    public void writeMessageBody(AbstractSocketOutputStream httpSocketOutputStream) throws IOException {
        if (httpSocketOutputStream != null && this.httpResponse != null) {
            boolean originalIsChunking = httpSocketOutputStream.isChunking();
            httpSocketOutputStream.setChunking(true);
            this.httpResponse.writeResponseBody(httpSocketOutputStream);
            httpSocketOutputStream.flush();
            httpSocketOutputStream.setChunking(false);
            httpSocketOutputStream.writeLastChunk();
            httpSocketOutputStream.writeCRLF();
            httpSocketOutputStream.setChunking(originalIsChunking);
        }
    }
}

