/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.management;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.management.XqeMBeanServer;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqebifw.management.WaitDataCollectorMBean;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanException;
import javax.management.ObjectName;

public class WaitDataCollector
implements WaitDataCollectorMBean {
    private static final int DEFAULT_INTERVAL = 30000;
    private AtomicInteger interval = new AtomicInteger(30000);
    private AtomicBoolean enabled = new AtomicBoolean(false);
    private Method javacore = null;
    private Method heapdump = null;
    private static XQELogger mLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MIB", LogLevel.ERROR);
    public static final String DATA_COLLECTOR_MBEAN_NAME = "com.cognos.xqe:type=util,service=queryService";

    public WaitDataCollector() {
        try {
            Class<?> dumpClass = Class.forName("com.ibm.jvm.Dump");
            this.javacore = dumpClass.getMethod("JavaDump", null);
            this.heapdump = dumpClass.getMethod("HeapDump", null);
        }
        catch (Exception e) {
            mLogger.log(LogLevel.INFO, "Could not find IBM JVM Dump class or methods.", (Throwable)e);
        }
    }

    @Override
    public void dumpJavacore() throws MBeanException {
        if (this.javacore != null) {
            try {
                this.javacore.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
        }
    }

    @Override
    public void dumpHeap() throws MBeanException {
        if (this.heapdump != null) {
            try {
                this.heapdump.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
        }
    }

    @Override
    public int getInterval() {
        return this.interval.get();
    }

    @Override
    public boolean getStatus() {
        return this.enabled.get();
    }

    @Override
    public void setInterval(int newInterval) {
        this.interval.set(newInterval);
    }

    @Override
    public void startCollection() {
        this.enabled.set(true);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (WaitDataCollector.this.enabled.get()) {
                    try {
                        Thread.sleep(WaitDataCollector.this.interval.get());
                        WaitDataCollector.this.dumpJavacore();
                    }
                    catch (Exception e) {
                        mLogger.log(e);
                        WaitDataCollector.this.enabled.set(false);
                    }
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void stopCollection() {
        this.enabled.set(false);
    }

    public static void registerMBean() {
        try {
            ObjectName objName = new ObjectName(DATA_COLLECTOR_MBEAN_NAME);
            XqeMBeanServer.getInstance().registerMBean(new WaitDataCollector(), objName);
        }
        catch (Exception e) {
            mLogger.log(LogLevel.WARN, (Throwable)e);
        }
    }

    public static void unregisterMBean() {
        try {
            ObjectName objName = new ObjectName(DATA_COLLECTOR_MBEAN_NAME);
            XqeMBeanServer.getInstance().unregisterMBean(objName);
        }
        catch (Exception e) {
            mLogger.log(LogLevel.WARN, (Throwable)e);
        }
    }

    @Override
    public void setJVMSystemProperty(String key, String value) {
        System.setProperty(key, value);
    }

    @Override
    public String getJVMSystemProperty(String key) {
        return System.getProperty(key);
    }

    @Override
    public void removeJVMSystemProperty(String key) {
        if (System.getProperty(key) != null) {
            System.getProperties().remove(key);
        }
    }
}

