/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.management;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.securecache.MemberStorage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqebifw.management.XqeCacheOperations;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Timer;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;

public final class XqeSALMetrics {
    public static final String XQE_SAL_METRICS_MBEAN_NAME = "com.cognos:type=salMetrics,service=xqeMetricsService";
    private static final String GETCACHED_DATASOURCES = "getCachedDatasources";
    private static final String GETCACHED_CATALOGS = "getCachedCatalogs";
    private static final String GETCACHED_CUBES = "getCachedCubes";
    private static final String GETCACHE_OPERATIONS = "getCacheOperations";
    private MBeanServer mbeanServer = null;
    public static final String FLUSH_NON_LOCALIZED = "Clear cache";
    public static final String DUMP_NON_LOCALIZED = "Write cache state";
    private static XqeSALMetrics salmanager = null;
    private ObjectName objName = null;
    private Timer threadTimer = new Timer("XQESaALMetrics-Timer", true);
    private static XQELogger mLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MIB", LogLevel.ERROR);

    public ObjectName getObjName() {
        return this.objName;
    }

    public static void start(MBeanServer server) {
        if (salmanager == null) {
            salmanager = new XqeSALMetrics(server);
        }
    }

    public static void stop() {
        if (salmanager != null) {
            try {
                XqeSALMetrics.salmanager.mbeanServer.unregisterMBean(XqeSALMetrics.salmanager.objName);
            }
            catch (MBeanRegistrationException e) {
                mLogger.log(e);
            }
            catch (InstanceNotFoundException e) {
                mLogger.log(e);
            }
            XqeSALMetrics.salmanager.threadTimer.cancel();
            salmanager = null;
        }
    }

    public XqeSALMetrics() {
    }

    private XqeSALMetrics(MBeanServer server) {
        this.mbeanServer = server;
        try {
            Method flushMethod = XqeSALMetrics.class.getMethod("flush", new Class[0]);
            Method dumpMethod = XqeSALMetrics.class.getMethod("dump", new Class[0]);
            Method flushDMRMethod = XqeSALMetrics.class.getMethod("flushDMRCache", new Class[0]);
            Method dumpDMRMethod = XqeSALMetrics.class.getMethod("dumpDMRCache", new Class[0]);
            Method parameterizedFlushMethod = XqeSALMetrics.class.getMethod("flush", String.class, String.class, String.class);
            Method parameterizedDumpMethod = XqeSALMetrics.class.getMethod("dump", String.class, String.class, String.class);
            Method parameterizedFlushDMRMethod = XqeSALMetrics.class.getMethod("flushDMRCache", String.class, String.class);
            Method parameterizedDumpDMRMethod = XqeSALMetrics.class.getMethod("dumpDMRCache", String.class, String.class);
            Method getDatasourcesMethod = XqeSALMetrics.class.getMethod(GETCACHED_DATASOURCES, new Class[0]);
            Method getCatalogsMethod = XqeSALMetrics.class.getMethod(GETCACHED_CATALOGS, String.class);
            Method getCubesMethod = XqeSALMetrics.class.getMethod(GETCACHED_CUBES, String.class, String.class);
            Method getCacheOperations = XqeSALMetrics.class.getMethod(GETCACHE_OPERATIONS, String.class);
            ModelMBeanOperationInfo flushInfo = new ModelMBeanOperationInfo("Flush All the SAL Cache", flushMethod);
            ModelMBeanOperationInfo dumpInfo = new ModelMBeanOperationInfo("Dump All the SAL Cache to Logs", dumpMethod);
            ModelMBeanOperationInfo parameterizedFlushInfo = new ModelMBeanOperationInfo("Flush the SAL Cache for specified datasource/catalog/cube", parameterizedFlushMethod);
            ModelMBeanOperationInfo parameterizedDumpInfo = new ModelMBeanOperationInfo("Dump the SAL Cache for specified datasource/catalog/cube", parameterizedDumpMethod);
            ModelMBeanOperationInfo flushDMRInfo = new ModelMBeanOperationInfo("Flush ALl the SAL Cache for DMR Datasource", flushDMRMethod);
            ModelMBeanOperationInfo dumpDMRInfo = new ModelMBeanOperationInfo("Dump All the SAL Cache for DMR Datasource to Logs", dumpDMRMethod);
            ModelMBeanOperationInfo parameterizedFlushDMRInfo = new ModelMBeanOperationInfo("Flush the SAL Cache for DMR Datasource for specified datasource/package", parameterizedFlushDMRMethod);
            ModelMBeanOperationInfo parameterizedDumpDMRInfo = new ModelMBeanOperationInfo("Dump the SAL Cache for DMR Datasource for specified datasource/package", parameterizedDumpDMRMethod);
            ModelMBeanOperationInfo getCachedDatasourcesInfo = new ModelMBeanOperationInfo("fetches cached datasources list", getDatasourcesMethod);
            ModelMBeanOperationInfo getCachedCatalogsInfo = new ModelMBeanOperationInfo("fetches cached catalogs list", getCatalogsMethod);
            ModelMBeanOperationInfo getCachedCubesInfo = new ModelMBeanOperationInfo("fetches cached Cubes list", getCubesMethod);
            ModelMBeanOperationInfo getCacheOperationsInfo = new ModelMBeanOperationInfo("gets list of permissible operations on cache", getCacheOperations);
            ModelMBeanInfoSupport mmbi = new ModelMBeanInfoSupport(XqeSALMetrics.class.getName(), "Holds SAL Cache related operations", null, null, new ModelMBeanOperationInfo[]{flushInfo, dumpInfo, parameterizedFlushInfo, parameterizedDumpInfo, flushDMRInfo, dumpDMRInfo, parameterizedFlushDMRInfo, parameterizedDumpDMRInfo, getCachedDatasourcesInfo, getCachedCatalogsInfo, getCachedCubesInfo, getCacheOperationsInfo}, null);
            RequiredModelMBean mmb = new RequiredModelMBean(mmbi);
            mmb.setManagedResource(this, "ObjectReference");
            try {
                this.objName = new ObjectName(XQE_SAL_METRICS_MBEAN_NAME);
            }
            catch (MalformedObjectNameException e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
            }
            try {
                this.mbeanServer.registerMBean(mmb, this.objName);
            }
            catch (InstanceAlreadyExistsException e) {
                throw new XQERuntimeException(e);
            }
            catch (MBeanRegistrationException e) {
                throw new XQERuntimeException(e);
            }
            catch (NotCompliantMBeanException e) {
                throw new XQERuntimeException(e);
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, e);
        }
    }

    public boolean flush() {
        return XqeCacheOperations.flush();
    }

    public boolean flush(String dataSourceName, String catalogName, String cubeName) {
        return XqeCacheOperations.flush(dataSourceName, catalogName, cubeName);
    }

    public String dump() {
        return XqeCacheOperations.dump();
    }

    public String dump(String dataSourceName, String catalogName, String cubeName) {
        return XqeCacheOperations.dump(dataSourceName, catalogName, cubeName);
    }

    public String[] getCachedDatasources() {
        Collection<String> dataSources = MemberStorage.getDataSources();
        return dataSources.toArray(new String[0]);
    }

    public String[] getCachedCatalogs(String datasources) {
        Collection<String> catalogs = MemberStorage.getCatalogs(datasources);
        return catalogs.toArray(new String[0]);
    }

    public String[] getCachedCubes(String datasource, String catalog) {
        Collection<String> cubes = MemberStorage.getCubes(datasource, catalog);
        return cubes.toArray(new String[0]);
    }

    public static String[] getCacheOperations(String contentLocale) {
        return new String[]{XqeSALMetrics.getFlushOperationLocalizedName(contentLocale), XqeSALMetrics.getDumpOperationLocalizedName(contentLocale)};
    }

    public static String[] getROLAPOperations(String contentLocale) {
        return new String[]{XqeSALMetrics.getROLAPRefreshCubeDataCacheOperationLocalizedName(contentLocale), XqeSALMetrics.getROLAPRefreshCubeMemberCacheOperationLocalizedName(contentLocale), XqeSALMetrics.getROLAPRefreshCubeSecurityOperationLocalizedName(contentLocale), XqeSALMetrics.getROLAPRestartCubesOperationLocalizedName(contentLocale), XqeSALMetrics.getROLAPStartCubesOperationLocalizedName(contentLocale), XqeSALMetrics.getROLAPStopCubesOperationLocalizedName(contentLocale), XqeSALMetrics.getROLAPForcedStartCubesOperationLocalizedName(contentLocale), XqeSALMetrics.getROLAPForcedStopCubesOperationLocalizedName(contentLocale), XqeSALMetrics.getROLAPClearCubeWorkloadLogOperationLocalizedName(contentLocale)};
    }

    public boolean flushDMRCache(String dataSourceName, String packageName) {
        return XqeCacheOperations.flushDMRCache(dataSourceName, packageName);
    }

    public String dumpDMRCache(String dataSourceName, String packageName) {
        return XqeCacheOperations.dumpDMRCache(dataSourceName, packageName);
    }

    public boolean flushDMRCache() {
        return XqeCacheOperations.flushDMRCache();
    }

    public String dumpDMRCache() {
        return XqeCacheOperations.dumpDMRCache();
    }

    public static String getFlushOperationLocalizedName(String contentLocale) {
        return XQEMessages.getMessage(XQEMessageKeys.UI_xqeClearCacheLink, LocaleConverter.strToLocale(contentLocale));
    }

    public static String getDumpOperationLocalizedName(String contentLocale) {
        return XQEMessages.getMessage(XQEMessageKeys.UI_xqeWriteCacheStateLink, LocaleConverter.strToLocale(contentLocale));
    }

    public static String getROLAPRefreshCubeDataCacheOperationLocalizedName(String contentLocale) {
        return XQEMessages.getMessage(XQEMessageKeys.UI_xqeROLAPQSATRefreshDataCacheOperation, LocaleConverter.strToLocale(contentLocale));
    }

    public static String getROLAPRefreshCubeMemberCacheOperationLocalizedName(String contentLocale) {
        return XQEMessages.getMessage(XQEMessageKeys.UI_xqeROLAPQSATRefreshMemberCacheOperation, LocaleConverter.strToLocale(contentLocale));
    }

    public static String getROLAPRefreshCubeSecurityOperationLocalizedName(String contentLocale) {
        return XQEMessages.getMessage(XQEMessageKeys.UI_xqeROLAPQSATRefreshSecuritySettingsOperation, LocaleConverter.strToLocale(contentLocale));
    }

    public static String getROLAPRestartCubesOperationLocalizedName(String contentLocale) {
        return XQEMessages.getMessage(XQEMessageKeys.UI_xqeROLAPQSATRestartOperation, LocaleConverter.strToLocale(contentLocale));
    }

    public static String getROLAPStartCubesOperationLocalizedName(String contentLocale) {
        return XQEMessages.getMessage(XQEMessageKeys.UI_xqeROLAPQSATStartOperation, LocaleConverter.strToLocale(contentLocale));
    }

    public static String getROLAPForcedStartCubesOperationLocalizedName(String contentLocale) {
        return XQEMessages.getMessage(XQEMessageKeys.UI_xqeROLAPQSATStartCubesAndSourceCubesOperation, LocaleConverter.strToLocale(contentLocale));
    }

    public static String getROLAPClearCubeWorkloadLogOperationLocalizedName(String contentLocale) {
        return XQEMessages.getMessage(XQEMessageKeys.UI_xqeROLAPQSATClearWorkloadLogOperation, LocaleConverter.strToLocale(contentLocale));
    }

    public static String getROLAPStopCubesOperationLocalizedName(String contentLocale) {
        return XQEMessages.getMessage(XQEMessageKeys.UI_xqeROLAPQSATStopOperation, LocaleConverter.strToLocale(contentLocale));
    }

    public static String getROLAPForcedStopCubesOperationLocalizedName(String contentLocale) {
        return XQEMessages.getMessage(XQEMessageKeys.UI_xqeROLAPQSATStopImmediatelyOperation, LocaleConverter.strToLocale(contentLocale));
    }
}

