/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.management;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.management.XqeMetricNotificationSupport;
import com.cognos.xqe.metrics.IMetricsMBean;
import com.cognos.xqe.metrics.Metric;
import com.cognos.xqe.metrics.MetricTimestamp;
import com.cognos.xqe.metrics.MetricsCompositeMetric;
import com.cognos.xqe.metrics.MetricsCounter;
import com.cognos.xqe.metrics.MetricsCounterDoesNotExist;
import com.cognos.xqe.metrics.MetricsCurrentTime;
import com.cognos.xqe.metrics.MetricsStatus;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeMessages;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeMetrics;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class XqeSystemMetricsMBean
extends XqeMetricNotificationSupport
implements IMetricsMBean {
    private static final String TIME = "Time";
    private static final String XQE_METRICS_RESET = "reset";
    private static final String XQE_ROLAP_PARAM_NAME = "cubeNames";
    private static final String XQE_ROLAP_PARAM_DESC = "Cubes to process";
    private static final String[] XQE_ROLAP_TYPE_NAMES = new String[]{"cubeName", "state", "messages", "dependents", "sources", "stoppedSources", "runningDependents"};
    private static final String[] XQE_ROLAP_TYPE_DESCRIPTIONS = new String[]{"Cube name", "Current cube state", "Admin operation messages", "Dependent cubes", "Source cubes", "Stopped source cubes", "Running dependent cubes"};
    private static final OpenType<?>[] XQE_ROLAP_FIELD_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
    public static final String XQE_METRICS_LAST_RESET = "LastXqeQueriesResetTime";
    private ConcurrentHashMap<String, Metric> metricsMap = new ConcurrentHashMap();
    private static Map<String, String> attributeNameMap = new HashMap<String, String>(){
        {
            this.put("AllRequestsLastUpdateTime", "NumberOfReceivedRequestsLastUpdateTime");
            this.put("FailedRequestsLastUpdateTime", "NumberOfFailedRequestsLastUpdateTime");
            this.put("LastRequestResetTime", "NumberOfReceivedRequestsLastResetTime");
            this.put("OperationalStatusLastUpdateTime", "OperationalStatusLastUpdateTime");
            this.put("ReceivedRequestsLastUpdateTime", "NumberOfReceivedRequestsLastUpdateTime");
            this.put("SuccessfulRequestsLastUpdateTime", "NumberOfSuccessfulRequestsLastUpdateTime");
        }
    };
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MIB", LogLevel.ERROR);
    private CompositeType cubeStateCompositeType;
    private TabularType cubeStateTabularType;
    private CompositeType cubeStateContainerType;
    private ArrayList<String> rolapFieldNames = new ArrayList<String>(Arrays.asList(XQE_ROLAP_TYPE_NAMES));
    private MBeanInfo cachedInfo = null;
    private static final String VOID = "void";

    public XqeSystemMetricsMBean() {
        this.metricsMap.put(XQE_METRICS_LAST_RESET, new MetricTimestamp(XQE_METRICS_LAST_RESET));
        this.metricsMap.put("CurrentTime", new MetricsCurrentTime("CurrentTime"));
        this.metricsMap.put("OperationalStatus", new MetricsStatus("OperationalStatus"));
        this.metricsMap.put("OperationalStatusLastUpdateTime", new MetricsCurrentTime("OperationalStatusLastUpdateTime"));
        MetricsCounter lastResponseTime = new MetricsCounter("LastResponseTime");
        MetricTimestamp lastResponseTimeUpdate = new MetricTimestamp("LastResponseTimeLastUpdateTime");
        MetricsCompositeMetric composite = new MetricsCompositeMetric("ConsolidatedLastResponseTime", new Metric[]{lastResponseTime, lastResponseTimeUpdate});
        this.metricsMap.put("LastResponseTime", lastResponseTime);
        this.metricsMap.put("LastResponseTimeLastUpdateTime", lastResponseTimeUpdate);
        this.metricsMap.put("ConsolidatedLastResponseTime", composite);
        try {
            this.rolapFieldNames.addAll(ROLAPCubeMetrics.getNames());
            ArrayList<String> descriptions = new ArrayList<String>(Arrays.asList(XQE_ROLAP_TYPE_DESCRIPTIONS));
            descriptions.addAll(ROLAPCubeMetrics.getDescriptions());
            ArrayList types = new ArrayList(Arrays.asList(XQE_ROLAP_FIELD_TYPES));
            types.add(ROLAPCubeMessages.getDefinition());
            types.add(ROLAPCube.getCubeListType());
            types.add(ROLAPCube.getCubeListType());
            types.add(ROLAPCube.getCubeListType());
            types.add(ROLAPCube.getCubeListType());
            types.addAll(ROLAPCubeMetrics.getTypes());
            this.cubeStateCompositeType = new CompositeType("cubeStates", "Cube states", this.rolapFieldNames.toArray(new String[0]), descriptions.toArray(new String[0]), types.toArray(new OpenType[0]));
            this.cubeStateTabularType = new TabularType("cubeStates", "Cube states", this.cubeStateCompositeType, new String[]{"cubeName"});
            this.cubeStateContainerType = new CompositeType("cubeStates", "Cube states", new String[]{"cubeStates"}, new String[]{"Cube states"}, new OpenType[]{this.cubeStateTabularType});
        }
        catch (OpenDataException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        String name;
        if (attribute == null) {
            throw new AttributeNotFoundException("null");
        }
        if ("CubeState".equals(attribute)) {
            return this.getCubeState();
        }
        Metric metric = null;
        metric = this.metricsMap.get(attribute);
        if (metric == null && (name = attributeNameMap.get(attribute)) != null) {
            metric = this.metricsMap.get(name);
        }
        if (metric != null) {
            return metric.getValue();
        }
        throw new AttributeNotFoundException(attribute);
    }

    private CompositeData getCubeState() throws MBeanException {
        Collection<ROLAPCube> cubes = ROLAPCubeManager.getInstance().getCubes();
        try {
            TabularDataSupport tds = new TabularDataSupport(this.cubeStateTabularType);
            for (ROLAPCube cube : cubes) {
                ArrayList<Object> values = new ArrayList<Object>();
                values.add(cube.getName());
                values.add(cube.getState().toString());
                values.add(cube.getMessages().getValues());
                values.add(cube.getDependentCubesMetricValues());
                values.add(cube.getSourceCubesMetricValues());
                values.add(cube.getStoppedSourceCubesMetricValues());
                values.add(cube.getRunningDependentCubesMetricValues());
                values.addAll(cube.getMetrics().getValues());
                CompositeDataSupport cds = new CompositeDataSupport(this.cubeStateCompositeType, this.rolapFieldNames.toArray(new String[0]), values.toArray(new Object[0]));
                tds.put(cds);
            }
            return new CompositeDataSupport(this.cubeStateContainerType, new String[]{"cubeStates"}, new Object[]{tds});
        }
        catch (Throwable e) {
            mErrorLogger.log("Error building cube state metric value", e);
            throw new MBeanException(new XQERuntimeException(e));
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList attribs = new AttributeList();
        if (attributes == null) {
            return attribs;
        }
        for (String attrib : attributes) {
            try {
                attribs.add(new Attribute(attrib, this.getAttribute(attrib)));
            }
            catch (Exception e) {
                mErrorLogger.log(e);
            }
        }
        return attribs;
    }

    public MBeanInfo buildMBeanInfo() {
        String className = this.getClass().getName();
        String description = "This MBean provides system metrics for the XQE service.";
        ArrayList<MBeanAttributeInfo> attribs = new ArrayList<MBeanAttributeInfo>();
        MBeanAttributeInfo attrib = null;
        attrib = new MBeanAttributeInfo("CubeState", CompositeData.class.getCanonicalName(), "Cube states", true, false, false);
        attribs.add(attrib);
        attrib = new MBeanAttributeInfo("PackageCacheState", CompositeData.class.getCanonicalName(), "Package cache state", true, false, false);
        attribs.add(attrib);
        for (String key : this.metricsMap.keySet()) {
            String attribClass = key.endsWith(TIME) ? Date.class.getName() : Long.class.getName();
            try {
                attrib = new MBeanAttributeInfo(key, attribClass, "Access metric " + key, true, false, false);
            }
            catch (Exception ex) {
                mErrorLogger.log(ex);
                return null;
            }
            attribs.add(attrib);
        }
        MBeanAttributeInfo[] mbeanAttribs = new MBeanAttributeInfo[attribs.size()];
        attribs.toArray(mbeanAttribs);
        MBeanOperationInfo[] operationInfo = new MBeanOperationInfo[]{new MBeanOperationInfo(XQE_METRICS_RESET, "Resets MBean counters", null, VOID, 1), new MBeanOperationInfo(XQE_METRICS_RESET, "Resets a particular MBean counter", new MBeanParameterInfo[]{new MBeanParameterInfo("counterName", "java.lang.String", "Counter Name")}, VOID, 1), new MBeanOperationInfo("startCubes", "Start specified ROLAP cubes", new MBeanParameterInfo[]{new MBeanParameterInfo(XQE_ROLAP_PARAM_NAME, "[Ljava.lang.String;", XQE_ROLAP_PARAM_DESC)}, VOID, 1), new MBeanOperationInfo("forceStartCubes", "Start specified ROLAP cubes and their source cubes", new MBeanParameterInfo[]{new MBeanParameterInfo(XQE_ROLAP_PARAM_NAME, "[Ljava.lang.String;", XQE_ROLAP_PARAM_DESC)}, VOID, 1), new MBeanOperationInfo("stopCubes", "Stop specified ROLAP cubes", new MBeanParameterInfo[]{new MBeanParameterInfo(XQE_ROLAP_PARAM_NAME, "[Ljava.lang.String;", XQE_ROLAP_PARAM_DESC)}, VOID, 1), new MBeanOperationInfo("forceStopCubes", "Force-stop specified ROLAP cubes", new MBeanParameterInfo[]{new MBeanParameterInfo(XQE_ROLAP_PARAM_NAME, "[Ljava.lang.String;", XQE_ROLAP_PARAM_DESC)}, VOID, 1), new MBeanOperationInfo("restartCubes", "Restart specified ROLAP cubes", new MBeanParameterInfo[]{new MBeanParameterInfo(XQE_ROLAP_PARAM_NAME, "[Ljava.lang.String;", XQE_ROLAP_PARAM_DESC)}, VOID, 1), new MBeanOperationInfo("refreshCubeMemberCache", "Refresh member caches for specified ROLAP cubes", new MBeanParameterInfo[]{new MBeanParameterInfo(XQE_ROLAP_PARAM_NAME, "[Ljava.lang.String;", XQE_ROLAP_PARAM_DESC)}, VOID, 1), new MBeanOperationInfo("refreshCubeDataCache", "Refresh data caches for specified ROLAP cubes", new MBeanParameterInfo[]{new MBeanParameterInfo(XQE_ROLAP_PARAM_NAME, "[Ljava.lang.String;", XQE_ROLAP_PARAM_DESC)}, VOID, 1), new MBeanOperationInfo("refreshCubeSecurity", "Refresh security for specified ROLAP cubes", new MBeanParameterInfo[]{new MBeanParameterInfo(XQE_ROLAP_PARAM_NAME, "[Ljava.lang.String;", XQE_ROLAP_PARAM_DESC)}, VOID, 1), new MBeanOperationInfo("clearCubeWorkloadLog", "Clear workload log for specified ROLAP cubes", new MBeanParameterInfo[]{new MBeanParameterInfo(XQE_ROLAP_PARAM_NAME, "[Ljava.lang.String;", XQE_ROLAP_PARAM_DESC)}, VOID, 1), new MBeanOperationInfo("pauseCubes", "Pause specified ROLAP cubes", new MBeanParameterInfo[]{new MBeanParameterInfo(XQE_ROLAP_PARAM_NAME, "[Ljava.lang.String;", XQE_ROLAP_PARAM_DESC)}, VOID, 1), new MBeanOperationInfo("incrementallyLoadCubes", "Incrementally load specified ROLAP cubes", new MBeanParameterInfo[]{new MBeanParameterInfo(XQE_ROLAP_PARAM_NAME, "[Ljava.lang.String;", XQE_ROLAP_PARAM_DESC), new MBeanParameterInfo("transactionID", "java.lang.String", "Transaction ID to load")}, VOID, 1)};
        MBeanNotificationInfo[] notifInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "A metric in this MBean has changed.")};
        MBeanInfo info = new MBeanInfo(className, description, mbeanAttribs, null, operationInfo, notifInfo);
        return info;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.cachedInfo == null) {
            this.cachedInfo = this.buildMBeanInfo();
        }
        return this.cachedInfo;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (XQE_METRICS_RESET.equals(actionName)) {
            String counterType = null;
            if (params != null && params.length > 0 && params[0] != null && params[0] instanceof String) {
                counterType = (String)params[0];
            }
            if (counterType == null) {
                this.reset();
            } else {
                this.resetCounter(counterType);
            }
            return null;
        }
        if ("startCubes".equals(actionName)) {
            ROLAPCubeManager.getInstance().startCubes(Arrays.asList((String[])params[0]));
            return null;
        }
        if ("forceStartCubes".equals(actionName)) {
            ROLAPCubeManager.getInstance().forceStartCubes(Arrays.asList((String[])params[0]), false);
            return null;
        }
        if ("stopCubes".equals(actionName)) {
            ROLAPCubeManager.getInstance().stopCubes(Arrays.asList((String[])params[0]));
            return null;
        }
        if ("forceStopCubes".equals(actionName)) {
            ROLAPCubeManager.getInstance().forceStopCubes(Arrays.asList((String[])params[0]));
            return null;
        }
        if ("restartCubes".equals(actionName)) {
            ROLAPCubeManager.getInstance().restartCubes(Arrays.asList((String[])params[0]));
            return null;
        }
        if ("refreshCubeMemberCache".equals(actionName)) {
            ROLAPCubeManager.getInstance().refreshCubeMemberCache(Arrays.asList((String[])params[0]));
            return null;
        }
        if ("refreshCubeDataCache".equals(actionName)) {
            ROLAPCubeManager.getInstance().refreshCubeDataCache(Arrays.asList((String[])params[0]));
            return null;
        }
        if ("enableResultSetCache".equals(actionName)) {
            ROLAPCubeManager.getInstance().disableResultSetCache(Arrays.asList((String[])params[0]), false);
            return null;
        }
        if ("disableResultSetCache".equals(actionName)) {
            ROLAPCubeManager.getInstance().disableResultSetCache(Arrays.asList((String[])params[0]), true);
            return null;
        }
        if ("refreshCubeSecurity".equals(actionName)) {
            ROLAPCubeManager.getInstance().refreshCubeSecurity(Arrays.asList((String[])params[0]));
            return null;
        }
        if ("clearCubeWorkloadLog".equals(actionName)) {
            ROLAPCubeManager.getInstance().clearCubeWorkloadLog(Arrays.asList((String[])params[0]));
            return null;
        }
        if ("pauseCubes".equals(actionName)) {
            ROLAPCubeManager.getInstance().pauseCubes(Arrays.asList((String[])params[0]));
            return null;
        }
        if ("incrementallyLoadCubes".equals(actionName)) {
            ROLAPCubeManager.getInstance().incrementallyLoadCubes(Arrays.asList((String[])params[0]), (String)params[1]);
            return null;
        }
        if ("addCubes".equals(actionName)) {
            ROLAPCubeManager.getInstance().addCubes(Arrays.asList((String[])params[0]));
            return null;
        }
        if ("deleteCubes".equals(actionName)) {
            ROLAPCubeManager.getInstance().deleteCubes(Arrays.asList((String[])params[0]));
            return null;
        }
        if ("setCubeProperty".equals(actionName)) {
            try {
                ROLAPCubeManager.getInstance().setCubeProperty((String)params[0], (String)params[1], Arrays.asList((String[])params[2]));
            }
            catch (XQERuntimeException e) {
                OperationsException ex = new OperationsException(String.format("%s: %s", actionName, e.getMessage()));
                throw new MBeanException(ex);
            }
            return null;
        }
        throw new MBeanException(new OperationsException(actionName));
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new InvalidAttributeValueException();
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }

    @Override
    public void reset() {
        Object oldValue = null;
        for (Metric metric : this.metricsMap.values()) {
            try {
                oldValue = metric.getValue();
                metric.reset();
                if (!(oldValue instanceof Long) || (Long)oldValue == 0L) continue;
                this.sendAttributeChangedNotification(metric.getMetricName(), (Long)oldValue, new Long(0L));
            }
            catch (Exception e) {
                mErrorLogger.log(e.getMessage());
            }
        }
    }

    @Override
    public void resetCounter(String counterType) throws MetricsCounterDoesNotExist {
        Metric metric = null;
        metric = this.metricsMap.get(counterType);
        if (metric == null) {
            throw new MetricsCounterDoesNotExist(counterType);
        }
        Object oldValue = metric.getValue();
        metric.reset();
        if (oldValue instanceof Long && (Long)oldValue != 0L) {
            this.sendAttributeChangedNotification(metric.getMetricName(), (Long)oldValue, 0L);
        }
    }

    @Override
    public Metric createMetric(String name) {
        return this.createMetric(name, 0L);
    }

    @Override
    public Metric createMetric(String name, long value) {
        this.cachedInfo = null;
        MetricsCounter counter = new MetricsCounter(name, value);
        MetricTimestamp updateTimestamp = counter.getUpdateTimeStamp();
        MetricTimestamp resetTimestamp = counter.getResetTimeStamp();
        this.metricsMap.put(name, counter);
        this.metricsMap.put(updateTimestamp.getMetricName(), updateTimestamp);
        this.metricsMap.put(resetTimestamp.getMetricName(), resetTimestamp);
        this.sendAttributeChangedNotification(name, 0L, value);
        return counter;
    }

    @Override
    public long incrementCounter(String name, long num) throws MetricsCounterDoesNotExist {
        Metric metric = null;
        metric = this.metricsMap.get(name);
        if (metric == null) {
            throw new MetricsCounterDoesNotExist(name);
        }
        long oldValue = metric.increment(num);
        long newValue = metric.getLongValue();
        this.sendAttributeChangedNotification(name, oldValue, newValue);
        return oldValue;
    }

    @Override
    public long decrementCounter(String name, long num) throws MetricsCounterDoesNotExist {
        Metric metric = null;
        metric = this.metricsMap.get(name);
        if (metric == null) {
            throw new MetricsCounterDoesNotExist(name);
        }
        long oldValue = metric.decrement(num);
        long newValue = metric.getLongValue();
        this.sendAttributeChangedNotification(name, oldValue, newValue);
        return oldValue;
    }

    @Override
    public long getCounterLongValue(String name) throws MetricsCounterDoesNotExist {
        Metric metric = null;
        metric = this.metricsMap.get(name);
        if (metric == null) {
            throw new MetricsCounterDoesNotExist(name);
        }
        long counterValue = metric.getLongValue();
        return counterValue;
    }

    @Override
    public Object[] getSnapshot(String[] counterNames) {
        Object[] metrics = new Object[counterNames.length];
        for (int i = 0; i < counterNames.length; ++i) {
            Metric metric = this.metricsMap.get(counterNames[i]);
            metrics[i] = metric.getLongValue();
        }
        return metrics;
    }

    @Override
    public void setOperationalStatus(String status) {
        Metric oldTimeStamp = this.metricsMap.get("OperationalStatusLastUpdateTime");
        MetricsCurrentTime newTimestamp = new MetricsCurrentTime("OperationalStatusLastUpdateTime");
        this.metricsMap.put("OperationalStatusLastUpdateTime", newTimestamp);
        MetricsStatus stat = new MetricsStatus("OperationalStatus");
        stat.setValue(status);
        this.metricsMap.put("OperationalStatus", stat);
        this.sendAttributeChangedNotification("OperationalStatusLastUpdateTime", oldTimeStamp.getLongValue(), newTimestamp.getLongValue());
    }

    @Override
    public long setMetricValue(String name, long value) throws MetricsCounterDoesNotExist {
        long newValue;
        Metric metric = null;
        metric = this.metricsMap.get(name);
        if (metric == null) {
            throw new MetricsCounterDoesNotExist(name);
        }
        long oldValue = metric.setValue(value);
        if (oldValue != (newValue = metric.getLongValue())) {
            this.sendAttributeChangedNotification(name, oldValue, newValue);
        }
        return oldValue;
    }
}

