/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.management;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.metrics.MetricsManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import mx4j.tools.remote.proxy.RemoteMBeanProxy;

public class XqeSystemMetricsProxyCreator
implements DynamicMBean,
NotificationListener {
    public static final String CREATE_PROXIES = "createProxies";
    private static XQELogger mLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "MIB", LogLevel.ERROR);
    private MBeanInfo mbeanInfo = null;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private ConcurrentHashMap<String, JMXConnector> connectors = new ConcurrentHashMap();

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.mbeanInfo == null) {
            this.mbeanInfo = this.buildMBeanInfo();
        }
        return this.mbeanInfo;
    }

    private MBeanInfo buildMBeanInfo() {
        MBeanInfo info = null;
        MBeanOperationInfo[] operationInfo = new MBeanOperationInfo[]{new MBeanOperationInfo(CREATE_PROXIES, "Creates metrics MBean proxies", new MBeanParameterInfo[]{new MBeanParameterInfo("qsJmxUrl", "java.lang.String", "Query Service JMX RMI URL")}, "void", 1)};
        info = new MBeanInfo(this.getClass().getName(), "Creates metrics proxy objects on query service startup.", null, null, operationInfo, null);
        return info;
    }

    private void connect(String jmxUrl) throws MBeanException {
        try {
            JMXConnector cntor = this.connectors.get(jmxUrl);
            if (cntor == null) {
                ICCLConfiguration cclConfig = XQECCLConfigurationFactory.getInstance();
                cclConfig.init();
                String dispatcherPwd = cclConfig.getValue("disp_sharedsecret", false);
                JMXServiceURL url = new JMXServiceURL(jmxUrl);
                HashMap<String, Object> environment = new HashMap<String, Object>();
                environment.put("jmx.remote.credentials", dispatcherPwd);
                environment.put("request.waiting.timeout", 300000);
                cntor = JMXConnectorFactory.connect(url, environment);
                this.connectors.put(jmxUrl, cntor);
                cntor.addConnectionNotificationListener(this, null, null);
            }
            MBeanServerConnection mbeanServerConnection = cntor.getMBeanServerConnection();
            String name = MetricsManager.getMBeanName(jmxUrl);
            ObjectName objName = new ObjectName(name);
            RemoteMBeanProxy proxy = new RemoteMBeanProxy(objName, mbeanServerConnection);
            try {
                PogoMBeanServer.getInstance().getServer().registerMBean(proxy, objName);
            }
            catch (InstanceAlreadyExistsException e) {
                PogoMBeanServer.getInstance().getServer().unregisterMBean(objName);
                PogoMBeanServer.getInstance().getServer().registerMBean(proxy, objName);
            }
            ObjectName adminMBean = new ObjectName("com.cognos.xqe:type=requestMetrics,service=queryService");
            PogoMBeanServer.getInstance().getServer().invoke(adminMBean, "registerProxy", new Object[]{name}, new String[]{String.class.getName()});
            ObjectName remotePackageMetricsName = new ObjectName("com.cognos.xqe:type=packageMetrics,service=queryService");
            ObjectName localPackageMetricsName = new ObjectName("com.cognos.xqe:type=packageMetrics,service=queryService");
            proxy = new RemoteMBeanProxy(remotePackageMetricsName, mbeanServerConnection);
            try {
                PogoMBeanServer.getInstance().getServer().registerMBean(proxy, localPackageMetricsName);
            }
            catch (InstanceAlreadyExistsException e) {
                PogoMBeanServer.getInstance().getServer().unregisterMBean(localPackageMetricsName);
                PogoMBeanServer.getInstance().getServer().registerMBean(proxy, localPackageMetricsName);
            }
        }
        catch (Exception e) {
            mErrorLogger.log(e);
            throw new MBeanException(e);
        }
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (CREATE_PROXIES.equals(actionName)) {
            String jmxUrl = null;
            if (params[0] == null || !(params[0] instanceof String)) {
                throw new MBeanException(new IllegalArgumentException());
            }
            jmxUrl = (String)params[0];
            this.connect(jmxUrl);
            return null;
        }
        throw new ReflectionException(new OperationsException(actionName));
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException(attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        return new AttributeList();
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException(attribute.getName());
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }

    public static String getMBeanName() {
        return "com.cognos.xqe:type=config,service=XqeSystemMetricsProxyCreator";
    }

    @Override
    public void handleNotification(Notification notification, Object callback) {
        boolean failure;
        String notificationType = notification.getType();
        boolean bl = failure = "jmx.remote.connection.closed".equals(notificationType) || "jmx.remote.connection.failed".equals(notificationType);
        if (failure) {
            String url = ((RMIConnector)notification.getSource()).getAddress().toString();
            mLogger.log("Unregistering proxy " + url);
            JMXConnector connector = this.connectors.remove(url);
            try {
                connector.removeConnectionNotificationListener(this);
            }
            catch (ListenerNotFoundException e) {
                mLogger.log(e);
            }
            try {
                ObjectName objName = new ObjectName(MetricsManager.getMBeanName(url));
                PogoMBeanServer.getInstance().getServer().unregisterMBean(objName);
            }
            catch (Exception e) {
                mLogger.log(e);
            }
            try {
                connector.close();
            }
            catch (IOException e) {
                mLogger.log(e);
            }
            connector = null;
        }
    }
}

