/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.management.cogadmin;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.management.XqeMetricNotificationSupport;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;

public abstract class AbstractAdminConsoleMBeanProxy
extends XqeMetricNotificationSupport
implements NotificationListener {
    protected Map<String, Object> attributeMap = new ConcurrentHashMap<String, Object>();
    protected MBeanServer mbeanServer;
    protected ObjectName proxyObjName;

    public AbstractAdminConsoleMBeanProxy(MBeanServer server, String proxy) {
        this.mbeanServer = server;
        this.setProxy(proxy);
    }

    protected Date getDateAttribute(String attributeName) {
        Date date = null;
        try {
            date = (Date)this.mbeanServer.getAttribute(this.proxyObjName, attributeName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (date == null) {
            date = (Date)this.attributeMap.get(attributeName);
        } else {
            this.attributeMap.put(attributeName, date);
        }
        return date;
    }

    protected long getLongAttribute(String attributeName) {
        Long num = null;
        try {
            num = (Long)this.mbeanServer.getAttribute(this.proxyObjName, attributeName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (num == null || num == 0L) {
            num = (Long)this.attributeMap.get(attributeName);
            if (num == null) {
                num = new Long(0L);
            }
        } else {
            this.attributeMap.put(attributeName, num);
        }
        return num;
    }

    public Object getAttribute(String attributeName) {
        try {
            return this.mbeanServer.getAttribute(this.proxyObjName, attributeName);
        }
        catch (AttributeNotFoundException e) {
            throw new XQERuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new XQERuntimeException(e);
        }
        catch (MBeanException e) {
            throw new XQERuntimeException(e);
        }
        catch (ReflectionException e) {
            throw new XQERuntimeException(e);
        }
    }

    public CompositeData getCompositeAttribute(String attributeName) {
        return (CompositeData)this.getAttribute(attributeName);
    }

    protected void setProxy(String proxyName) {
        try {
            this.proxyObjName = new ObjectName(proxyName);
            this.mbeanServer.addNotificationListener(this.proxyObjName, this, null, null);
        }
        catch (MalformedObjectNameException e) {
            throw new XQERuntimeException(e);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    protected void invokeMethod(String methodName, Object[] params, String[] signature) {
        try {
            this.mbeanServer.invoke(this.proxyObjName, methodName, params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new XQERuntimeException(e);
        }
        catch (MBeanException e) {
            throw new XQERuntimeException(e);
        }
        catch (ReflectionException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        this.sendNotification(notification);
    }
}

