/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.runtree.olap.mdx.rolapprovider.admin.tool;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCommandResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateResult;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqebifw.adminconsole.server.JmxUtils;
import com.cognos.xqebifw.management.XqeAgent;
import com.cognos.xqebifw.runtree.olap.mdx.rolapprovider.admin.tool.ROLAPAdminTestTool;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class JMXCommandPlugin
implements ROLAPAdminTestTool.ICommandPlugin {
    private ObjectName objectName = null;
    private MBeanServerConnection mbeanServerConnection = null;
    private ICCLConfiguration cclConfig = XQECCLConfigurationFactory.getInstance();
    private static final String COLON = ":";
    private static final int DEFAULT_PROXY_PORT = 9999;

    public JMXCommandPlugin(ROLAPAdminTestTool.MODE mode, int portOverride) throws Exception {
        this.cclConfig.init();
        if (mode == ROLAPAdminTestTool.MODE.JMX) {
            String[] xqeJmxUrl;
            MBeanServerConnection conn = this.getDispatcherHessianConnection();
            if (conn == null) {
                ROLAPAdminTestTool.error("Unable to create Hessian connection");
            }
            if ((xqeJmxUrl = JmxUtils.getAllXqeJMXURls(null, conn)) == null || xqeJmxUrl.length == 0) {
                ROLAPAdminTestTool.error("Cannot load a JMX URL");
            }
            String credential = JmxUtils.getPassword(null, xqeJmxUrl[0], conn);
            HashMap<String, String> environment = new HashMap<String, String>();
            environment.put("jmx.remote.credentials", credential);
            JMXConnector cntor = JMXConnectorFactory.connect(new JMXServiceURL(xqeJmxUrl[0]), environment);
            this.mbeanServerConnection = cntor.getMBeanServerConnection();
            ROLAPAdminTestTool.println("Using server: " + xqeJmxUrl[0].toString());
            this.objectName = new ObjectName("com.cognos.xqe:type=serviceMetrics,service=xqeService");
        } else {
            int proxyPort = 9999;
            if (portOverride != -1) {
                proxyPort = portOverride;
            }
            URL dispURL = new URL(this.cclConfig.getValue("internalDispatcher", false));
            int dispatcherPort = dispURL.getPort();
            String dispatcherHost = XqeAgent.normalizeLocalhost(dispURL.getHost(), false);
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + dispatcherHost + COLON + proxyPort + "/proxyserver");
            ROLAPAdminTestTool.println("Using proxy: " + url.toString());
            JMXConnector cntor = null;
            try {
                cntor = JMXConnectorFactory.connect(url);
            }
            catch (Exception e) {
                ROLAPAdminTestTool.error("Please enable JMX port in cogconfig to use JMX proxy", e);
            }
            this.mbeanServerConnection = cntor.getMBeanServerConnection();
            this.objectName = new ObjectName("com.cognos:service=queryService,dispatcher=\"http://" + dispatcherHost + COLON + dispatcherPort + "/p2pd\",type=Metrics");
        }
        if (this.mbeanServerConnection == null) {
            ROLAPAdminTestTool.error("Could not set up JMX connection");
        }
        ROLAPAdminTestTool.println("Query service object: " + this.objectName.toString() + " \n");
    }

    private MBeanServerConnection getDispatcherHessianConnection() throws Exception {
        String connectionUrl = null;
        String dispatcherAddr = this.cclConfig.getValue("internalDispatcher", false);
        String dispatcherPassword = this.cclConfig.getValue("disp_sharedsecret", false);
        connectionUrl = XqeAgent.makeDispatcherJmxUrl(new URL(dispatcherAddr), false);
        if (connectionUrl == null) {
            ROLAPAdminTestTool.error("Unable to determine dispatcher JMX URL from dispatcher URL " + dispatcherAddr);
        }
        byte[] token = CryptoProvider.getToken((byte[])dispatcherPassword.getBytes());
        JMXConnector cntor = XqeAgent.getDispatcherJMXConnection(connectionUrl, token);
        return cntor.getMBeanServerConnection();
    }

    @Override
    public IROLAPCommandResult executeCommand(String command, List<String> cubes, HashMap<String, String> arguments, boolean silent) throws Exception {
        if (!silent) {
            ROLAPAdminTestTool.println("Executing command '" + command + "' on cubes " + cubes.toString() + "\n");
        }
        if (command.equals("incrementallyLoadCubes")) {
            this.mbeanServerConnection.invoke(this.objectName, command, new Object[]{cubes.toArray(new String[0]), arguments.get("transactionID")}, new String[]{"[Ljava.lang.String;", "java.lang.String"});
        } else {
            this.mbeanServerConnection.invoke(this.objectName, command, new Object[]{cubes.toArray(new String[0])}, new String[]{"[Ljava.lang.String;"});
        }
        return null;
    }

    @Override
    public void setProperty(String propertyName, String propertyValue, List<String> cubes) throws Exception {
        if (propertyName.equals(ROLAPConfiguration.DISABLED_QNAME.getLocalPart()) || propertyName.equals(ROLAPConfiguration.ENABLE_DYNAMIC_MEMBER_CACHING_QNAME.getLocalPart()) || propertyName.equals(ROLAPConfiguration.DISABLE_RESULT_SET_CACHE_QNAME.getLocalPart()) || propertyName.equals(ROLAPConfiguration.DISABLE_EXTERNAL_AGGREGATES_QNAME.getLocalPart())) {
            JMXCommandPlugin.assertPropertyIsValidBoolean(propertyName, propertyValue);
        } else if (propertyName.equals(ROLAPConfiguration.MEMBER_CACHE_LIMIT_QNAME.getLocalPart()) || propertyName.equals(ROLAPConfiguration.PREDICATE_MEMBER_REFERENCE_THRESHOLD_QNAME.getLocalPart()) || propertyName.equals(ROLAPConfiguration.DATA_CACHE_SIZE_LIMIT_QNAME.getLocalPart()) || propertyName.equals(ROLAPConfiguration.AGGREGATE_CACHE_SIZE_LIMIT_QNAME.getLocalPart()) || propertyName.equals(ROLAPConfiguration.RESULT_SET_CACHE_SIZE_LIMIT_QNAME.getLocalPart()) || propertyName.equals(ROLAPConfiguration.MAX_HIERARCHY_LOAD_THREADS_QNAME.getLocalPart()) || propertyName.equals(ROLAPConfiguration.MAX_AGGREGATE_LOAD_THREADS_QNAME.getLocalPart()) || propertyName.equals(ROLAPConfiguration.MEASURES_THRESHOLD_QNAME.getLocalPart()) || propertyName.equals(ROLAPConfiguration.AUTOMATIC_AGGREGATE_OPTIMIZATION_QNAME.getLocalPart())) {
            JMXCommandPlugin.assertPropertyIsValidInteger(propertyName, propertyValue);
        } else {
            ROLAPAdminTestTool.error(String.format("The property '%s' is unknown.", propertyName));
        }
        ROLAPAdminTestTool.println(String.format("Setting property '%s' to '%s' on cubes %s\n", propertyName, propertyValue, cubes.toString()));
        this.mbeanServerConnection.invoke(this.objectName, "setCubeProperty", new Object[]{propertyName, propertyValue, cubes.toArray(new String[cubes.size()])}, new String[]{"java.lang.String", "java.lang.String", "[Ljava.lang.String;"});
    }

    private static void assertPropertyIsValidBoolean(String propertyName, String propertyValue) {
        if (!"true".equalsIgnoreCase(propertyValue) && !"false".equalsIgnoreCase(propertyValue)) {
            ROLAPAdminTestTool.error(String.format("The value for the property '%s' is not a boolean: %s", propertyName, propertyValue));
        }
    }

    private static void assertPropertyIsValidInteger(String propertyName, String propertyValue) {
        try {
            Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException e) {
            ROLAPAdminTestTool.error(String.format("The value for the property '%s' is not an integer: %s", propertyName, propertyValue));
        }
    }

    @Override
    public ROLAPCubeStateResult getCubeStates(List<String> cubes, boolean silent) throws Exception {
        CompositeData data = (CompositeData)this.mbeanServerConnection.getAttribute(this.objectName, "CubeState");
        TabularData td = (TabularData)data.get("cubeStates");
        Collection<CompositeData> values = CollectionCast.uncheckedCast(td.values());
        ROLAPCubeStateResult states = new ROLAPCubeStateResult();
        for (CompositeData cd : values) {
            String cubeName = cd.get("cubeName").toString();
            if (!cubes.isEmpty() && !cubes.contains(cubeName)) continue;
            String cubeState = cd.get("state").toString();
            states.setState(cubeName, cubeState);
        }
        return states;
    }
}

