/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.runtree.olap.mdx.rolapprovider.admin.tool;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCommandResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateResult;
import com.cognos.xqebifw.runtree.olap.mdx.rolapprovider.admin.tool.BiBusCommandPlugin;
import com.cognos.xqebifw.runtree.olap.mdx.rolapprovider.admin.tool.JMXCommandPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class ROLAPAdminTestTool {
    private static final String NL = "\n";
    private static final String DS = "  ";
    private static final String COMMA = ",";
    private static final String COMMA_SPACE = ", ";
    private static final long CREDENTIAL_NO = 3L;
    public static final String CMD_GET_CUBE_STATE = "getCubeState";
    public static final String CMD_GET_CUBE_METRICS = "getCubeMetrics";
    public static final String CMD_GET_CUBE_MESSAGES = "getCubeMessages";
    public static final String CMD_START_CUBES = "startCubes";
    public static final String CMD_STOP_CUBES = "stopCubes";
    public static final String CMD_FORCE_START_CUBES = "forceStartCubes";
    public static final String CMD_FORCE_STOP_CUBES = "forceStopCubes";
    public static final String CMD_RESTART_CUBES = "restartCubes";
    public static final String CMD_REFRESH_CUBE_MEMBER_CACHE = "refreshCubeMemberCache";
    public static final String CMD_REFRESH_CUBE_DATA_CACHE = "refreshCubeDataCache";
    public static final String CMD_REFRESH_CUBE_SECURITY = "refreshCubeSecurity";
    public static final String CMD_CLEAR_CUBE_WORKLOAD_LOG = "clearCubeWorkloadLog";
    public static final String CMD_PAUSE_CUBES = "pauseCubes";
    public static final String CMD_INCREMENTALLY_LOAD_CUBES = "incrementallyLoadCubes";
    public static final String CMD_ENABLE_RESULT_SET_CACHE = "enableResultSetCache";
    public static final String CMD_DISABLE_RESULT_SET_CACHE = "disableResultSetCache";
    private static final String CMD_ADD_CUBES = "addCubes";
    private static final String CMD_DELETE_CUBES = "deleteCubes";
    private static final String CMD_SET = "set";
    private static final String CMD_WAIT_STATE = "waitForState";
    private static final int DEFAULT_COUNTDOWN = 10;
    private static int portOverride = -1;
    private static String serverOverride = null;
    private static MODE mode = MODE.JMX;
    private static int waitOverride = -1;
    private static String expectedState = null;
    private static String[] capabilitiesRemoveOverride;
    private static String[] capabilitiesAddOverride;
    private static boolean executeCommandOnly;
    private static boolean verboseOverride;
    private static String configurationPropertyName;
    private static String configurationPropertyValue;
    private static int commandIdx;
    private static String[] biLoginCredentials;
    private static ArrayList<String> cubes;
    private static final HashSet<String> ALLOWED_ARGS;
    private static HashMap<String, String> arguments;
    private static boolean exitOnError;
    private static final String[] COMMANDS;

    private static void usage() {
        ROLAPAdminTestTool.println("Usage:\n\n" + ROLAPAdminTestTool.class.getSimpleName() + " [-j|-a|-b] [-p port] [-s server] [-w wait] [-l \"namespace,userid,password\"] [-e state] [-c[a|r] capability1[,capability2]* | all] [-o] [-arg argName argValue] [-v] command [cube0 cube1 ...]\n\n -j - (default) Connect to DQ via internal JMX API\n -a - Connect to DQ via JMX proxy (emulating Admin UI). This requires \"External\n      JMX port\" in cogconfig to be set to a specific port (9999 by default).\n      Specify port using -p. Another way to achieve the same effect is to\n      uncomment property \"rmiregistryport\" in\n      webapps/p2pd/WEB-INF/p2pd_deploy_defaults.properties and restart Tomcat\n -b - Connect to DQ via BiBus\n -p port - Specify the port to use; overrides the default used for a particular\n      operation (only applies to JMX proxy commands - parameter -a and BiBus\n      commands - parameter -b)\n -s server - Specify the server name to use; overrides the default used for a\n      particular operation (only applies to BiBus commands - parameter -b)\n -w wait - Specify the maximum amount of time (seconds) the server can use to\n      process the request before sending a response to the client; overrides\n      the default used for a particular operation (only applies to BiBus\n      commands - parameter -b, and '" + CMD_WAIT_STATE + "' command)\n -ca capability1[,capability2]* - Specify the capabilities to add to the\n      BiBusHeader before sending the request containing the command to the\n      server \n      For example: -ca \"" + "canUseDataSourcesTool" + COMMA + "canUseServerAdministrationTool" + "\"\n      (only applies to BiBus commands - parameter -b)\n -cr capability1[,capability2]* | all - Specify the capabilities to remove from\n      the BiBusHeader before sending the request containing the command to the\n      server\n      For example: -cr  \"" + "canUseDataSourcesTool" + COMMA + "canUseServerAdministrationTool" + "\" \n      (only applies to BiBus commands - parameter -b) \n -l \"namespace,userid,password\" - Specify the BI login parameters\n      For example: -l \"LDAP,ckent,super\"\n      (only applies to BiBus commands - parameter -b)  \n -o - Execute the specified command only; do not get cube states before/after\n      the command\n -e state - Wait for the cube to reach specified state. State is one of the\n      following: " + (Object)((Object)States.DISABLED) + COMMA_SPACE + (Object)((Object)States.STOPPED) + COMMA_SPACE + (Object)((Object)States.STARTING) + COMMA_SPACE + (Object)((Object)States.RUNNING) + COMMA_SPACE + (Object)((Object)States.STOPPING) + COMMA_SPACE + (Object)((Object)States.PAUSING) + COMMA_SPACE + NL + "      " + (Object)((Object)States.PAUSED) + ". The command will wait for the period of time specified by\n      -w parameter\n -arg argName argValue - Specifies command arguments.\n        Currently supported arguments:\n          transactionID - Optional argument to command " + CMD_INCREMENTALLY_LOAD_CUBES + NL + " -v - Display verbose output (only applies to BiBus commands - parameter -b)\n\nNote that any parameter containing a comma or a space must be included in double quotes, e.g. \"param1,param2\"\n\nAvailable commands: \n" + DS + CMD_FORCE_STOP_CUBES + NL + DS + CMD_GET_CUBE_STATE + NL + DS + CMD_GET_CUBE_METRICS + NL + DS + CMD_REFRESH_CUBE_DATA_CACHE + NL + DS + CMD_REFRESH_CUBE_MEMBER_CACHE + NL + DS + CMD_REFRESH_CUBE_SECURITY + NL + DS + CMD_CLEAR_CUBE_WORKLOAD_LOG + NL + DS + CMD_RESTART_CUBES + NL + DS + CMD_START_CUBES + NL + DS + CMD_FORCE_START_CUBES + NL + DS + CMD_STOP_CUBES + NL + DS + CMD_PAUSE_CUBES + NL + DS + CMD_INCREMENTALLY_LOAD_CUBES + NL + DS + CMD_WAIT_STATE + NL + NL + "Commands available for JMX only: \n" + DS + CMD_ADD_CUBES + NL + DS + CMD_DELETE_CUBES + NL + DS + CMD_DISABLE_RESULT_SET_CACHE + NL + DS + CMD_ENABLE_RESULT_SET_CACHE + NL + DS + CMD_SET + " <propertyName> <propertyValue> where <propertyName> is\n" + DS + DS + ROLAPConfiguration.DATA_CACHE_SIZE_LIMIT_QNAME + NL + DS + DS + ROLAPConfiguration.AGGREGATE_CACHE_SIZE_LIMIT_QNAME + NL + DS + DS + ROLAPConfiguration.DISABLED_QNAME + NL + DS + DS + ROLAPConfiguration.DISABLE_EXTERNAL_AGGREGATES_QNAME + NL + DS + DS + ROLAPConfiguration.DISABLE_RESULT_SET_CACHE_QNAME + NL + DS + DS + ROLAPConfiguration.ENABLE_DYNAMIC_MEMBER_CACHING_QNAME + NL + DS + DS + ROLAPConfiguration.MEMBER_CACHE_LIMIT_QNAME + NL + DS + DS + ROLAPConfiguration.PREDICATE_MEMBER_REFERENCE_THRESHOLD_QNAME + NL + DS + DS + ROLAPConfiguration.RESULT_SET_CACHE_SIZE_LIMIT_QNAME + NL + DS + DS + ROLAPConfiguration.STARTUP_TRIGGER_NAME_QNAME + NL + DS + DS + ROLAPConfiguration.MAX_HIERARCHY_LOAD_THREADS_QNAME + NL + DS + DS + ROLAPConfiguration.MAX_AGGREGATE_LOAD_THREADS_QNAME + NL + DS + DS + ROLAPConfiguration.MEASURES_THRESHOLD_QNAME + NL + DS + DS + ROLAPConfiguration.AUTOMATIC_AGGREGATE_OPTIMIZATION_QNAME + NL + DS + DS + ROLAPConfiguration.POST_IN_MEMORY_TRIGGER_NAME_QNAME + NL);
        System.exit(1);
    }

    static void error(String message, Throwable exception) {
        ROLAPAdminTestTool.print("Error: " + message);
        if (exception != null) {
            ROLAPAdminTestTool.println(" : " + exception.getMessage());
            if (verboseOverride) {
                exception.printStackTrace(System.out);
            }
        }
        if (!exitOnError) {
            throw new RuntimeException(message, exception);
        }
        System.exit(1);
    }

    static void error(String message) {
        ROLAPAdminTestTool.error(message, null);
    }

    private static void printCubeStates(Map<String, String> states) {
        for (String name : states.keySet()) {
            ROLAPAdminTestTool.println("\t" + name + " = " + states.get(name));
        }
        ROLAPAdminTestTool.println("");
    }

    private static void parseArguments(String[] args) {
        if (args.length == 0) {
            ROLAPAdminTestTool.usage();
        }
        boolean moreCommands = true;
        for (int i = 0; i < args.length && moreCommands; ++i) {
            if (args[i].equals("-p")) {
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Invalid port argument");
                }
                try {
                    portOverride = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException e) {
                    ROLAPAdminTestTool.error("Invalid port number - " + args[i]);
                }
                continue;
            }
            if (args[i].equals("-s")) {
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Invalid server name");
                }
                serverOverride = args[i];
                continue;
            }
            if (args[i].equals("-a")) {
                mode = MODE.PROXY;
                continue;
            }
            if (args[i].equals("-b")) {
                mode = MODE.BIBUS;
                continue;
            }
            if (args[i].equals("-l")) {
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Invalid credentials argument");
                    continue;
                }
                biLoginCredentials = args[i].split(COMMA);
                if ((long)biLoginCredentials.length == 3L) continue;
                ROLAPAdminTestTool.error("Missing credential arguments. Requires \"<namespace>,<userid>,<password>\"");
                continue;
            }
            if (args[i].equals("-arg")) {
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Invalid command argument");
                    continue;
                }
                String argName = args[i];
                if (!ALLOWED_ARGS.contains(argName)) {
                    ROLAPAdminTestTool.error("Unknown argument: " + argName);
                }
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Missing value for argument: " + argName);
                }
                String argValue = args[i];
                arguments.put(argName, argValue);
                continue;
            }
            if (args[i].equals("-j")) {
                mode = MODE.JMX;
                continue;
            }
            if (args[i].equals("-w")) {
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Invalid wait argument");
                }
                try {
                    waitOverride = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException e) {
                    ROLAPAdminTestTool.error("Invalid wait value - " + args[i]);
                }
                continue;
            }
            if (args[i].equals("-e")) {
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Invalid expected state argument");
                }
                expectedState = args[i].toUpperCase();
                boolean stateNotFound = true;
                for (States state : States.values()) {
                    if (!state.name().equals(expectedState)) continue;
                    stateNotFound = false;
                    break;
                }
                if (!stateNotFound) continue;
                ROLAPAdminTestTool.error("Invalid state name - " + args[i]);
                continue;
            }
            if (args[i].equals("-cr")) {
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Invalid remove capabilities argument. At least 1 capability must be included");
                }
                if ("all".equalsIgnoreCase(args[i])) {
                    capabilitiesRemoveOverride = new String[]{"all"};
                    continue;
                }
                capabilitiesRemoveOverride = args[i].split(COMMA);
                continue;
            }
            if (args[i].equals("-ca")) {
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Invalid add capabilities argument. At least 1 capability must be included");
                }
                capabilitiesAddOverride = args[i].split(COMMA);
                continue;
            }
            if (args[i].equals("-o")) {
                executeCommandOnly = true;
                continue;
            }
            if (args[i].equals("-v")) {
                verboseOverride = true;
                continue;
            }
            for (int c = 0; c < COMMANDS.length; ++c) {
                if (!args[i].equals(COMMANDS[c])) continue;
                commandIdx = c;
                break;
            }
            if (commandIdx == -1) {
                ROLAPAdminTestTool.error("Unknown command: " + args[i]);
            }
            if (args[i].equals(CMD_SET)) {
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Invalid set argument - missing property name");
                }
                configurationPropertyName = args[i];
                if (++i >= args.length) {
                    ROLAPAdminTestTool.error("Invalid set argument - missing property value");
                }
                configurationPropertyValue = args[i];
            }
            moreCommands = false;
        }
        for (int cubeIdx = i; cubeIdx < args.length; ++cubeIdx) {
            cubes.add(args[cubeIdx]);
        }
    }

    public static void main(String[] args) {
        ROLAPAdminTestTool.parseArguments(args);
        try {
            ICommandPlugin plugin = mode == MODE.JMX || mode == MODE.PROXY ? new JMXCommandPlugin(mode, portOverride) : new BiBusCommandPlugin(serverOverride, portOverride, waitOverride, capabilitiesRemoveOverride, capabilitiesAddOverride, biLoginCredentials);
            if (commandIdx != 0) {
                ROLAPCubeStateResult states;
                if (!executeCommandOnly) {
                    states = plugin.getCubeStates(cubes, false);
                    ROLAPAdminTestTool.println("Cube states before command:");
                    ROLAPAdminTestTool.printCubeStates(states.getStates());
                }
                if (CMD_SET.equals(COMMANDS[commandIdx])) {
                    plugin.setProperty(configurationPropertyName, configurationPropertyValue, cubes);
                } else if (CMD_WAIT_STATE.equals(COMMANDS[commandIdx])) {
                    ROLAPAdminTestTool.waitForState(plugin);
                } else {
                    plugin.executeCommand(COMMANDS[commandIdx], cubes, arguments, false);
                }
                if (!executeCommandOnly) {
                    states = plugin.getCubeStates(cubes, false);
                    ROLAPAdminTestTool.println("Cube states after command:");
                    ROLAPAdminTestTool.printCubeStates(states.getStates());
                }
            } else {
                ROLAPCubeStateResult states = plugin.getCubeStates(cubes, false);
                ROLAPAdminTestTool.println("Cube states:");
                ROLAPAdminTestTool.printCubeStates(states.getStates());
            }
            ROLAPAdminTestTool.println("Done.");
        }
        catch (Exception e) {
            ROLAPAdminTestTool.error("Exception occurred", e);
        }
    }

    private static void waitForState(ICommandPlugin plugin) throws Exception {
        int countDown = 10;
        if (waitOverride != -1) {
            countDown = waitOverride;
        }
        ROLAPAdminTestTool.println("\nWaiting for " + countDown + "s for the cubes to reach " + expectedState + " state...\n");
        boolean stateReached = true;
        for (int i = 0; i < countDown; ++i) {
            Map<String, String> states = plugin.getCubeStates(cubes, true).getStates();
            stateReached = true;
            for (String state : states.values()) {
                if (state.toUpperCase().equals(expectedState)) continue;
                stateReached = false;
                break;
            }
            if (stateReached) break;
            if ((long)i % TimeUnit.MINUTES.toSeconds(1L) == 0L) {
                ROLAPAdminTestTool.println("");
            }
            ROLAPAdminTestTool.print(".");
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
        if (stateReached) {
            ROLAPAdminTestTool.println(" \n\n" + expectedState + " state reached successfully.\n");
        } else {
            ROLAPAdminTestTool.println("\n\n" + expectedState + " state not reached.\n");
        }
    }

    public static void println(String s) {
        System.out.println(s);
    }

    public static void print(String s) {
        System.out.print(s);
    }

    public static void printVerbose(String message) {
        if (verboseOverride) {
            ROLAPAdminTestTool.println("   " + message);
        }
    }

    public static void setVerbose(boolean verbose) {
        verboseOverride = verbose;
    }

    public static void setExitOnError(boolean exit) {
        exitOnError = exit;
    }

    static {
        executeCommandOnly = false;
        verboseOverride = false;
        commandIdx = -1;
        biLoginCredentials = new String[]{"", null, null};
        cubes = new ArrayList();
        ALLOWED_ARGS = new HashSet<String>(Arrays.asList("transactionID"));
        arguments = new HashMap();
        exitOnError = true;
        COMMANDS = new String[]{CMD_GET_CUBE_STATE, CMD_GET_CUBE_METRICS, CMD_START_CUBES, CMD_FORCE_START_CUBES, CMD_STOP_CUBES, CMD_FORCE_STOP_CUBES, CMD_RESTART_CUBES, CMD_REFRESH_CUBE_MEMBER_CACHE, CMD_REFRESH_CUBE_DATA_CACHE, CMD_REFRESH_CUBE_SECURITY, CMD_CLEAR_CUBE_WORKLOAD_LOG, CMD_PAUSE_CUBES, CMD_INCREMENTALLY_LOAD_CUBES, CMD_ENABLE_RESULT_SET_CACHE, CMD_DISABLE_RESULT_SET_CACHE, CMD_ADD_CUBES, CMD_DELETE_CUBES, CMD_SET, CMD_WAIT_STATE};
    }

    public static interface ICommandPlugin {
        public ROLAPCubeStateResult getCubeStates(List<String> var1, boolean var2) throws Exception;

        public IROLAPCommandResult executeCommand(String var1, List<String> var2, HashMap<String, String> var3, boolean var4) throws Exception;

        public void setProperty(String var1, String var2, List<String> var3) throws Exception;
    }

    private static enum States {
        DISABLED,
        STOPPED,
        STARTING,
        RUNNING,
        STOPPING,
        PAUSING,
        PAUSED;

    }

    static enum MODE {
        JMX,
        PROXY,
        BIBUS;

    }
}

