/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqebifw.zipi;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.cubingservices.messaging.Message;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.zipi.IZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.cognos.xqebifw.cubingservices.V5QueryHandler;
import com.cognos.xqebifw.cubingservices.messaging.XMLAMessage;
import com.cognos.xqebifw.cubingservices.messaging.XMLAResponseMessage;
import com.cognos.xqebifw.management.XqeAgent;
import com.cognos.xqebifw.zipi.ZipiCallable;
import com.cognos.xqebifw.zipi.ZipiConfigurationAdapter;
import com.cognos.xqebifw.zipi.ZipiDataSourceAdapter;
import com.cognos.xqebifw.zipi.ZipiXMLAMessageAdapter;
import com.ibm.cognos.pogo.zipi.RequestAdapter;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.ZipiStorage;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;

public final class ZipiBridgeImpl
implements IZipiBridge {
    protected static final String DQ_SERVICE = "queryService";
    protected static final String DQ_PROCESS = "Java_DQServer";
    protected static final String EMPTYACTIONNAME = "EmptyActionName";
    protected static final String EMPTYOBJPATH = "";
    protected static final String UNDERSCORE = "_";
    private static final long DEFAULT_TIMER_PERIOD = 1000L;
    private static final long DEFAULT_TIMER_DELAY = 120000L;
    private static final String ZIPI_TASK_PERIOD = "zipi[@period]";
    private static final String ZIPI_TASK_DELAY = "zipi[@delay]";
    private final int zipiProcessId = this.getLocalProcessId();
    private boolean enabled = true;
    private XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private JMXConnector connector = null;
    private ObjectName zipiMBean = null;
    private ZipiUpdateTask task = new ZipiUpdateTask();
    private Timer timer = new Timer("ZIPI-Update-Timer", true);
    private long taskPeriod = 1000L;
    private long taskDelay = 120000L;

    @Override
    public void initialize() {
        this.enabled = ZipiFactory.getConfig().isZipiEnabled();
        if (this.enabled) {
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            this.taskPeriod = configuration.getLongProperty(ZIPI_TASK_PERIOD, 1000L);
            this.taskDelay = configuration.getLongProperty(ZIPI_TASK_DELAY, 120000L);
            ZipiFactory.initialize();
            ZipiStorage.setSrcURI((String)V5QueryHandler.getServerURL());
            ZipiStorage.setStaticService((String)DQ_SERVICE);
            this.connector = XqeAgent.getDispatcherJMXConnection();
            try {
                this.zipiMBean = new ObjectName("com.cognos:type=ZIPI");
            }
            catch (MalformedObjectNameException e) {
                throw new XQERuntimeException(e);
            }
            this.timer.schedule((TimerTask)this.task, this.taskDelay, this.taskPeriod);
        }
    }

    @Override
    public void shutdown() {
        this.task.cancel();
    }

    private JMXConnector getConnector() {
        if (this.connector == null) {
            this.connector = XqeAgent.getDispatcherJMXConnection();
        }
        return this.connector;
    }

    private void clearConnector() {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException ex) {
                this.logger.log(ex);
            }
            this.connector = null;
        }
    }

    @Override
    public void updateDispatcher() throws Exception {
        MBeanServerConnection dispatcher = null;
        if (!ZipiFactory.getReader().isEmpty()) {
            dispatcher = this.getConnector().getMBeanServerConnection();
            Collection events = ZipiFactory.drainEvents();
            dispatcher.invoke(this.zipiMBean, "updateEvents", new Object[]{events}, new String[]{"java.util.Collection"});
        }
    }

    @Override
    public void clearCurrentContext() {
        ZipiFactory.getStorage().clearCurrentContext();
    }

    @Override
    public ZipiTimer startTimer() {
        if (this.enabled) {
            ZipiTimer zipiTimer = ZipiFactory.startTimer();
            this.setProcessNameAndID(zipiTimer);
            return zipiTimer;
        }
        return null;
    }

    @Override
    public ZipiTimer startTimer(String action) {
        if (this.enabled) {
            ZipiTimer zipiTimer = ZipiFactory.startTimer((String)action);
            this.setProcessNameAndID(zipiTimer);
            return zipiTimer;
        }
        return null;
    }

    @Override
    public ZipiTimer startTimer(String action, String objPath) {
        if (this.enabled) {
            ZipiTimer zipiTimer = ZipiFactory.startTimer((String)action);
            if (objPath != null) {
                zipiTimer.setObjectPath(objPath);
            }
            this.setProcessNameAndID(zipiTimer);
            return zipiTimer;
        }
        return null;
    }

    @Override
    public ZipiTimer startTimer(String action, String objPath, String qName) {
        if (this.enabled) {
            String objLongName = null;
            objLongName = qName != null ? objPath + UNDERSCORE + qName : objPath;
            return this.startTimer(action, objLongName);
        }
        return null;
    }

    @Override
    public ZipiTimer startTimer(RequestAdapter zipiAdapter) {
        if (this.enabled) {
            ZipiTimer zipiTimer = ZipiFactory.startTimer((RequestAdapter)zipiAdapter);
            this.setProcessNameAndID(zipiTimer);
            return zipiTimer;
        }
        return null;
    }

    @Override
    public ZipiTimer startTimer(Message msg) {
        if (this.enabled) {
            ZipiTimer zipiTimer = msg instanceof XMLAMessage ? ZipiFactory.startTimer((RequestAdapter)new ZipiXMLAMessageAdapter(msg)) : ZipiFactory.startTimer();
            this.setProcessNameAndID(zipiTimer);
            return zipiTimer;
        }
        return null;
    }

    @Override
    public ZipiTimer startTimer(IDataSource dataSource, String objPath) {
        if (this.enabled) {
            ZipiTimer zipiTimer = ZipiFactory.startTimer((RequestAdapter)new ZipiDataSourceAdapter(dataSource));
            String objLongName = null;
            objLongName = objPath != null ? dataSource.getCMDataSourceName() + UNDERSCORE + objPath : objPath;
            zipiTimer.setObjectPath(objLongName);
            this.setProcessNameAndID(zipiTimer);
            return zipiTimer;
        }
        return null;
    }

    @Override
    public void appendAction(String action) {
        if (this.enabled) {
            ZipiFactory.getCurrentTimer().appendAction(action);
        }
    }

    @Override
    public void setAction(String action) {
        if (this.enabled) {
            ZipiFactory.getCurrentTimer().setAction(action);
        }
    }

    @Override
    public void setObjPath(String objPath) {
        if (this.enabled && objPath != null) {
            ZipiFactory.getCurrentTimer().setObjectPath(objPath);
        }
    }

    @Override
    public void setZipiContextAndObjPath(String objPath) {
        if (this.enabled && objPath != null) {
            ZipiContext.clearAndSetQRDName(objPath);
            ZipiFactory.getCurrentTimer().setObjectPath(objPath);
        }
    }

    @Override
    public void updateZipiContext(ZipiTimer zipiTimer, String action, String objPath) {
        if (this.enabled) {
            zipiTimer.setAction(action);
            if (objPath != null) {
                zipiTimer.setObjectPath(objPath);
            }
            this.setProcessNameAndID(zipiTimer);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getRuntimeMXBeanName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    @Override
    public int getLocalProcessId() {
        String beanName = this.getRuntimeMXBeanName();
        return Integer.parseInt(beanName.substring(0, beanName.indexOf("@")));
    }

    @Override
    public void setProcessNameAndID(ZipiTimer zipiTimer) {
        if (this.enabled) {
            zipiTimer.setProcessName(DQ_PROCESS);
            zipiTimer.setProcessID(this.zipiProcessId);
        }
    }

    @Override
    public void addZipiHeaders(StringBuilder msgHeader) {
        if (this.enabled) {
            msgHeader.append("zipi.step");
            msgHeader.append(": ");
            msgHeader.append(ZipiFactory.getCurrentTimer().getCurrentStep());
            msgHeader.append(XMLAResponseMessage.CRLF);
        }
    }

    @Override
    public void reconfigure(ICCLConfiguration cclConfig) {
        boolean previous = this.enabled;
        ZipiFactory.getConfig().reconfigure((Configuration)new ZipiConfigurationAdapter(cclConfig));
        if (previous != ZipiFactory.getConfig().isZipiEnabled()) {
            if (previous) {
                this.shutdown();
            } else {
                this.initialize();
            }
        }
    }

    @Override
    public <V> Callable<V> wrapCallable(Callable<V> callable, String zipiAction, String zipiObjPath, int startStep) {
        if (this.enabled) {
            return new ZipiCallable<V>(callable, zipiAction, zipiObjPath);
        }
        return callable;
    }

    private class ZipiUpdateTask
    extends TimerTask {
        private ZipiUpdateTask() {
        }

        @Override
        public void run() {
            try {
                ZipiBridgeImpl.this.updateDispatcher();
            }
            catch (Exception e) {
                ZipiBridgeImpl.this.logger.log(e);
                ZipiBridgeImpl.this.clearConnector();
            }
        }
    }
}

