/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.mdx.parser.MDXParser;
import com.cognos.xqe.ast.mdx.parser.ParseException;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.transformation.olap.XQEOlapPlanningException;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import com.cognos.xqe.util.LinkedStack;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.xml.XMLEscCharacter;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import com.cognos.xqemfw4j.MFWCalculation;
import com.cognos.xqemfw4j.MFWDimension;
import com.cognos.xqemfw4j.MFWHierarchy;
import com.cognos.xqemfw4j.MFWMeasure;
import com.cognos.xqemfw4j.MFWMeasureHierarchy;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import com.cognos.xqemfw4j.MFWNamedSetParserVisitor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

class MFWCalculationNamedSet
extends MFWCalculation
implements INamedSet {
    private static final String QUERY_LEVELS = "/property[name='levels']/__Value";
    protected String uniqueName = null;
    protected List<ILevel> levels = null;
    IDimension dimension;
    IHierarchy hierarchy;

    MFWCalculationNamedSet(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandle) {
        super(mfwConnection, mfwHandle);
        if (!"namedSet".equals(this.getCalcType())) {
            this.throwInvalidObject();
        }
    }

    @Override
    public IDimension getDimension() {
        if (this.dimension == null) {
            IHierarchy namedsetHierarchy;
            IDimension namedsetDimension = null;
            MFWMultiRequestHandle[] dimensionRef = this.queryHandles(MFWModelRes.getInstance().RID_dimensions, MFWModelRes.getInstance().RID_refobj);
            if (dimensionRef != null) {
                switch (dimensionRef.length) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        String dimensionRefValue = this.queryValue(dimensionRef[0]);
                        namedsetDimension = (IDimension)this.getConnection().bindMetadataReference(dimensionRefValue);
                        break;
                    }
                    default: {
                        this.throwInvalidObject();
                    }
                }
            }
            if (namedsetDimension == null && (namedsetHierarchy = this.getHierarchy()) != null) {
                namedsetDimension = namedsetHierarchy.getDimension();
            }
            if (namedsetDimension == null && !this.getConnection().getCubes()[0].getModelDataSource().isROLAP()) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_FailGetNamedSetDimension);
            }
            this.dimension = namedsetDimension;
        }
        return this.dimension;
    }

    @Override
    public IHierarchy getHierarchy() {
        if (this.hierarchy == null) {
            IHierarchy namedsetHierarchy = null;
            MFWMultiRequestHandle[] hierarchyRef = this.queryHandles(MFWModelRes.getInstance().RID_hierarchies, MFWModelRes.getInstance().RID_refobj);
            if (hierarchyRef != null) {
                switch (hierarchyRef.length) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        String hierarchyRefValue = this.queryValue(hierarchyRef[0]);
                        namedsetHierarchy = (IHierarchy)this.getConnection().bindMetadataReference(hierarchyRefValue);
                        break;
                    }
                    default: {
                        this.throwInvalidObject();
                    }
                }
            }
            if (namedsetHierarchy == null && this.dimension != null && this.getDimension().isMeasuresDimension()) {
                namedsetHierarchy = this.getDimension().getDefaultHierarchy();
            }
            this.hierarchy = namedsetHierarchy;
        }
        return this.hierarchy;
    }

    @Override
    public IDataType getDataType() {
        if (this.dataType == null) {
            this.dataType = DataTypeFactory.getMemberType();
        }
        return this.dataType;
    }

    @Override
    public IXQEQueryNode getSet(PlanningEnvironment environment, MetadataConnection mdConnection, MDXQuery mdxQuery) throws XQEOlapPlanningException {
        ByteArrayInputStream bais;
        AbstractMDXNode result = null;
        String utf8 = "UTF-8";
        String mdxStringOrginal = XMLEscCharacter.unescapeString(this.getExpression());
        String mdxString = mdxStringOrginal.replaceAll(".&", ".");
        try {
            bais = new ByteArrayInputStream(mdxString.getBytes(utf8));
        }
        catch (IOException e) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_FailedToExpandNamedSet, (Throwable)e, this.getName(), mdxString);
        }
        MDXParser parser = new MDXParser(bais, utf8);
        parser.setNodeFactory(environment.getNodeFactory());
        try {
            parser.Set_EOF();
        }
        catch (ParseException e) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_FailedToExpandNamedSet, (Throwable)e, this.getName(), mdxString);
        }
        try {
            MFWNamedSetParserVisitor namedSetParserVisitor = new MFWNamedSetParserVisitor(parser, environment, mdConnection, mdxQuery, mdxStringOrginal);
            result = (AbstractMDXNode)namedSetParserVisitor.interpretObject(this);
        }
        catch (InterpreterException e) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_FailedToExpandNamedSet, (Throwable)e, this.getName(), mdxString);
        }
        if (result == null) {
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_FailedToExpandNamedSet, this.getName(), mdxString);
        }
        boolean includeSelf = false;
        IXQEQueryNode[] existingMDXNamedSetReferences = mdxQuery.getDescendantsOfType(1014, includeSelf);
        MDXNamedSetReference existingMDXNamedSetReference = null;
        for (int i = 0; i < existingMDXNamedSetReferences.length; ++i) {
            MDXNamedSetReference currMDXNamedSetReference = (MDXNamedSetReference)existingMDXNamedSetReferences[i];
            AbstractMDXSet currDefintion = (AbstractMDXSet)currMDXNamedSetReference.getDefinition().getChild(0);
            if (!currDefintion.isSameExpression(result, false)) continue;
            existingMDXNamedSetReference = currMDXNamedSetReference;
            break;
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        if (existingMDXNamedSetReference != null) {
            result = (AbstractMDXNode)nodeFactory.deepCopyNode(existingMDXNamedSetReference);
        } else {
            result = MDXBuilder.buildMDXNamedSet(nodeFactory, mdxQuery, "_DB", result);
            ((MDXNamedSetReference)result).getDefinition().setDBNamedSet();
        }
        return result;
    }

    @Override
    protected IMetadata bindMetadataToExternalNameInExpression(String metadataUniqueName) {
        IMetadata metadataObject = null;
        LinkedStack<Object> stack = new LinkedStack<Object>();
        stack.push(this.getDimension().getCube().getMeasuresHierarchy());
        stack.push(this.getDimension());
        stack.push(this.getHierarchy());
        while (stack.size() > 0 && metadataObject == null) {
            IMetadata metadata = (IMetadata)stack.pop();
            if (metadata == null) continue;
            if (metadataUniqueName.equals(metadata.getUniqueName())) {
                metadataObject = metadata;
                continue;
            }
            if (metadata instanceof MFWDimension) {
                for (IMetadata iMetadata : ((MFWDimension)metadata).getHierarchies()) {
                    stack.push(iMetadata);
                }
                continue;
            }
            if (metadata instanceof MFWMeasureHierarchy) {
                for (IMember iMember : ((MFWMeasureHierarchy)metadata).getMembers()) {
                    stack.push(iMember);
                }
                continue;
            }
            if (metadata instanceof MFWHierarchy) {
                for (IMetadata iMetadata : ((IHierarchy)metadata).getLevels()) {
                    stack.push(iMetadata);
                }
                continue;
            }
            if (!(metadata instanceof MFWMeasure)) continue;
            for (IMember iMember : ((MFWMeasure)metadata).getChildMembers()) {
                stack.push(iMember);
            }
        }
        return metadataObject;
    }

    @Override
    public List<ILevel> getLevels() {
        if (this.levels == null) {
            this.levels = this.queryLevels();
        }
        return this.levels;
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            this.uniqueName = this.queryValue(MFWModelRes.getInstance().RID_externalName, new short[0]);
        }
        return this.uniqueName;
    }

    private List<ILevel> queryLevels() {
        List<Object> queryLevels = new ArrayList<ILevel>();
        String levelsInfo = this.queryValue(QUERY_LEVELS);
        if (levelsInfo != null) {
            ArrayList<String> levelUniqueNames = new ArrayList<String>();
            try {
                XMLStreamReader xmlReader = StaxUtil.createXMLStreamReader(levelsInfo);
                while (xmlReader.hasNext() && StaxUtil.moveToElement(xmlReader, "level")) {
                    ChildElementIterator childIter = new ChildElementIterator(xmlReader);
                    while (childIter.next()) {
                        if (xmlReader.getLocalName().equals("externalName")) {
                            levelUniqueNames.add(xmlReader.getElementText());
                            continue;
                        }
                        StaxUtil.skipElement(xmlReader);
                    }
                    if (StaxUtil.testOnEndElement(xmlReader, "level")) continue;
                    StaxUtil.moveToEndElement(xmlReader, "level");
                }
                xmlReader.close();
            }
            catch (XMLStreamException ex) {
                throw new XQERuntimeException(ex);
            }
            for (String levelUniqueName : levelUniqueNames) {
                ILevel level = this.getHierarchy().getLevel(levelUniqueName);
                queryLevels.add(level);
            }
            queryLevels = Collections.unmodifiableList(queryLevels);
        } else if (this.getConnection().getCubes()[0].getModelDataSource().isROLAP()) {
            queryLevels.addAll(this.getHierarchy().getLevels());
            queryLevels = Collections.unmodifiableList(queryLevels);
        } else {
            List<String> levelUniqueNames = this.queryLevelUniqueNames();
            if (levelUniqueNames == null) {
                queryLevels = Collections.unmodifiableList(new ArrayList());
            } else {
                queryLevels = new ArrayList(levelUniqueNames.size());
                for (String levelUniqueName : levelUniqueNames) {
                    ILevel level = this.getHierarchy().getLevel(levelUniqueName);
                    queryLevels.add(level);
                }
                queryLevels = Collections.unmodifiableList(queryLevels);
            }
        }
        return queryLevels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> queryLevelUniqueNames() {
        ICube cube = this.getDimension().getCube();
        IModelDataSource modelDS = cube.getModelDataSource();
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        IDataSource ds = executionEnvironment.getOrAddDataSource(modelDS);
        IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(ds.getType());
        MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(ds, executionEnvironment, modelDS.getConnection().getExpressionLocale());
        IOLAPMetadataProvider metadataProvider = dataProvider.getMetadataProvider(mdQueryArgs);
        MetadataRestriction restrictions = new MetadataRestriction();
        if (modelDS.getCatalog() != null) {
            restrictions.add(RestrictionType.CATALOG, modelDS.getCatalog().getUniqueName());
        }
        restrictions.add(RestrictionType.CUBE, cube.getUniqueName());
        restrictions.add(RestrictionType.SET, this.getUniqueName());
        List<String> levelUniqueNames = null;
        try {
            levelUniqueNames = metadataProvider.getNamedSetLevelUniqueNames(restrictions);
        }
        finally {
            metadataProvider.release();
        }
        return levelUniqueNames;
    }
}

