/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeHandle;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.content.ICMConnection;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.metadata.IAlias;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IVariable;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.xml.XMLUtils;
import com.cognos.xqemfw4j.MFWAlias;
import com.cognos.xqemfw4j.MFWCatalog;
import com.cognos.xqemfw4j.MFWCube;
import com.cognos.xqemfw4j.MFWMetadata;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import com.cognos.xqemfw4j.MFWNamespace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

class MFWDataSource
extends MFWMetadata
implements IModelDataSource {
    static final long serialVersionUID = 7647274105530911872L;
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(MFWDataSource.class);
    protected String name = null;
    protected List<ICube> cubes = null;
    protected ICube cube = null;
    protected List<IVariable> variables = null;
    private String queryType = null;
    private IAlias alias = null;
    private String interfaceType = null;
    private String interfaceTypeFromModel = null;
    private String cmDatasource = null;
    private String schema = null;
    private String connectionString = null;
    private static final String QUERY_VARIABLES = "/property[name='SAP BW Variables']/property";
    private ICatalog catalog = null;
    Map<String, Object> metadataProperties;
    private String queryProcessing = null;
    private String rollupProcessing = null;
    private String limitedLocalScope = null;
    private DateTimeValue cubeDataUpdatedOn = null;
    private DateTimeValue cubeSchemaUpdatedOn = null;
    private String cubeCurrentPeriod = null;
    private Boolean cubeIsOptimized = null;
    private String cubeDefaultMeasure = null;
    private ICube.CubeSuppressionTypeEnum suppression = null;
    private Boolean attributeDimensionsAsProperties = null;
    private String id = null;
    private String transactionAccessMode = null;
    private String transactionStatementMode = null;
    private String nullValueSorting = null;
    private boolean interfaceRead;
    private static final Map<String, ICube.CubeSuppressionTypeEnum> SUPPRESSION_TYPE_MAP = Collections.unmodifiableMap(new HashMap<String, ICube.CubeSuppressionTypeEnum>(){
        {
            this.put("none", ICube.CubeSuppressionTypeEnum.NONE);
            this.put("null", ICube.CubeSuppressionTypeEnum.NULL);
            this.put("zero", ICube.CubeSuppressionTypeEnum.ZERO);
            this.put("nullAndZero", ICube.CubeSuppressionTypeEnum.NULL_AND_ZERO);
        }
    });
    private boolean cubeInitialized = false;
    private DateTimeValue cubeCreatedOn;

    MFWDataSource(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandle) {
        super(mfwConnection, mfwHandle);
    }

    @Override
    public List<ICube> getCubes() {
        if (this.cubes == null && this.getCube() != null) {
            ArrayList<ICube> datasourceCubes = new ArrayList<ICube>();
            datasourceCubes.add(this.getCube());
            this.cubes = Collections.unmodifiableList(datasourceCubes);
        }
        return this.cubes;
    }

    private boolean containsMultidimensionalObjects(IMetadata namespace) {
        MFWNodeHandle[] hDims = this.getConnection().getGateway().getGatewayImpl().lookupObjectsByType((short)232);
        return hDims.length > 0;
    }

    @Override
    public ICube getCube() {
        if (this.cube == null && !this.cubeInitialized) {
            this.queryCube();
            this.cubeInitialized = true;
        }
        return this.cube;
    }

    private void queryCube() {
        ICube modelCube = null;
        if (this.isRelational()) {
            INamespace rootNameSpace = this.getConnection().getRootNamespace();
            if (this.containsMultidimensionalObjects(rootNameSpace)) {
                MFWCube mfwCube = new MFWCube(this.getConnection(), ((MFWNamespace)rootNameSpace).getHandles());
                mfwCube.setDatasource(this);
                mfwCube.setNamespace((MFWNamespace)rootNameSpace);
                modelCube = mfwCube;
            }
        } else {
            MFWMultiRequestHandle[] handles = this.queryHandles(MFWModelRes.getInstance().RID_cube, new short[0]);
            if (handles != null && handles.length > 0) {
                modelCube = (ICube)this.getConnection().mfwObjectToMetadataObject(handles[0]);
            }
        }
        this.setCube(modelCube);
    }

    private synchronized void setCube(ICube modelCube) {
        if (this.cube == null) {
            this.cube = modelCube;
        }
    }

    @Override
    public String getQueryType() {
        if (this.queryType == null) {
            this.queryType = this.queryValue(MFWModelRes.getInstance().RID_queryType, new short[0]);
        }
        return this.queryType;
    }

    @Override
    public boolean isMultidimensional() {
        return this.getQueryType().equals("multidimensional");
    }

    @Override
    public boolean isRelational() {
        return this.getQueryType().equals("relational");
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public String getInterface() {
        if (!this.interfaceRead) {
            String cmInterface = this.getInterfaceFromCM();
            if (cmInterface == null) {
                cmInterface = this.getInterfaceTypeFromModel();
            }
            this.interfaceType = cmInterface;
            this.interfaceRead = true;
        }
        return this.interfaceType;
    }

    private String getInterfaceTypeFromModel() {
        if (this.interfaceTypeFromModel == null) {
            String modelInterface;
            this.interfaceTypeFromModel = modelInterface = this.queryValue(MFWModelRes.getInstance().RID_interface, new short[0]);
        }
        return this.interfaceTypeFromModel;
    }

    private String getInterfaceFromCM() {
        try {
            ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            Collection<ICMConnection> conns = ContentManager.getConnections(env.getRequestEnvironment(), this.getCMDataSourceName());
            if (conns.size() == 1) {
                String cs = conns.iterator().next().getConnectionString();
                return DataSourceTypeEnum.getInterfaceTypeFromConnectionString(cs);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    @Override
    public String getCMDataSourceName() {
        if (this.cmDatasource == null) {
            this.cmDatasource = this.queryValue(MFWModelRes.getInstance().RID_cmDataSource, new short[0]);
        }
        return this.cmDatasource;
    }

    @Override
    public void setCMDataSource(String dataSourceVal) {
        this.cmDatasource = dataSourceVal;
    }

    public String getConnectionString() {
        if (this.connectionString == null) {
            this.connectionString = this.queryValue(MFWModelRes.getInstance().RID_connectionString, new short[0]);
        }
        return this.connectionString;
    }

    @Override
    public String getSchema() {
        if (this.schema == null) {
            this.schema = this.queryValue(MFWModelRes.getInstance().RID_schema, new short[0]);
        }
        return this.schema;
    }

    @Override
    public ICatalog getCatalog() {
        MFWMultiRequestHandle[] handles;
        if (this.catalog == null && (handles = this.queryHandles(MFWModelRes.getInstance().RID_catalog, new short[0])) != null && handles.length > 0) {
            this.catalog = new MFWCatalog(this.getConnection(), handles);
        }
        return this.catalog;
    }

    @Override
    public IAlias getAlias() {
        if (this.alias == null) {
            String aliasTableMapRef = this.queryValue(MFWModelRes.getInstance().RID_aliasTableMapRef, new short[0]);
            if (aliasTableMapRef == null) {
                String query = "/project//dimension[dataSourceRef=" + XMLUtils.xPathLiteral(this.getID()) + "]/" + "aliasTableMapRef";
                MFWMultiRequestHandle[] handles = this.getConnection().queryHandles(query);
                ArrayList<IAlias> aliasTables = new ArrayList<IAlias>(handles.length);
                for (MFWMultiRequestHandle handleAlias : handles) {
                    aliasTableMapRef = this.getConnection().queryValue(handleAlias);
                    aliasTables.add((IAlias)this.getConnection().bindMetadataReference(aliasTableMapRef));
                }
                this.alias = new MFWAlias(this.getConnection(), aliasTables);
            } else {
                this.alias = (IAlias)this.getConnection().bindMetadataReference(aliasTableMapRef);
            }
        }
        return this.alias;
    }

    @Override
    public Map<String, Object> getMetadataProperties() {
        if (this.metadataProperties == null) {
            List<String> projectLocales;
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (this.getName() != null) {
                properties.put("name", this.getName());
            }
            if (this.getCube() != null && this.getCube().getUniqueName() != null) {
                properties.put("cube", this.getCube().getUniqueName());
            }
            if (this.getQueryType() != null) {
                properties.put("queryType", this.getQueryType());
            }
            if (this.getInterfaceTypeFromModel() != null) {
                properties.put("interface", this.getInterfaceTypeFromModel());
            }
            if (this.getCMDataSourceName() != null) {
                properties.put("cmDataSource", this.getCMDataSourceName());
            }
            if (this.getSchema() != null) {
                properties.put("schema", this.getSchema());
            }
            if (this.getCatalog() != null) {
                properties.put("catalog", this.getCatalog().getUniqueName());
            }
            if (this.getConnectionString() != null) {
                properties.put("connectionString", this.getConnectionString());
            }
            if (!this.getAttributeDimensionsAsProperties()) {
                properties.put("attribute", "dimension");
            }
            if (this.getTransactionAccessMode() != null) {
                properties.put("transactionAccessMode", this.getTransactionAccessMode());
            }
            if (this.getTransactionStatementMode() != null) {
                properties.put("transactionStatementMode", this.getTransactionStatementMode());
            }
            if (this.getNullValueSorting() != null) {
                properties.put("nullValueSorting", this.getNullValueSorting());
            }
            if ((projectLocales = this.getConnection().queryLocales()) != null) {
                properties.put("project_locales", new LinkedHashSet<String>(projectLocales));
            }
            this.metadataProperties = Collections.unmodifiableMap(properties);
        }
        return this.metadataProperties;
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.DATASOURCE;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public List<IVariable> getVariables() {
        if (this.variables == null) {
            MFWMultiRequestHandle[] mfwVariables = this.queryHandles(QUERY_VARIABLES);
            List<IVariable> vars = Collections.unmodifiableList(CollectionCast.downcast(this.getConnection().mfwObjectsToMetadataObjects(mfwVariables), IMetadata.class, IVariable.class));
            this.variables = vars;
        }
        return this.variables;
    }

    @Override
    public String toString() {
        return this.getID();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.queryValue(MFWModelRes.getInstance().RID_name, new short[0]);
        }
        return this.name;
    }

    String getQueryProcessing() {
        if (this.queryProcessing == null) {
            this.queryProcessing = this.queryValue(MFWModelRes.getInstance().RID_queryProcessing, new short[0]);
        }
        return this.queryProcessing;
    }

    String getRollupProcessing() {
        if (this.rollupProcessing == null) {
            this.rollupProcessing = this.queryValue(MFWModelRes.getInstance().RID_rollupProcessing, new short[0]);
        }
        return this.rollupProcessing;
    }

    String getLimitedLocalScope() {
        if (this.limitedLocalScope == null) {
            this.limitedLocalScope = this.queryValue(MFWModelRes.getInstance().RID_limitedLocalScope, new short[0]);
        }
        return this.limitedLocalScope;
    }

    DateTimeValue getCubeDataUpdatedOn() {
        String dateTime;
        if (this.cubeDataUpdatedOn == null && (dateTime = this.queryValue(MFWModelRes.getInstance().RID_cubeDataUpdatedOn, new short[0])) != null) {
            dateTime = this.removeTrailingZ(dateTime);
            TimestampValue tempCubeDataUpdatedOn = DataValueFactory.createTimestampValue();
            ((DateTimeValue)tempCubeDataUpdatedOn).set(dateTime);
            this.cubeDataUpdatedOn = tempCubeDataUpdatedOn;
        }
        return this.cubeDataUpdatedOn;
    }

    DateTimeValue getCubeSchemaUpdatedOn() {
        String dateTime;
        if (this.cubeSchemaUpdatedOn == null && (dateTime = this.queryValue(MFWModelRes.getInstance().RID_cubeSchemaUpdatedOn, new short[0])) != null) {
            dateTime = this.removeTrailingZ(dateTime);
            TimestampValue tempCubeSchemaUpdatedOn = DataValueFactory.createTimestampValue();
            ((DateTimeValue)tempCubeSchemaUpdatedOn).set(dateTime);
            this.cubeSchemaUpdatedOn = tempCubeSchemaUpdatedOn;
        }
        return this.cubeSchemaUpdatedOn;
    }

    DateTimeValue getCubeCreatedOn() {
        String dateTime;
        if (this.cubeCreatedOn == null && (dateTime = this.queryValue(MFWModelRes.getInstance().RID_cubeCreatedOn, new short[0])) != null) {
            dateTime = this.removeTrailingZ(dateTime);
            TimestampValue tempCubeCreatedOn = DataValueFactory.createTimestampValue();
            ((DateTimeValue)tempCubeCreatedOn).set(dateTime);
            this.cubeCreatedOn = tempCubeCreatedOn;
        }
        return this.cubeCreatedOn;
    }

    String getCubeCurrentPeriod() {
        if (this.cubeCurrentPeriod == null) {
            this.cubeCurrentPeriod = this.queryValue(MFWModelRes.getInstance().RID_cubeCurrentPeriod, new short[0]);
        }
        return this.cubeCurrentPeriod;
    }

    public String removeTrailingZ(String dateTime) {
        if (dateTime.length() > 0 && dateTime.charAt(dateTime.length() - 1) == 'Z') {
            dateTime = dateTime.substring(0, dateTime.length() - 1);
        }
        return dateTime;
    }

    boolean getCubeIsOptimized() {
        if (this.cubeIsOptimized == null) {
            this.cubeIsOptimized = "true".equals(this.queryValue(MFWModelRes.getInstance().RID_cubeIsOptimized, new short[0]));
        }
        return this.cubeIsOptimized;
    }

    String getCubeDefaultMeasure() {
        if (this.cubeDefaultMeasure == null) {
            this.cubeDefaultMeasure = this.queryValue(MFWModelRes.getInstance().RID_cubeDefaultMeasure, new short[0]);
        }
        return this.cubeDefaultMeasure;
    }

    ICube.CubeSuppressionTypeEnum getSuppression() {
        if (this.suppression == null) {
            this.suppression = SUPPRESSION_TYPE_MAP.get(this.queryValue(MFWModelRes.getInstance().RID_suppression, new short[0]));
        }
        return this.suppression;
    }

    boolean getAttributeDimensionsAsProperties() {
        if (this.attributeDimensionsAsProperties == null) {
            this.attributeDimensionsAsProperties = "true".equals(this.queryValue(MFWModelRes.getInstance().getResourceID("attributeDimensionsAsProperties"), new short[0]));
        }
        return this.attributeDimensionsAsProperties;
    }

    @Override
    public String getV5UniqueName() {
        return this.getID();
    }

    @Override
    public String getID() {
        if (this.id == null) {
            this.id = this.queryValue(MFWModelRes.getInstance().RID_ID, new short[0]);
        }
        return this.id;
    }

    @Override
    public boolean isROLAP() {
        return "RO".equals(this.getInterfaceTypeFromModel());
    }

    String getTransactionAccessMode() {
        if (this.transactionAccessMode == null) {
            this.transactionAccessMode = this.queryValue(MFWModelRes.getInstance().RID_transactionAccessMode, new short[0]);
        }
        return this.transactionAccessMode;
    }

    String getTransactionStatementMode() {
        if (this.transactionStatementMode == null) {
            this.transactionStatementMode = this.queryValue(MFWModelRes.getInstance().RID_transactionStatementMode, new short[0]);
        }
        return this.transactionStatementMode;
    }

    String getNullValueSorting() {
        if (this.nullValueSorting == null) {
            this.nullValueSorting = this.queryValue(MFWModelRes.getInstance().RID_nullValueSorting, new short[0]);
        }
        return this.nullValueSorting;
    }

    @Override
    public boolean isContentManager() {
        return true;
    }
}

