/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.types.DimensionType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqemfw4j.MFWAccessedViaShortcut;
import com.cognos.xqemfw4j.MFWDataSource;
import com.cognos.xqemfw4j.MFWHierarchy;
import com.cognos.xqemfw4j.MFWMetadata;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import com.cognos.xqemfw4j.MFWNamespace;
import com.cognos.xqemfw4j.MFWShortcut;
import com.cognos.xqemfw4j.MFWVirtualDefaultHierarchy;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;

class MFWDimension
extends MFWAccessedViaShortcut
implements IDimension {
    private static final String STR_MINUS = "-";
    private static final String CLOSE_BRACKET = "']";
    private static final String EQUAL = "='";
    private static final String OPEN_BRACKET = "[";
    public static final int SAP_DATE_LENGTH = 8;
    public static final int JAVA_DATE_LENGTH = 10;
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(MFWDimension.class);
    private static final String DEFINITION_TYPE_DB_QUERY = "dbQuery";
    private static final String DEFINITION_TYPE_MODEL_QUERY = "modelQuery";
    static final long serialVersionUID = 7647274105530911872L;
    protected String name = null;
    protected String uniqueID = null;
    protected String uniqueName = null;
    private String v5UniqueName = null;
    protected ICube cube = null;
    protected int dimensionIndex = -1;
    protected List<IHierarchy> hierarchies = null;
    protected IHierarchy defaultHierarchy = null;
    protected DimensionTypeEnum dimensionType = null;
    protected Integer cardinality = null;
    protected Boolean membersRollup = null;
    private String id = null;
    protected Boolean keyFigureStructure = null;
    protected Boolean defaultHierarchyExistInModel = null;
    protected Boolean attributeDimension = null;
    protected Boolean sortMembersMetadata = null;
    protected Boolean sortMembersData = null;
    protected Boolean sortMembersAndEnableMrf = null;
    protected double orderOfMagnitude = -1.0;
    private List<IEmbeddedFilter> filters = null;
    private List<IEmbeddedFilter> previewFilters = null;
    private List<IEmbeddedFilter> securityFilters = null;
    private MFWDimension dimUnderTargetNamespace = null;
    private IScopeRelationship[] scopeRelationships = null;
    private static final String QUERY_PPDSCODE = "/property[name='PPDS_CODE']";
    private static final String QUERY_ATTRIBUTEDIMENSION = "/property[name='isAttributeDimension']/__Value";
    private static final String QUERY_SORTMEMBERSMETADATA = "/sortMembersMetadata";
    private static final String QUERY_SORTMEMBERSDATA = "/sortMembersData";
    private static final String QUERY_SORTMEMBERSANDENABLEMRF = "/sortMembersAndEnableMrf";
    public static final String PROJECT = "project";
    private static final String DATE_FORMAT = "yyyyMMdd";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String MAX_KEY_DATE = "9999-12-31T00:00:00";
    private static final String MIN_KEY_DATE = "1000-01-01T00:00:00";
    private static final int MILLSECS_PER_DAY = 86400000;

    protected MFWDimension(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandle) {
        super(mfwConnection, mfwHandle);
    }

    @Override
    public List<IHierarchy> getHierarchies() {
        if (this.hierarchies == null) {
            List<MFWHierarchy> hierarchyList = new ArrayList();
            short ridHierarchyFolder = MFWModelRes.getInstance().RID_hierarchyFolder;
            short ridHierarchy = MFWModelRes.getInstance().RID_hierarchy;
            MFWMultiRequestHandle[] handles = this.getHandles();
            ArrayList<MFWMultiRequestHandle> handleList = null;
            if (handles != null && handles.length > 0) {
                handleList = new ArrayList<MFWMultiRequestHandle>(handles.length + 1);
                for (int i = 0; i < handles.length; ++i) {
                    handleList.add(handles[i]);
                }
                handleList.add(null);
            }
            Stack<MFWMultiRequestHandle> stack = new Stack<MFWMultiRequestHandle>();
            stack.push(this.getHandle());
            while (stack.size() > 0) {
                MFWMultiRequestHandle handle = (MFWMultiRequestHandle)stack.pop();
                if (handle.getInfo().getRID() == ridHierarchy) {
                    handleList.set(handleList.size() - 1, handle);
                    MFWHierarchy hierarchy = (MFWHierarchy)this.getConnection().mfwObjectToMetadataObject(handleList.toArray(new MFWMultiRequestHandle[handleList.size()]));
                    hierarchyList.add(hierarchy);
                    continue;
                }
                MFWMultiRequestHandle[] hHierarchies = this.queryHandles(handle, ridHierarchy, new short[0]);
                for (int i = hHierarchies.length - 1; i >= 0; --i) {
                    stack.push(hHierarchies[i]);
                }
                MFWMultiRequestHandle[] hHierarchyFolders = this.queryHandles(handle, ridHierarchyFolder, new short[0]);
                for (int i = hHierarchyFolders.length - 1; i >= 0; --i) {
                    stack.push(hHierarchyFolders[i]);
                }
            }
            hierarchyList = Collections.unmodifiableList(hierarchyList);
            this.hierarchies = hierarchyList;
        }
        return this.hierarchies;
    }

    @Override
    public IHierarchy getDefaultHierarchy() {
        if (this.defaultHierarchy == null) {
            IHierarchy hier = null;
            this.defaultHierarchyExistInModel = true;
            String hierarchyRef = this.queryValue(MFWModelRes.getInstance().RID_defaultHierarchy, new short[0]);
            for (IHierarchy hierarchy : this.getHierarchies()) {
                MFWHierarchy mfwHierarchy = (MFWHierarchy)hierarchy;
                if (!mfwHierarchy.getID().equals(hierarchyRef)) continue;
                hier = mfwHierarchy;
                break;
            }
            if (DataSourceTypeEnum.isSAPBW(this.getCube().getModelDataSource().getInterface())) {
                if (hier != null && !hier.getUniqueName().equals(this.getUniqueName())) {
                    this.defaultHierarchyExistInModel = false;
                    List<IHierarchy> hiers = this.getHierarchies();
                    for (IHierarchy hier1 : hiers) {
                        if (!hier1.getUniqueName().equals(this.getUniqueName())) continue;
                        hier = hier1;
                        this.defaultHierarchyExistInModel = true;
                        break;
                    }
                }
                if (hier == null || !this.defaultHierarchyExistInModel.booleanValue()) {
                    hier = this.queryDefaultHierarchy();
                    this.defaultHierarchyExistInModel = false;
                }
            }
            this.defaultHierarchy = hier;
        }
        return this.defaultHierarchy;
    }

    @Override
    public boolean isDefaultHierarchyExistInModel() {
        if (this.defaultHierarchyExistInModel == null) {
            this.getDefaultHierarchy();
        }
        return this.defaultHierarchyExistInModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHierarchy queryDefaultHierarchy() {
        IModelDataSource modelDS = this.getCube().getModelDataSource();
        IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(modelDS.getInterface());
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(executionEnvironment.getOrAddDataSource(modelDS), executionEnvironment, modelDS.getConnection().getExpressionLocale());
        IOLAPMetadataProvider metadataProvider = dataProvider.getMetadataProvider(mdQueryArgs);
        MetadataRestriction restrictions = new MetadataRestriction();
        if (this.getCube().getModelDataSource().getCatalog() != null) {
            restrictions.add(RestrictionType.CATALOG, modelDS.getCatalog().getUniqueName());
        }
        restrictions.add(RestrictionType.CUBE, this.getCube().getUniqueName());
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.getUniqueName());
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, this.getUniqueName());
        List<HierarchyRecord> records = null;
        try {
            records = metadataProvider.getHierarchies(restrictions);
            if (records == null || records.size() != 1) {
                this.getConnection().throwInternalError("Querying DefaultHierarchy of dimension " + this.getUniqueName() + " returned empty result.");
            }
            MFWVirtualDefaultHierarchy mFWVirtualDefaultHierarchy = new MFWVirtualDefaultHierarchy(this, records.get(0));
            return mFWVirtualDefaultHierarchy;
        }
        finally {
            metadataProvider.release();
        }
    }

    @Override
    public IMember[] getMembers() {
        return this.getDefaultHierarchy().getMembers();
    }

    @Override
    public ICube getCube() {
        if (this.cube == null) {
            ICube dimCube = null;
            String datasourceRef = this.queryValue(MFWModelRes.getInstance().RID_dataSourceRef, new short[0]);
            List<IModelDataSource> datasourceList = this.getConnection().getModelDataSources();
            if (datasourceRef != null && datasourceRef.length() > 0) {
                for (IModelDataSource datasource : datasourceList) {
                    MFWDataSource mfwDatasource = (MFWDataSource)datasource;
                    if (!mfwDatasource.getID().equals(datasourceRef)) continue;
                    dimCube = mfwDatasource.getCube();
                    break;
                }
                if (dimCube == null) {
                    throw new XQERuntimeException(XQEMessageKeys.MD_UnableToFindCube, datasourceRef);
                }
            } else {
                for (IModelDataSource datasource : datasourceList) {
                    MFWDataSource mfwDatasource = (MFWDataSource)datasource;
                    if (!mfwDatasource.isRelational()) continue;
                    dimCube = mfwDatasource.getCube();
                    break;
                }
            }
            this.cube = dimCube;
        }
        return this.cube;
    }

    @Override
    public int getCardinality() {
        if (this.cardinality == null) {
            int defaultCardinality = 0;
            if (this.getDefaultHierarchy() != null) {
                defaultCardinality = this.getDefaultHierarchy().getCardinality();
            }
            this.cardinality = defaultCardinality;
        }
        return this.cardinality;
    }

    @Override
    public int getHierarchyCount() {
        int hierarchyCount = 0;
        if (this.getHierarchies() != null) {
            hierarchyCount = this.getHierarchies().size();
        }
        return hierarchyCount;
    }

    @Override
    public boolean isDBMeasureDimension() {
        return false;
    }

    @Override
    public boolean isMeasuresDimension() {
        return this.getType() == DimensionTypeEnum.MEASURE;
    }

    @Override
    public boolean isRegularDimension() {
        return this.getType() == DimensionTypeEnum.REGULAR;
    }

    @Override
    public boolean isTimeDimension() {
        return this.getType() == DimensionTypeEnum.TIME;
    }

    @Override
    public IDataType getDataType() {
        return DimensionType.DIMENSIONTYPE;
    }

    @Override
    public IHierarchy getHierarchy(String hierarchyUniqueName) {
        IHierarchy hierarchy = null;
        if (this.getHierarchies() != null) {
            for (IHierarchy hier : this.getHierarchies()) {
                if (!hierarchyUniqueName.equals(hier.getUniqueName())) continue;
                hierarchy = hier;
                break;
            }
        }
        return hierarchy;
    }

    private List<IHierarchy> getHierarchiesInRangeOfKeyDate(String hierarchyUniqueName, String keyDate, DateValue validFrom, DateValue validTo) {
        String fromDate = "";
        String toDate = "";
        ArrayList<IHierarchy> tempHierarchies = new ArrayList<IHierarchy>();
        List<IHierarchy> hiers = this.getHierarchies();
        for (IHierarchy hier : hiers) {
            if (hierarchyUniqueName.equals(hier.getUniqueName())) {
                String curDate = (String)hier.getProperty("Valid_From");
                if (curDate != null) {
                    fromDate = curDate.substring(0, 10);
                }
                if ((curDate = (String)hier.getProperty("Valid_To")) != null) {
                    toDate = curDate.substring(0, 10);
                }
                if (fromDate.length() == 0 && toDate.length() == 0) {
                    return null;
                }
                if (fromDate.length() == 0 && toDate.length() == 10) {
                    if (this.compareSAPDates(keyDate, toDate) <= 0) {
                        tempHierarchies.add(hier);
                    }
                } else if (toDate.length() == 0 && fromDate.length() == 10) {
                    if (this.compareSAPDates(keyDate, fromDate) >= 0) {
                        tempHierarchies.add(hier);
                    }
                } else if (validFrom != null && validTo != null) {
                    if (this.compareSAPDates(validTo.getString(), toDate) <= 0 && this.compareSAPDates(validFrom.getString(), fromDate) >= 0) {
                        tempHierarchies.add(hier);
                    }
                } else if (this.compareSAPDates(keyDate, toDate) <= 0 && this.compareSAPDates(keyDate, fromDate) >= 0) {
                    tempHierarchies.add(hier);
                }
            }
            fromDate = "";
            toDate = "";
        }
        return tempHierarchies;
    }

    @Override
    public boolean compareTDHierarchies(IHierarchy hier1, IHierarchy hier2) {
        String toDate1 = "";
        String fromDate1 = "";
        String toDate2 = "";
        String fromDate2 = "";
        if (!hier1.getUniqueName().equals(hier2.getUniqueName())) {
            return false;
        }
        String curDate = (String)hier1.getProperty("Valid_From");
        if (curDate != null) {
            fromDate1 = curDate.substring(0, 10);
        }
        if ((curDate = (String)hier1.getProperty("Valid_To")) != null) {
            toDate1 = curDate.substring(0, 10);
        }
        if ((curDate = (String)hier2.getProperty("Valid_From")) != null) {
            fromDate2 = curDate.substring(0, 10);
        }
        if ((curDate = (String)hier2.getProperty("Valid_To")) != null) {
            toDate2 = curDate.substring(0, 10);
        }
        return toDate1.equals(toDate2) && fromDate1.equals(fromDate2);
    }

    private IHierarchy getHierarchy(String keyDate, List<IHierarchy> hiers) {
        IHierarchy hierarchy = null;
        String toDate = "";
        String fromDate = "";
        try {
            long toDateDelta;
            SimpleDateFormat df = new SimpleDateFormat(DATE_TIME_FORMAT);
            Date maxDate = df.parse(MAX_KEY_DATE);
            Date minDate = df.parse(MIN_KEY_DATE);
            long fromDateDelta = toDateDelta = (maxDate.getTime() - minDate.getTime()) / 86400000L;
            SimpleDateFormat df1 = new SimpleDateFormat(DATE_FORMAT);
            Date keyDate1 = df1.parse(StringUtils.remove((String)keyDate, (String)STR_MINUS));
            for (IHierarchy hier : hiers) {
                Date toDate1;
                long tempToDateDelta;
                toDate = (String)hier.getProperty("Valid_To");
                if (toDate == null || toDate.length() == 0) {
                    toDate = MAX_KEY_DATE;
                }
                if ((tempToDateDelta = ((toDate1 = df.parse(toDate)).getTime() - keyDate1.getTime()) / 86400000L) > toDateDelta) continue;
                fromDate = (String)hier.getProperty("Valid_From");
                if (fromDate == null || fromDate.length() == 0) {
                    fromDate = MIN_KEY_DATE;
                }
                Date fromDate1 = df.parse(fromDate);
                long tempFromDateDelta = (keyDate1.getTime() - fromDate1.getTime()) / 86400000L;
                if (tempFromDateDelta > fromDateDelta) continue;
                hierarchy = hier;
                toDateDelta = tempToDateDelta;
                fromDateDelta = tempFromDateDelta;
            }
        }
        catch (ParseException ex) {
            throw new XQERuntimeException(ex);
        }
        return hierarchy;
    }

    @Override
    public IHierarchy getHierarchy(String hierarchyUniqueName, String keyDate, DateValue validFrom, DateValue validTo) {
        if (keyDate == null || keyDate.length() == 0) {
            return this.getHierarchy(hierarchyUniqueName);
        }
        IHierarchy hierarchy = null;
        List<IHierarchy> hieres = this.getHierarchies();
        if (hieres != null) {
            List<IHierarchy> matchedHierarchies = this.getHierarchiesInRangeOfKeyDate(hierarchyUniqueName, keyDate, validFrom, validTo);
            if (matchedHierarchies != null) {
                if (matchedHierarchies.size() > 1) {
                    hierarchy = this.getHierarchy(keyDate, matchedHierarchies);
                } else if (matchedHierarchies.size() == 1) {
                    hierarchy = matchedHierarchies.get(0);
                }
            }
            if (hierarchy == null) {
                return this.getHierarchy(hierarchyUniqueName);
            }
        }
        return hierarchy;
    }

    private int compareSAPDates(String firstDate, String secondDate) {
        int date2;
        firstDate = StringUtils.remove((String)firstDate, (String)STR_MINUS);
        secondDate = StringUtils.remove((String)secondDate, (String)STR_MINUS);
        int date1 = Integer.parseInt(firstDate.substring(0, 8));
        if (date1 > (date2 = Integer.parseInt(secondDate.substring(0, 8)))) {
            return 1;
        }
        if (date1 < date2) {
            return -1;
        }
        return 0;
    }

    @Override
    public DimensionTypeEnum getType() {
        if (this.dimensionType == null) {
            String type = this.queryValue(MFWModelRes.getInstance().RID_type, new short[0]);
            DimensionTypeEnum dimType = DimensionTypeEnum.fromFMDimensionTypeString(type);
            if (dimType.equals((Object)DimensionTypeEnum.UNKNOWN)) {
                dimType = DimensionTypeEnum.REGULAR;
            }
            this.dimensionType = dimType;
        }
        return this.dimensionType;
    }

    @Override
    public boolean getMembersRollup() {
        if (this.membersRollup == null) {
            String membersRollupModel = this.queryValue(MFWModelRes.getInstance().RID_membersRollup, new short[0]);
            this.membersRollup = "true".equals(membersRollupModel);
        }
        return this.membersRollup;
    }

    @Override
    public int getIndex() {
        if (this.dimensionIndex == -1) {
            this.dimensionIndex = this.getCube().getDimensionIndex(this);
        }
        return this.dimensionIndex;
    }

    @Override
    public int getIndex(String cubeName) {
        return this.getIndex();
    }

    @Override
    public int getLevelIndex(ILevel d) {
        this.throwNotImplemented();
        return -1;
    }

    @Override
    public ILevel getLevel(int index) {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public int getHierarchyIndex(IHierarchy h) {
        this.throwNotImplemented();
        return -1;
    }

    @Override
    public int getLevelCount() {
        return this.getDefaultHierarchy().getLevelCount();
    }

    @Override
    public IMember getMember(String memberName) {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public ILevel getLevel(String levName) {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.DIMENSION;
    }

    @Override
    public IHierarchy getHierarchy(int index) {
        return this.getHierarchies().get(index);
    }

    @Override
    public boolean isShell() {
        return false;
    }

    @Override
    public boolean isDMR() {
        String definitionType = this.queryValue(MFWModelRes.getInstance().RID_definitionType, new short[0]);
        return DEFINITION_TYPE_MODEL_QUERY.equals(definitionType) || DEFINITION_TYPE_DB_QUERY.equals(definitionType);
    }

    @Override
    public boolean isShareable() {
        return false;
    }

    @Override
    public boolean convertedFromDBQuerySubject() {
        String definitionType = this.queryValue(MFWModelRes.getInstance().RID_definitionType, new short[0]);
        return DEFINITION_TYPE_DB_QUERY.equals(definitionType);
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            String dimensionName = this.getShortcut() != null ? this.getShortcut().getName() : this.queryName();
            this.name = dimensionName;
        }
        return this.name;
    }

    @Override
    public String getDescription() {
        if (this.isAccessedViaShortcut()) {
            return this.getShortcut().getDescription();
        }
        if (this.description == null) {
            this.description = this.queryDescription();
        }
        return this.description;
    }

    @Override
    public String getScreenTip() {
        if (this.isAccessedViaShortcut()) {
            return this.getShortcut().getScreenTip();
        }
        if (this.screenTip == null) {
            this.screenTip = this.queryScreenTip();
        }
        return this.screenTip;
    }

    @Override
    public String getUniqueID() {
        if (this.uniqueID == null) {
            this.uniqueID = this.queryValue(QUERY_PPDSCODE);
        }
        return this.uniqueID;
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            String dimensionUniqueName = this.queryValue(MFWModelRes.getInstance().RID_externalName, new short[0]);
            if (dimensionUniqueName == null) {
                dimensionUniqueName = this.buildDefaultUniqueName();
            }
            this.uniqueName = dimensionUniqueName;
        }
        return this.uniqueName;
    }

    @Override
    public String getV5UniqueName() {
        if (this.v5UniqueName == null) {
            IMetadata parentObj = this.getParentObjectSkipFolders();
            String parentName = ((MFWMetadata)parentObj).getV5UniqueName();
            String dimensionV5UniqueName = null;
            dimensionV5UniqueName = parentObj instanceof MFWShortcut && !(((MFWShortcut)parentObj).getTarget() instanceof INamespace) ? parentName : UniqueNameGenerator.appendUniqueName(parentName, this.getName());
            this.v5UniqueName = dimensionV5UniqueName;
        }
        return this.v5UniqueName;
    }

    @Override
    public String getID() {
        if (this.id == null) {
            this.id = this.buildID();
        }
        return this.id;
    }

    @Override
    public boolean isKeyFigureStructure() {
        if (this.keyFigureStructure == null) {
            this.keyFigureStructure = DataSourceTypeEnum.isSAPBW(this.getCube().getModelDataSource().getInterface()) && DimensionTypeEnum.UNKNOWN.equals((Object)DimensionTypeEnum.fromFMDimensionTypeString(this.queryValue(MFWModelRes.getInstance().RID_type, new short[0])));
        }
        return this.keyFigureStructure;
    }

    @Override
    public boolean isAttributeDimension() {
        if (this.attributeDimension == null) {
            this.attributeDimension = "true".equals(this.queryValue(QUERY_ATTRIBUTEDIMENSION));
        }
        return this.attributeDimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<HierarchyRecord> queryHierarchyRecords() {
        IModelDataSource modelDS = this.getCube().getModelDataSource();
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        IDataSource ds = executionEnvironment.getOrAddDataSource(modelDS);
        IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(ds.getType());
        MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(ds, executionEnvironment, modelDS.getConnection().getExpressionLocale());
        IOLAPMetadataProvider metadataProvider = dataProvider.getMetadataProvider(mdQueryArgs);
        MetadataRestriction restrictions = new MetadataRestriction();
        if (modelDS.getCatalog() != null) {
            restrictions.add(RestrictionType.CATALOG, modelDS.getCatalog().getUniqueName());
        }
        restrictions.add(RestrictionType.CUBE, this.getCube().getUniqueName());
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.getUniqueName());
        List<HierarchyRecord> records = null;
        try {
            records = metadataProvider.getHierarchies(restrictions);
        }
        finally {
            metadataProvider.release();
        }
        return records;
    }

    @Override
    public String[] getParentNamespaces() {
        MFWMultiRequestHandle handle = this.getHandle().getParent();
        ArrayList<String> namespaces = new ArrayList<String>();
        if (this.isAccessedViaShortcut()) {
            try {
                namespaces.add(UniqueNameParser.parserFirstIdentifier(this.getID()));
            }
            catch (UniqueNameParserException e) {
                throw new XQERuntimeException();
            }
            if (this.getHandles()[1].getParent().getName().equals(PROJECT)) {
                return namespaces.toArray(new String[0]);
            }
            handle = this.getHandles()[1].getParent().getParent();
        }
        if (handle == null) {
            return new String[0];
        }
        if (handle.getName().equals(PROJECT)) {
            return namespaces.toArray(new String[namespaces.size()]);
        }
        return this.getParentNamespaces(handle, namespaces);
    }

    private String[] getParentNamespaces(MFWMultiRequestHandle handle, List<String> namespaces) {
        String parentType = handle.getParent().getName();
        if (parentType.equals(PROJECT)) {
            return namespaces.toArray(new String[namespaces.size()]);
        }
        String[] pNames = null;
        try {
            pNames = UniqueNameParser.parse(this.queryValue(handle, MFWModelRes.getInstance().RID_ID, new short[0]));
        }
        catch (UniqueNameParserException e) {
            throw new XQERuntimeException(e);
        }
        for (String pName : pNames) {
            namespaces.add(pName);
        }
        return this.getParentNamespaces(handle.getParent(), namespaces);
    }

    @Override
    public MFWNamespace getParentNamespace() {
        IMetadata parent;
        for (parent = this.getParentObject(); parent != null && !(parent instanceof INamespace); parent = parent.getParentObject()) {
        }
        if (parent != null) {
            return (MFWNamespace)parent;
        }
        return null;
    }

    @Override
    public List<IEmbeddedFilter> getFilters() {
        if (this.filters == null) {
            List<IEmbeddedFilter> dimensionFilters = CollectionCast.downcast(this.getConnection().queryMetadata(this.getHandle(), MFWModelRes.getInstance().RID_filterDefinition, new short[0]), IMetadata.class, IEmbeddedFilter.class);
            this.filters = dimensionFilters;
        }
        return this.filters;
    }

    @Override
    public List<IEmbeddedFilter> getPreviewFilters() {
        if (this.previewFilters == null) {
            List<IEmbeddedFilter> dimensionFilters = CollectionCast.downcast(this.getConnection().queryMetadata(this.getHandle(), MFWModelRes.getInstance().RID_previewFilter, new short[0]), IMetadata.class, IEmbeddedFilter.class);
            this.previewFilters = dimensionFilters;
        }
        return this.previewFilters;
    }

    @Override
    public List<IEmbeddedFilter> getSecurityFilters() {
        if (this.securityFilters == null) {
            List<IEmbeddedFilter> dimensionFilters = CollectionCast.downcast(this.getConnection().queryMetadata(this.getHandle(), MFWModelRes.getInstance().RID_securityFilterDefinition, new short[0]), IMetadata.class, IEmbeddedFilter.class);
            this.securityFilters = dimensionFilters;
        }
        return this.securityFilters;
    }

    public boolean getSortMembersMetadata() {
        if (this.sortMembersMetadata == null) {
            this.sortMembersMetadata = "true".equals(this.queryValue(QUERY_SORTMEMBERSMETADATA));
        }
        return this.sortMembersMetadata;
    }

    @Override
    public boolean getSortMembersData() {
        if (this.sortMembersData == null) {
            this.sortMembersData = "true".equals(this.queryValue(QUERY_SORTMEMBERSDATA));
        }
        return this.sortMembersData;
    }

    @Override
    public boolean getSortMembersAndEnableMrf() {
        if (this.sortMembersAndEnableMrf == null) {
            this.sortMembersAndEnableMrf = "true".equals(this.queryValue(QUERY_SORTMEMBERSANDENABLEMRF));
        }
        return this.sortMembersAndEnableMrf;
    }

    public IScopeRelationship[] getScopeRelationships() {
        if (this.scopeRelationships == null) {
            this.scopeRelationships = this.getConnection().getScopeRelationships(this.getID());
        }
        return this.scopeRelationships;
    }

    @Override
    public IDimension getShortcutTarget(IDimension dimension) {
        if (dimension instanceof MFWAccessedViaShortcut && dimension.getShortcut() != null) {
            return (MFWDimension)dimension.getShortcut().getTarget();
        }
        return dimension;
    }

    private boolean isLeftOrRightObject(IScopeRelationship scopeRelationship, MFWDimension dimension) {
        IShortcut shortcut;
        IMetadata leftObject = scopeRelationship.getLeftRefObject();
        IMetadata rightObject = scopeRelationship.getRightRefObject();
        return dimension.isAccessedViaShortcut() ? leftObject.equals(shortcut = dimension.getShortcut()) || rightObject.equals(shortcut) : leftObject.equals(dimension) || rightObject.equals(dimension);
    }

    @Override
    public IScopeRelationship getScopeRelationship(IMetadata otherMetadata) {
        if (!(this instanceof MFWDimension) || !(otherMetadata instanceof MFWDimension)) {
            return null;
        }
        MFWDimension dimension1 = this;
        MFWDimension dimension2 = (MFWDimension)otherMetadata;
        MFWDimension measureDimension = null;
        MFWDimension regularDimension = null;
        if (dimension1.isMeasuresDimension() && !dimension2.isMeasuresDimension()) {
            measureDimension = dimension1;
            regularDimension = dimension2;
        } else if (!dimension1.isMeasuresDimension() && dimension2.isMeasuresDimension()) {
            measureDimension = dimension2;
            regularDimension = dimension1;
        }
        if (measureDimension == null) {
            return null;
        }
        for (int i = 0; i < 2; ++i) {
            IScopeRelationship[] allScopeRels;
            for (IScopeRelationship scopeRel : allScopeRels = measureDimension.getScopeRelationships()) {
                if (!this.isLeftOrRightObject(scopeRel, measureDimension) || !this.isLeftOrRightObject(scopeRel, regularDimension)) continue;
                return scopeRel;
            }
            measureDimension = (MFWDimension)this.getShortcutTarget(measureDimension);
            regularDimension = (MFWDimension)this.getShortcutTarget(regularDimension);
        }
        return null;
    }

    public boolean isAutoGenerated() {
        return false;
    }

    @Override
    public double getOrderOfMagnitude() {
        if (this.orderOfMagnitude == -1.0) {
            String orderOfMagnitudeString = this.queryValue("orderOfMagnitude");
            try {
                String d = orderOfMagnitudeString.replaceAll(",", ".");
                this.orderOfMagnitude = Double.parseDouble(d);
            }
            catch (NumberFormatException e1) {
                this.orderOfMagnitude = 0.0;
            }
        }
        return this.orderOfMagnitude;
    }

    @Override
    public MFWDimension getDimUnderTargetNamespace() {
        if (this.dimUnderTargetNamespace == null) {
            this.dimUnderTargetNamespace = this.findMatchingDimensionUnderTargetNamespace();
        }
        return this.dimUnderTargetNamespace;
    }

    @Override
    public boolean isUnderNamespaceShortcut() {
        return this != this.getDimUnderTargetNamespace();
    }

    public MFWDimension findMatchingDimensionUnderTargetNamespace() {
        MFWDimension dimUnderTargetNS = this;
        MFWNamespace parentNS = this.getParentNamespace();
        if (parentNS != null) {
            IShortcut scNS = parentNS.getShortcut();
            IMetadata targetNS = null;
            while (scNS != null) {
                targetNS = scNS.getTarget();
                scNS = ((IAccessedViaShortcut)targetNS).getShortcut();
            }
            if (targetNS != null) {
                String targetDimRef = UniqueNameGenerator.appendUniqueName(targetNS.getID(), this.getName());
                IMetadata target = this.getConnection().bindMetadataReference(targetDimRef);
                if (target != null && target instanceof MFWDimension) {
                    dimUnderTargetNS = (MFWDimension)target;
                }
            }
        }
        return dimUnderTargetNS;
    }
}

