/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.types.HierarchyType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqemfw4j.MFWDimension;
import com.cognos.xqemfw4j.MFWLevel;
import com.cognos.xqemfw4j.MFWMember;
import com.cognos.xqemfw4j.MFWMetadata;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import com.cognos.xqemfw4j.MFWShortcut;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MFWHierarchy
extends MFWMetadata
implements IHierarchy {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(MFWHierarchy.class);
    private static final String UNEXPECTED_MEMBER_RESPONSE = "Unexpected metadata response";
    private static final String CLOSE_BRACKET = "']";
    private static final String EQUAL = "='";
    private static final String OPEN_BRACKET = "[";
    private static final String QUERY_PPDSCODE = "/property[name='PPDS_CODE']";
    protected static final String QUERY_VALID_FROM = "/property[name='Valid_From']/__Value";
    protected static final String QUERY_VALID_TO = "/property[name='Valid_To']/__Value";
    private static final String CLOSE_SQUARE_BRACKET = "]";
    private static final String DOT_OPEN_SQUARE_BRACKET = ".[";
    static final long serialVersionUID = 7647274105530911872L;
    protected String uniqueName = null;
    protected String name = null;
    protected String uniqueID = null;
    private String v5UniqueName = null;
    protected IDimension dimension = null;
    protected List<ILevel> levels = null;
    protected IMember defaultMember = null;
    protected IMember highestLevelRollup = null;
    protected Integer cardinality = null;
    protected Boolean balanced = null;
    protected Boolean ragged = null;
    protected Boolean multiRoot = null;
    protected Boolean parentChild = null;
    protected List<String> relatedHierarchyNames = null;
    protected IMember rootMember = null;
    private String id = null;
    List<IMember> calculatedMembers;

    protected MFWHierarchy(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandle) {
        super(mfwConnection, mfwHandle);
    }

    @Override
    public List<ILevel> getLevels() {
        if (this.levels == null) {
            List<ILevel> hierarchyLevels = Collections.unmodifiableList(CollectionCast.downcast(this.getConnection().queryMetadata(this.getHandles(), MFWModelRes.getInstance().RID_level, new short[0]), IMetadata.class, ILevel.class));
            this.levels = hierarchyLevels;
        }
        return this.levels;
    }

    @Override
    public ILevel getLevel(String levelUniqueName) {
        ILevel level = null;
        if (this.getLevels() != null) {
            for (ILevel lev : this.getLevels()) {
                if (!lev.getUniqueName().equals(levelUniqueName)) continue;
                level = lev;
                break;
            }
        }
        return level;
    }

    @Override
    public IDimension getDimension() {
        if (this.dimension == null) {
            IDimension hierarchyDimension;
            this.dimension = hierarchyDimension = (IDimension)this.buildParentMetadataObject(MFWModelRes.getInstance().RID_dimension);
        }
        return this.dimension;
    }

    @Override
    public IMember getDefaultMember() {
        if (this.defaultMember == null) {
            IModelDataSource modelDataSource = this.getDimension().getCube().getModelDataSource();
            String dataSourceType = modelDataSource.getInterface();
            IMember defaultMemberOfHierarchy = null;
            if (modelDataSource.isMultidimensional()) {
                boolean invalidSAPDefaultMember;
                MFWMultiRequestHandle defaultMemberHandle = this.queryHandle(MFWModelRes.getInstance().getResourceID("defaultMemberExternalName"), new short[0]);
                boolean bl = invalidSAPDefaultMember = DataSourceTypeEnum.isSAPBW(dataSourceType) && (this.getDimension().getType() == DimensionTypeEnum.TIME || this.getDimension().getType() == DimensionTypeEnum.SAPTIME) && !this.getUniqueName().equals(this.getDimension().getUniqueName());
                if (invalidSAPDefaultMember) {
                    String memberUniqueName = UniqueNameGenerator.createMemberExternalName(this, this.queryValue(defaultMemberHandle));
                    defaultMemberOfHierarchy = this.createDummyDefaultMember(memberUniqueName);
                } else if (defaultMemberHandle == null) {
                    HierarchyRecord hierarchyRecord = this.queryHierarchyRecord();
                    String defaultMemberUniqueName = hierarchyRecord.getDefaultMemberUniqueName();
                    if ((defaultMemberUniqueName == null || defaultMemberUniqueName.isEmpty()) && DataSourceTypeEnum.isSAPBW(dataSourceType)) {
                        defaultMemberOfHierarchy = this.createDummyDefaultMember(defaultMemberUniqueName);
                    } else {
                        MemberRecord memberRecord = this.queryMemberRecord(defaultMemberUniqueName);
                        MFWLevel level = (MFWLevel)this.getLevel(memberRecord.getLevelNumber());
                        defaultMemberOfHierarchy = new MFWMember(defaultMemberUniqueName, level);
                    }
                } else {
                    defaultMemberOfHierarchy = new MFWMember(this.getConnection(), new MFWMultiRequestHandle[]{defaultMemberHandle});
                }
            } else {
                defaultMemberOfHierarchy = this.getRootMember();
            }
            this.defaultMember = defaultMemberOfHierarchy;
        }
        return this.defaultMember;
    }

    private IMember createDummyDefaultMember(String memberUniqueName) {
        if (memberUniqueName == null || memberUniqueName.isEmpty()) {
            memberUniqueName = "[dummy_default_member_unique_name]";
        }
        return new MFWMember(memberUniqueName, (MFWLevel)this.getLevel(0));
    }

    @Override
    public int getCardinality() {
        if (this.cardinality == null) {
            Integer hierarchyCardinality;
            String modelCardinality = this.queryValue(MFWModelRes.getInstance().RID_cardinality, new short[0]);
            if (modelCardinality == null) {
                HierarchyRecord hierarchyRecord = this.queryHierarchyRecord();
                hierarchyCardinality = hierarchyRecord.getCardinality();
            } else {
                hierarchyCardinality = Integer.valueOf(modelCardinality);
            }
            this.cardinality = hierarchyCardinality;
        }
        return this.cardinality;
    }

    @Override
    public int getLevelCount() {
        int levelCount = 0;
        if (this.getLevels() != null) {
            levelCount = this.getLevels().size();
        }
        if (this.isParentChild() && levelCount == 0) {
            throw new RuntimeException("Level count requested on ParentChild hierarchy with none known levels. Operation not supported.");
        }
        return levelCount;
    }

    @Override
    public boolean isRagged() {
        if (this.ragged == null) {
            Boolean isRagged;
            String dataSourceType = this.getDimension().getCube().getModelDataSource().getInterface();
            if (DataSourceTypeEnum.isSAPBW(dataSourceType)) {
                isRagged = this.getLevelCount() > 2 || this.isMultiRoot();
            } else {
                String modelRagged = this.queryValue(MFWModelRes.getInstance().RID_ragged, new short[0]);
                isRagged = "true".equals(modelRagged);
            }
            this.ragged = isRagged;
        }
        return this.ragged;
    }

    @Override
    public boolean isUnbalanced() {
        if (this.balanced == null) {
            String dataSourceType;
            String modelBalanced = this.queryValue(MFWModelRes.getInstance().RID_balanced, new short[0]);
            Boolean isBalanced = "true".equals(modelBalanced);
            if (this.isRagged() && (DataSourceTypeEnum.isYukon(dataSourceType = this.getDimension().getCube().getModelDataSource().getInterface()) || DataSourceTypeEnum.isSAPBW(dataSourceType))) {
                isBalanced = Boolean.FALSE;
            }
            this.balanced = isBalanced;
        }
        return this.balanced == false;
    }

    @Override
    public boolean isParentChild() {
        if (this.parentChild == null) {
            String booleanString = this.queryValue(MFWModelRes.getInstance().RID_parentChild, new short[0]);
            this.parentChild = "true".equals(booleanString);
        }
        return this.parentChild;
    }

    @Override
    public boolean isMultiRoot() {
        if (this.multiRoot == null) {
            String booleanString = this.queryValue(MFWModelRes.getInstance().RID_multiRoot, new short[0]);
            this.multiRoot = "true".equals(booleanString);
        }
        return this.multiRoot;
    }

    @Override
    public String createCalculatedMemberUniqueName(String suffix) {
        StringBuilder strBuf = new StringBuilder(this.getUniqueName());
        strBuf.append(DOT_OPEN_SQUARE_BRACKET).append(suffix).append(CLOSE_SQUARE_BRACKET);
        return strBuf.toString();
    }

    @Override
    public IDataType getDataType() {
        return HierarchyType.HIERARCHYTYPE;
    }

    @Override
    public ILevel getLevel(int index) {
        ILevel level = null;
        if (this.getLevels() != null && index >= 0 && index < this.getLevels().size()) {
            level = this.getLevels().get(index);
        }
        return level;
    }

    @Override
    public int getLevelIndex(ILevel level) {
        int levelIndex = -1;
        if (this.getLevels() != null) {
            levelIndex = this.getLevels().indexOf(level);
        }
        return levelIndex;
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.HIERARCHY;
    }

    @Override
    public IMember[] getMembers() {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public IMember getMember(String memberUniqueName) {
        this.throwNotImplemented();
        return null;
    }

    @Override
    public List<String> getRelatedHierarchyNames(ILevel lowestLevel) {
        if (this.relatedHierarchyNames == null) {
            ArrayList<String> relatedHierarchyNamesArray = new ArrayList<String>();
            List<ILevel> levelList = this.getLevels();
            for (int i = 0; i <= lowestLevel.getIndex(); ++i) {
                ILevel level = levelList.get(i);
                String baseAttrHierarchy = (String)level.getProperty("baseAttributeHierarchyRef");
                if (baseAttrHierarchy == null) continue;
                relatedHierarchyNamesArray.add(baseAttrHierarchy);
            }
            IDimension thisDimension = this.getDimension();
            List<IHierarchy> hierarchies = thisDimension.getHierarchies();
            for (int i = 0; i < relatedHierarchyNamesArray.size(); ++i) {
                String relatedHierarchyName = (String)relatedHierarchyNamesArray.get(i);
                for (int k = 0; k < hierarchies.size(); ++k) {
                    IHierarchy hierarchy = hierarchies.get(k);
                    if (hierarchy == this) continue;
                    levelList = hierarchy.getLevels();
                    boolean baseAttrHierFoundInHierarchy = false;
                    for (int j = levelList.size() - 1; j >= 0; --j) {
                        int listIndex;
                        ILevel level = levelList.get(j);
                        String baseAttrHierarchy = (String)level.getProperty("baseAttributeHierarchyRef");
                        if (baseAttrHierarchy == null || !baseAttrHierFoundInHierarchy && !relatedHierarchyName.equals(baseAttrHierarchy)) continue;
                        for (listIndex = 0; listIndex < relatedHierarchyNamesArray.size() && !((String)relatedHierarchyNamesArray.get(listIndex)).equals(baseAttrHierarchy); ++listIndex) {
                        }
                        if (listIndex == relatedHierarchyNamesArray.size()) {
                            relatedHierarchyNamesArray.add(baseAttrHierarchy);
                        }
                        baseAttrHierFoundInHierarchy = true;
                    }
                }
            }
            this.relatedHierarchyNames = Collections.unmodifiableList(relatedHierarchyNamesArray);
        }
        return this.relatedHierarchyNames;
    }

    @Override
    public IMember getRootMember() {
        String dataSourceType = this.getDimension().getCube().getModelDataSource().getInterface();
        if (DataSourceTypeEnum.isTMR(dataSourceType)) {
            List<MemberRecord> memberRecords = this.queryRootMemberRecordsFromProvider();
            if (memberRecords != null && memberRecords.size() > 1 && this.isMultiRoot()) {
                return null;
            }
            if (memberRecords != null && !memberRecords.isEmpty()) {
                MemberRecord rootMemberRecord = memberRecords.get(0);
                MFWLevel level = (MFWLevel)this.getLevel(rootMemberRecord.getLevelNumber());
                this.rootMember = new MFWMember(rootMemberRecord.getUniqueName(), level);
                return this.rootMember;
            }
        }
        if (this.rootMember == null) {
            MFWMember hierarchyRootMember = null;
            MFWMultiRequestHandle rootMUN = this.queryHandle(MFWModelRes.getInstance().RID_rootMUN, new short[0]);
            if (rootMUN == null) {
                rootMUN = this.queryHandle(MFWModelRes.getInstance().RID_rootMember, new short[0]);
            }
            if (rootMUN != null) {
                MFWMultiRequestHandle[] handles = this.getHandles();
                MFWMultiRequestHandle[] rootCaptions = this.queryHandles(MFWModelRes.getInstance().RID_rootCaption, new short[0]);
                ArrayList<MFWMultiRequestHandle> handleList = new ArrayList<MFWMultiRequestHandle>(handles.length + 1 + rootCaptions.length);
                if (handles.length > 0) {
                    for (int i = 0; i < handles.length; ++i) {
                        handleList.add(handles[i]);
                    }
                }
                handleList.add(rootMUN);
                handleList.addAll(Arrays.asList(rootCaptions));
                if (DataSourceTypeEnum.isSAPBW(dataSourceType)) {
                    hierarchyRootMember = new MFWMember(this.getConnection(), handleList.toArray(new MFWMultiRequestHandle[handleList.size()]), this.getLevel(0));
                }
                if (hierarchyRootMember == null) {
                    hierarchyRootMember = new MFWMember(this.getConnection(), handleList.toArray(new MFWMultiRequestHandle[handleList.size()]));
                }
            }
            this.rootMember = hierarchyRootMember;
        }
        return this.rootMember;
    }

    @Override
    public boolean isShell() {
        return false;
    }

    @Override
    public IMember getHighestLevelRollup() {
        return this.highestLevelRollup;
    }

    @Override
    public boolean isAutoGenerated() {
        return false;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public String getUniqueID() {
        if (this.uniqueID == null) {
            this.uniqueID = this.queryValue(QUERY_PPDSCODE);
        }
        return this.uniqueID;
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            String hierarchyUniqueName = this.queryValue(MFWModelRes.getInstance().RID_externalName, new short[0]);
            if (hierarchyUniqueName == null) {
                hierarchyUniqueName = this.buildDefaultUniqueName();
            }
            this.uniqueName = hierarchyUniqueName;
        }
        return this.uniqueName;
    }

    @Override
    protected String buildDefaultUniqueName() {
        StringBuilder sb = new StringBuilder();
        sb.append(UniqueNameGenerator.createUniqueName(this.getDimension().getName()));
        sb.append(".");
        sb.append(UniqueNameGenerator.createUniqueName(this.getName()));
        return sb.toString();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.queryName();
        }
        return this.name;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = this.queryDescription();
        }
        return this.description;
    }

    @Override
    public String getScreenTip() {
        if (this.screenTip == null) {
            this.screenTip = this.queryScreenTip();
        }
        return this.screenTip;
    }

    @Override
    public String getV5UniqueName() {
        if (this.v5UniqueName == null) {
            IMetadata parentObj = this.getParentObjectSkipFolders();
            String hierarchyV5UniqueName = null;
            if (parentObj == null) {
                hierarchyV5UniqueName = UniqueNameGenerator.appendUniqueName(((MFWDimension)this.getDimension()).getV5UniqueName(), this.getName());
            } else {
                String parentName = ((MFWMetadata)parentObj).getV5UniqueName();
                hierarchyV5UniqueName = parentObj instanceof MFWShortcut && ((MFWShortcut)parentObj).getTarget() instanceof INamespace ? UniqueNameGenerator.appendUniqueName(parentName, this.getDimension().getName(), this.getName()) : UniqueNameGenerator.appendUniqueName(parentName, this.getName());
            }
            this.v5UniqueName = hierarchyV5UniqueName;
        }
        return this.v5UniqueName;
    }

    @Override
    public String getID() {
        if (this.id == null) {
            this.id = this.buildID();
        }
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HierarchyRecord queryHierarchyRecord() {
        ICube cube = this.getDimension().getCube();
        IModelDataSource modelDS = cube.getModelDataSource();
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        IDataSource ds = executionEnvironment.getOrAddDataSource(modelDS);
        IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(ds.getType());
        MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(ds, executionEnvironment, modelDS.getConnection().getExpressionLocale());
        IOLAPMetadataProvider metadataProvider = dataProvider.getMetadataProvider(mdQueryArgs);
        MetadataRestriction restrictions = new MetadataRestriction();
        if (modelDS.getCatalog() != null) {
            restrictions.add(RestrictionType.CATALOG, modelDS.getCatalog().getUniqueName());
        }
        restrictions.add(RestrictionType.CUBE, cube.getUniqueName());
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.getDimension().getUniqueName());
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, this.getUniqueName());
        this.addProjectLocales(modelDS, restrictions);
        this.setKeyDate(ds, restrictions);
        List<HierarchyRecord> records = null;
        try {
            records = metadataProvider.getHierarchies(restrictions);
        }
        finally {
            metadataProvider.release();
        }
        if (records == null || records.size() != 1) {
            this.getConnection().throwInternalError(UNEXPECTED_MEMBER_RESPONSE);
        }
        return records.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemberRecord queryMemberRecord(String memberUniqueName) {
        if (memberUniqueName == null || memberUniqueName.isEmpty()) {
            return null;
        }
        ICube cube = this.getDimension().getCube();
        IModelDataSource modelDS = cube.getModelDataSource();
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        IDataSource ds = executionEnvironment.getOrAddDataSource(modelDS);
        IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(ds.getType());
        if (dataProvider == null) {
            return null;
        }
        MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(ds, executionEnvironment, modelDS.getConnection().getExpressionLocale());
        IOLAPMetadataProvider metadataProvider = dataProvider.getMetadataProvider(mdQueryArgs);
        MetadataRestriction restrictions = new MetadataRestriction();
        if (modelDS.getCatalog() != null) {
            restrictions.add(RestrictionType.CATALOG, modelDS.getCatalog().getUniqueName());
        }
        restrictions.add(RestrictionType.CUBE, cube.getUniqueName());
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.getDimension().getUniqueName());
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, this.getUniqueName());
        restrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, memberUniqueName);
        this.addProjectLocales(modelDS, restrictions);
        this.setKeyDate(ds, restrictions);
        List<MemberRecord> records = null;
        try {
            records = metadataProvider.getMembers(restrictions);
        }
        finally {
            metadataProvider.release();
        }
        if (records == null || records.size() != 1) {
            return null;
        }
        return records.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemberRecord> queryRootMemberRecordsFromProvider() {
        ICube cube = this.getDimension().getCube();
        IModelDataSource modelDS = cube.getModelDataSource();
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        IDataSource ds = executionEnvironment.getOrAddDataSource(modelDS);
        IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(ds.getType());
        MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(ds, executionEnvironment, modelDS.getConnection().getExpressionLocale());
        IOLAPMetadataProvider metadataProvider = dataProvider.getMetadataProvider(mdQueryArgs);
        MetadataRestriction restrictions = new MetadataRestriction();
        if (modelDS.getCatalog() != null) {
            restrictions.add(RestrictionType.CATALOG, modelDS.getCatalog().getUniqueName());
        }
        restrictions.add(RestrictionType.CUBE, cube.getUniqueName());
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.getDimension().getUniqueName());
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, this.getUniqueName());
        this.addProjectLocales(modelDS, restrictions);
        this.setKeyDate(ds, restrictions);
        List<MemberRecord> records = null;
        try {
            records = metadataProvider.getHierarchyRootMembers(restrictions);
        }
        finally {
            metadataProvider.release();
        }
        return records;
    }

    private void setKeyDate(IDataSource ds, MetadataRestriction restrictions) {
        if (DataSourceTypeEnum.isSAPBW(ds.getType())) {
            String from = this.getValidFrom();
            String to = this.getValidTo();
            if (null == to && null == from) {
                return;
            }
            IDataSourceCapabilities capabilities = ds.getCapabilities();
            String keyDate = MetadataUtil.getKeydateWithConfig(from, to, capabilities.isSupported("use.valid.from"));
            if (keyDate != null) {
                restrictions.add(RestrictionType.KEY_DATE, keyDate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LevelRecord> queryLevelRecords() {
        ICube cube = this.getDimension().getCube();
        IModelDataSource modelDS = cube.getModelDataSource();
        ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        IDataSource ds = executionEnvironment.getOrAddDataSource(modelDS);
        IOLAPDataProvider dataProvider = ProviderManager.getInstance().getOLAPProvider(ds.getType());
        MetadataQueryArguments mdQueryArgs = MetadataQueryArguments.buildArguments(ds, executionEnvironment, modelDS.getConnection().getExpressionLocale());
        IOLAPMetadataProvider metadataProvider = dataProvider.getMetadataProvider(mdQueryArgs);
        MetadataRestriction restrictions = new MetadataRestriction();
        if (cube.getModelDataSource().getCatalog() != null) {
            restrictions.add(RestrictionType.CATALOG, modelDS.getCatalog().getUniqueName());
        }
        restrictions.add(RestrictionType.CUBE, cube.getUniqueName());
        restrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, this.getDimension().getUniqueName());
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, this.getUniqueName());
        this.addProjectLocales(modelDS, restrictions);
        this.setKeyDate(ds, restrictions);
        List<LevelRecord> records = null;
        try {
            records = metadataProvider.getLevels(restrictions);
        }
        finally {
            metadataProvider.release();
        }
        return records;
    }

    @Override
    public boolean isDMR() {
        return this.getDimension().isDMR();
    }

    @Override
    public String getValidFrom() {
        return this.queryValue(QUERY_VALID_FROM);
    }

    @Override
    public String getValidTo() {
        return this.queryValue(QUERY_VALID_TO);
    }

    @Override
    public List<IMember> getCalculatedMembers() {
        if (this.calculatedMembers == null) {
            List<IMember> calcMembers = CollectionCast.downcast(this.getConnection().queryMetadata(this.getHandles(), MFWModelRes.getInstance().RID_calculatedMember, new short[0]), IMetadata.class, IMember.class);
            this.calculatedMembers = calcMembers;
        }
        return this.calculatedMembers;
    }

    @Override
    public IMember[] getMembers(InterpreterContext ic) {
        return null;
    }

    @Override
    public IMember getDefaultMemberFromProvider() {
        IModelDataSource modelDataSource = this.getDimension().getCube().getModelDataSource();
        String dataSourceType = modelDataSource.getInterface();
        if (!DataSourceTypeEnum.isTMR(dataSourceType)) {
            return null;
        }
        HierarchyRecord hierarchyRecord = this.queryHierarchyRecord();
        String defaultMemberUniqueName = hierarchyRecord.getDefaultMemberUniqueName();
        MemberRecord memberRecord = this.queryMemberRecord(defaultMemberUniqueName);
        if (memberRecord != null) {
            MFWLevel level = (MFWLevel)this.getLevel(memberRecord.getLevelNumber());
            this.defaultMember = new MFWMember(defaultMemberUniqueName, level);
        }
        return this.defaultMember;
    }

    @Override
    public String getCaption() {
        if (this.caption == null) {
            this.caption = this.queryCaption();
        }
        return this.caption;
    }

    @Override
    protected String queryCaption() {
        String contentLocale = this.getConnection().getContentLocaleString();
        String caption = null;
        for (MFWMultiRequestHandle handleName : this.queryHandles(MFWModelRes.getInstance().RID_name, new short[0])) {
            if (!contentLocale.equals(this.getConnection().queryValue(handleName, MFWModelRes.getInstance().RID_locale, new short[0]))) continue;
            caption = this.getConnection().queryValue(handleName, MFWModelRes.getInstance().RID__Value, new short[0]);
        }
        return caption;
    }

    private void addProjectLocales(IModelDataSource modelDS, MetadataRestriction restrictions) {
        Map<String, Object> metadataProperties = modelDS.getMetadataProperties();
        Set projectLocales = (Set)metadataProperties.get("project_locales");
        if (projectLocales != null && !projectLocales.isEmpty()) {
            ArrayList locales = new ArrayList(projectLocales);
            restrictions.add(RestrictionType.PROJECT_LOCALES, locales);
        }
    }
}

