/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.LevelType;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqemfw4j.MFWHierarchy;
import com.cognos.xqemfw4j.MFWMetadata;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import com.cognos.xqemfw4j.MFWQueryItemOfLevel;
import com.cognos.xqemfw4j.MFWShortcut;
import com.cognos.xqemfw4j.MFWSortItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

class MFWLevel
extends MFWMetadata
implements ILevel {
    private static final String CLOSE_BRACKET = "']";
    private static final String EQUAL = "='";
    private static final String OPEN_BRACKET = "[";
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(MFWLevel.class);
    private static final String QUERY_PPDSCODE = "/property[name='PPDS_CODE']";
    private static final String QUERY_CARDINALITY = "/property[name='levelCardinality']/__Value";
    private static final String LEVEL = " Level ";
    public static final String BASE_ATTRIBUTE_HIERARCHY_REF = "baseAttributeHierarchyRef";
    static final long serialVersionUID = 7647274105530911872L;
    protected String name = null;
    private String id = null;
    protected String uniqueID = null;
    protected String uniqueName = null;
    protected IHierarchy hierarchy = null;
    protected List<IMember> members = null;
    protected List<IProperty> memberProperties = null;
    protected Integer levelIndex = null;
    protected Integer cardinality = null;
    protected Boolean isUnique = null;
    protected double orderOfMagnitude = -1.0;
    private List<MFWSortItem> sortItems = null;
    private String v5UniqueName = null;

    protected MFWLevel(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandle) {
        super(mfwConnection, mfwHandle);
    }

    @Override
    public List<IMember> getMembers() {
        if (this.members == null) {
            this.members = new ArrayList<IMember>();
        }
        return this.members;
    }

    @Override
    public IHierarchy getHierarchy() {
        if (this.hierarchy == null) {
            IHierarchy levelHierarchy;
            this.hierarchy = levelHierarchy = (IHierarchy)this.buildParentMetadataObject(MFWModelRes.getInstance().RID_hierarchy);
        }
        return this.hierarchy;
    }

    @Override
    public int getCardinality() {
        if (this.cardinality == null) {
            String modelCardinality = this.queryValue(QUERY_CARDINALITY);
            if (modelCardinality == null) {
                modelCardinality = "0";
            }
            this.cardinality = Integer.valueOf(modelCardinality);
        }
        return this.cardinality;
    }

    @Override
    public List<IMember> getMembers(int startIndex, int count) {
        List<IMember> items = this.getMembers();
        return items.subList(startIndex, count);
    }

    @Override
    public ILevel getNextLevel() {
        ILevel nextLevel = null;
        int index = this.getIndex() + 1;
        if (index < this.getHierarchy().getLevels().size()) {
            nextLevel = this.getHierarchy().getLevels().get(index);
        }
        return nextLevel;
    }

    @Override
    public ILevel getPreviousLevel() {
        ILevel previousLevel = null;
        int index = this.getIndex() - 1;
        if (index >= 0) {
            previousLevel = this.getHierarchy().getLevels().get(index);
        }
        return previousLevel;
    }

    @Override
    public boolean isLeafLevel() {
        int levelCount;
        int index = this.getIndex();
        return index == (levelCount = this.getHierarchy().getLevelCount()) - 1;
    }

    @Override
    public boolean isRootLevel() {
        int index = this.getIndex();
        return index == 0;
    }

    @Override
    public List<IProperty> getMemberProperties() {
        if (this.memberProperties == null) {
            ArrayList<MFWQueryItemOfLevel> propertyList = new ArrayList<MFWQueryItemOfLevel>();
            short ridQueryItemFolder = MFWModelRes.getInstance().RID_queryItemFolder;
            short ridQueryItem = MFWModelRes.getInstance().RID_queryItem;
            MFWMultiRequestHandle[] handles = this.getHandles();
            ArrayList<MFWMultiRequestHandle> handleList = null;
            if (handles != null && handles.length > 0) {
                handleList = new ArrayList<MFWMultiRequestHandle>(handles.length + 1);
                for (int i = 0; i < handles.length; ++i) {
                    handleList.add(handles[i]);
                }
                handleList.add(null);
            }
            Stack<MFWMultiRequestHandle> stack = new Stack<MFWMultiRequestHandle>();
            stack.push(this.getHandle());
            while (stack.size() > 0) {
                MFWMultiRequestHandle handle = (MFWMultiRequestHandle)stack.pop();
                if (handle == null) continue;
                if (handle.getInfo().getRID() == ridQueryItem) {
                    handleList.set(handleList.size() - 1, handle);
                    MFWQueryItemOfLevel queryItem = (MFWQueryItemOfLevel)this.getConnection().mfwObjectToMetadataObject(handleList.toArray(new MFWMultiRequestHandle[handleList.size()]));
                    propertyList.add(queryItem);
                    continue;
                }
                MFWMultiRequestHandle[] hQueryItems = this.queryHandles(handle, ridQueryItem, new short[0]);
                for (int i = hQueryItems.length - 1; i >= 0; --i) {
                    stack.push(hQueryItems[i]);
                }
                MFWMultiRequestHandle[] hQueryItemFolders = this.queryHandles(handle, ridQueryItemFolder, new short[0]);
                for (int i = hQueryItemFolders.length - 1; i >= 0; --i) {
                    stack.push(hQueryItemFolders[i]);
                }
            }
            this.memberProperties = Collections.unmodifiableList(propertyList);
        }
        return this.memberProperties;
    }

    @Override
    public ISortItem[] getSortItems() {
        if (this.sortItems == null) {
            MFWMultiRequestHandle[] sortItemHandles;
            ArrayList<MFWSortItem> localSortItems = new ArrayList<MFWSortItem>();
            for (MFWMultiRequestHandle sortItemHandle : sortItemHandles = this.queryHandles(MFWModelRes.getInstance().RID_sortItem, new short[0])) {
                MFWSortItem sortItem = new MFWSortItem(this.getConnection(), new MFWMultiRequestHandle[]{sortItemHandle});
                localSortItems.add(sortItem);
            }
            this.sortItems = localSortItems;
        }
        return this.sortItems.toArray(new MFWSortItem[this.sortItems.size()]);
    }

    @Override
    public IProperty getMemberProperty(String propertyName) {
        List<IProperty> allProperties = this.getMemberProperties();
        for (IProperty prop : allProperties) {
            if (!prop.getUniqueName().equals(propertyName)) continue;
            return prop;
        }
        return null;
    }

    @Override
    public IDataType getDataType() {
        return LevelType.LEVELTYPE;
    }

    @Override
    public boolean isUnique() {
        if (this.isUnique == null) {
            String booleanString = this.queryValue(MFWModelRes.getInstance().RID_isUnique, new short[0]);
            this.isUnique = "true".equals(booleanString);
        }
        return this.isUnique;
    }

    @Override
    public double getOrderOfMagnitude() {
        if (this.orderOfMagnitude == -1.0) {
            String orderOfMagnitudeString = this.queryValue("orderOfMagnitude");
            try {
                String d = orderOfMagnitudeString.replaceAll(",", ".");
                this.orderOfMagnitude = Double.parseDouble(d);
            }
            catch (NumberFormatException e1) {
                this.orderOfMagnitude = 0.0;
            }
        }
        return this.orderOfMagnitude;
    }

    @Override
    public int getIndex() {
        if (this.levelIndex == null) {
            this.levelIndex = this.getHierarchy().getLevelIndex(this);
        }
        return this.levelIndex;
    }

    @Override
    public IDimension getDimension() {
        return this.getHierarchy().getDimension();
    }

    @Override
    public MetadataType getObjectType() {
        return MetadataType.LEVEL;
    }

    @Override
    public String getV5UniqueName() {
        if (this.v5UniqueName == null) {
            String levelV5UniqueName = null;
            IMetadata parentObj = this.getParentObjectSkipFolders();
            if (parentObj == null) {
                levelV5UniqueName = UniqueNameGenerator.appendUniqueName(((MFWHierarchy)this.getHierarchy()).getV5UniqueName(), this.getName());
            } else {
                String parentName = ((MFWMetadata)parentObj).getV5UniqueName();
                levelV5UniqueName = parentObj instanceof MFWShortcut ? (((MFWShortcut)parentObj).getTarget() instanceof INamespace ? UniqueNameGenerator.appendUniqueName(parentName, this.getDimension().getName(), this.getHierarchy().getName(), this.getName()) : UniqueNameGenerator.appendUniqueName(parentName, this.getHierarchy().getName(), this.getName())) : UniqueNameGenerator.appendUniqueName(parentName, this.getName());
            }
            this.v5UniqueName = levelV5UniqueName;
        }
        return this.v5UniqueName;
    }

    protected static String createLevelUniqueName(IHierarchy aHierarchy, int levelNumber) {
        MetadataConnection connection;
        if (!aHierarchy.isShell() && (connection = aHierarchy.getConnection()) == null) {
            connection = aHierarchy.getDimension().getConnection();
        }
        StringBuilder strBuf = new StringBuilder(aHierarchy.getName());
        strBuf.append(LEVEL).append(levelNumber);
        return UniqueNameGenerator.createUniqueName(aHierarchy.getName(), strBuf.toString());
    }

    @Override
    public boolean isAutoGenerated() {
        return false;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public String getUniqueID() {
        if (this.uniqueID == null) {
            this.uniqueID = this.queryValue(QUERY_PPDSCODE);
        }
        return this.uniqueID;
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            String memberUniqueName = this.queryValue(MFWModelRes.getInstance().RID_externalName, new short[0]);
            if (memberUniqueName == null) {
                memberUniqueName = this.buildDefaultUniqueName();
            }
            this.uniqueName = memberUniqueName;
        }
        return this.uniqueName;
    }

    @Override
    public IMember getMember(String memberUniqueName) {
        return null;
    }

    @Override
    protected String buildDefaultUniqueName() {
        StringBuilder sb = new StringBuilder();
        sb.append(UniqueNameGenerator.createUniqueName(this.getHierarchy().getDimension().getName()));
        sb.append(".");
        sb.append(UniqueNameGenerator.createUniqueName(this.getHierarchy().getName()));
        sb.append(".");
        sb.append(UniqueNameGenerator.createUniqueName(this.getName()));
        return sb.toString();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.queryName();
        }
        return this.name;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = this.queryDescription();
        }
        return this.description;
    }

    @Override
    public String getScreenTip() {
        if (this.screenTip == null) {
            this.screenTip = this.queryScreenTip();
        }
        return this.screenTip;
    }

    @Override
    public String getID() {
        if (this.id == null) {
            this.id = this.buildID();
        }
        return this.id;
    }

    @Override
    public boolean isDMR() {
        return this.getDimension().isDMR();
    }
}

