/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqemfw4j;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.UnknownType;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.AllocationRule;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.bean.BeanPropertySupport;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqemfw4j.MFWAggregateRule;
import com.cognos.xqemfw4j.MFWDimension;
import com.cognos.xqemfw4j.MFWMeasureDimension;
import com.cognos.xqemfw4j.MFWMeasureHierarchy;
import com.cognos.xqemfw4j.MFWMember;
import com.cognos.xqemfw4j.MFWMetadata;
import com.cognos.xqemfw4j.MFWMetadataConnection;
import com.cognos.xqemfw4j.MFWMultiRequestGateway;
import com.cognos.xqemfw4j.MFWMultiRequestHandle;
import com.cognos.xqemfw4j.MFWNamespace;
import java.util.ArrayList;
import java.util.Collections;

class MFWMeasure
extends MFWMember
implements IMeasure {
    private static final BeanPropertySupport BEAN_PROPERTY_SUPPORT = new BeanPropertySupport(MFWMeasure.class);
    private static final String CONSTANT = "constant";
    static final long serialVersionUID = 7647274105530911872L;
    private boolean exprFetchedFromMFW4J = false;
    private String expression = null;
    private String format = null;
    AggregateTypeEnum regularAggregate = null;
    AggregateTypeEnum semiAggregate = null;
    AggregateTypeEnum aggregate = null;
    volatile IAggregateRule[] aggregateRules = null;
    protected String name = null;
    protected IDataType dataType = null;
    private AllocationRule allocationRule;
    private boolean parentInitialized = false;
    private Integer solveOrder;

    MFWMeasure(MFWMetadataConnection mfwConnection, MFWMultiRequestHandle[] mfwHandle) {
        super(mfwConnection, mfwHandle);
    }

    @Override
    public boolean isMeasure() {
        return true;
    }

    @Override
    public IDataType getDataType() {
        if (this.dataType == null) {
            IDataType localDataType = this.queryDataType();
            if (localDataType == UnknownType.UNKNOWNTYPE) {
                localDataType = MetadataUtil.calculateExpressionDataType(this);
            }
            this.dataType = localDataType;
        }
        if (this.dataType == UnknownType.UNKNOWNTYPE) {
            return null;
        }
        return this.dataType;
    }

    @Override
    public int getPrecision() {
        return this.getDataType().getPrecision();
    }

    @Override
    public int getScale() {
        return this.getDataType().getScale();
    }

    public int getSize() {
        return this.getDataType().getLength();
    }

    @Override
    public String getUnits() {
        return null;
    }

    @Override
    public AggregateTypeEnum getRegularAggregate() {
        if (this.regularAggregate == null) {
            this.regularAggregate = AggregateTypeEnum.valueOfModelString(this.queryValue(MFWModelRes.getInstance().RID_regularAggregate, new short[0]));
        }
        return this.regularAggregate;
    }

    @Override
    public AggregateTypeEnum getSemiAggregate() {
        if (this.semiAggregate == null) {
            this.semiAggregate = AggregateTypeEnum.valueOfModelString(this.queryValue(MFWModelRes.getInstance().RID_semiAggregate, new short[0]));
        }
        return this.semiAggregate;
    }

    public AggregateTypeEnum getAggregationRule() {
        if (this.aggregate == null) {
            this.aggregate = AggregateTypeEnum.valueOfModelString(this.queryValue(MFWModelRes.getInstance().RID_aggregationRule, new short[0]));
        }
        return this.aggregate;
    }

    @Override
    public IAggregateRule[] getAggregateRules() {
        if (this.aggregateRules == null) {
            this.aggregateRules = this.queryAggregateRules();
        }
        return this.aggregateRules;
    }

    private IAggregateRule[] queryAggregateRules() {
        IAggregateRule[] modelAggregateRules = null;
        MFWMultiRequestHandle[] aggregateRuleHandles = this.queryHandles(MFWModelRes.getInstance().RID_aggregateRule, new short[0]);
        ArrayList<MFWAggregateRule> ruleList = new ArrayList<MFWAggregateRule>();
        for (MFWMultiRequestHandle handle : aggregateRuleHandles) {
            ruleList.add(new MFWAggregateRule(this.getConnection(), new MFWMultiRequestHandle[]{handle}));
        }
        modelAggregateRules = Collections.unmodifiableList(ruleList).toArray(new IAggregateRule[ruleList.size()]);
        return modelAggregateRules;
    }

    @Override
    public BeanPropertySupport getBeanPropertySupport() {
        return BEAN_PROPERTY_SUPPORT;
    }

    @Override
    public String getV5MUN() {
        if (this.v5MUN == null) {
            this.v5MUN = this.getV5UniqueName();
        }
        return this.v5MUN;
    }

    int getDepth() {
        int depth = 0;
        for (MFWMultiRequestHandle handle = this.getHandle().getParent(); handle != null; handle = handle.getParent()) {
            short rid = handle.getNameRID();
            if (rid == MFWModelRes.getInstance().RID_measure) {
                ++depth;
                continue;
            }
            if (rid == MFWModelRes.getInstance().RID_dimension) break;
        }
        return depth;
    }

    @Override
    public ILevel getLevel() {
        if (this.level == null) {
            this.level = this.queryLevel();
        }
        return this.level;
    }

    private ILevel queryLevel() {
        MFWMeasureDimension dimension = (MFWMeasureDimension)this.buildParentMetadataObject(MFWModelRes.getInstance().RID_dimension);
        MFWMeasureHierarchy hierarchy = (MFWMeasureHierarchy)dimension.getHierarchy(0);
        return hierarchy.getLevel(this.getDepth());
    }

    @Override
    public IMember getParent() {
        if (!this.parentInitialized) {
            MFWMeasure parentMeasure = null;
            for (MFWMultiRequestHandle handle = this.getHandle().getParent(); handle != null; handle = handle.getParent()) {
                short rid = handle.getNameRID();
                if (rid == MFWModelRes.getInstance().RID_measure) {
                    parentMeasure = (MFWMeasure)this.getConnection().mfwObjectToMetadataObject(handle);
                    break;
                }
                if (rid == MFWModelRes.getInstance().RID_dimension) break;
            }
            this.parent = parentMeasure;
            this.parentInitialized = true;
        }
        return this.parent;
    }

    @Override
    public String getV5UniqueName() {
        if (this.v5MUN == null) {
            String v5UniqueName = null;
            IMetadata parentObj = this.getParentObjectSkipFolders();
            String parentName = ((MFWMetadata)parentObj).getV5UniqueName();
            this.v5MUN = v5UniqueName = UniqueNameGenerator.appendUniqueName(parentName, this.getName());
        }
        return this.v5MUN;
    }

    @Override
    public String toString() {
        return this.getID();
    }

    @Override
    protected String buildDefaultUniqueName() {
        StringBuilder sb = new StringBuilder();
        sb.append(UniqueNameGenerator.createUniqueName(this.getHierarchy().getDimension().getName()));
        sb.append(".");
        return sb.toString();
    }

    @Override
    public String getUniqueName() {
        if (this.uniqueName == null) {
            String measureUniqueName = this.queryValue(MFWModelRes.getInstance().RID_externalName, new short[0]);
            if (measureUniqueName == null) {
                measureUniqueName = this.buildDefaultUniqueName();
            }
            this.uniqueName = measureUniqueName;
        }
        return this.uniqueName;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.queryName();
        }
        return this.name;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            this.description = this.queryDescription();
        }
        return this.description;
    }

    @Override
    public String getScreenTip() {
        if (this.screenTip == null) {
            this.screenTip = this.queryScreenTip();
        }
        return this.screenTip;
    }

    @Override
    public String getCaption() {
        if (this.caption == null) {
            this.caption = this.queryCaption();
        }
        return this.caption;
    }

    @Override
    public LocalizedString getLocalizedCaption() {
        String defaultLocale = this.getConnection().getDefaultLocaleString();
        LocalizedString captions = new LocalizedString(defaultLocale, this.queryName(defaultLocale));
        for (MFWMultiRequestHandle handleName : this.queryHandles(MFWModelRes.getInstance().RID_name, new short[0])) {
            String locale = this.getConnection().queryValue(handleName, MFWModelRes.getInstance().RID_locale, new short[0]);
            String localizedName = this.getConnection().queryValue(handleName, MFWModelRes.getInstance().RID__Value, new short[0]);
            captions.put(locale, localizedName);
        }
        return captions;
    }

    @Override
    public IScopeRelationship getScopeRelationship(IMetadata otherMetadata) {
        IScopeRelationship targetScopeRelationship;
        IScopeRelationship scopeRelationship;
        MFWNamespace regularDimNS;
        MFWDimension dimension = (MFWDimension)this.getDimension();
        MFWNamespace measureDimNS = dimension.getParentNamespace();
        if (measureDimNS != null && measureDimNS.getShortcut() != null) {
            dimension = dimension.getDimUnderTargetNamespace();
        }
        if (otherMetadata instanceof MFWDimension && (regularDimNS = ((MFWDimension)otherMetadata).getParentNamespace()) != null && regularDimNS.getShortcut() != null) {
            otherMetadata = ((MFWDimension)otherMetadata).getDimUnderTargetNamespace();
        }
        if ((scopeRelationship = dimension.getScopeRelationship(otherMetadata)) != null) {
            return scopeRelationship;
        }
        IMetadata otherMetadataTarget = null;
        if (otherMetadata instanceof IAccessedViaShortcut) {
            IShortcut sc = ((IAccessedViaShortcut)otherMetadata).getShortcut();
            otherMetadataTarget = sc != null ? sc.getTarget() : otherMetadata;
        }
        MFWMember targetMeasure = null;
        if (this.getDimension() instanceof IAccessedViaShortcut) {
            IShortcut sc = ((IAccessedViaShortcut)((Object)this.getDimension())).getShortcut();
            if (sc != null) {
                IDimension targetMeasureDim = (IDimension)sc.getTarget();
                for (IMember metadata : targetMeasureDim.getMembers()) {
                    if (metadata.getName().equals(this.getName())) {
                        targetMeasure = (MFWMeasure)metadata;
                    }
                    if (targetMeasure != null) break;
                }
                if (targetMeasure == null) {
                    throw new XQERuntimeException();
                }
            } else {
                targetMeasure = this;
            }
        }
        if ((targetMeasure.getDimension() != this.getDimension() || otherMetadataTarget != otherMetadata) && (targetScopeRelationship = ((MFWMeasure)targetMeasure).getScopeRelationship(otherMetadataTarget)) != null) {
            return targetScopeRelationship;
        }
        return null;
    }

    @Override
    public IScopeRelationship[] getScopeRelationships() {
        return ((MFWDimension)this.getDimension()).getScopeRelationships();
    }

    @Override
    public AllocationRule getAllocationRule() {
        if (this.allocationRule == null) {
            short rid = MFWModelRes.getInstance().getResourceID("allocationRule");
            String allocRule = this.getConnection().queryValue(this.getHandle(), rid, new short[0]);
            AllocationRule measureAllocationRule = AllocationRule.DEFAULT;
            if (CONSTANT.equals(allocRule)) {
                measureAllocationRule = AllocationRule.CONSTANT;
            }
            this.allocationRule = measureAllocationRule;
        }
        return this.allocationRule;
    }

    @Override
    public IQuerySubject getQuerySubject() {
        IDimension qs = this.getDimension();
        if (qs instanceof IQuerySubject) {
            return (IQuerySubject)((Object)qs);
        }
        return null;
    }

    public String getSql() {
        MFWMultiRequestGateway gw = this.getConnection().getGateway();
        return gw.getObjectPropertyValue(this.getHandle(), MFWModelRes.getInstance().RID_sql);
    }

    @Override
    public boolean isDMR() {
        IDimension dimension = this.getDimension();
        if (dimension != null) {
            return dimension.isDMR();
        }
        return false;
    }

    @Override
    public String getExpression() {
        if (!this.exprFetchedFromMFW4J) {
            this.expression = this.queryExpression();
            this.exprFetchedFromMFW4J = true;
        }
        return this.expression;
    }

    @Override
    public String getFormat() {
        if (this.format == null) {
            this.format = this.queryValue(MFWModelRes.getInstance().RID_format, new short[0]);
        }
        return this.format;
    }

    @Override
    public Integer getSolveOrder() {
        if (this.solveOrder == null) {
            Integer measureSolveOrder;
            String solveOrderStr = this.queryValue(MFWModelRes.getInstance().RID_calculatedMeasureSolveOrder, new short[0]);
            if (solveOrderStr == null || solveOrderStr.length() == 0) {
                measureSolveOrder = XQEIntegerPool.getInteger(-1);
            } else {
                try {
                    measureSolveOrder = Integer.valueOf(solveOrderStr);
                }
                catch (NumberFormatException e) {
                    measureSolveOrder = XQEIntegerPool.getInteger(-1);
                }
            }
            this.solveOrder = measureSolveOrder;
        }
        if (this.solveOrder < 0) {
            return null;
        }
        return this.solveOrder;
    }

    @Override
    public boolean isMFWMeasure() {
        return true;
    }
}

